/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.tck;

import com.neeve.aep.AepEngine;
import com.neeve.config.Config;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.sma.tck.AbstractSMATckTestApp;
import com.neeve.sma.tck.SMATckTestServer;
import com.neeve.test.UnitTest;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class AbstractSMATckServerTest
extends UnitTest {
    private static final HashSet<String> DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS = new HashSet();
    private static final HashSet<String> DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS = new HashSet();
    private static final RogLogUtil.FieldFilter PRIMARY_BACKUP_FILTER;
    protected static final RogLogUtil.FieldFilter SENDER_RECEIVER_FILTER;
    protected static final HashSet<SMATckTestServer<?>> servers;

    @After
    public void reset() {
        for (EmbeddedXVM embeddedXVM : servers) {
            Object app;
            if (embeddedXVM.getStartupError() != null || !(embeddedXVM instanceof SMATckTestServer) || !((app = ((SMATckTestServer)embeddedXVM).getApplication()) instanceof AbstractSMATckTestApp)) continue;
            ((AbstractSMATckTestApp)app).resetMessageCounts();
        }
    }

    @AfterClass
    public static void closeServers() throws Throwable {
        Throwable error = null;
        for (EmbeddedXVM embeddedXVM : servers) {
            try {
                embeddedXVM.getServerController().stop();
                if (embeddedXVM.getStartupError() != null) continue;
                AbstractSMATckTestApp app = null;
                if (!(embeddedXVM instanceof SMATckTestServer)) continue;
                Object theapp = ((SMATckTestServer)embeddedXVM).getApplication();
                if (theapp instanceof AbstractSMATckTestApp) {
                    app = (AbstractSMATckTestApp)theapp;
                    app.cleanup();
                }
                while (app.getEngine().getState() != AepEngine.State.Stopped) {
                    Thread.sleep(100L);
                }
            }
            catch (Throwable thrown) {
                if (error != null) {
                    error = thrown;
                }
                thrown.printStackTrace();
            }
        }
        servers.clear();
        if (error != null) {
            throw error;
        }
    }

    public static SMATckTestServer.Config config(Class<?> applicationClass) {
        return new SMATckTestServer.Config();
    }

    protected static <T extends AbstractSMATckTestApp> SMATckTestServer<T> createServer(String appName, Class<T> applicationClass) {
        SMATckTestServer<T> server = SMATckTestServer.create(appName, null, applicationClass, null);
        servers.add(server);
        return server;
    }

    protected static <T extends AbstractSMATckTestApp> SMATckTestServer<T> createServer(String appName, String instanceId, Class<T> applicationClass) {
        SMATckTestServer<T> server = SMATckTestServer.create(appName, instanceId, applicationClass, null);
        servers.add(server);
        return server;
    }

    protected static <T extends AbstractSMATckTestApp> SMATckTestServer<T> createServer(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
        SMATckTestServer<T> server = SMATckTestServer.create(appName, instanceId, applicationClass, configOverrides);
        servers.add(server);
        return server;
    }

    protected static <T extends AbstractSMATckTestApp> T createApp(String appName, String instanceId, Class<T> applicationClass) throws Throwable {
        return AbstractSMATckServerTest.createApp(appName, instanceId, applicationClass, null);
    }

    protected static <T extends AbstractSMATckTestApp> T createApp(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) throws Throwable {
        SMATckTestServer<T> server = AbstractSMATckServerTest.createServer(appName, instanceId, applicationClass, configOverrides);
        server.start();
        if (((AbstractSMATckTestApp)server.getApplication()).getEngine().isPrimary()) {
            ((AbstractSMATckTestApp)server.getApplication()).getEngine().waitForMessagingToStart();
        }
        return server.getApplication();
    }

    protected static <T extends AbstractSMATckTestApp> T restartApp(T app) throws Throwable {
        return AbstractSMATckServerTest.restartApp(app, false);
    }

    protected static <T extends AbstractSMATckTestApp> void stopApp(T app, boolean cleanStorage) throws Throwable {
        for (SMATckTestServer<?> server : servers) {
            if (server.getApplication() != app) continue;
            AbstractSMATckServerTest.stopServer(server, cleanStorage);
            break;
        }
    }

    protected static void stopServer(SMATckTestServer<?> server, boolean cleanStorage) throws Throwable {
        String persisterName;
        servers.remove(server);
        server.shutdown();
        Object app = server.getApplication();
        if (cleanStorage && ((AbstractSMATckTestApp)app).engine.getStore() != null && (persisterName = ((AbstractSMATckTestApp)app).engine.getStore().getDescriptor().getPersister()) != null) {
            StorePersisterDescriptor persisterDesc = StorePersisterDescriptor.load((String)persisterName);
            persisterDesc.setProperty("storeRoot", Config.getDataDirectory() + "/" + server.getServerName());
            RogLog tlog = RogLog.create((String)persisterDesc.getName(), (Properties)persisterDesc.getProperties());
            File metadata = tlog.getMetadataFile();
            for (int retries = 0; metadata.exists() && retries < 20; ++retries) {
                tlog.delete();
                if (!metadata.exists()) continue;
                Thread.sleep(100L);
            }
            if (metadata.exists()) {
                throw new Exception("Failed to delete transaction log");
            }
        }
    }

    protected static <T extends AbstractSMATckTestApp> T restartApp(T app, boolean cleanStorage) throws Throwable {
        for (SMATckTestServer<?> server : servers) {
            if (server.getApplication() != app) continue;
            AbstractSMATckServerTest.stopServer(server, cleanStorage);
            return (T)AbstractSMATckServerTest.createApp(app.descriptor.getName(), server.getInstanceId(), app.getClass(), server.getConfigOverrides());
        }
        throw new IllegalStateException("App not found in any started server");
    }

    protected final void assertPrimaryAndBackupMessageEqual(AbstractSMATckTestApp primary, AbstractSMATckTestApp backup) throws Exception {
        Assert.assertEquals((String)("Backup has different number of messages than primary for app (" + primary.getAppLoader().getAppName() + "."), (long)primary.receivedMessageCount, (long)backup.receivedMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= primary.received.size(); ++i) {
            if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)primary.received.get(i - 1)), (IRogNode)((IRogNode)backup.received.get(i - 1)), (RogLogUtil.FieldFilter)PRIMARY_BACKUP_FILTER, (StringBuffer)diffBuffer)) continue;
            throw new Exception("Primary (source) and backup (target) messages diverge at message #" + i + ": " + diffBuffer);
        }
    }

    protected final void assertSentAndReceivedMessageEqual(AbstractSMATckTestApp sender, AbstractSMATckTestApp receiver) throws Exception {
        Assert.assertEquals((String)("Receiver (" + receiver.getAppLoader().getAppName() + ") has different number of messages than sender (" + sender.getAppLoader().getAppName() + ")"), (long)sender.sentMessageCount, (long)receiver.receivedMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= sender.sent.size(); ++i) {
            if (RogLogUtil.compareRogNodes((IRogNode)((IRogNode)sender.sent.get(i - 1)), (IRogNode)((IRogNode)receiver.received.get(i - 1)), (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) continue;
            throw new Exception("Sender (source) and receiver (target) messages diverge at message #" + i + ": " + diffBuffer);
        }
    }

    protected final void assertSentAndReceivedMessageEqual(AbstractSMATckTestApp sender, AbstractSMATckTestApp receiver, String channelAndBus) throws Exception {
        this.assertSentAndReceivedMessageEqual(sender, receiver, channelAndBus, false, false, false);
    }

    protected final void assertSentAndReceivedMessageEqual(AbstractSMATckTestApp sender, AbstractSMATckTestApp receiver, String channelAndBus, boolean compareChannelName, boolean compareBusName, boolean compareKey) throws Exception {
        AbstractSMATckTestApp.ChannelMessageTracker senderTracker = sender.getChannelMessageTracker(channelAndBus);
        AbstractSMATckTestApp.ChannelMessageTracker receiverTracker = receiver.getChannelMessageTracker(channelAndBus);
        Assert.assertEquals((String)("Receiver (" + receiver.getAppLoader().getAppName() + ") has different number of messages on " + channelAndBus + "' than sender (" + sender.getAppLoader().getAppName() + ")"), (long)senderTracker.sentMessageCount, (long)receiverTracker.rcvdMessageCount);
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= senderTracker.sentMessages.size(); ++i) {
            if (!RogLogUtil.compareRogNodes((IRogNode)((IRogNode)senderTracker.sentMessages.get(i - 1)), (IRogNode)((IRogNode)receiverTracker.rcvdMessages.get(i - 1)), (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) {
                throw new Exception(sender.getAppLoader().getAppName() + " (Source) and " + receiver.getAppLoader().getAppName() + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ": " + diffBuffer);
            }
            if (compareChannelName) {
                Assert.assertEquals((String)(sender.getAppLoader().getAppName() + " (Source) and " + receiver.getAppLoader().getAppName() + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", channel name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageChannel(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageChannel());
            }
            if (compareBusName) {
                Assert.assertEquals((String)(sender.getAppLoader().getAppName() + " (Source) and " + receiver.getAppLoader().getAppName() + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", bus name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageBus(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageBus());
            }
            if (!compareKey) continue;
            Assert.assertEquals((String)(sender.getAppLoader().getAppName() + " (Source) and " + receiver.getAppLoader().getAppName() + " (Target) messages on '" + channelAndBus + "' diverge at message #" + i + ", message key name mismatch."), (Object)senderTracker.sentMessages.get(i - 1).getMessageKey(), (Object)receiverTracker.rcvdMessages.get(i - 1).getMessageKey());
        }
    }

    static {
        AbstractSMATckServerTest.configureForInMemoryConfigRepo(AbstractSMATckServerTest.class);
        DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("id");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("stableTransactionId");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("serializedMetadataLength");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("preProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("postProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("appSendBeginTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("appSendDoneTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("postProcessingTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("originTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBus");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannel");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKey");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageBusAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageChannelAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageKeyAsRaw");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionOutSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("messageTransportHeaders");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("inMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outMsgsInTransaction");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("ownershipCount");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("outTs");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionInSequenceNumber");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isInboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("isOutboundMessage");
        DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.add("transactionId");
        PRIMARY_BACKUP_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_PRIMARY_BACKUP_FIELD_EXCEPTIONS.contains(path);
            }
        };
        SENDER_RECEIVER_FILTER = new RogLogUtil.FieldFilter(){
            RogLogUtil.FieldFilter defaultFilter;

            public final boolean filter(Class<?> type, String path) {
                if (this.defaultFilter == null) {
                    try {
                        this.defaultFilter = RogLogUtil.loadComparisonFilter();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading comparison filter", e);
                    }
                }
                return this.defaultFilter.filter(type, path) || DIVERGENT_SENDER_RECEIVER_FIELD_EXCEPTIONS.contains(path);
            }
        };
        servers = new HashSet();
    }
}

