/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import cern.colt.function.IntObjectProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepBusConnectionStats;
import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepBusConnectionStats;
import com.neeve.aep.IAepEngineStats;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIntMap;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreSenderStats;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerFileSystemAccessor;
import com.neeve.server.controller.SrvControllerHeartbeatGenerator;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingStats;
import com.neeve.server.mon.SrvMonAppEngineStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerFeederQueueStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerStats;
import com.neeve.server.mon.SrvMonAppMessageLoggerStats;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonAppStoreBindingICRSenderStats;
import com.neeve.server.mon.SrvMonAppStoreBindingPersisterStats;
import com.neeve.server.mon.SrvMonAppStoreBindingRole;
import com.neeve.server.mon.SrvMonAppStoreBindingState;
import com.neeve.server.mon.SrvMonAppStoreBindingStats;
import com.neeve.server.mon.SrvMonAppStoreICRRole;
import com.neeve.server.mon.SrvMonDisruptorClaimStrategy;
import com.neeve.server.mon.SrvMonDisruptorStats;
import com.neeve.server.mon.SrvMonDisruptorWaitStrategy;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.server.mon.SrvMonLongSeries;
import com.neeve.server.mon.SrvMonMsgTypeStats;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSeriesType;
import com.neeve.server.mon.SrvMonSysDiskStats;
import com.neeve.server.mon.SrvMonSysGCCollectorStats;
import com.neeve.server.mon.SrvMonSysGCStats;
import com.neeve.server.mon.SrvMonSysIndividualThreadStats;
import com.neeve.server.mon.SrvMonSysJITStats;
import com.neeve.server.mon.SrvMonSysMemoryEntityTypeCounters;
import com.neeve.server.mon.SrvMonSysMemoryIOBufCounters;
import com.neeve.server.mon.SrvMonSysMemoryNativeCounters;
import com.neeve.server.mon.SrvMonSysMemoryOffHeapUsage;
import com.neeve.server.mon.SrvMonSysMemoryStats;
import com.neeve.server.mon.SrvMonSysMemoryUsage;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.SrvMonSysThreadStats;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.SrvMonUserSeriesStat;
import com.neeve.server.mon.SrvMonUserStats;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.stats.IStats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

final class SrvControllerDirectHeartbeatGenerator
extends SrvControllerHeartbeatGenerator {
    private final SrvController controller;
    private final Sys sys;
    private final Pools pools;
    private final AdminClients adminClients;
    private final Apps apps;
    private final long statsInterval;
    private final WeakHashMap<Thread, XString> threadNameCache = new WeakHashMap();
    private final boolean seriesCollectionEnabled;
    private final SrvController.IntHistogramComputer intervalIntSeriesComputer;
    private final SrvController.LongHistogramComputer intervalLongSeriesComputer;
    private final DoubleArrayList tempSeriesCollectorArray = new DoubleArrayList();
    private final XLinkedHashMap<IStats.Series, SrvController.IntSeriesCollector> intSeriesCollectors = new XLinkedHashMap();
    private final XLinkedHashMap<IStats.Series, SrvController.LongSeriesCollector> longSeriesCollectors = new XLinkedHashMap();
    private final Object processingCriticalSection = new Object();
    private final SrvConfigDescriptor.Heartbeats config;
    private long lastThreadNameCacheCleanup = -1L;
    private boolean done;

    SrvControllerDirectHeartbeatGenerator(SrvController controller) {
        this.config = controller.configDescriptor.getHeartbeats();
        this.setName("X-Server-" + controller.getConfigDescriptor().getName() + "-SrvControllerDirectHeartbeatGenerator");
        this.controller = controller;
        this.sys = new Sys(this);
        this.pools = new Pools(this.config.isCollectPoolStats(), this.config.isCollectAllPoolStats(), controller.configDescriptor.getHeartbeats().getPoolDepletionThreshold());
        this.adminClients = new AdminClients();
        this.apps = new Apps(this);
        this.statsInterval = this.config.getInterval() * 1000L;
        this.seriesCollectionEnabled = this.config.isCollectSeriesStats();
        this.intervalIntSeriesComputer = new SrvController.IntHistogramComputer();
        this.intervalLongSeriesComputer = new SrvController.LongHistogramComputer();
    }

    private final XString lookupThreadName(Thread thread) {
        XString name = this.threadNameCache.get(thread);
        if (name == null) {
            name = XString.create((String)thread.getName());
            this.threadNameCache.put(thread, name);
        }
        if (this.lastThreadNameCacheCleanup == -1L) {
            this.lastThreadNameCacheCleanup = System.currentTimeMillis();
        }
        if (this.threadNameCache.size() > 100 && this.lastThreadNameCacheCleanup - System.currentTimeMillis() > 60000L) {
            Iterator<Thread> cachedThreads = this.threadNameCache.keySet().iterator();
            while (cachedThreads.hasNext()) {
                Thread candidate = cachedThreads.next();
                if (candidate == null || candidate.isAlive()) continue;
                cachedThreads.remove();
            }
        }
        return name;
    }

    private final SrvMonIntSeries collectIntSeriesStats(IStats.Series series) {
        if (this.seriesCollectionEnabled && series != null) {
            SrvController.IntSeriesCollector collector = (SrvController.IntSeriesCollector)this.intSeriesCollectors.get((Object)series);
            if (collector == null) {
                collector = new SrvController.IntSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                this.intSeriesCollectors.put((Object)series, (Object)collector);
            }
            try {
                return collector.collect(this.intervalIntSeriesComputer);
            }
            catch (Throwable e) {
                this.controller.tracer().log("Exception encountered while collecting series (int) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                return null;
            }
        }
        return null;
    }

    private final SrvMonLongSeries collectLongSeriesStats(IStats.Series series) {
        if (this.seriesCollectionEnabled && series != null) {
            SrvController.LongSeriesCollector collector = (SrvController.LongSeriesCollector)this.longSeriesCollectors.get((Object)series);
            if (collector == null) {
                collector = new SrvController.LongSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                this.longSeriesCollectors.put((Object)series, (Object)collector);
            }
            try {
                return collector.collect(this.intervalLongSeriesComputer);
            }
            catch (Throwable e) {
                this.controller.tracer().log("Exception encountered while collecting series (long) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void populateMessageLoggerStats(SrvMonAppMessageLoggerStats.Serializer monMessageLoggerStatsSerializer, IRogMessageLogger.Stats loggerStats) {
        monMessageLoggerStatsSerializer.numMessagesRecorded(loggerStats.getNumMessagesLogged()).numCommits(loggerStats.getNumCommits()).numExplicitFlushes(loggerStats.getNumFlushesExplicit()).numImplicitFlushes(loggerStats.getNumFlushesImplicit()).numForks(0L).fileSize(loggerStats.getFileSize()).fileSizeUsed(loggerStats.getFileSizeUsed()).detachedPersist(loggerStats.isDetached());
        if (loggerStats.isDetached()) {
            SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
            try {
                SrvMonDisruptorStats.Serializer disruptorStatsSerializer = disruptorStats.serializer();
                disruptorStatsSerializer.capacity(loggerStats.getDisruptorCapacity()).remaining(loggerStats.getDisruptorRemaining()).claimStrategy(this.toDisruptorClaimStrategy(loggerStats.getDisruptorClaimStrategy())).waitStrategy(this.toDisruptorWaitStrategy(loggerStats.getDisruptorWaitStrategy()));
                SrvMonIntSeries monIntSeries = this.collectIntSeriesStats((IStats.Series)loggerStats.getOfferToPollLatencies());
                try {
                    disruptorStatsSerializer.offerToPollLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                disruptorStatsSerializer.done();
                monMessageLoggerStatsSerializer.disruptorStats(disruptorStatsSerializer);
            }
            finally {
                disruptorStats.dispose();
            }
        }
        monMessageLoggerStatsSerializer.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void populateHeartbeatLoggerStats(SrvMonHeartbeatMessage.Serializer heartbeatMessageSerializer, IRogMessageLogger.Stats loggerStats) {
        if (loggerStats != null) {
            SrvMonAppMessageLoggerStats monMessageLoggerStats = SrvMonAppMessageLoggerStats.create();
            try {
                SrvMonAppMessageLoggerStats.Serializer monMessageLoggerStatsSerializer = monMessageLoggerStats.serializer();
                this.populateMessageLoggerStats(monMessageLoggerStatsSerializer, loggerStats);
                heartbeatMessageSerializer.heartbeatLoggerStats(monMessageLoggerStatsSerializer);
            }
            finally {
                monMessageLoggerStats.dispose();
            }
        }
    }

    private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
        try {
            return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
        }
        catch (Throwable e) {
            return SrvMonDisruptorClaimStrategy.Unknown;
        }
    }

    private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
        try {
            return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
        }
        catch (Throwable e) {
            return SrvMonDisruptorWaitStrategy.Unknown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void shutdown() {
        Object object = this.processingCriticalSection;
        synchronized (object) {
            this.done = true;
            this.interrupt();
        }
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    final void onPoolAdded(UtlPool<?> pool) {
        this.pools.onPoolAdded(pool);
    }

    @Override
    final void onPoolRemoved(UtlPool<?> pool) {
        this.pools.onPoolRemoved(pool);
    }

    @Override
    final void onAppInitialized(SrvAppLoader appLoader) {
        this.apps.onAppInitialized(appLoader);
    }

    @Override
    final void onAppUnloaded(String appName) {
        this.apps.onAppUnloaded(appName);
    }

    @Override
    final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
        this.adminClients.onAdminClientConnected(client);
    }

    @Override
    final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
        this.adminClients.onAdminClientDisconnected(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        UtlThread.setDefaultCPUAffinityMask();
        long nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
        UtlThread.ThreadStats threadStats = UtlThread.registerOrGetThreadStats((Thread)Thread.currentThread());
        try {
            while (!this.done) {
                try {
                    threadStats.preWait();
                    Thread.sleep(Math.max(0L, nextHeartbeat - System.currentTimeMillis()));
                    threadStats.postWait();
                    nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
                    Object object = this.processingCriticalSection;
                    synchronized (object) {
                        if (!this.done) {
                            try {
                                long wallTime = System.currentTimeMillis();
                                long ts1 = System.nanoTime();
                                SrvMonHeartbeatMessage heartbeatMessage = SrvMonHeartbeatMessage.create();
                                SrvMonHeartbeatMessage.Serializer heartbeatMessageSerializer = heartbeatMessage.serializer(32768);
                                this.sys.populateHeartbeat(heartbeatMessageSerializer);
                                this.pools.populateHeartbeat(heartbeatMessageSerializer);
                                this.apps.populateHeartbeat(heartbeatMessageSerializer);
                                this.adminClients.populateHeartbeat(heartbeatMessageSerializer);
                                if (this.controller.isHeartbeatLogOpen()) {
                                    this.populateHeartbeatLoggerStats(heartbeatMessageSerializer, this.controller.getHeartbeatLogStats());
                                }
                                this.controller.completeHeartbeat(wallTime, ts1, System.nanoTime(), heartbeatMessageSerializer);
                                this.controller.processHeartbeat(heartbeatMessage);
                            }
                            catch (Throwable e) {
                                this.controller.tracer().log("Error preparing/processing heartbeat" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            UtlThread.deregister((Thread)Thread.currentThread());
        }
    }

    static final class Apps {
        private final XLinkedHashMap<String, AppStats> appsStats = new XLinkedHashMap();
        private final XIndexedList<IEventMultiplexerStats.IFeederQueueStats> feederQueueStatsCollector = new XIndexedList();
        private final XIndexedList<IAepBusConnectionStats> busConnectionStatsCollector = new XIndexedList();
        private final MsgTypeStatsCollector msgTypeStatsCollector = new MsgTypeStatsCollector();
        private final int inactiveMessageTypeStatsInclusionFrequency;
        private final SrvControllerDirectHeartbeatGenerator heartbeatGenerator;
        private int inactiveMessageTypeStatsInclusionCountdown = 1;

        public Apps(SrvControllerDirectHeartbeatGenerator heartbeatGenerator) {
            this.heartbeatGenerator = heartbeatGenerator;
            this.inactiveMessageTypeStatsInclusionFrequency = heartbeatGenerator != null ? heartbeatGenerator.config.getInactiveMessageTypeStatsInclusionFrequency() : 1;
            this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
        }

        private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
            try {
                return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorClaimStrategy.Unknown;
            }
        }

        private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
            try {
                return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorWaitStrategy.Unknown;
            }
        }

        private final SrvMonAppStoreBindingRole toStoreBindingRole(IStoreBinding.Role role) {
            if (role != null) {
                switch (role) {
                    case Primary: {
                        return SrvMonAppStoreBindingRole.Primary;
                    }
                    case Backup: {
                        return SrvMonAppStoreBindingRole.Backup;
                    }
                }
                return SrvMonAppStoreBindingRole.Unknown;
            }
            return null;
        }

        private final SrvMonAppStoreICRRole toStoreICRRole(IStoreBinding.InterClusterReplicationRole interClusterReplicationRole) {
            if (interClusterReplicationRole == null) {
                return SrvMonAppStoreICRRole.None;
            }
            switch (interClusterReplicationRole) {
                case Sender: {
                    return SrvMonAppStoreICRRole.Sender;
                }
                case StandaloneReceiver: {
                    return SrvMonAppStoreICRRole.StandaloneReceiver;
                }
            }
            return SrvMonAppStoreICRRole.None;
        }

        private final SrvMonAppStoreBindingState toStoreBindingState(IStoreBinding.State state) {
            if (state != null) {
                switch (state) {
                    case Opening: {
                        return SrvMonAppStoreBindingState.Opening;
                    }
                    case Open: {
                        return SrvMonAppStoreBindingState.Open;
                    }
                    case Failed: {
                        return SrvMonAppStoreBindingState.Failed;
                    }
                    case Closed: {
                        return SrvMonAppStoreBindingState.Closed;
                    }
                }
                return SrvMonAppStoreBindingState.Unknown;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateInboundMessageLoggerStats(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, IRogMessageLogger.Stats loggerStats) {
            if (loggerStats != null) {
                SrvMonAppMessageLoggerStats monMessageLoggerStats = SrvMonAppMessageLoggerStats.create();
                try {
                    SrvMonAppMessageLoggerStats.Serializer monMessageLoggerStatsSerializer = monMessageLoggerStats.serializer();
                    this.heartbeatGenerator.populateMessageLoggerStats(monMessageLoggerStatsSerializer, loggerStats);
                    monEngineStatsSerializer.inboundMessageLoggerStats(monMessageLoggerStatsSerializer);
                }
                finally {
                    monMessageLoggerStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateOutboundMessageLoggerStats(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, IRogMessageLogger.Stats loggerStats) {
            if (loggerStats != null) {
                SrvMonAppMessageLoggerStats monMessageLoggerStats = SrvMonAppMessageLoggerStats.create();
                try {
                    SrvMonAppMessageLoggerStats.Serializer monMessageLoggerStatsSerializer = monMessageLoggerStats.serializer();
                    this.heartbeatGenerator.populateMessageLoggerStats(monMessageLoggerStatsSerializer, loggerStats);
                    monEngineStatsSerializer.outboundMessageLoggerStats(monMessageLoggerStatsSerializer);
                }
                finally {
                    monMessageLoggerStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populatePerTransactionStatsLoggerStats(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, IRogMessageLogger.Stats loggerStats) {
            if (loggerStats != null) {
                SrvMonAppMessageLoggerStats monMessageLoggerStats = SrvMonAppMessageLoggerStats.create();
                try {
                    SrvMonAppMessageLoggerStats.Serializer monMessageLoggerStatsSerializer = monMessageLoggerStats.serializer();
                    this.heartbeatGenerator.populateMessageLoggerStats(monMessageLoggerStatsSerializer, loggerStats);
                    monEngineStatsSerializer.perTransactionStatsLoggerStats(monMessageLoggerStatsSerializer);
                }
                finally {
                    monMessageLoggerStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEngineStats(SrvMonAppStats.Serializer monAppStatsSerializer, IAepEngineStats engineStats) {
            SrvMonAppEngineStats monEngineStats = SrvMonAppEngineStats.create();
            try {
                SrvMonAppEngineStats.Serializer monEngineStatsSerializer = monEngineStats.serializer();
                monEngineStatsSerializer.numFlows(engineStats.getNumFlows()).numMsgsRcvdBestEffort(engineStats.getNumMsgsRcvdBestEffort()).numMsgsRcvdGuaranteed(engineStats.getNumMsgsRcvdGuaranteed()).numMsgsFiltered(engineStats.getNumMsgsFiltered()).numMsgsSourced(engineStats.getNumMsgsSourced()).numDupMsgsRcvd(engineStats.getNumDupMsgsRcvd()).numMsgsSentBestEffort(engineStats.getNumMsgsSentBestEffort()).numMsgsSentGuaranteed(engineStats.getNumMsgsSentGuaranteed()).numMsgsResent(engineStats.getNumMsgsResent()).numEventsRcvd(engineStats.getNumEventsRcvd()).numEventsProcessed(engineStats.getNumEventsProcessed()).numFlowEventsRcvd(engineStats.getNumFlowEventsRcvd()).numFlowEventsProcSuccess(engineStats.getNumFlowEventsProcSuccess()).numFlowEventsProcFail(engineStats.getNumFlowEventsProcFail()).numFlowEventsProcComplete(engineStats.getNumFlowEventsProcComplete()).numTransactions(engineStats.getNumTransactions()).numCommitsStarted(engineStats.getNumCommitsStarted()).numCommitsCompleted(engineStats.getNumCommitsCompleted()).numSendCommitsStarted(engineStats.getNumSendCommitsStarted()).numSendCommitsCompleted(engineStats.getNumSendCommitsCompleted()).sendCommitCompletionQueueSize(engineStats.getSendCommitCompletionQueueSize()).numStoreCommitsStarted(engineStats.getNumStoreCommitsStarted()).numStoreCommitsCompleted(engineStats.getNumStoreCommitsCompleted()).storeCommitCompletionQueueSize(engineStats.getStoreCommitCompletionQueueSize()).numRollbacks(engineStats.getNumRollbacks()).numPartialRollbacks(engineStats.getNumPartialRollbacks()).backupOutboundQueueSize(engineStats.getBackupOutboundQueueSize()).backupOutboundLogQueueSize(engineStats.getBackupOutboundLogQueueSize()).outboundSno(engineStats.getOutboundSequenceNumber()).outboundStableSno(engineStats.getOutboundStableSequenceNumber());
                SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitEpilogueLatencies());
                try {
                    monEngineStatsSerializer.commitEpilogueLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitFullLatencies());
                try {
                    monEngineStatsSerializer.commitFullLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitPrologueLatencies());
                try {
                    monEngineStatsSerializer.commitPrologueLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitSendLatencies());
                try {
                    monEngineStatsSerializer.commitSendLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitStartLatencies());
                try {
                    monEngineStatsSerializer.commitStartLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitStoreLatencies());
                try {
                    monEngineStatsSerializer.commitStoreLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitTransitionLatencies());
                try {
                    monEngineStatsSerializer.commitTransitionLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getInAckLatencies());
                try {
                    monEngineStatsSerializer.inAckLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getInOutLatencies());
                try {
                    monEngineStatsSerializer.inOutLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgPreProcessingLatencies());
                try {
                    monEngineStatsSerializer.msgPreProcLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgProcessingLatencies());
                try {
                    monEngineStatsSerializer.msgProcessingLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgFilteringLatencies());
                try {
                    monEngineStatsSerializer.msgFilteringLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendCoreLatencies());
                try {
                    monEngineStatsSerializer.msgSendCoreLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendLatencies());
                try {
                    monEngineStatsSerializer.msgSendLatencies(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg1ProcessingTimes());
                try {
                    monEngineStatsSerializer.transactionLeg1ProcessingTimes(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg2ProcessingTimes());
                try {
                    monEngineStatsSerializer.transactionLeg2ProcessingTimes(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg3ProcessingTimes());
                try {
                    monEngineStatsSerializer.transactionLeg3ProcessingTimes(monIntSeries);
                }
                finally {
                    if (monIntSeries != null) {
                        monIntSeries.dispose();
                    }
                }
                if (this.heartbeatGenerator.config.isIncludeMessageTypeStats()) {
                    this.msgTypeStatsCollector.collect(monEngineStatsSerializer, engineStats.getMessageTypeStatsTable());
                }
                this.populateInboundMessageLoggerStats(monEngineStatsSerializer, engineStats.getInboundMessageLoggerStats());
                this.populateOutboundMessageLoggerStats(monEngineStatsSerializer, engineStats.getOutboundMessageLoggerStats());
                this.populatePerTransactionStatsLoggerStats(monEngineStatsSerializer, engineStats.getPerTransactionStatsLoggerStats());
                monEngineStatsSerializer.done();
                monAppStatsSerializer.engineStats(monEngineStatsSerializer);
            }
            finally {
                monEngineStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEventMultiplexerFeederQueueStats(SrvMonAppEventMultiplexerStats.Serializer monEventMultiplexerStatsSerializer, IEventMultiplexerStats eventMultiplexerStats) {
            if (eventMultiplexerStats != null) {
                SrvMonAppEventMultiplexerFeederQueueStats monEventMultiplexerFeederQueueStats = SrvMonAppEventMultiplexerFeederQueueStats.create();
                try {
                    this.feederQueueStatsCollector.clear();
                    eventMultiplexerStats.getFeederQueueStats(this.feederQueueStatsCollector);
                    for (int i = 0; i < this.feederQueueStatsCollector.size(); ++i) {
                        SrvMonAppEventMultiplexerFeederQueueStats.Serializer monEventMultiplexerFeederQueueStatsSerializer = monEventMultiplexerFeederQueueStats.serializer();
                        Thread owner = ((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOwner();
                        if (owner == null) continue;
                        if (this.heartbeatGenerator != null) {
                            monEventMultiplexerFeederQueueStatsSerializer.owner(this.heartbeatGenerator.lookupThreadName(owner));
                        } else {
                            monEventMultiplexerFeederQueueStatsSerializer.owner(owner.getName());
                        }
                        monEventMultiplexerFeederQueueStatsSerializer.size(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getSize());
                        monEventMultiplexerFeederQueueStatsSerializer.decongestCount(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getDecongestCount());
                        SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOfferToPollLatencies());
                        try {
                            monEventMultiplexerFeederQueueStatsSerializer.offerToPollLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monEventMultiplexerFeederQueueStatsSerializer.done();
                        monEventMultiplexerStatsSerializer.feederQueueStats(monEventMultiplexerFeederQueueStatsSerializer);
                    }
                }
                finally {
                    monEventMultiplexerFeederQueueStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEventMultiplexerDisruptorStats(SrvMonAppEventMultiplexerStats.Serializer monEventMultiplexerStatsSerializer, IEventMultiplexerStats eventMultiplexerStats) {
            if (eventMultiplexerStats != null) {
                SrvMonDisruptorStats monEventMultiplexerDisruptorStats = SrvMonDisruptorStats.create();
                try {
                    SrvMonDisruptorStats.Serializer monEventMultiplexerDisruptorStatsSerializer = monEventMultiplexerDisruptorStats.serializer();
                    monEventMultiplexerDisruptorStatsSerializer.capacity(eventMultiplexerStats.getCapacity()).remaining(eventMultiplexerStats.getCapacityRemaining()).claimStrategy(this.toDisruptorClaimStrategy(eventMultiplexerStats.getClaimStrategy())).waitStrategy(this.toDisruptorWaitStrategy(eventMultiplexerStats.getWaitStrategy()));
                    SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)eventMultiplexerStats.getOfferToPollLatencies());
                    try {
                        monEventMultiplexerDisruptorStatsSerializer.offerToPollLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monEventMultiplexerDisruptorStatsSerializer.done();
                    monEventMultiplexerStatsSerializer.disruptorStats(monEventMultiplexerDisruptorStatsSerializer);
                }
                finally {
                    monEventMultiplexerDisruptorStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEventMultiplexerStats(SrvMonAppStats.Serializer monAppStatsSerializer, IEventMultiplexerStats eventMultiplexerStats) {
            if (eventMultiplexerStats != null) {
                SrvMonAppEventMultiplexerStats monEventMultiplexerStats = SrvMonAppEventMultiplexerStats.create();
                try {
                    SrvMonAppEventMultiplexerStats.Serializer monEventMultiplexerStatsSerializer = monEventMultiplexerStats.serializer();
                    monEventMultiplexerStatsSerializer.lastDecongested(eventMultiplexerStats.getLastDecongested()).maxConcurrency(eventMultiplexerStats.getMaxConcurrency()).scheduleQueueSize(eventMultiplexerStats.getScheduleQueueSize());
                    this.populateEventMultiplexerDisruptorStats(monEventMultiplexerStatsSerializer, eventMultiplexerStats);
                    this.populateEventMultiplexerFeederQueueStats(monEventMultiplexerStatsSerializer, eventMultiplexerStats);
                    monEventMultiplexerStatsSerializer.done();
                    monAppStatsSerializer.eventMultiplexerStats(monEventMultiplexerStatsSerializer);
                }
                finally {
                    monEventMultiplexerStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateStoreBindingPersisterStats(SrvMonAppStoreBindingStats.Serializer monStoreBindingStatsSerializer, IStorePersisterStats persisterStats) {
            if (persisterStats != null) {
                SrvMonAppStoreBindingPersisterStats monStoreBindingPersisterStats = SrvMonAppStoreBindingPersisterStats.create();
                try {
                    SrvMonAppStoreBindingPersisterStats.Serializer monStoreBindingPersisterStatsSerializer = monStoreBindingPersisterStats.serializer();
                    monStoreBindingPersisterStatsSerializer.numPutsRecorded(persisterStats.getNumPutsRecorded()).numUpdatesRecorded(persisterStats.getNumUpdatesRecorded()).numRemovesRecorded(persisterStats.getNumRemovesRecorded()).numSendsRecorded(persisterStats.getNumSendsRecorded()).numCommits(persisterStats.getNumCommits()).numForks(persisterStats.getNumForks()).fileSize(persisterStats.getFileSize()).fileSizeUsed(persisterStats.getFileSizeUsed()).detachedPersist(persisterStats.isDetached());
                    if (persisterStats.isDetached()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        try {
                            SrvMonDisruptorStats.Serializer disruptorStatsSerializer = disruptorStats.serializer();
                            disruptorStatsSerializer.capacity(persisterStats.getDisruptorCapacity()).remaining(persisterStats.getDisruptorRemaining()).claimStrategy(this.toDisruptorClaimStrategy(persisterStats.getDisruptorClaimStrategy())).waitStrategy(this.toDisruptorWaitStrategy(persisterStats.getDisruptorWaitStrategy()));
                            SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)persisterStats.getOfferToPollLatencies());
                            try {
                                disruptorStatsSerializer.offerToPollLatencies(monIntSeries);
                            }
                            finally {
                                if (monIntSeries != null) {
                                    monIntSeries.dispose();
                                }
                            }
                            disruptorStatsSerializer.done();
                            monStoreBindingPersisterStatsSerializer.disruptorStats(disruptorStatsSerializer);
                        }
                        finally {
                            disruptorStats.dispose();
                        }
                    }
                    monStoreBindingPersisterStatsSerializer.done();
                    monStoreBindingStatsSerializer.persisterStats(monStoreBindingPersisterStatsSerializer);
                }
                finally {
                    monStoreBindingPersisterStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateStoreBindingICRSenderStats(SrvMonAppStoreBindingStats.Serializer monStoreBindingStatsSerializer, IStoreSenderStats senderStats) {
            if (senderStats != null) {
                SrvMonAppStoreBindingICRSenderStats monStoreBindingICRSenderStats = SrvMonAppStoreBindingICRSenderStats.create();
                try {
                    SrvMonAppStoreBindingICRSenderStats.Serializer monStoreBindingICRSenderStatsSerializer = monStoreBindingICRSenderStats.serializer();
                    monStoreBindingICRSenderStatsSerializer.numPutsRecorded(senderStats.getNumPutsRecorded()).numUpdatesRecorded(senderStats.getNumUpdatesRecorded()).numRemovesRecorded(senderStats.getNumRemovesRecorded()).numSendsRecorded(senderStats.getNumSendsRecorded()).numCommits(senderStats.getNumCommits()).numForks(senderStats.getNumForks()).detachedSend(senderStats.isDetached());
                    if (senderStats.isDetached()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        try {
                            SrvMonDisruptorStats.Serializer disruptorStatsSerializer = disruptorStats.serializer();
                            disruptorStatsSerializer.capacity(senderStats.getDisruptorCapacity()).remaining(senderStats.getDisruptorRemaining()).claimStrategy(this.toDisruptorClaimStrategy(senderStats.getDisruptorClaimStrategy())).waitStrategy(this.toDisruptorWaitStrategy(senderStats.getDisruptorWaitStrategy()));
                            SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)senderStats.getOfferToPollLatencies());
                            try {
                                disruptorStatsSerializer.offerToPollLatencies(monIntSeries);
                            }
                            finally {
                                if (monIntSeries != null) {
                                    monIntSeries.dispose();
                                }
                            }
                            disruptorStatsSerializer.done();
                            monStoreBindingICRSenderStatsSerializer.disruptorStats(disruptorStatsSerializer);
                        }
                        finally {
                            disruptorStats.dispose();
                        }
                    }
                    monStoreBindingICRSenderStatsSerializer.done();
                    monStoreBindingStatsSerializer.iCRSenderStats(monStoreBindingICRSenderStatsSerializer);
                }
                finally {
                    monStoreBindingICRSenderStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateStoreBindingStats(SrvMonAppStats.Serializer monAppStatsSerializer, IStoreBindingStats storeBindingStats) {
            if (storeBindingStats != null) {
                SrvMonAppStoreBindingStats monStoreBindingStats = SrvMonAppStoreBindingStats.create();
                try {
                    SrvMonAppStoreBindingStats.Serializer monStoreBindingStatsSerializer = monStoreBindingStats.serializer();
                    monStoreBindingStatsSerializer.role(this.toStoreBindingRole(storeBindingStats.getRole())).iCRRole(this.toStoreICRRole(storeBindingStats.getBinding().getInterClusterReplicationRole())).state(this.toStoreBindingState(storeBindingStats.getState())).size(storeBindingStats.getBinding().sizeUnprotected()).dataSize(storeBindingStats.getDataSize()).numCommitsSent(storeBindingStats.getNumCommitsSent()).numCommitEntriesSent(storeBindingStats.getNumCommitEntriesSent()).numCommitsReceived(storeBindingStats.getNumCommitsReceived()).numCommitEntriesReceived(storeBindingStats.getNumCommitEntriesReceived()).numCommitCompletionsSent(storeBindingStats.getNumCommitCompletionsSent()).numCommitCompletionsReceived(storeBindingStats.getNumCommitCompletionsReceived());
                    SrvMonIntSeries monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getCommitLatencies());
                    try {
                        monStoreBindingStatsSerializer.commitLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats(storeBindingStats.getCommitQueueSizes());
                    try {
                        monStoreBindingStatsSerializer.commitQueueSize(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getDeserializeLatencies());
                    try {
                        monStoreBindingStatsSerializer.deserializeLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getIcrSendLatencies());
                    try {
                        monStoreBindingStatsSerializer.icrSendLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getIndexLatencies());
                    try {
                        monStoreBindingStatsSerializer.indexLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getPersisterLatencies());
                    try {
                        monStoreBindingStatsSerializer.persistLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeLatencies());
                    try {
                        monStoreBindingStatsSerializer.serializeLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToPersistLatencies());
                    try {
                        monStoreBindingStatsSerializer.serializeToPersistLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToWireLatencies());
                    try {
                        monStoreBindingStatsSerializer.serializeToWireLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireLatencies());
                    try {
                        monStoreBindingStatsSerializer.wireLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireToDeserializeLatencies());
                    try {
                        monStoreBindingStatsSerializer.wireToDeserializeLatencies(monIntSeries);
                    }
                    finally {
                        if (monIntSeries != null) {
                            monIntSeries.dispose();
                        }
                    }
                    this.populateStoreBindingPersisterStats(monStoreBindingStatsSerializer, storeBindingStats.getPersisterStats());
                    this.populateStoreBindingICRSenderStats(monStoreBindingStatsSerializer, storeBindingStats.getICRSenderStats());
                    monStoreBindingStatsSerializer.done();
                    monAppStatsSerializer.storeBindingStats(monStoreBindingStatsSerializer);
                }
                finally {
                    monStoreBindingStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateBusConnectionStats(SrvMonAppStats.Serializer monAppStatsSerializer, List<IAepBusConnectionStats> busConnectionsStats) {
            SrvMonAppBusBindingStats monBusBindingStats = SrvMonAppBusBindingStats.create();
            try {
                for (int i = 0; i < busConnectionsStats.size(); ++i) {
                    MessageLatencyManager lm;
                    SrvMonIntSeries monIntSeries;
                    IAepBusConnectionStats busConnectionStats = busConnectionsStats.get(i);
                    SrvMonAppBusBindingStats.Serializer monBusBindingStatsSerializer = monBusBindingStats.serializer();
                    monBusBindingStatsSerializer.busBindingName(busConnectionStats.getBusConnection().getBusDescriptor().getName()).internal(busConnectionStats.getBusConnection().isInternal()).numMsgsRcvd(busConnectionStats.getNumMsgsRcvd()).numMsgsInBatchesRcvd(busConnectionStats.getNumMsgsInBatchesRcvd()).numMsgBatchesRcvd(busConnectionStats.getNumMsgBatchesRcvd()).numAcksSent(busConnectionStats.getNumAcksSent()).numMsgsEnqueued(busConnectionStats.getNumMsgsEnqueued()).numMsgsSent(busConnectionStats.getNumMsgsSent()).numStabilityRcvd(busConnectionStats.getNumStabilityRcvd()).numStabilityInBatchesRcvd(busConnectionStats.getNumStabilityInBatchesRcvd()).numStabilityBatchesRcvd(busConnectionStats.getNumStabilityBatchesRcvd()).numPacketsRcvd(busConnectionStats.getNumPacketsRcvd()).numCommits(busConnectionStats.getNumCommits()).numRollbacks(busConnectionStats.getNumRollbacks()).numPartialRollbacks(busConnectionStats.getNumPartialRollbacks()).numClients(busConnectionStats.getNumClients()).numChannelsUp(busConnectionStats.getNumChannelsUp()).numBindingFailures(busConnectionStats.getNumBindingFailures()).detachedCommit(busConnectionStats.isDetachedCommit());
                    if (busConnectionStats.isDetachedCommit()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        try {
                            SrvMonDisruptorStats.Serializer disruptorStatsSerializer = disruptorStats.serializer();
                            disruptorStatsSerializer.capacity(busConnectionStats.getDisruptorCapacity()).remaining(busConnectionStats.getDisruptorRemaining()).claimStrategy(this.toDisruptorClaimStrategy(busConnectionStats.getDisruptorClaimStrategy())).waitStrategy(this.toDisruptorWaitStrategy(busConnectionStats.getDisruptorWaitStrategy()));
                            monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)busConnectionStats.getDisruptorOfferToPollLatencies());
                            try {
                                disruptorStatsSerializer.offerToPollLatencies(monIntSeries);
                            }
                            finally {
                                if (monIntSeries != null) {
                                    monIntSeries.dispose();
                                }
                            }
                            disruptorStatsSerializer.done();
                            monBusBindingStatsSerializer.disruptorStats(disruptorStatsSerializer);
                        }
                        finally {
                            disruptorStats.dispose();
                        }
                    }
                    if ((lm = busConnectionStats.getLatencyManager()) != null) {
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getCreateToSendLatencies());
                        try {
                            monBusBindingStatsSerializer.createToSendLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getDeserializeLatencies());
                        try {
                            monBusBindingStatsSerializer.deserializeLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getDeserializeToReceiveLatencies());
                        try {
                            monBusBindingStatsSerializer.deserializeToReceiveLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getOriginToReceiveLatencies());
                        try {
                            monBusBindingStatsSerializer.originToReceiveLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSendToPollLatencies());
                        try {
                            monBusBindingStatsSerializer.sendToPollLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSendToSerializeLatencies());
                        try {
                            monBusBindingStatsSerializer.sendToSerializeLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSerializeLatencies());
                        try {
                            monBusBindingStatsSerializer.serializeLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSerializeToWireLatencies());
                        try {
                            monBusBindingStatsSerializer.serializeToWireLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireSendLatencies());
                        try {
                            monBusBindingStatsSerializer.wireSendLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireLatencies());
                        try {
                            monBusBindingStatsSerializer.wireLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireToDeserializeLatencies());
                        try {
                            monBusBindingStatsSerializer.wireToDeserializeLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                        monIntSeries = this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireToWireLatencies());
                        try {
                            monBusBindingStatsSerializer.wireToWireLatencies(monIntSeries);
                        }
                        finally {
                            if (monIntSeries != null) {
                                monIntSeries.dispose();
                            }
                        }
                    }
                    monBusBindingStatsSerializer.done();
                    monAppStatsSerializer.busBindingStats(monBusBindingStatsSerializer);
                }
            }
            finally {
                monBusBindingStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateUserSeriesStats(SrvMonUserStats.Serializer userStatsSerializer, IStats.Series recorded) {
            SrvMonUserSeriesStat userSeriesStat = SrvMonUserSeriesStat.create();
            try {
                SrvMonUserSeriesStat.Serializer userSeriesStatSerializer = userSeriesStat.serializer();
                userSeriesStatSerializer.name(recorded.getNameAsRaw()).seriesType(SrvMonSeriesType.LONG);
                SrvMonLongSeries monLongSeries = this.heartbeatGenerator.collectLongSeriesStats(recorded);
                try {
                    userSeriesStatSerializer.longSeries(monLongSeries);
                }
                finally {
                    if (monLongSeries != null) {
                        monLongSeries.dispose();
                    }
                }
                userSeriesStatSerializer.done();
                userStatsSerializer.series(userSeriesStatSerializer);
            }
            finally {
                userSeriesStat.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateUserCounterStats(SrvMonUserStats.Serializer userStatsSerializer, IStats.Counter recorded) {
            SrvMonUserCounterStat userCounterStat = SrvMonUserCounterStat.create();
            try {
                SrvMonUserCounterStat.Serializer userCounterStatSerializer = userCounterStat.serializer();
                userCounterStatSerializer.name(recorded.getNameAsRaw()).count(recorded.getCount()).done();
                userStatsSerializer.counters(userCounterStatSerializer);
            }
            finally {
                userCounterStat.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateUserGaugeStats(SrvMonUserStats.Serializer userStatsSerializer, IStats.Gauge recorded) {
            SrvMonUserGaugeStat userGaugeStat = SrvMonUserGaugeStat.create();
            try {
                SrvMonUserGaugeStat.Serializer userGaugeStatSerializer = userGaugeStat.serializer();
                userGaugeStatSerializer.name(recorded.getNameAsRaw());
                SrvMonUtil.addGaugeValue(userGaugeStatSerializer, recorded);
                userGaugeStatSerializer.done();
                userStatsSerializer.gauges(userGaugeStatSerializer);
            }
            finally {
                userGaugeStat.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateUserStats(SrvMonAppStats.Serializer monAppStatsSerializer, IAepEngineStats engineStats) {
            List userSeries = engineStats.getUserSeriesStats();
            List userCounters = engineStats.getUserCounterStats();
            List userGauges = engineStats.getUserGaugeStats();
            if (!userSeries.isEmpty() && this.heartbeatGenerator.seriesCollectionEnabled || !userCounters.isEmpty() || !userGauges.isEmpty()) {
                SrvMonUserStats userStats = SrvMonUserStats.create();
                try {
                    int i;
                    SrvMonUserStats.Serializer userStatsSerializer = userStats.serializer();
                    if (!userSeries.isEmpty() && this.heartbeatGenerator.seriesCollectionEnabled) {
                        for (i = 0; i < userSeries.size(); ++i) {
                            this.populateUserSeriesStats(userStatsSerializer, (IStats.Series)userSeries.get(i));
                        }
                    }
                    if (!userCounters.isEmpty()) {
                        for (i = 0; i < userCounters.size(); ++i) {
                            this.populateUserCounterStats(userStatsSerializer, (IStats.Counter)userCounters.get(i));
                        }
                    }
                    if (!userGauges.isEmpty()) {
                        for (i = 0; i < userGauges.size(); ++i) {
                            this.populateUserGaugeStats(userStatsSerializer, (IStats.Gauge)userGauges.get(i));
                        }
                    }
                    userStatsSerializer.done();
                    monAppStatsSerializer.userStats(userStatsSerializer);
                }
                finally {
                    userStats.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void populateHeartbeat(SrvMonHeartbeatMessage.Serializer heartbeatSerializer) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                --this.inactiveMessageTypeStatsInclusionCountdown;
                SrvMonAppStats monAppStats = SrvMonAppStats.create();
                try {
                    XIterator appsStatsIt = this.appsStats.reuseableValueIterator();
                    while (appsStatsIt.hasNext()) {
                        AppStats appStats = (AppStats)appsStatsIt.next();
                        IAepEngineStats engineStats = appStats.appLoader.getAppEngine().getStats();
                        SrvMonAppStats.Serializer monAppStatsSerializer = monAppStats.serializer();
                        monAppStatsSerializer.appName(appStats.appLoader.getAppName());
                        this.populateEngineStats(monAppStatsSerializer, engineStats);
                        this.populateEventMultiplexerStats(monAppStatsSerializer, engineStats.getEventMultiplexerStats());
                        this.populateStoreBindingStats(monAppStatsSerializer, engineStats.getStoreBindingStats());
                        this.busConnectionStatsCollector.clear();
                        engineStats.getBusConnectionStats(this.busConnectionStatsCollector);
                        this.populateBusConnectionStats(monAppStatsSerializer, (List<IAepBusConnectionStats>)this.busConnectionStatsCollector);
                        this.populateUserStats(monAppStatsSerializer, engineStats);
                        heartbeatSerializer.appsStats(monAppStatsSerializer);
                    }
                }
                finally {
                    monAppStats.dispose();
                }
                if (this.inactiveMessageTypeStatsInclusionCountdown <= 0) {
                    this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAppInitialized(SrvAppLoader appLoader) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                this.appsStats.put((Object)appLoader.getAppName(), (Object)new AppStats(appLoader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAppUnloaded(String appName) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                this.appsStats.remove((Object)appName);
            }
        }

        private final class AppStats {
            private final SrvAppLoader appLoader;
            private final NumberFormat format;
            private EngineStats engineStats;
            private StoreBindingStats storeBindingStats;
            private Map<String, BusBindingStats> busBindingsStats = new HashMap<String, BusBindingStats>();
            private long startTime;
            private long stampTime;

            AppStats(SrvAppLoader appLoader) {
                this.format = NumberFormat.getInstance();
                this.format.setMaximumFractionDigits(2);
                this.appLoader = appLoader;
                this.stampTime = this.startTime = System.currentTimeMillis();
                this.init(appLoader);
            }

            AppStats(SrvMonAppStats stats, long collectionTime) {
                this.format = NumberFormat.getInstance();
                this.format.setMaximumFractionDigits(2);
                this.appLoader = null;
                this.stampTime = this.startTime = collectionTime;
                this.refresh(stats);
            }

            private final void init(SrvAppLoader appLoader) {
                AepEngine engine = appLoader.getAppEngine();
                this.engineStats = new EngineStats(engine);
                if (engine.getStore() != null) {
                    this.storeBindingStats = new StoreBindingStats(engine.getStore());
                }
                for (AepBusConnection busConnection : engine.getBusConnections()) {
                    this.busBindingsStats.put(busConnection.getBusDescriptor().getName(), new BusBindingStats(busConnection));
                }
            }

            private final void refresh(SrvMonAppStats stats) {
            }

            private final void stamp(SrvMonAppStats stats) {
                SrvMonAppBusBindingStats[] monBusBindingsStats;
                if (stats.getEngineStats() != null) {
                    if (this.engineStats == null) {
                        this.engineStats = new EngineStats(stats.getEngineStats());
                    }
                    this.engineStats.stamp(stats.getEngineStats());
                }
                if (stats.getStoreBindingStats() != null) {
                    if (this.storeBindingStats == null) {
                        this.storeBindingStats = new StoreBindingStats(stats.getStoreBindingStats());
                    }
                    this.storeBindingStats.stamp(stats.getStoreBindingStats());
                }
                if ((monBusBindingsStats = stats.getBusBindingStats()) != null) {
                    for (SrvMonAppBusBindingStats monBusBindingStats : monBusBindingsStats) {
                        BusBindingStats busBindingStats = this.busBindingsStats.get(monBusBindingStats.getBusBindingName());
                        if (busBindingStats == null) {
                            busBindingStats = new BusBindingStats(monBusBindingStats);
                            this.busBindingsStats.put(monBusBindingStats.getBusBindingName(), busBindingStats);
                        }
                        busBindingStats.stamp(monBusBindingStats);
                    }
                }
                this.refresh(stats);
            }

            private final class BusBindingStats {
                private long numMsgsRcvdLast;
                private long numMsgsInBatchesRcvdLast;
                private long numMsgBatchesRcvdLast;
                private long numMsgsEnqueuedLast;
                private long numMsgsSentLast;
                private long numFlushesSyncLast;
                private long numMsgsFlushedSyncLast;
                private long numFlushesAsyncLast;
                private long numMsgsFlushedAsyncLast;
                private long numStabilityRcvdLast;
                private long numStabilityInBatchesRcvdLast;
                private long numStabilityBatchesRcvdLast;
                private long numPacketsRcvdLast;
                private long numCommitsLast;
                private long numMsgsRcvdCurrent;
                private long numMsgsInBatchesRcvdCurrent;
                private long numMsgBatchesRcvdCurrent;
                private long numMsgsEnqueuedCurrent;
                private long numMsgsSentCurrent;
                private long numFlushesSyncCurrent;
                private long numMsgsFlushedSyncCurrent;
                private long numFlushesAsyncCurrent;
                private long numMsgsFlushedAsyncCurrent;
                private long numStabilityRcvdCurrent;
                private long numStabilityInBatchesRcvdCurrent;
                private long numStabilityBatchesRcvdCurrent;
                private long numPacketsRcvdCurrent;
                private long numCommitsCurrent;
                private long numRollbacksCurrent;
                private int numClientsCurrent;
                private int numChannelsUpCurrent;
                private int numBindingFailuresCurrent;

                BusBindingStats(AepBusConnection busConnection) {
                    this.init(busConnection);
                }

                BusBindingStats(SrvMonAppBusBindingStats stats) {
                    this.refresh(stats);
                }

                private final void init(AepBusConnection busConnection) {
                    AepBusConnectionStats stats = busConnection.getStats();
                    this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                    this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                    this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                    this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                    this.numMsgsSentCurrent = stats.getNumMsgsSent();
                    this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                    this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                    this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                    this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                    this.numCommitsCurrent = stats.getNumCommits();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numClientsCurrent = stats.getNumClients();
                    this.numChannelsUpCurrent = stats.getNumChannelsUp();
                    this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                }

                private final void refresh(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                    this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                    this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                    this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                    this.numMsgsSentCurrent = stats.getNumMsgsSent();
                    this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                    this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                    this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                    this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                    this.numCommitsCurrent = stats.getNumCommits();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numClientsCurrent = stats.getNumClients();
                    this.numChannelsUpCurrent = stats.getNumChannelsUp();
                    this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                }

                final void stamp(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdLast = this.numMsgsRcvdCurrent;
                    this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvdCurrent;
                    this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvdCurrent;
                    this.numMsgsEnqueuedLast = this.numMsgsEnqueuedCurrent;
                    this.numMsgsSentLast = this.numMsgsSentCurrent;
                    this.numStabilityRcvdLast = this.numStabilityRcvdCurrent;
                    this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvdCurrent;
                    this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvdCurrent;
                    this.numPacketsRcvdLast = this.numPacketsRcvdCurrent;
                    this.numCommitsLast = this.numCommitsCurrent;
                    this.refresh(stats);
                }
            }

            private final class StoreBindingStats {
                private long numCommitsSentLast;
                private long numCommitEntriesSentLast;
                private long numCommitsReceivedLast;
                private long numCommitEntriesReceivedLast;
                private long numCommitCompletionsSentLast;
                private long numCommitCompletionsReceivedLast;
                private int sizeCurrent;
                private long numCommitsSentCurrent;
                private long numCommitEntriesSentCurrent;
                private long numCommitsReceivedCurrent;
                private long numCommitEntriesReceivedCurrent;
                private long numCommitCompletionsSentCurrent;
                private long numCommitCompletionsReceivedCurrent;
                private PersisterStats persisterStats;
                private ICRSenderStats icrSenderStats;

                StoreBindingStats(IStoreBinding binding) {
                    this.init(binding);
                }

                StoreBindingStats(SrvMonAppStoreBindingStats stats) {
                    this.refresh(stats);
                }

                private final void init(IStoreBinding storeBinding) {
                    IStoreBindingStats stats = storeBinding.getStats();
                    this.sizeCurrent = storeBinding.size();
                    this.numCommitsSentCurrent = stats.getNumCommitsSent();
                    this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                    this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                    this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                    this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                    this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                    this.persisterStats = storeBinding.getPersister() != null ? new PersisterStats(storeBinding.getPersister()) : null;
                    this.icrSenderStats = storeBinding.getICRSender() != null ? new ICRSenderStats(storeBinding.getICRSender()) : null;
                }

                private final void refresh(SrvMonAppStoreBindingStats stats) {
                    this.sizeCurrent = stats.getSize();
                    this.numCommitsSentCurrent = stats.getNumCommitsSent();
                    this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                    this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                    this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                    this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                    this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                }

                final void stamp(SrvMonAppStoreBindingStats stats) {
                    this.numCommitsSentLast = this.numCommitsSentCurrent;
                    this.numCommitEntriesSentLast = this.numCommitEntriesSentCurrent;
                    this.numCommitsReceivedLast = this.numCommitsReceivedCurrent;
                    this.numCommitEntriesReceivedLast = this.numCommitEntriesReceivedCurrent;
                    this.numCommitCompletionsSentLast = this.numCommitCompletionsSentCurrent;
                    this.numCommitCompletionsReceivedLast = this.numCommitCompletionsReceivedCurrent;
                    this.refresh(stats);
                    if (stats.getPersisterStats() != null) {
                        if (this.persisterStats == null) {
                            this.persisterStats = new PersisterStats(stats.getPersisterStats());
                        }
                        this.persisterStats.stamp(stats.getPersisterStats());
                    }
                    if (stats.getICRSenderStats() != null) {
                        if (this.icrSenderStats == null) {
                            this.icrSenderStats = new ICRSenderStats(stats.getICRSenderStats());
                        }
                        this.icrSenderStats.stamp(stats.getICRSenderStats());
                    }
                }

                private final class ICRSenderStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;

                    ICRSenderStats(IStoreSender sender) {
                        this.init(sender);
                    }

                    ICRSenderStats(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.refresh(stats);
                    }

                    private final void init(IStoreSender sender) {
                        IStoreSenderStats stats = sender.getStats();
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    private final void refresh(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    final void stamp(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.refresh(stats);
                    }
                }

                private final class PersisterStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;

                    PersisterStats(IStorePersister persister) {
                        this.init(persister);
                    }

                    PersisterStats(SrvMonAppStoreBindingPersisterStats stats) {
                        this.refresh(stats);
                    }

                    private final void init(IStorePersister persister) {
                        IStorePersisterStats stats = persister.getStats();
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    private final void refresh(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    final void stamp(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.refresh(stats);
                    }
                }
            }

            private final class EngineStats {
                private long numMsgsRcvdBestEffortLast;
                private long numMsgsRcvdGuaranteedLast;
                private long numMsgsSentBestEffortLast;
                private long numMsgsSentGuaranteedLast;
                private long numEventsRcvdLast;
                private long numFlowEventsRcvdLast;
                private long numTransactionsLast;
                private long numMsgsRcvdBestEffortCurrent;
                private long numMsgsRcvdGuaranteedCurrent;
                private long numMsgsSentBestEffortCurrent;
                private long numMsgsSentGuaranteedCurrent;
                private long numEventsRcvdCurrent;
                private long numFlowEventsRcvdCurrent;
                private long numFlowEventsProcSuccessCurrent;
                private long numTransactionsCurrent;
                private long numCommitsStartedCurrent;
                private long numRollbacksCurrent;

                EngineStats(AepEngine engine) {
                    this.init(engine);
                }

                EngineStats(SrvMonAppEngineStats stats) {
                    this.refresh(stats);
                }

                private final void init(AepEngine engine) {
                    IAepEngineStats engineStats = engine.getStats();
                    this.numMsgsRcvdBestEffortCurrent = engineStats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = engineStats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsSentBestEffortCurrent = engineStats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = engineStats.getNumMsgsSentGuaranteed();
                    this.numEventsRcvdCurrent = engineStats.getNumEventsRcvd();
                    this.numFlowEventsRcvdCurrent = engineStats.getNumFlowEventsRcvd();
                    this.numFlowEventsProcSuccessCurrent = engineStats.getNumFlowEventsProcSuccess();
                    this.numTransactionsCurrent = engineStats.getNumTransactions();
                    this.numCommitsStartedCurrent = engineStats.getNumCommitsStarted();
                    this.numRollbacksCurrent = engineStats.getNumRollbacks();
                }

                private final void refresh(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortCurrent = stats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = stats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsSentBestEffortCurrent = stats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = stats.getNumMsgsSentGuaranteed();
                    this.numEventsRcvdCurrent = stats.getNumEventsRcvd();
                    this.numFlowEventsRcvdCurrent = stats.getNumFlowEventsRcvd();
                    this.numFlowEventsProcSuccessCurrent = stats.getNumFlowEventsProcSuccess();
                    this.numTransactionsCurrent = stats.getNumTransactions();
                    this.numCommitsStartedCurrent = stats.getNumCommitsStarted();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                }

                final void stamp(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                    this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                    this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                    this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                    this.numEventsRcvdLast = this.numEventsRcvdCurrent;
                    this.numFlowEventsRcvdLast = this.numFlowEventsRcvdCurrent;
                    this.numTransactionsLast = this.numTransactionsCurrent;
                    this.refresh(stats);
                }
            }
        }

        private final class MsgTypeStatsCollector {
            private XIntLinkedHashMap<MsgTypeStats> msgTypeStats = new XIntLinkedHashMap();
            private XIntLinkedHashMap<IAepEngineStats.IMessageTypeStats> copiedEngineMsgTypeStatsTable = new XIntLinkedHashMap();
            private final IntObjectProcedure msgTypeStatsCopier = new IntObjectProcedure(){

                public final boolean apply(int key, Object stats) {
                    MsgTypeStatsCollector.this.copiedEngineMsgTypeStatsTable.put(key, (Object)((IAepEngineStats.IMessageTypeStats)stats));
                    return true;
                }
            };

            private MsgTypeStatsCollector() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void collect(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, OpenIntObjectHashMap engineMessageTypeStats) {
                if (engineMessageTypeStats == null) {
                    return;
                }
                this.copiedEngineMsgTypeStatsTable.clear();
                OpenIntObjectHashMap openIntObjectHashMap = engineMessageTypeStats;
                synchronized (openIntObjectHashMap) {
                    engineMessageTypeStats.forEachPair(this.msgTypeStatsCopier);
                }
                XCollectionIterator it = this.copiedEngineMsgTypeStatsTable.reuseableEntryIterator();
                while (it.hasNext()) {
                    XIntMap.Entry entry = (XIntMap.Entry)it.next();
                    MsgTypeStats stats = (MsgTypeStats)this.msgTypeStats.get(entry.getKey());
                    if (stats == null) {
                        stats = new MsgTypeStats((IAepEngineStats.IMessageTypeStats)entry.getValue());
                        this.msgTypeStats.put(entry.getKey(), (Object)stats);
                    }
                    stats.collectCurrentValues((IAepEngineStats.IMessageTypeStats)entry.getValue());
                }
                XIterator statsIt = this.msgTypeStats.reuseableValueIterator();
                while (statsIt.hasNext()) {
                    MsgTypeStats typeStats = (MsgTypeStats)statsIt.next();
                    typeStats.computeAndInclude(monEngineStatsSerializer, Apps.this.inactiveMessageTypeStatsInclusionCountdown == 0);
                }
            }
        }

        private final class MsgTypeStats {
            final XString name;
            final short factoryid;
            final short typeid;
            private long numMsgsRcvdBestEffortLast;
            private long numMsgsRcvdGuaranteedLast;
            private long numMsgsSourcedLast;
            private long numMsgsSentBestEffortLast;
            private long numMsgsSentGuaranteedLast;
            private long numMsgsFilteredLast;
            private long numDupMsgsRcvdLast;
            private long numMsgsResentLast;
            private long numMsgsRcvdBestEffortCurrent;
            private long numMsgsRcvdGuaranteedCurrent;
            private long numMsgsSourcedCurrent;
            private long numMsgsSentBestEffortCurrent;
            private long numMsgsSentGuaranteedCurrent;
            private long numMsgsFilteredCurrent;
            private long numDupMsgsRcvdCurrent;
            private long numMsgsResentCurrent;
            private SrvMonIntSeries messageCreateToOfferLatencies;
            private SrvMonIntSeries messageOfferToPollLatencies;
            private SrvMonIntSeries messageFilteringLatencies;
            private SrvMonIntSeries messagePreProcessingLatencies;
            private SrvMonIntSeries messageProcessingLatencies;

            MsgTypeStats(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                this.name = XString.create((String)engineMsgTypeStats.getMessageTypeName());
                this.typeid = engineMsgTypeStats.getMessageTypeId();
                this.factoryid = engineMsgTypeStats.getMessageFactoryId();
            }

            final void collectCurrentValues(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                this.numDupMsgsRcvdCurrent = engineMsgTypeStats.getNumDupMsgsRcvd();
                this.numMsgsFilteredCurrent = engineMsgTypeStats.getNumMsgsFiltered();
                this.numMsgsRcvdBestEffortCurrent = engineMsgTypeStats.getNumMsgsRcvdBestEffort();
                this.numMsgsRcvdGuaranteedCurrent = engineMsgTypeStats.getNumMsgsRcvdGuaranteed();
                this.numMsgsResentCurrent = engineMsgTypeStats.getNumMsgsResent();
                this.numMsgsSentBestEffortCurrent = engineMsgTypeStats.getNumMsgsSentBestEffort();
                this.numMsgsSentGuaranteedCurrent = engineMsgTypeStats.getNumMsgsSentGuaranteed();
                this.numMsgsSourcedCurrent = engineMsgTypeStats.getNumMsgsSourced();
                this.messageCreateToOfferLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgCreateToOfferLatencies());
                this.messageOfferToPollLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgOfferToPollLatencies());
                this.messageFilteringLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgFilteringLatencies());
                this.messagePreProcessingLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgPreProcessingLatencies());
                this.messageProcessingLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgProcessingLatencies());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void computeAndInclude(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, boolean includeInactive) {
                if (!includeInactive && this.numMsgsRcvdBestEffortLast == this.numMsgsRcvdBestEffortCurrent && this.numMsgsRcvdGuaranteedLast == this.numMsgsRcvdGuaranteedCurrent && this.numMsgsSourcedLast == this.numMsgsSourcedCurrent && this.numMsgsSentBestEffortLast == this.numMsgsSentBestEffortCurrent && this.numMsgsSentGuaranteedLast == this.numMsgsSentGuaranteedCurrent && this.numMsgsFilteredLast == this.numMsgsFilteredCurrent && this.numDupMsgsRcvdLast == this.numDupMsgsRcvdCurrent && this.numMsgsResentLast == this.numMsgsResentCurrent) {
                    if (this.messageCreateToOfferLatencies != null) {
                        this.messageCreateToOfferLatencies.dispose();
                        this.messageCreateToOfferLatencies = null;
                    }
                    if (this.messageOfferToPollLatencies != null) {
                        this.messageOfferToPollLatencies.dispose();
                        this.messageOfferToPollLatencies = null;
                    }
                    if (this.messagePreProcessingLatencies != null) {
                        this.messagePreProcessingLatencies.dispose();
                        this.messagePreProcessingLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    return;
                }
                SrvMonMsgTypeStats monMsgTypeStats = SrvMonMsgTypeStats.create();
                try {
                    SrvMonMsgTypeStats.Serializer monMsgTypeStatsSerializer = monMsgTypeStats.serializer();
                    monMsgTypeStatsSerializer.messageTypeName(this.name).messageFactoryId(this.factoryid).messageTypeId(this.typeid).numDupMsgsRcvd(this.numDupMsgsRcvdCurrent).numMsgsFiltered(this.numMsgsFilteredCurrent).numMsgsRcvdBestEffort(this.numMsgsRcvdBestEffortCurrent).numMsgsRcvdGuaranteed(this.numMsgsRcvdGuaranteedCurrent).numMsgsResent(this.numMsgsResentCurrent).numMsgsSentBestEffort(this.numMsgsSentBestEffortCurrent).numMsgsSentGuaranteed(this.numMsgsSentGuaranteedCurrent).numMsgsSourced(this.numMsgsSourcedCurrent).msgCreateToOfferLatencies(this.messageCreateToOfferLatencies).msgOfferToPollLatencies(this.messageOfferToPollLatencies).msgFilteringLatencies(this.messageFilteringLatencies).msgPreProcessingLatencies(this.messagePreProcessingLatencies).msgProcessingLatencies(this.messageProcessingLatencies).done();
                    monEngineStatsSerializer.msgTypeStats(monMsgTypeStatsSerializer);
                }
                finally {
                    monMsgTypeStats.dispose();
                }
                this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                this.numDupMsgsRcvdLast = this.numDupMsgsRcvdCurrent;
                this.numMsgsResentLast = this.numMsgsResentCurrent;
                if (this.messageCreateToOfferLatencies != null) {
                    this.messageCreateToOfferLatencies.dispose();
                    this.messageCreateToOfferLatencies = null;
                }
                if (this.messageOfferToPollLatencies != null) {
                    this.messageOfferToPollLatencies.dispose();
                    this.messageOfferToPollLatencies = null;
                }
                if (this.messageFilteringLatencies != null) {
                    this.messageFilteringLatencies.dispose();
                    this.messageFilteringLatencies = null;
                }
                if (this.messagePreProcessingLatencies != null) {
                    this.messagePreProcessingLatencies.dispose();
                    this.messagePreProcessingLatencies = null;
                }
                if (this.messageProcessingLatencies != null) {
                    this.messageProcessingLatencies.dispose();
                    this.messageProcessingLatencies = null;
                }
            }
        }

        public static enum EntityType {
            Engine,
            UserStat,
            EventMultiplexer,
            StoreBinding,
            StoreBindingPersister,
            StoreBindingICRSender,
            BusBinding;

        }
    }

    static final class AdminClients {
        private final XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> adminClientsStats = new XLinkedHashMap();
        private final Tracer tracer = Tracer.get((String)"nv.server.stats.adminclient");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                this.adminClientsStats.put((Object)client.getName(), (Object)client.getStats());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                this.adminClientsStats.remove((Object)client.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void populateHeartbeat(SrvMonHeartbeatMessage.Serializer heartbeatMessageSerializer) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                XIterator adminClientStatsIt = this.adminClientsStats.reuseableValueIterator();
                while (adminClientStatsIt.hasNext()) {
                    SrvControllerAdminApp.AdminClientContext.Stats adminClientStats = (SrvControllerAdminApp.AdminClientContext.Stats)adminClientStatsIt.next();
                    if (adminClientStats == null && this.tracer.debug) {
                        this.tracer.log("NULL ADMIN STAT DETECTED IN ADMINCLIENTSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    SrvMonAdminClientStats monAdminClientStats = SrvMonAdminClientStats.create();
                    try {
                        SrvMonAdminClientStats.Serializer monAdminClientStatsSerializer = monAdminClientStats.serializer();
                        monAdminClientStatsSerializer.name(adminClientStats.getClient().getName()).lifecyclesSent(adminClientStats.getEventsSent()).tracesSent(adminClientStats.getTracesSent()).tracesDropped(adminClientStats.getTracesDropped()).heartbeatsSent(adminClientStats.getHeartbeatsSent()).heartbeatsDropped(adminClientStats.getHeartbeatsDropped()).flushesScheduled(adminClientStats.getFlushesScheduled()).flushesExecuted(adminClientStats.getFlushesExecuted()).outboundQueueCapacity(adminClientStats.getOutboundQueueCapacity()).outboundQueueSize(adminClientStats.getOutboundQueueSize()).outboundQueueCount(adminClientStats.getOutboundQueueCount()).outboundQueueFlushSize(adminClientStats.getOutboundQueueFlushSize()).outboundQueueFlushCount(adminClientStats.getOutboundQueueFlushCount()).done();
                        heartbeatMessageSerializer.adminClientStats(monAdminClientStatsSerializer);
                    }
                    finally {
                        monAdminClientStats.dispose();
                    }
                }
            }
        }
    }

    static final class Pools {
        private final XLinkedHashMap<String, PoolStats> poolsStats = new XLinkedHashMap();
        private final ObjectArrayList poolStatsHolder = new ObjectArrayList(4096);
        private final Tracer tracer;
        private final boolean enabled;
        private final boolean collectAll;
        private final float depletionThreshold;

        public Pools(boolean enabled, boolean collectAll, float poolDepletionThreshold) {
            this.enabled = enabled;
            this.tracer = Tracer.get((String)"nv.server.stats.pool");
            float value = poolDepletionThreshold;
            if (value <= 0.0f) {
                value = 101.0f;
            }
            this.collectAll = collectAll;
            this.depletionThreshold = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyPoolStatsToHolder() {
            this.poolStatsHolder.clear();
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                XIterator poolStatsIt = this.poolsStats.reuseableValueIterator();
                while (poolStatsIt.hasNext()) {
                    PoolStats poolStats = (PoolStats)poolStatsIt.next();
                    if (poolStats == null && this.tracer.debug) {
                        this.tracer.log("NULL POOL STAT DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (poolStats.pool == null && this.tracer.debug) {
                        this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    this.poolStatsHolder.add((Object)poolStats);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onPoolAdded(UtlPool<?> pool) {
            if (!this.enabled) {
                return;
            }
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                this.poolsStats.put((Object)pool.key(), (Object)new PoolStats(pool));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onPoolRemoved(UtlPool<?> pool) {
            if (!this.enabled) {
                return;
            }
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                this.poolsStats.remove((Object)pool.key());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void populateHeartbeat(SrvMonHeartbeatMessage.Serializer heartbeatMessageSerializer) {
            if (!this.enabled) {
                return;
            }
            this.copyPoolStatsToHolder();
            for (int i = 0; i < this.poolStatsHolder.size(); ++i) {
                PoolStats poolStats = (PoolStats)this.poolStatsHolder.get(i);
                if (poolStats.pool == null && this.tracer.debug) {
                    this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                    continue;
                }
                try {
                    UtlPool.Stats corePoolStats = poolStats.pool.stats();
                    long putsCurrent = corePoolStats.puts();
                    long getsCurrent = corePoolStats.gets();
                    long hitsCurrent = corePoolStats.hits();
                    long missesCurrent = corePoolStats.misses();
                    long growthsCurrent = corePoolStats.growths();
                    long evictsCurrent = corePoolStats.evicts();
                    long dwashesCurrent = corePoolStats.detachedWashes();
                    int size = poolStats.pool.size();
                    int capacity = poolStats.pool.capacity();
                    int preallocated = corePoolStats.preallocated();
                    int maxCapacity = poolStats.pool.params().getMaxCapacity();
                    if (this.collectAll || poolStats.isAtOrBelowDepletionThreshold(size) || missesCurrent - poolStats.missesLast > 0L || size > poolStats.sizeHighaterMark || evictsCurrent - poolStats.evictsLast > 0L) {
                        SrvMonPoolStats monPoolStats = SrvMonPoolStats.create();
                        try {
                            SrvMonPoolStats.Serializer monPoolStatsSerializer = monPoolStats.serializer();
                            monPoolStatsSerializer.puts(putsCurrent).gets(getsCurrent).hits(hitsCurrent).misses(missesCurrent).growths(growthsCurrent).evicts(evictsCurrent).detachedWashes(dwashesCurrent).preallocated(preallocated).size(size).capacity(capacity).maxCapacity(maxCapacity).key(poolStats.pool.key()).done();
                            heartbeatMessageSerializer.poolStats(monPoolStatsSerializer);
                        }
                        finally {
                            monPoolStats.dispose();
                        }
                    }
                    poolStats.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent, size);
                    continue;
                }
                catch (IllegalStateException e) {
                    if (poolStats.pool == null || poolStats.pool.isClosed()) continue;
                    throw e;
                }
            }
        }

        private final class PoolStats {
            private final UtlPool<?> pool;
            final int depletionThresholdDecrement;
            private long putsLast;
            private long getsLast;
            private long hitsLast;
            private long missesLast;
            private long growthsLast;
            private long evictsLast;
            private long dwashesLast;
            private int nextDepletionThreshold = -1;
            private int sizeHighaterMark = -1;

            PoolStats(UtlPool<?> pool) {
                this.pool = pool;
                UtlPool.Stats stats = this.pool.stats();
                this.stamp(stats.puts(), stats.gets(), stats.hits(), stats.misses(), stats.growths(), stats.evicts(), stats.detachedWashes(), pool.size());
                if (stats.preallocated() > 0 && pool.size() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                    this.depletionThresholdDecrement = (int)((float)stats.preallocated() * Pools.this.depletionThreshold / 100.0f);
                    this.nextDepletionThreshold = Math.max(0, stats.preallocated() - this.depletionThresholdDecrement);
                } else {
                    this.depletionThresholdDecrement = 0;
                    this.nextDepletionThreshold = -1;
                }
            }

            PoolStats(SrvMonPoolStats stats) {
                this.pool = null;
                this.stamp(stats.getPuts(), stats.getGets(), stats.getHits(), stats.getMisses(), stats.getGrowths(), stats.getEvicts(), stats.getDetachedWashes(), stats.getSize());
                if (stats.getPreallocated() > 0 && stats.getSize() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                    this.depletionThresholdDecrement = (int)((float)stats.getPreallocated() * Pools.this.depletionThreshold / 100.0f);
                    this.nextDepletionThreshold = Math.max(0, stats.getPreallocated() - this.depletionThresholdDecrement);
                } else {
                    this.depletionThresholdDecrement = 0;
                    this.nextDepletionThreshold = -1;
                }
            }

            final void stamp(long puts, long gets, long hits, long misses, long growths, long evicts, long dwashes, int size) {
                this.putsLast = puts;
                this.getsLast = gets;
                this.hitsLast = hits;
                this.missesLast = misses;
                this.growthsLast = growths;
                this.evictsLast = evicts;
                this.dwashesLast = dwashes;
                if (this.isAtOrBelowDepletionThreshold(size)) {
                    while (this.nextDepletionThreshold >= size) {
                        this.nextDepletionThreshold -= this.depletionThresholdDecrement;
                    }
                }
                this.sizeHighaterMark = Math.max(size, this.sizeHighaterMark);
            }

            final boolean isAtOrBelowDepletionThreshold(int size) {
                if (this.depletionThresholdDecrement > 0) {
                    return size <= this.nextDepletionThreshold;
                }
                return false;
            }
        }
    }

    static final class Sys {
        private final SrvControllerDirectHeartbeatGenerator heartbeatGenerator;
        private final Tracer tracer;
        private final XIntLinkedHashMap<Thread.State> threadStates = new XIntLinkedHashMap();
        private final MemoryMXBean memoryBean;
        private final OperatingSystemMXBean osBean;
        private final SunOperatingSystemMXBean sunOsBean;
        private final ThreadMXBean threadBean;
        private final CompilationMXBean jitBean;
        private final Method zgThreadAccessor;
        private final Field zgThreadStateField;
        private final Field zgCharArrayThreadNameField;
        private final Field zgStringThreadNameField;
        private final SrvControllerFileSystemAccessor.FileRoot[] fileRoots;
        private final boolean collectIndividualThreadStats;
        private final boolean collectNonZGStats;
        private Throwable lastZgThreadNameAccessorException;

        Sys(SrvControllerDirectHeartbeatGenerator heartbeatGenerator) {
            this.heartbeatGenerator = heartbeatGenerator;
            this.tracer = Tracer.get((String)"nv.server.stats.sys");
            this.memoryBean = ManagementFactory.getMemoryMXBean();
            this.osBean = ManagementFactory.getOperatingSystemMXBean();
            this.sunOsBean = this.getSunOsMBean();
            this.threadBean = ManagementFactory.getThreadMXBean();
            this.jitBean = ManagementFactory.getCompilationMXBean();
            this.zgThreadAccessor = this.getThreadAccessor();
            this.zgThreadStateField = this.getThreadStateField();
            this.zgCharArrayThreadNameField = this.getCharArrayThreadNameField();
            this.zgStringThreadNameField = this.zgCharArrayThreadNameField == null ? this.getStringThreadNameField() : null;
            if (this.zgCharArrayThreadNameField == null && this.zgStringThreadNameField == null) {
                this.tracer.log("Couldn't load zero garbage thread name accessor: " + this.lastZgThreadNameAccessorException.getMessage() + " ... Server stats may not register updated thread names.", Tracer.Level.WARNING);
            }
            boolean zgThreadStats = this.zgThreadAccessor != null && this.zgThreadStateField != null;
            this.collectNonZGStats = heartbeatGenerator.config.isCollectNonZGStats();
            this.collectIndividualThreadStats = heartbeatGenerator.config.isCollectIndividualThreadStats();
            this.fileRoots = this.collectNonZGStats ? SrvControllerFileSystemAccessor.getEnhancedFileRootsIfAvailable() : SrvControllerFileSystemAccessor.getStandardFileRoots();
            this.tracer.log("ZERO GARBAGE THREAD STATS ARE....." + (zgThreadStats ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("SYSTEM DISK STATS ARE............." + (SrvControllerFileSystemAccessor.areEnhandedFileSystemRootsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("SYSTEM MEM STATS ARE.............." + (this.sunOsBean != null ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("ENHANCED CPU STATS ARE............" + (this.sunOsBean != null && this.sunOsBean.enhancedProcessorLoadStatsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("NON ZERO GARBAGE STATS ARE........" + (this.collectNonZGStats ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
        }

        private final SunOperatingSystemMXBean getSunOsMBean() {
            SunOperatingSystemMXBean sunOsMbean = null;
            try {
                sunOsMbean = (SunOperatingSystemMXBean)Class.forName("com.neeve.server.controller.SrvControllerSunOsMbeanAccessor").newInstance();
            }
            catch (Throwable thrown) {
                this.tracer.log("Sun os mbean not available (" + thrown.getMessage() + ") some processor and memory system stats will not be available.", Tracer.Level.WARNING);
            }
            return sunOsMbean;
        }

        private final Method getThreadAccessor() {
            Method zgThreadAccessorCandidate = null;
            try {
                try {
                    zgThreadAccessorCandidate = this.threadBean.getClass().getDeclaredMethod("getThreads", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    zgThreadAccessorCandidate = this.threadBean.getClass().getSuperclass().getDeclaredMethod("getThreads", new Class[0]);
                }
                if (!zgThreadAccessorCandidate.getReturnType().equals(Thread[].class)) {
                    throw new Exception("Unexpected return type on native ThreadMX bean accessor '" + zgThreadAccessorCandidate + "'");
                }
                zgThreadAccessorCandidate.setAccessible(true);
                ((Thread[])zgThreadAccessorCandidate.invoke((Object)this.threadBean, new Object[0])).hashCode();
            }
            catch (Throwable thrown) {
                zgThreadAccessorCandidate = null;
                this.tracer.log("Couldn't load zero garbage ThreadMXBean accessor: " + thrown.toString() + " ... Server stats will produce garbage!", Tracer.Level.WARNING);
            }
            return zgThreadAccessorCandidate;
        }

        private final Field getThreadStateField() {
            Field zgThreadStateFieldCandidate = null;
            try {
                zgThreadStateFieldCandidate = Thread.class.getDeclaredField("threadStatus");
                if (zgThreadStateFieldCandidate.getType() != Integer.TYPE) {
                    throw new Exception("Unexpected field type for '" + zgThreadStateFieldCandidate + "'");
                }
                zgThreadStateFieldCandidate.setAccessible(true);
                zgThreadStateFieldCandidate.getInt(Thread.currentThread());
            }
            catch (Throwable thrown) {
                zgThreadStateFieldCandidate = null;
                this.tracer.log("Couldn't load zero garbage thread state accessor: " + thrown.getMessage() + " ... Server stats will produce garbage!", Tracer.Level.WARNING);
            }
            return zgThreadStateFieldCandidate;
        }

        private final Field getCharArrayThreadNameField() {
            Field zgThreadNameFieldCandidate;
            block4: {
                zgThreadNameFieldCandidate = null;
                try {
                    zgThreadNameFieldCandidate = Thread.class.getDeclaredField("name");
                    if (zgThreadNameFieldCandidate.getType() == char[].class) {
                        zgThreadNameFieldCandidate.setAccessible(true);
                        char[] testGet = (char[])zgThreadNameFieldCandidate.get(Thread.currentThread());
                        if (testGet == null) {
                            throw new Exception("Failed to get thread name via reflection (null)");
                        }
                        break block4;
                    }
                    throw new Exception("Unexpected field type for '" + zgThreadNameFieldCandidate + "'");
                }
                catch (Throwable thrown) {
                    zgThreadNameFieldCandidate = null;
                    this.lastZgThreadNameAccessorException = thrown;
                }
            }
            return zgThreadNameFieldCandidate;
        }

        private final Field getStringThreadNameField() {
            Field zgThreadNameFieldCandidate;
            block4: {
                zgThreadNameFieldCandidate = null;
                try {
                    zgThreadNameFieldCandidate = Thread.class.getDeclaredField("name");
                    if (zgThreadNameFieldCandidate.getType() == String.class) {
                        zgThreadNameFieldCandidate.setAccessible(true);
                        String testGet = (String)zgThreadNameFieldCandidate.get(Thread.currentThread());
                        if (testGet == null) {
                            throw new Exception("Failed to get thread name via reflection (null)");
                        }
                        break block4;
                    }
                    throw new Exception("Unexpected field type for '" + zgThreadNameFieldCandidate + "'");
                }
                catch (Throwable thrown) {
                    zgThreadNameFieldCandidate = null;
                    this.lastZgThreadNameAccessorException = thrown;
                }
            }
            return zgThreadNameFieldCandidate;
        }

        private final void populateLoadStats(SrvMonSysStats.Serializer sysStatsSerializer) {
            sysStatsSerializer.availableProcessors(this.osBean.getAvailableProcessors()).systemLoadAverage(this.osBean.getSystemLoadAverage());
            if (this.sunOsBean != null && this.collectNonZGStats && this.sunOsBean.enhancedProcessorLoadStatsAvailable()) {
                sysStatsSerializer.processCpuLoad(this.sunOsBean.getProcessCpuLoad()).systemCpuLoad(this.sunOsBean.getSystemCpuLoad());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateHeapUsageStats(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryUsage heapUsage = SrvMonSysMemoryUsage.create();
            try {
                MemoryUsage beanHeapUsage = this.memoryBean.getHeapMemoryUsage();
                SrvMonSysMemoryUsage.Serializer heapUsageSerializer = heapUsage.serializer();
                heapUsageSerializer.init(beanHeapUsage.getInit()).used(beanHeapUsage.getUsed()).committed(beanHeapUsage.getCommitted()).max(beanHeapUsage.getMax()).done();
                sysMemoryStatsSerializer.heapUsage(heapUsageSerializer);
            }
            finally {
                heapUsage.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateNonHeapUsageStats(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryUsage nonHeapUsage = SrvMonSysMemoryUsage.create();
            try {
                MemoryUsage beanNonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
                SrvMonSysMemoryUsage.Serializer nonHeapUsageSerializer = nonHeapUsage.serializer();
                nonHeapUsageSerializer.init(beanNonHeapUsage.getInit()).used(beanNonHeapUsage.getUsed()).committed(beanNonHeapUsage.getCommitted()).max(beanNonHeapUsage.getMax()).done();
                sysMemoryStatsSerializer.nonHeapUsage(nonHeapUsageSerializer);
            }
            finally {
                nonHeapUsage.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateOffHeapUsageStats(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryOffHeapUsage offHeapUsage = SrvMonSysMemoryOffHeapUsage.create();
            try {
                MemoryStats memoryStats = MemoryStats.getInstance();
                SrvMonSysMemoryOffHeapUsage.Serializer offHeapUsageSerializer = offHeapUsage.serializer();
                offHeapUsageSerializer.usedLive(memoryStats.getOffHeapMemoryUsedLive()).usedPooled(memoryStats.getOffHeapMemoryUsedPooled()).done();
                sysMemoryStatsSerializer.offHeapUsage(offHeapUsageSerializer);
            }
            finally {
                offHeapUsage.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateNativeMemoryCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryNativeCounters counters = SrvMonSysMemoryNativeCounters.create();
            try {
                MemoryStats.NativeMemoryStats memoryStats = MemoryStats.getInstance().getNativeStatsCounters();
                SrvMonSysMemoryNativeCounters.Serializer countersSerializer = counters.serializer();
                countersSerializer.allocCount(memoryStats.getAllocCount()).allocBytes(memoryStats.getAllocBytes()).reallocCount(memoryStats.getReallocCount()).reallocBytes(memoryStats.getReallocBytes()).freeCount(memoryStats.getFreeCount()).freeBytes(memoryStats.getFreeBytes()).done();
                sysMemoryStatsSerializer.nativeCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateIOBufMemoryCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryIOBufCounters counters = SrvMonSysMemoryIOBufCounters.create();
            try {
                MemoryStats.IOBufferStats bufferStats = MemoryStats.getInstance().getIOBufferStatsCounters();
                SrvMonSysMemoryIOBufCounters.Serializer countersSerializer = counters.serializer();
                countersSerializer.bufferAllocCount(bufferStats.getBufferAllocCount()).bufferAllocBytes(bufferStats.getBufferAllocBytes()).bufferPoolAllocCount(bufferStats.getBufferPoolAllocCount()).bufferPoolAllocBytes(bufferStats.getBufferPoolAllocBytes()).bufferReallocCount(bufferStats.getBufferReallocCount()).bufferReallocBytes(bufferStats.getBufferReallocBytes()).bufferForkCount(bufferStats.getBufferForkCount()).bufferForkBytes(bufferStats.getBufferForkBytes()).bufferGCDisposeCount(bufferStats.getBufferGCDisposeCount()).bufferGCDisposeBytes(bufferStats.getBufferGCDisposeBytes()).bufferPoolDisposeCount(bufferStats.getBufferPoolDisposeCount()).bufferPoolDisposeBytes(bufferStats.getBufferPoolDisposeBytes()).bufferPoolLeakCount(bufferStats.getBufferPoolLeakCount()).bufferPoolLeakBytes(bufferStats.getBufferPoolLeakBytes()).done();
                sysMemoryStatsSerializer.iobufCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        private final void populateEntityMemoryStatsCounters(SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer, MemoryStats.EntityTypeStats memoryStats) {
            countersSerializer.liveCount(memoryStats.getLiveCount()).pooledCount(memoryStats.getPooledCount()).createAllocCount(memoryStats.getCreateAllocCount()).poolAllocCount(memoryStats.getPoolAllocCount()).gCDisposeCount(memoryStats.getGCDisposeCount()).poolDisposeCount(memoryStats.getPoolDisposeCount()).poolLeakCount(memoryStats.getPoolLeakCount()).pojoLiveCount(memoryStats.getPojoLiveCount()).pojoPooledCount(memoryStats.getPojoPooledCount()).pojoCreateAllocCount(memoryStats.getPojoCreateAllocCount()).pojoPoolAllocCount(memoryStats.getPojoPoolAllocCount()).pojoGCDisposeCount(memoryStats.getPojoGCDisposeCount()).pojoPoolDisposeCount(memoryStats.getPojoPoolDisposeCount()).pojoPoolLeakCount(memoryStats.getPojoPoolLeakCount()).serializerLiveCount(memoryStats.getSerializerLiveCount()).serializerPooledCount(memoryStats.getSerializerPooledCount()).serializerCreateAllocCount(memoryStats.getSerializerCreateAllocCount()).serializerPoolAllocCount(memoryStats.getSerializerPoolAllocCount()).serializerGCDisposeCount(memoryStats.getSerializerGCDisposeCount()).serializerPoolDisposeCount(memoryStats.getSerializerPoolDisposeCount()).serializerPoolLeakCount(memoryStats.getSerializerPoolLeakCount()).deserializerLiveCount(memoryStats.getDeserializerLiveCount()).deserializerPooledCount(memoryStats.getDeserializerPooledCount()).deserializerCreateAllocCount(memoryStats.getDeserializerCreateAllocCount()).deserializerPoolAllocCount(memoryStats.getDeserializerPoolAllocCount()).deserializerGCDisposeCount(memoryStats.getDeserializerGCDisposeCount()).deserializerPoolDisposeCount(memoryStats.getDeserializerPoolDisposeCount()).deserializerPoolLeakCount(memoryStats.getDeserializerPoolLeakCount()).metadataLiveCount(memoryStats.getMetadataLiveCount()).metadataLiveBytes(memoryStats.getMetadataLiveBytes()).metadataAllocCount(memoryStats.getMetadataAllocCount()).metadataAllocBytes(memoryStats.getMetadataAllocBytes()).metadataGCDisposeCount(memoryStats.getMetadataGCDisposeCount()).metadataGCDisposeBytes(memoryStats.getMetadataGCDisposeBytes()).metadataPoolDisposeCount(memoryStats.getMetadataPoolDisposeCount()).metadataPoolDisposeBytes(memoryStats.getMetadataPoolDisposeBytes()).dataLiveCount(memoryStats.getDataLiveCount()).dataLiveBytes(memoryStats.getDataLiveBytes()).dataAllocCount(memoryStats.getDataAllocCount()).dataAllocBytes(memoryStats.getDataAllocBytes()).dataGCDisposeCount(memoryStats.getDataGCDisposeCount()).dataGCDisposeBytes(memoryStats.getDataGCDisposeBytes()).dataPoolDisposeCount(memoryStats.getDataPoolDisposeCount()).dataPoolDisposeBytes(memoryStats.getDataPoolDisposeBytes()).done();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEmbeddedEntityCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                this.populateEntityMemoryStatsCounters(countersSerializer, MemoryStats.getInstance().getEmbeddedEntityStatsCounters());
                sysMemoryStatsSerializer.embeddedEntityCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEmbeddedEntityCountersByType(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                Map embeddedEntityCountersByType;
                Map map = embeddedEntityCountersByType = MemoryStats.getInstance().getEmbeddedEntityTypeStatsCounters();
                synchronized (map) {
                    for (Map.Entry entry : embeddedEntityCountersByType.entrySet()) {
                        Class embeddedEntityClass = (Class)entry.getKey();
                        SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                        countersSerializer.entityName(embeddedEntityClass.getName()).entityShortName(embeddedEntityClass.getSimpleName());
                        this.populateEntityMemoryStatsCounters(countersSerializer, (MemoryStats.EntityTypeStats)entry.getValue());
                        sysMemoryStatsSerializer.embeddedEntityCountersByType(countersSerializer);
                    }
                }
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEntityCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                this.populateEntityMemoryStatsCounters(countersSerializer, MemoryStats.getInstance().getEntityStatsCounters());
                sysMemoryStatsSerializer.entityCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateEntityCountersByType(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                Map entityCountersByType;
                Map map = entityCountersByType = MemoryStats.getInstance().getEntityTypeStatsCounters();
                synchronized (map) {
                    for (Map.Entry entry : entityCountersByType.entrySet()) {
                        Class entityClass = (Class)entry.getKey();
                        SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                        countersSerializer.entityName(entityClass.getName()).entityShortName(entityClass.getSimpleName());
                        this.populateEntityMemoryStatsCounters(countersSerializer, (MemoryStats.EntityTypeStats)entry.getValue());
                        sysMemoryStatsSerializer.entityCountersByType(countersSerializer);
                    }
                }
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateMessageCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                this.populateEntityMemoryStatsCounters(countersSerializer, MemoryStats.getInstance().getMessageStatsCounters());
                sysMemoryStatsSerializer.messageCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateMessageCountersByType(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                Map messageCountersByType;
                Map map = messageCountersByType = MemoryStats.getInstance().getMessageTypeStatsCounters();
                synchronized (map) {
                    for (Map.Entry entry : messageCountersByType.entrySet()) {
                        Class messageClass = (Class)entry.getKey();
                        SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                        countersSerializer.entityName(messageClass.getName()).entityShortName(messageClass.getSimpleName());
                        this.populateEntityMemoryStatsCounters(countersSerializer, (MemoryStats.EntityTypeStats)entry.getValue());
                        sysMemoryStatsSerializer.messageCountersByType(countersSerializer);
                    }
                }
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateCollectionCounters(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                this.populateEntityMemoryStatsCounters(countersSerializer, MemoryStats.getInstance().getCollectionStatsCounters());
                sysMemoryStatsSerializer.collectionCounters(countersSerializer);
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateCollectionCountersByType(SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer) {
            SrvMonSysMemoryEntityTypeCounters counters = SrvMonSysMemoryEntityTypeCounters.create();
            try {
                Map collectionCountersByType;
                Map map = collectionCountersByType = MemoryStats.getInstance().getCollectionTypeStatsCounters();
                synchronized (map) {
                    for (Map.Entry entry : collectionCountersByType.entrySet()) {
                        Class collectionClass = (Class)entry.getKey();
                        SrvMonSysMemoryEntityTypeCounters.Serializer countersSerializer = counters.serializer();
                        countersSerializer.entityName(collectionClass.getName()).entityShortName(collectionClass.getSimpleName());
                        sysMemoryStatsSerializer.collectionCountersByType(countersSerializer);
                    }
                }
            }
            finally {
                counters.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateMemoryStats(SrvMonSysStats.Serializer sysStatsSerializer) {
            SrvMonSysMemoryStats sysMemoryStats = SrvMonSysMemoryStats.create();
            try {
                SrvMonSysMemoryStats.Serializer sysMemoryStatsSerializer = sysMemoryStats.serializer();
                this.populateHeapUsageStats(sysMemoryStatsSerializer);
                this.populateNonHeapUsageStats(sysMemoryStatsSerializer);
                this.populateOffHeapUsageStats(sysMemoryStatsSerializer);
                this.populateNativeMemoryCounters(sysMemoryStatsSerializer);
                this.populateIOBufMemoryCounters(sysMemoryStatsSerializer);
                this.populateEmbeddedEntityCounters(sysMemoryStatsSerializer);
                this.populateEmbeddedEntityCountersByType(sysMemoryStatsSerializer);
                this.populateEntityCounters(sysMemoryStatsSerializer);
                this.populateEntityCountersByType(sysMemoryStatsSerializer);
                this.populateMessageCounters(sysMemoryStatsSerializer);
                this.populateMessageCountersByType(sysMemoryStatsSerializer);
                this.populateCollectionCounters(sysMemoryStatsSerializer);
                this.populateCollectionCountersByType(sysMemoryStatsSerializer);
                if (this.sunOsBean != null) {
                    sysMemoryStatsSerializer.committedVirtualMemorySize(this.sunOsBean.getCommittedVirtualMemorySize()).freePhysicalMemorySize(this.sunOsBean.getFreePhysicalMemorySize()).freeSwapSpaceSize(this.sunOsBean.getFreeSwapSpaceSize()).totalPhysicalMemorySize(this.sunOsBean.getTotalPhysicalMemorySize()).totalSwapSpaceSize(this.sunOsBean.getTotalSwapSpaceSize());
                }
                sysMemoryStatsSerializer.done();
                sysStatsSerializer.memoryStats(sysMemoryStatsSerializer);
            }
            finally {
                sysMemoryStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateGCCollectorStats(SrvMonSysGCStats.Serializer sysGCStatsSerializer, GarbageCollectorMXBean gcBean) {
            SrvMonSysGCCollectorStats collectorStats = SrvMonSysGCCollectorStats.create();
            try {
                SrvMonSysGCCollectorStats.Serializer collectorStatsSerializer = collectorStats.serializer();
                collectorStatsSerializer.collectorName(gcBean.getName()).collectionCount(gcBean.getCollectionCount()).collectionTime(gcBean.getCollectionTime()).done();
                sysGCStatsSerializer.collectorsStats(collectorStatsSerializer);
            }
            finally {
                collectorStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateGCStats(SrvMonSysStats.Serializer sysStatsSerializer) {
            SrvMonSysGCStats sysGCStats = SrvMonSysGCStats.create();
            try {
                SrvMonSysGCStats.Serializer sysGCStatsSerializer = sysGCStats.serializer();
                List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (int i = 0; i < gcBeans.size(); ++i) {
                    this.populateGCCollectorStats(sysGCStatsSerializer, gcBeans.get(i));
                }
                sysGCStatsSerializer.done();
                sysStatsSerializer.gcStats(sysGCStatsSerializer);
            }
            finally {
                sysGCStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateJITStats(SrvMonSysStats.Serializer sysStatsSerializer) {
            SrvMonSysJITStats sysJITStats = SrvMonSysJITStats.create();
            try {
                SrvMonSysJITStats.Serializer sysJITStatsSerializer = sysJITStats.serializer();
                sysJITStatsSerializer.name(this.jitBean.getName()).totalCompilationTime(this.jitBean.isCompilationTimeMonitoringSupported() ? this.jitBean.getTotalCompilationTime() : -1L).done();
                sysStatsSerializer.jitStats(sysJITStatsSerializer);
            }
            finally {
                sysJITStats.dispose();
            }
        }

        private final char[] getThreadNameCharArray(Thread thread) {
            char[] name;
            block3: {
                name = null;
                if (this.zgCharArrayThreadNameField != null) {
                    try {
                        name = (char[])this.zgCharArrayThreadNameField.get(thread);
                    }
                    catch (Throwable thrown) {
                        if (!this.tracer.debug) break block3;
                        this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                    }
                }
            }
            return name;
        }

        private final String getThreadNameString(Thread thread) {
            String name;
            block3: {
                name = null;
                if (this.zgCharArrayThreadNameField == null && this.zgStringThreadNameField != null) {
                    try {
                        name = (String)this.zgStringThreadNameField.get(thread);
                    }
                    catch (Throwable thrown) {
                        if (!this.tracer.debug) break block3;
                        this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                    }
                }
            }
            return name;
        }

        private final XString getThreadName(Thread thread) {
            char[] threadNameCharArray = this.getThreadNameCharArray(thread);
            String threadNameString = this.getThreadNameString(thread);
            XString threadName = this.heartbeatGenerator.lookupThreadName(thread);
            if (threadNameCharArray != null && threadName.length() != threadNameCharArray.length || threadNameString != null && threadName.length() != threadNameString.length()) {
                this.heartbeatGenerator.threadNameCache.remove(thread);
                threadName = this.heartbeatGenerator.lookupThreadName(thread);
            }
            return threadName;
        }

        private final Thread.State getThreadState(Thread thread) {
            Thread.State state;
            block5: {
                state = null;
                if (this.zgThreadStateField != null) {
                    try {
                        int status = this.zgThreadStateField.getInt(thread);
                        state = (Thread.State)((Object)this.threadStates.get(status));
                        if (state == null) {
                            state = thread.getState();
                            this.threadStates.put(status, (Object)state);
                        }
                    }
                    catch (Throwable thrown) {
                        if (!this.tracer.debug) break block5;
                        this.tracer.log("Error getting thread state" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                    }
                }
            }
            if (state == null) {
                state = thread.getState();
            }
            return state;
        }

        private final long getThreadCpuTime(Thread thread, Thread.State state) {
            long cpuTime = 0L;
            if (thread.isAlive() && state != Thread.State.NEW) {
                cpuTime = this.threadBean.getThreadCpuTime(thread.getId());
            }
            return cpuTime;
        }

        private final long getThreadUserTime(Thread thread, Thread.State state) {
            long userTime = 0L;
            if (thread.isAlive() && state != Thread.State.NEW) {
                userTime = this.threadBean.getThreadUserTime(thread.getId());
            }
            return userTime;
        }

        private final String getThreadAffinity(Thread thread) {
            UtlThread.ThreadStats stats = UtlThread.getThreadStats((Thread)thread);
            return stats != null ? stats.getAffinityString() : null;
        }

        private final long getThreadWaitTime(Thread thread) {
            UtlThread.ThreadStats stats = UtlThread.getThreadStats((Thread)thread);
            return stats != null && stats.getWaitCount() > 0L ? stats.getWaitTime() : 0L;
        }

        private final long getThreadWaitCount(Thread thread) {
            UtlThread.ThreadStats stats = UtlThread.getThreadStats((Thread)thread);
            return stats != null && stats.getWaitCount() > 0L ? stats.getWaitCount() : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateIndividualThreadStats(SrvMonSysThreadStats.Serializer sysThreadStatsSerializer, Thread thread) {
            SrvMonSysIndividualThreadStats sysIndividualThreadStats = SrvMonSysIndividualThreadStats.create();
            try {
                SrvMonSysIndividualThreadStats.Serializer sysIndividualThreadStatsSerializer = sysIndividualThreadStats.serializer();
                Thread.State state = this.getThreadState(thread);
                sysIndividualThreadStatsSerializer.id(thread.getId()).name(this.getThreadName(thread)).state(state.toString()).cpuTime(this.getThreadCpuTime(thread, state)).usrTime(this.getThreadUserTime(thread, state)).collectTime(System.nanoTime()).affinity(this.getThreadAffinity(thread)).waitTime(this.getThreadWaitTime(thread)).waitCount(this.getThreadWaitCount(thread)).done();
                sysThreadStatsSerializer.individualThreadStats(sysIndividualThreadStatsSerializer);
            }
            finally {
                sysIndividualThreadStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateIndividualThreadStats(SrvMonSysThreadStats.Serializer sysThreadStatsSerializer, long threadId) {
            SrvMonSysIndividualThreadStats sysIndividualThreadStats = SrvMonSysIndividualThreadStats.create();
            try {
                ThreadInfo tinfo = this.threadBean.getThreadInfo(threadId);
                SrvMonSysIndividualThreadStats.Serializer sysIndividualThreadStatsSerializer = sysIndividualThreadStats.serializer();
                sysIndividualThreadStatsSerializer.id(threadId).name(tinfo != null ? tinfo.getThreadName() : "<defunct>").state(tinfo != null ? tinfo.getThreadState().toString() : "<unavailable>").cpuTime(Math.max(0L, this.threadBean.getThreadCpuTime(threadId))).usrTime(Math.max(0L, this.threadBean.getThreadUserTime(threadId))).collectTime(System.nanoTime()).done();
                sysThreadStatsSerializer.individualThreadStats(sysIndividualThreadStatsSerializer);
            }
            finally {
                sysIndividualThreadStats.dispose();
            }
        }

        private final Thread[] getThreadsZg() {
            Thread[] threads = null;
            try {
                threads = (Thread[])this.zgThreadAccessor.invoke((Object)this.threadBean, (Object[])null);
            }
            catch (Throwable thrown) {
                this.tracer.log("Error getting MX Bean threads: " + thrown.getMessage(), Tracer.Level.WARNING);
            }
            return threads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateThreadStats(SrvMonSysStats.Serializer sysStatsSerializer) {
            SrvMonSysThreadStats sysThreadStats = SrvMonSysThreadStats.create();
            try {
                SrvMonSysThreadStats.Serializer sysThreadStatsSerializer = sysThreadStats.serializer();
                sysThreadStatsSerializer.threadCount(this.threadBean.getThreadCount()).daemonThreadCount(this.threadBean.getDaemonThreadCount()).peakThreadCount(this.threadBean.getPeakThreadCount());
                if (this.collectIndividualThreadStats) {
                    Thread[] threads = this.getThreadsZg();
                    if (threads != null) {
                        for (int i = 0; i < threads.length; ++i) {
                            this.populateIndividualThreadStats(sysThreadStatsSerializer, threads[i]);
                        }
                    } else {
                        long[] ids = this.threadBean.getAllThreadIds();
                        for (int i = 0; i < ids.length; ++i) {
                            this.populateIndividualThreadStats(sysThreadStatsSerializer, ids[i]);
                        }
                    }
                }
                sysThreadStatsSerializer.done();
                sysStatsSerializer.threadStats(sysThreadStatsSerializer);
            }
            finally {
                sysThreadStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateDiskStats(SrvMonSysStats.Serializer sysStatsSerializer, SrvControllerFileSystemAccessor.FileRoot fileRoot) {
            SrvMonSysDiskStats sysDiskStats = SrvMonSysDiskStats.create();
            try {
                SrvMonSysDiskStats.Serializer sysDiskStatsSerializer = sysDiskStats.serializer();
                sysDiskStatsSerializer.rootPath(fileRoot.getPath()).totalSpace(fileRoot.getTotalSpace()).usableSpace(fileRoot.getUsableSpace()).freeSpace(fileRoot.getFreeSpace()).done();
                sysStatsSerializer.diskStats(sysDiskStatsSerializer);
            }
            finally {
                sysDiskStats.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void populateHeartbeat(SrvMonHeartbeatMessage.Serializer heartbeatSerializer) {
            SrvMonSysStats sysStats = SrvMonSysStats.create();
            try {
                SrvMonSysStats.Serializer sysStatsSerializer = sysStats.serializer();
                this.populateLoadStats(sysStatsSerializer);
                this.populateMemoryStats(sysStatsSerializer);
                this.populateGCStats(sysStatsSerializer);
                this.populateJITStats(sysStatsSerializer);
                this.populateThreadStats(sysStatsSerializer);
                sysStatsSerializer.done();
                heartbeatSerializer.sysStats(sysStatsSerializer);
            }
            finally {
                sysStats.dispose();
            }
        }

        public static interface SunOperatingSystemMXBean {
            public long getCommittedVirtualMemorySize();

            public long getTotalSwapSpaceSize();

            public long getFreeSwapSpaceSize();

            public long getFreePhysicalMemorySize();

            public long getTotalPhysicalMemorySize();

            public long getProcessCpuTime();

            public double getProcessCpuLoad();

            public double getSystemCpuLoad();

            public boolean enhancedProcessorLoadStatsAvailable();
        }
    }
}

