/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public final class MessageViewFactoryDescriptor
extends SmaObject {
    private final String name;
    private final short id;
    private final String className;

    private MessageViewFactoryDescriptor(String name, short id, String className) {
        super(null);
        this.name = name;
        this.id = id;
        this.className = className;
    }

    public final String getName() {
        return this.name;
    }

    public final short getId() {
        return this.id;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void save(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/viewfactories");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/sma/viewfactories");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperty("Id", String.valueOf(this.getId()));
            entity.setProperty("Name", this.getName());
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new SmaException(e);
        }
    }

    public final void save() throws SmaException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/viewfactories");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", " + this.id + ", '" + this.className + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("view factory name cannot be null");
        }
        return repo.getSimpleEntity("/sma/viewfactories/" + name) != null;
    }

    public static boolean exists(String name) {
        return MessageViewFactoryDescriptor.exists(Config.getRepository(), name);
    }

    public static MessageViewFactoryDescriptor create(String name, short id, String className) {
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("factory class name cannot be null");
        }
        return new MessageViewFactoryDescriptor(name, id, className);
    }

    public static MessageViewFactoryDescriptor load(IConfigRepository repo, String name) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("factory name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/sma/viewfactories/" + name);
        if (entity != null) {
            short id = (short)UtlProps.getValue((Properties)entity.getProperties(), (String)"Id", (int)0);
            if (id == 0) {
                throw new SmaException("Invalid view factory configuration [Missing or invalid value for 'Id']");
            }
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new SmaException("Invalid view factory configuration [Missing 'Class' property]");
            }
            return MessageViewFactoryDescriptor.create(name, id, className);
        }
        throw new SmaException("View factory '" + name + "' not found in repository");
    }

    public static MessageViewFactoryDescriptor load(String name) throws SmaException {
        return MessageViewFactoryDescriptor.load(Config.getRepository(), name);
    }

    public static Map<Short, MessageViewFactoryDescriptor> loadAll(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashMap<Short, MessageViewFactoryDescriptor> factories = new LinkedHashMap<Short, MessageViewFactoryDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/viewfactories");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    MessageViewFactoryDescriptor descriptor = MessageViewFactoryDescriptor.load(repo, entity.getName());
                    MessageViewFactoryDescriptor existingDescriptor = factories.put(descriptor.getId(), descriptor);
                    if (existingDescriptor == null) continue;
                    descriptor.getTracer().log("SMA message view factory '" + descriptor.getName() + "' uses the same id as view factory '" + existingDescriptor.getName() + "' [id=" + descriptor.getId() + "]. Using view factory '" + descriptor.getName() + "'...", Tracer.Level.WARNING);
                }
                catch (SmaException e) {
                    throw new SmaException("Failure in loading descriptor for view factory '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return factories;
    }

    public static Map<Short, MessageViewFactoryDescriptor> loadAll() throws SmaException {
        return MessageViewFactoryDescriptor.loadAll(Config.getRepository());
    }
}

