/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.config.Config;
import com.neeve.sto.EStoFieldAlreadyPresentException;
import com.neeve.sto.EStoFieldCorruptException;
import com.neeve.sto.EStoInsufficientSpaceException;
import com.neeve.sto.IStoBufferManager;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldHeader;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class StoFieldContainer
implements Cloneable {
    private static final int defaultBufferSize = Config.getValue((String)"nv.sto.defaultbuffersize", (int)256);
    private UtlList fieldList;
    private StoField lateSyncBoundary;
    private int lateSyncBoundaryMark;
    private HashMap<String, StoField> fieldMap;
    private IStoBufferManager bufferManager;
    private ByteBuffer buffer;
    private StoField current;

    protected StoFieldContainer() {
        this.init(true);
    }

    protected StoFieldContainer(ByteBuffer buffer, boolean attach) {
        this();
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (attach) {
            this.buffer = buffer;
        }
        while (buffer.remaining() > 0) {
            StoField field = StoField.create(buffer, buffer.position());
            buffer.position(buffer.position() + field.getLength());
            this.fieldList.append((UtlListElement)field);
            if (field.isNamed()) {
                this.getFieldMap().put(field.getName(), field);
            }
            if (this.lateSyncBoundary == null && field.isVariableLength()) {
                this.lateSyncBoundary = field;
            }
            if (!attach || field.isVariableLength()) {
                field.clearBackingBuffer();
            }
            if (this.lateSyncBoundary != null) continue;
            this.lateSyncBoundaryMark = buffer.position();
        }
    }

    private final void init(boolean fromConstructor) {
        this.fieldList = UtlList.create();
        if (!fromConstructor) {
            this.lateSyncBoundary = null;
            this.lateSyncBoundaryMark = 0;
            this.fieldMap = null;
            this.bufferManager = null;
            this.buffer = null;
            this.current = null;
        }
    }

    private final HashMap<String, StoField> getFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap();
        }
        return this.fieldMap;
    }

    private final void growBackingBuffer(StoField field) throws EStoInsufficientSpaceException {
        if (this.bufferManager == null) {
            throw new EStoInsufficientSpaceException();
        }
        ByteBuffer newBuffer = this.bufferManager.allocate(this.buffer.capacity() * 2);
        this.buffer = newBuffer.put((ByteBuffer)this.buffer.flip());
        for (StoField current = (StoField)this.fieldList.first(); current != field; current = (StoField)current.next()) {
            if (current.getBackingBuffer() == null) continue;
            current.switchBackingBuffer(newBuffer);
        }
    }

    private final void sync(StoField field) throws EStoInsufficientSpaceException {
        int pos = this.buffer.position();
        int fieldLen = field.getLength();
        while (fieldLen > this.buffer.remaining()) {
            this.growBackingBuffer(field);
        }
        field.sync(this.buffer, pos);
        this.buffer.position(pos + fieldLen);
    }

    private final void setBackingBuffer(StoField field) throws EStoInsufficientSpaceException {
        int fieldLen = field.getLength();
        while (fieldLen > this.buffer.remaining()) {
            try {
                this.growBackingBuffer(field);
            }
            catch (EStoInsufficientSpaceException e) {
                this.clearBackingBuffer();
                throw e;
            }
        }
        int pos = this.buffer.position();
        field.setBackingBuffer(this.buffer, pos);
        this.buffer.position(pos + fieldLen);
    }

    public short getTypeFactoryId() {
        return 0;
    }

    public short getTypeId() {
        return 0;
    }

    public static StoFieldContainer create() {
        return new StoFieldContainer();
    }

    public static StoFieldContainer create(ByteBuffer buffer, boolean attach) {
        return new StoFieldContainer(buffer, attach);
    }

    public static StoFieldContainer create(ByteBuffer buffer) {
        return StoFieldContainer.create(buffer, true);
    }

    public static int getFieldOffset(ByteBuffer buffer, int pos) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (pos <= 0) {
            throw new IllegalArgumentException("pos must be > 0");
        }
        int offset = buffer.position();
        for (int i = 1; i < pos && offset < buffer.limit(); offset += StoField.getSerializedLength(buffer, offset), ++i) {
        }
        return offset < buffer.limit() ? offset + StoFieldHeader.getSerializedLength(buffer, offset) : -1;
    }

    public final StoFieldContainer setBackingBufferManager(IStoBufferManager bufferManager) {
        this.bufferManager = bufferManager;
        if (bufferManager != null && this.buffer == null) {
            this.setBackingBuffer(bufferManager.allocate(defaultBufferSize));
        }
        return this;
    }

    public final IStoBufferManager getBackingBufferManager() {
        return this.bufferManager;
    }

    public final StoFieldContainer clearBackingBufferManager() {
        return this.setBackingBufferManager(null);
    }

    public final StoFieldContainer setBackingBuffer(ByteBuffer buffer, boolean suppressClear) throws EStoInsufficientSpaceException {
        UtlListElement element;
        if (!suppressClear && this.buffer != null) {
            for (element = this.fieldList.first(); element != null; element = element.next()) {
                ((StoField)element).clearBackingBuffer();
            }
            this.buffer = null;
        }
        this.lateSyncBoundaryMark = 0;
        this.buffer = buffer;
        if (this.buffer != null) {
            StoField field;
            buffer.position(0);
            for (element = this.fieldList.first(); element != null && (field = (StoField)element) != this.lateSyncBoundary; element = element.next()) {
                this.setBackingBuffer(field);
                this.lateSyncBoundaryMark = this.buffer.position();
            }
        }
        return this;
    }

    public final StoFieldContainer setBackingBuffer(ByteBuffer buffer) throws EStoInsufficientSpaceException {
        return this.setBackingBuffer(buffer, false);
    }

    public final StoFieldContainer changeBackingBuffer(ByteBuffer buffer) throws EStoFieldCorruptException {
        this.buffer = buffer;
        if (this.buffer != null) {
            boolean reachedLateSyncBoundary = false;
            this.lateSyncBoundaryMark = 0;
            for (UtlListElement element = this.fieldList.first(); element != null; element = element.next()) {
                StoField field = (StoField)element;
                int pos = buffer.position();
                int fieldLength = StoField.getSerializedLength(field.getType(), buffer, pos);
                field.changeBackingBuffer(buffer, pos);
                buffer.position(pos + fieldLength);
                if (!reachedLateSyncBoundary && this.lateSyncBoundary == field) {
                    reachedLateSyncBoundary = true;
                }
                if (reachedLateSyncBoundary) {
                    field.clearBackingBuffer();
                    continue;
                }
                this.lateSyncBoundaryMark = buffer.position();
            }
            return this;
        }
        throw new IllegalArgumentException("buffer cannot be null");
    }

    public final ByteBuffer getBackingBuffer() {
        return this.buffer;
    }

    public final StoFieldContainer clearBackingBuffer() {
        return this.setBackingBuffer((ByteBuffer)null);
    }

    public final StoFieldContainer append(StoField field) throws EStoFieldAlreadyPresentException {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (!field.isLinked()) {
            this.fieldList.append((UtlListElement)field);
            if (field.getName() != null) {
                HashMap<String, StoField> fieldMap = this.getFieldMap();
                if (fieldMap.get(field.getName()) == null) {
                    fieldMap.put(field.getName(), field);
                } else {
                    throw new EStoFieldAlreadyPresentException();
                }
            }
            if (this.lateSyncBoundary == null && field.isVariableLength()) {
                this.lateSyncBoundary = field;
            }
            if (this.buffer != null && this.lateSyncBoundary == null) {
                this.setBackingBuffer(field);
                this.lateSyncBoundaryMark = this.buffer.position();
            }
        } else {
            throw new EStoFieldAlreadyPresentException();
        }
        return this;
    }

    public final StoField get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.fieldMap != null ? this.fieldMap.get(name) : null;
    }

    public final StoField get(int pos) {
        if (pos <= 0) {
            throw new IllegalArgumentException("pos must be > 0");
        }
        UtlList element = this.fieldList;
        for (int i = 1; i <= pos; ++i) {
            if ((element = element.next()) != null) continue;
            return null;
        }
        return (StoField)element;
    }

    public final StoField getLateSyncBoundary() {
        return this.lateSyncBoundary;
    }

    public final int getLateSyncBoundaryMark() {
        return this.lateSyncBoundaryMark;
    }

    public final boolean isVariableLength() {
        return this.lateSyncBoundary != null;
    }

    public final StoField first() {
        this.current = (StoField)this.fieldList.first();
        return this.current;
    }

    public final StoField next() {
        this.current = this.current == null ? this.first() : this.current.next();
        return this.current;
    }

    public final int count() {
        return this.fieldList.count();
    }

    public final int getSerializedLength() {
        int len;
        if (this.buffer != null) {
            if (this.lateSyncBoundary == null) {
                return this.lateSyncBoundaryMark;
            }
            len = this.lateSyncBoundaryMark;
            for (StoField field = this.lateSyncBoundary; field != null; field = (StoField)field.next()) {
                len += field.getLength();
            }
        } else {
            len = 0;
            for (StoField field = this.first(); field != null; field = (StoField)field.next()) {
                len += field.getLength();
            }
        }
        return len;
    }

    public final void reset() {
        for (StoField field = this.first(); field != null; field = (StoField)field.next()) {
            field.reset();
        }
    }

    public final StoFieldContainer sync() throws EStoInsufficientSpaceException {
        if (this.buffer != null || this.bufferManager != null) {
            if (this.buffer == null) {
                this.setBackingBuffer(this.bufferManager.allocate(defaultBufferSize));
            }
            this.buffer.position(this.lateSyncBoundaryMark);
            if (this.lateSyncBoundary != null) {
                StoField field = this.lateSyncBoundary;
                do {
                    this.sync(field);
                } while ((field = (StoField)field.next()) != null);
            }
        } else {
            throw new IllegalStateException("container does not have a backing buffer and a buffer manager is not set");
        }
        return this;
    }

    public final StoFieldContainer sync(ByteBuffer buffer, int offset) throws EStoInsufficientSpaceException {
        if (this.buffer == null) {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (offset < 0 || offset >= buffer.capacity()) {
                throw new IllegalArgumentException("offset must be >= 0 and < buffer capacity");
            }
            buffer.position(offset);
            for (StoField field = this.first(); field != null; field = (StoField)field.next()) {
                int pos = buffer.position();
                field.sync(buffer, pos);
                buffer.position(pos + StoField.getSerializedLength(buffer, pos));
            }
        } else {
            throw new IllegalStateException("container is attached to a backing buffer");
        }
        return this;
    }

    public final boolean contentsEquals(StoFieldContainer other) {
        boolean equal = this == other;
        if (!equal && (equal = other != null) && (equal = other.count() == this.count())) {
            StoField thisfld = this.first();
            StoField otherfld = other.first();
            while (equal && thisfld != null) {
                equal = thisfld.contentsEquals(otherfld);
                if (!equal) continue;
                thisfld = this.next();
                otherfld = other.next();
            }
        }
        return equal;
    }

    public Object clone() {
        StoFieldContainer clonee;
        try {
            clonee = (StoFieldContainer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
        }
        clonee.init(false);
        for (UtlListElement element = this.fieldList.first(); element != null; element = element.next()) {
            StoField field = (StoField)element;
            clonee.append((StoField)field.clone());
        }
        return clonee;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (UtlListElement element = this.fieldList.first(); element != null; element = element.next()) {
            StoField field = (StoField)element;
            String name = field.getName();
            sb.append("(").append(name == null ? "null" : name).append("=").append(field.getValueString()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

