/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotCompatibleException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkNotPresentException;
import com.neeve.link.ELnkReadOperationalException;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.ILnkSTRRootEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.root.RootConfig;
import java.util.UUID;

public class LnkSTRContainer
extends LnkContainer {
    private final EmxActionExecutor<ILnkPeerEndpoint, Object> readActionExecutor;
    private final StartReadAction startReadAction;
    private final StopReadAction stopReadAction;
    private final int flags;
    protected volatile IEmxDispatcher reader;

    protected LnkSTRContainer(RootConfig.ObjectConfig config, String name, IEmxDispatcher reader, int flags) throws ELnkAlreadyPresentException {
        super(config, name);
        this.flags = flags;
        this.reader = reader;
        this.readActionExecutor = new EmxActionExecutor();
        this.startReadAction = new StartReadAction();
        this.stopReadAction = new StopReadAction();
    }

    public static LnkSTRContainer createTemporary(RootConfig.ObjectConfig config, IEmxDispatcher reader) {
        LnkSTRContainer container;
        while (true) {
            String tmpName = UUID.randomUUID().toString();
            try {
                container = new LnkSTRContainer(config, tmpName, reader, 0){};
            }
            catch (ELnkAlreadyPresentException eLnkAlreadyPresentException) {
                continue;
            }
            break;
        }
        return container;
    }

    protected final void setReader(IEmxDispatcher reader) throws ELnkInvalidStateException, ELnkNotOwnerException {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (reader.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        if (this.reader != null) {
            throw new ELnkInvalidStateException("set reader", "reader already set");
        }
        this.reader = reader;
    }

    public final IEmxDispatcher getReader() {
        return this.reader;
    }

    @Override
    public final boolean isCompatible(ILnkPeerEndpoint pep) {
        ILnkRootEndpoint rep = pep.getRootEndpoint();
        return rep instanceof ILnkSTRRootEndpoint;
    }

    @Override
    public final void startRead(ILnkPeerEndpoint pep) throws ELnkNotPresentException, ELnkReadOperationalException, ELnkNotCompatibleException, ELnkException {
        try {
            this.readActionExecutor.invoke(this.reader, this.startReadAction, pep, 1);
        }
        catch (ELnkNotPresentException e) {
            throw e;
        }
        catch (ELnkReadOperationalException e) {
            throw e;
        }
        catch (ELnkNotCompatibleException e) {
            throw e;
        }
        catch (ELnkException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InternalError("Unexpected exception [" + e.toString() + "]");
        }
    }

    @Override
    public final IEmxDispatcher getCurrentReader() {
        return Thread.currentThread() == this.reader.getOwner() ? this.reader : null;
    }

    @Override
    public final void stopRead(ILnkPeerEndpoint pep) throws ELnkNotPresentException, ELnkNotCompatibleException, ELnkException {
        try {
            this.readActionExecutor.invoke(this.reader, this.stopReadAction, pep, 1);
        }
        catch (ELnkNotPresentException e) {
            throw e;
        }
        catch (ELnkNotCompatibleException e) {
            throw e;
        }
        catch (ELnkException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InternalError("Unexpected exception [" + e.toString() + "]");
        }
    }

    @Override
    public String toString() {
        return "[" + super.toString() + " STR]";
    }

    private final class StopReadAction
    implements IEmxAction<ILnkPeerEndpoint, Object> {
        private StopReadAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(IEmxDispatcher dispatcher, ILnkPeerEndpoint pep) throws Exception {
            LnkSTRContainer lnkSTRContainer = LnkSTRContainer.this;
            synchronized (lnkSTRContainer) {
                LnkSTRContainer.this.onStopRead(pep);
                if (pep.isReadOperational()) {
                    ((ILnkSTRRootEndpoint)pep.getRootEndpoint()).stopRead(0);
                }
            }
            return null;
        }
    }

    private final class StartReadAction
    implements IEmxAction<ILnkPeerEndpoint, Object> {
        private StartReadAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object execute(IEmxDispatcher dispatcher, ILnkPeerEndpoint pep) throws Exception {
            LnkSTRContainer lnkSTRContainer = LnkSTRContainer.this;
            synchronized (lnkSTRContainer) {
                LnkSTRContainer.this.onStartRead(pep);
                ((ILnkSTRRootEndpoint)pep.getRootEndpoint()).startRead(dispatcher, 0);
            }
            return null;
        }
    }
}

