/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import java.nio.ByteBuffer;

public final class EmxNwLnkInitPacket {
    private static final int VERSION_POS = 0;
    private static final int V1_IPV4_POS = 1;
    private static final int V1_PORT = 5;
    public static final byte V1 = 1;
    public static final int V1_FIXED_WIRE_LENGTH = 9;
    public static final byte VERSION = 1;
    public static final int MAX_FIXED_WIRE_LENGTH = 9;
    private ByteBuffer buffer;

    private EmxNwLnkInitPacket() {
    }

    public static final EmxNwLnkInitPacket create() {
        return new EmxNwLnkInitPacket();
    }

    public static final short getLatestVersion() {
        return 1;
    }

    private final short getVersion(ByteBuffer buffer) {
        return (short)(0xFF & buffer.get(0));
    }

    public final short getVersion() {
        if (this.buffer == null) {
            throw new IllegalStateException("init packet not initialized");
        }
        return this.getVersion(this.buffer);
    }

    public final int getIPv4Address() {
        if (this.buffer == null) {
            throw new IllegalStateException("init packet not initialized");
        }
        return this.buffer.getInt(1);
    }

    public final int getPort() {
        if (this.buffer == null) {
            throw new IllegalStateException("init packet not initialized");
        }
        return this.buffer.getInt(5);
    }

    public final ByteBuffer getBuffer() {
        if (this.buffer == null) {
            throw new IllegalStateException("init packet not initialized");
        }
        return this.buffer;
    }

    public final EmxNwLnkInitPacket serializeV1(int ipv4Address, int port) {
        this.buffer = ByteBuffer.allocate(9);
        this.buffer.put(0, (byte)1);
        this.buffer.putInt(1, ipv4Address);
        this.buffer.putInt(5, port);
        return this;
    }

    public final EmxNwLnkInitPacket deserialize(ByteBuffer data) {
        short version = this.getVersion(data);
        switch (version) {
            case 1: {
                if (data.remaining() != 9) {
                    throw new IllegalArgumentException("incorrect packet length for V" + version + " init packet (exp=" + 9 + ", actual=" + data.remaining() + ")");
                }
                this.buffer = ByteBuffer.allocate(9);
                this.buffer.put(data);
                this.buffer.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid version '" + version + "'");
            }
        }
        return this;
    }

    public final String toString() {
        String str = "";
        str = str + "[";
        try {
            str = str + this.getVersion() + ",";
            str = str + this.getIPv4Address() + ",";
            str = str + this.getPort();
        }
        catch (Throwable thrown) {
            str = str + " INVALID (" + thrown.getMessage() + ")";
        }
        str = str + "]";
        return str;
    }
}

