#!/bin/bash

# Usage function
print_usage() {
    echo "Usage: $0 --host <remote_host> --command <command_to_run>"
    exit 1
}

# Parse input arguments
REMOTE_HOST=""
REMOTE_COMMAND=""

while [[ "$1" == -* ]]; do
    case "$1" in
    --host)
        shift
        REMOTE_HOST=$1
        shift
    ;;
    --command)
        shift
        REMOTE_COMMAND=$1
        shift
    ;;
    *)
        echo "Error: Unknown option: $1" >&2
        print_usage
    ;;
    esac
done

# Validate input
if [[ -z "$REMOTE_HOST" || -z "$REMOTE_COMMAND" ]]; then
    print_usage
fi

# Execute the command remotely using the specified SSH key
ssh -i ~/.ssh/rumi rumi@$REMOTE_HOST "bash -c '$REMOTE_COMMAND'"
