/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.config.Config;
import com.neeve.util.UtlStr;
import com.neeve.util.UtlTailoringCore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class UtlTailoring
extends UtlTailoringCore {
    public static final String ENABLE_SPRING_STYLE_SUBSTITUTION_PROP = "nv.tailoring.enablespringstyle";
    private static final boolean ENABLE_SPRING_STYLE_SUBSTITUTION = Config.getValue((String)"nv.tailoring.enablespringstyle", (boolean)true);
    public static final String ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER_PROP = "nv.tailoring.enablenewspringstyleparser";
    public static final boolean ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER = Config.getValue((String)"nv.tailoring.enablenewspringstyleparser", (boolean)true);
    public static final PropertySource ENV_SUBSTITUTION_RESOLVER = new PropertySource(){

        public String getValue(String variable, String defValue) {
            return Config.hasValue((String)variable) ? Config.getValue((String)variable, (String)defValue) : defValue;
        }
    };
    private boolean appendUnreplacedProperties = true;
    private boolean leaveReplacementComments = true;

    public static final void tailorFile(File f, Properties props, STYLE style) throws IOException {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                UtlTailoring.tailorFile(child, props, style);
            }
            return;
        }
        switch (style) {
            case SPRING: {
                UtlTailoring.springScanAndReplace(f, props);
                break;
            }
            case PROPFILE: {
                UtlTailoring.propFileScanAndReplace(f, props, true, true);
                break;
            }
            case SUBST: {
                UtlTailoring.substScanAndReplace(f, props);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown style: " + (Object)((Object)style));
            }
        }
    }

    public static String springScanAndReplace(File f, Properties props) throws IOException {
        String string = UtlTailoring.readFile(f);
        String tailored = UtlTailoring.springScanAndReplace(string, props);
        if (tailored != string) {
            UtlTailoring.writeFile(tailored, f);
        }
        return tailored;
    }

    public static String springScanAndReplace(String string, Properties props) {
        try {
            return UtlTailoring.springScanAndReplace(string, new PropertiesPropSource(props));
        }
        catch (UtlTailoringCore.TailoringException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static String springScanAndReplace(String string, Properties props, boolean preserveDefaults) {
        try {
            return UtlTailoring.springScanAndReplace(string, new PropertiesPropSource(props), preserveDefaults);
        }
        catch (UtlTailoringCore.TailoringException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static String springScanAndReplace(String string, PropertySource props) throws UtlTailoringCore.TailoringException {
        return UtlTailoring.delimitedReplace(string, props, 0, "${", "}", "::", false, null);
    }

    public static String springScanAndReplace(String string, PropertySource props, boolean preserveDefaults) throws UtlTailoringCore.TailoringException {
        return UtlTailoring.delimitedReplace(string, props, 0, "${", "}", "::", preserveDefaults, null);
    }

    public static String substScanAndReplace(File f, Properties props) throws IOException {
        String string = UtlTailoring.readFile(f);
        String tailored = UtlTailoring.springScanAndReplace(string, props);
        if (tailored != string) {
            UtlTailoring.writeFile(tailored, f);
        }
        return tailored;
    }

    public static String substScanAndReplace(String string, Properties props) throws Exception {
        try {
            return UtlTailoring.substScanAndReplace(string, new PropertiesPropSource(props));
        }
        catch (UtlTailoringCore.TailoringException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static String substScanAndReplace(String str, PropertySource props) throws Exception {
        String fname = "$subst";
        if (str.contains("$subst")) {
            int sidx = str.indexOf("$subst(");
            if (sidx < 0) {
                throw new Exception("syntax error : '" + str + "' : $subst() : missing opening parenthesis");
            }
            int asidx = sidx + "$subst".length() + 1;
            int eidx = str.indexOf(")", asidx);
            if (eidx < 0) {
                throw new Exception("syntax error : '" + str + "' : $subst() : missing closing parenthesis");
            }
            try {
                str = UtlTailoring.substitute(str.substring(0, sidx) + UtlStr.subst(str.substring(asidx, eidx), props) + str.substring(eidx + 1, str.length()), props);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unable to substitute '" + str.substring(sidx - 6, eidx) + " should be of form $subst(%<varname>::<defaultval>%) - ", iae);
            }
        }
        return str;
    }

    public static String propFileScanAndReplace(File target, Properties props, boolean appendUreplacedValues, boolean leaveReplaceComment) throws IOException {
        String string = UtlTailoring.readFile(target);
        String tailored = UtlTailoring.propFileScanAndReplace(UtlTailoring.readFile(target), props, appendUreplacedValues, leaveReplaceComment);
        if (tailored != string) {
            UtlTailoring.writeFile(tailored, target);
        }
        return tailored;
    }

    private static String delimitedReplace(String string, PropertySource props, int start, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults, LinkedHashMap<String, String> cycleDetection) throws UtlTailoringCore.TailoringException {
        if (ENABLE_NEW_SPRING_STYLE_SUBSTITUTION_PARSER) {
            return UtlTailoringCore.delimitedReplace((String)string, (UtlTailoringCore.PropertySource)props, (int)start, (String)openString, (String)closeString, (String)defaultDelimiter, (boolean)preserveDefaults, cycleDetection);
        }
        return UtlTailoringCore.legacyDelimitedReplace((String)string, (UtlTailoringCore.PropertySource)props, (int)start, (String)openString, (String)closeString, (String)defaultDelimiter, (boolean)preserveDefaults, cycleDetection);
    }

    public static String propFileScanAndReplace(String propFileContent, Properties replacementProps, boolean appendUreplacedValues, boolean leaveReplaceComment) {
        String newline;
        StringTokenizer tok = new StringTokenizer(propFileContent, "\r\n", true);
        StringBuffer rc = new StringBuffer(propFileContent.length() + 1024);
        Properties toAppend = null;
        if (appendUreplacedValues) {
            toAppend = new Properties();
            toAppend.putAll((Map<?, ?>)replacementProps);
        }
        boolean replaced = false;
        int ePos = -1;
        String string = newline = propFileContent.indexOf("\r\n") == -1 ? "\n" : "\r\n";
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() == 1 && (token.equals("\r") || token.equals("\n"))) {
                rc.append(token);
                continue;
            }
            if (UtlTailoring.isPropFileComment(token) || (ePos = token.indexOf("=")) == -1) {
                rc.append(token);
                continue;
            }
            String propName = token.substring(0, ePos);
            String propVal = replacementProps.getProperty(propName);
            if (propVal != null) {
                String oldVal;
                if (leaveReplaceComment && !(oldVal = token.substring(ePos + 1).trim()).equals(propVal)) {
                    rc.append('#');
                    rc.append("TailoringUtil Original");
                    rc.append('#');
                    rc.append(token);
                    rc.append(newline);
                }
                rc.append(propName);
                rc.append('=');
                rc.append(replacementProps.getProperty(propName));
                if (toAppend != null) {
                    toAppend.remove(propName);
                }
                replaced = true;
                continue;
            }
            rc.append(token);
        }
        if (toAppend != null && !toAppend.isEmpty()) {
            rc.append(newline);
            rc.append(newline);
            rc.append("# Added by TailoringUtil:");
            for (Map.Entry<Object, Object> entry : toAppend.entrySet()) {
                rc.append(newline);
                rc.append(entry.getKey().toString());
                rc.append('=');
                rc.append(entry.getValue());
                replaced = true;
            }
        }
        if (!replaced) {
            return propFileContent;
        }
        return rc.toString();
    }

    public static final boolean isPropFileComment(String line) {
        return line != null && line.startsWith("#") || line.startsWith(";");
    }

    private static void writeFile(String tailored, File f) throws IOException {
        FileWriter fw = new FileWriter(f, false);
        fw.write(tailored);
        fw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File f) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            int b = -1;
            while ((b = br.read()) != -1) {
                baos.write(b);
            }
            baos.close();
            String string = new String(baos.toByteArray());
            return string;
        }
    }

    public void setAppendUnreplacedProperties(boolean appendUnreplacedProperties) {
        this.appendUnreplacedProperties = appendUnreplacedProperties;
    }

    public boolean isAppendUnreplacedProperties() {
        return this.appendUnreplacedProperties;
    }

    public void setLeaveReplacementComments(boolean leaveReplacementComments) {
        this.leaveReplacementComments = leaveReplacementComments;
    }

    public boolean isLeaveReplacementComments() {
        return this.leaveReplacementComments;
    }

    public static final String substitute(String str, PropertySource props) throws Exception {
        str = UtlTailoring.substScanAndReplace(str, props);
        if (ENABLE_SPRING_STYLE_SUBSTITUTION) {
            return UtlTailoring.springScanAndReplace(str, props);
        }
        return str;
    }

    public static final String substituteFromEnv(String str) throws Exception {
        return UtlTailoring.substitute(str, ENV_SUBSTITUTION_RESOLVER);
    }

    public static final void main(String[] args) throws Exception {
        String style = args[0];
        File file = new File(args[1]);
        Properties props = new Properties();
        props.load(new FileInputStream(args[2]));
        UtlTailoring.tailorFile(file, props, STYLE.toStyle(style));
    }

    public static enum STYLE {
        SPRING,
        PROPFILE,
        SUBST;


        public static STYLE toStyle(String name) {
            return STYLE.valueOf(name.toUpperCase());
        }
    }

    private static class PropertiesPropSource
    implements PropertySource {
        private final Properties props;

        PropertiesPropSource(Properties props) {
            this.props = props;
        }

        public String getValue(String key, String defaultValue) {
            return this.props.getProperty(key, defaultValue);
        }
    }

    public static interface PropertySource
    extends UtlTailoringCore.PropertySource {
    }
}

