/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCharCollection;
import com.neeve.lang.XCharCollectionBase;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XCharList;
import com.neeve.lang.XCharListIterator;
import com.neeve.lang.XCollection;
import java.util.NoSuchElementException;

public class XCharLinkedList
extends XCharCollectionBase
implements XCharList {
    private transient CharNode _head = this.newNode();
    private transient CharNode _tail = this.newNode();
    private transient int _size;

    public XCharLinkedList() {
        this(4);
    }

    public XCharLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        CharNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            CharNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XCharLinkedList(XCharCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XCharLinkedList newInstance() {
        return new XCharLinkedList();
    }

    @Override
    public final boolean add(char value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final char get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final char set(int index, char value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        CharNode node = this.nodeAt(index);
        char previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, char value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XCharCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        CharNode indexNode = this.nodeAt(index);
        XCharIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final char remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        CharNode node = this.nodeAt(index);
        char previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(char value) {
        int index = 0;
        CharNode n = this._head;
        CharNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char value) {
        int index = this.size() - 1;
        CharNode n = this._tail;
        CharNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XCharIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XCharListIterator listIterator() {
        return XCharLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XCharListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XCharLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XCharList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final char getFirst() {
        CharNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final char getLast() {
        CharNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(char value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(char value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final char removeFirst() {
        CharNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        char previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final char removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        CharNode last = this._tail._previous;
        char previousValue = last._value;
        this._tail = last;
        last._value = '\u0000';
        return previousValue;
    }

    public final void addBefore(CharNode next, char value) {
        CharNode newNode;
        CharNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        CharNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final CharNode nodeAt(int index) {
        CharNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final CharNode head() {
        return this._head;
    }

    @Override
    public final CharNode tail() {
        return this._tail;
    }

    @Override
    public final char valueOf(XCollection.Record record) {
        return ((CharNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        CharNode node = (CharNode)record;
        --this._size;
        node._value = '\u0000';
        node._previous._next = node._next;
        node._next._previous = node._previous;
        CharNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(char value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XCharList unmodifiable() {
        return (XCharList)super.unmodifiable();
    }

    protected CharNode newNode() {
        return new CharNode();
    }

    private void increaseCapacity() {
        CharNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        CharNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        CharNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        CharNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XCharLinkedListIterator
    implements XCharListIterator {
        private XCharLinkedList _list;
        private CharNode _nextNode;
        private CharNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XCharLinkedListIterator() {
        }

        public static XCharLinkedListIterator valueOf(XCharLinkedList list, CharNode nextNode, int nextIndex, int size) {
            XCharLinkedListIterator itr = new XCharLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public char next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public char previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(char o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(char o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XCharLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XCharCollectionBase
    implements XCharList {
        private XCharLinkedList _list;
        private CharNode _head;
        private CharNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XCharLinkedList list, CharNode head, CharNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public char valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XCharCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XCharCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            CharNode indexNode = this.nodeAt(index);
            XCharIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public char get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public char set(int index, char value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            CharNode node = this.nodeAt(index);
            char previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(char element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, char element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public char remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            CharNode node = this.nodeAt(index);
            char previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(char value) {
            int index = 0;
            CharNode n = this._head;
            CharNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(char value) {
            int index = this.size() - 1;
            CharNode n = this._tail;
            CharNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XCharListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XCharListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XCharLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XCharList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final CharNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                CharNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            CharNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class CharNode
    implements XCollection.Record {
        private CharNode _next;
        private CharNode _previous;
        private char _value;

        protected CharNode() {
        }

        public final char getValue() {
            return this._value;
        }

        @Override
        public final CharNode getNext() {
            return this._next;
        }

        @Override
        public final CharNode getPrevious() {
            return this._previous;
        }
    }
}

