/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class ConfigRepositorySerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeRepositoryToFile(String repoDescriptor, String targetDirectory, String serializedRepoFilename) throws IOException, EConfigException {
        if (repoDescriptor == null) {
            throw new IllegalArgumentException("repo descriptor cannot be null");
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException("target directory cannot be null");
        }
        if (serializedRepoFilename == null) {
            throw new IllegalArgumentException("serialized repo file name cannot be null");
        }
        new File(targetDirectory).mkdirs();
        ConfigRepositoryFactory repoFactory = ConfigRepositoryFactory.getInstance();
        IConfigRepository repo = repoFactory.openRepository(repoDescriptor, false);
        StringBuilder sb = new StringBuilder();
        repo.serialize(sb);
        try (FileOutputStream fos = new FileOutputStream(targetDirectory + File.separator + serializedRepoFilename);){
            fos.write(sb.toString().getBytes("UTF-8"));
        }
    }

    private static void printUsage() {
        System.err.println("Usage ConfigTool [{-r, --repository} repository_descriptor ('default' for the default repository)] ");
        System.err.println("                 [{-d, --directory} output directory]");
        System.err.println("                 [{-f, --file output file");
        System.err.println("                 [{-h, --help} print this help string]");
    }

    public static void main(String[] args) {
        block5: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option repoDescriptorOption = parser.addStringOption('r', "repository");
                CmdLineParser.Option directoryOption = parser.addStringOption('d', "directory");
                CmdLineParser.Option fileOption = parser.addStringOption('f', "file");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String repoDescriptor = (String)parser.getOptionValue(repoDescriptorOption, null);
                        String directoryName = (String)parser.getOptionValue(directoryOption, null);
                        String fileName = (String)parser.getOptionValue(fileOption, null);
                        ConfigRepositorySerializer.serializeRepositoryToFile(repoDescriptor, directoryName, fileName);
                        break block5;
                    }
                    ConfigRepositorySerializer.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    ConfigRepositorySerializer.printUsage();
                }
            }
            catch (Throwable e) {
                System.out.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        }
    }
}

