/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepEngine;
import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.IEventAcknowledger;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import java.util.Properties;

public final class AepSendEvent
extends Event {
    private final Acknowledger acknowledger = new Acknowledger();
    private MessageChannel channel;
    private IRogMessage message;
    private AepEngine engine;

    private AepSendEvent() {
        super((short)508);
    }

    public static Event create(Properties props) {
        return new AepSendEvent();
    }

    public static AepSendEvent create(MessageChannel channel, IRogMessage message, AepEngine engine) {
        return ((AepSendEvent)EventFactory.getInstance().createEvent((short)508)).init(channel, message, engine);
    }

    private final AepSendEvent init(MessageChannel channel, IRogMessage message, AepEngine engine) {
        super.init(null, null);
        this.channel = channel;
        this.message = message;
        if (this.message != null) {
            message.acquire();
        }
        this.engine = engine;
        this.setAcknowledger(this.acknowledger);
        return this;
    }

    protected final void reset() {
        this.channel = null;
        if (this.message != null) {
            this.message.dispose();
        }
        this.message = null;
        this.engine = null;
        this.acknowledger.status = null;
    }

    public final MessageChannel getMessageChannel() {
        return this.channel;
    }

    public final IRogMessage getMessage() {
        return this.message;
    }

    public final String toString() {
        return "[event=SEND, " + super.toString() + ", channel=" + (this.channel == null ? "null" : this.channel.getName()) + ", message=" + (this.message != null ? this.message.getClass().getSimpleName() : "null") + "]";
    }

    final class Acknowledger
    implements IEventAcknowledger {
        private volatile Exception status;

        Acknowledger() {
        }

        public void setStatus(Exception status) {
            this.status = status;
        }

        public void ack() {
            AepSendEvent.this.engine.dispatchSendStabilityEvent(AepSendEvent.this.channel, (MessageView)AepSendEvent.this.message, this.status);
        }

        public void dispose() {
            this.status = null;
        }
    }
}

