/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index;

import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class IdxBaseIndex<T, ID>
implements IdxIndex<T, ID> {
    protected StatsImpl<T> stats = new StatsImpl();

    public IdxBaseIndex(String name, boolean unique) {
        this.stats.setIndexName(name);
        this.stats.setUnique(unique);
    }

    @Override
    public final String getName() {
        return this.stats.getIndexName();
    }

    protected final void setStats(IdxIndex.Stats<T> stats) {
        this.stats = (StatsImpl)stats;
    }

    @Override
    public StatsImpl<T> getStats() {
        return this.stats;
    }

    @Override
    public final <REC> IdxField<REC, T> getField() {
        return this.stats.getField();
    }

    protected <REC> void setField(IdxField<REC, T> field) {
        this.stats.setField(field);
    }

    public abstract void computeStats();

    public abstract T getLowestKey();

    public abstract T getHighestKey();

    public String toString() {
        return (this.isUnique() ? "UNIQUE" : "NON-UNIQUE") + " INDEX on " + this.getField();
    }

    protected Object getIndexKey(T fieldValue) {
        IdxField.KeyMapping<T> keyMapping;
        IdxField<?, T> field = this.stats.getField();
        if (field != null && (keyMapping = field.getKeyMapping()) != null) {
            return keyMapping.convert(fieldValue);
        }
        return fieldValue;
    }

    protected T getFieldValue(Object indexKey) {
        IdxField.KeyMapping<T> keyMapping;
        IdxField<?, T> field = this.stats.getField();
        if (field != null && (keyMapping = field.getKeyMapping()) != null) {
            keyMapping.reverse().convert(indexKey);
        }
        return (T)indexKey;
    }

    public static class StatsImpl<T>
    implements IdxIndex.Stats<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean unique;
        private AtomicInteger keyCardinality = new AtomicInteger(0);
        private AtomicInteger cardinality = new AtomicInteger(0);
        private T lowKey;
        private T highKey;
        private String indexName;
        private IdxField<?, T> field;
        private boolean isComparable = true;
        private boolean comparableTested = false;
        private transient boolean dirty = false;
        private long commitSequenceNumber = 0L;
        private boolean indexUpToDate = false;

        public boolean resetDirty() {
            try {
                boolean bl = this.dirty;
                return bl;
            }
            finally {
                this.dirty = false;
            }
        }

        @Override
        public boolean isUnique() {
            return this.unique;
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }

        @Override
        public int getKeyCardinality() {
            return this.keyCardinality.get();
        }

        public void setKeyCardinality(int keyCardinality) {
            this.keyCardinality.set(keyCardinality);
        }

        @Override
        public int getCardinality() {
            return this.cardinality.get();
        }

        public void setCardinality(int cardinality) {
            this.cardinality.set(cardinality);
        }

        @Override
        public T getLowKey() {
            return this.lowKey;
        }

        public void setLowKey(T lowKey) {
            this.lowKey = lowKey;
        }

        @Override
        public T getHighKey() {
            return this.highKey;
        }

        public void setHighKey(T highKey) {
            this.highKey = highKey;
        }

        @Override
        public long getCommitSequenceNumber() {
            return this.commitSequenceNumber;
        }

        public void setCommitSequenceNumber(long commitSequenceNumber) {
            this.commitSequenceNumber = commitSequenceNumber;
        }

        @Override
        public boolean isLive() {
            return this.indexUpToDate;
        }

        public void setLive(boolean live) {
            this.indexUpToDate = live;
        }

        protected boolean hasComparableKeys(T key) {
            if (!this.comparableTested) {
                this.isComparable = key instanceof Comparable;
                this.comparableTested = true;
            }
            return this.isComparable;
        }

        public final void onKeyAdded(T key) {
            this.dirty = true;
            this.keyCardinality.incrementAndGet();
            if (this.hasComparableKeys(key)) {
                Comparable compKey = (Comparable)key;
                if (this.highKey == null || compKey.compareTo(this.highKey) > 0) {
                    this.setHighKey(key);
                }
                if (this.lowKey == null || compKey.compareTo(this.lowKey) < 0) {
                    this.setLowKey(key);
                }
            }
        }

        public final void onKeyRemoved(T key, IdxBaseIndex<T, ?> index) {
            this.dirty = true;
            this.keyCardinality.decrementAndGet();
            if (this.hasComparableKeys(key)) {
                if (key.equals(this.lowKey)) {
                    this.lowKey = index.getLowestKey();
                }
                if (key.equals(this.highKey)) {
                    this.highKey = index.getHighestKey();
                }
            }
        }

        public final void onValueAdded() {
            this.dirty = true;
            this.cardinality.incrementAndGet();
        }

        public final void onValueRemoved() {
            this.dirty = true;
            this.cardinality.decrementAndGet();
        }

        public String getIndexName() {
            return this.indexName;
        }

        public void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public IdxField<?, T> getField() {
            return this.field;
        }

        public void setField(IdxField<?, T> field) {
            this.field = field;
        }

        public final String toString() {
            return "Stats[unique: " + this.unique + ", card:" + this.cardinality + ", keyCard: " + this.keyCardinality + " high:" + this.highKey + ", low:" + this.lowKey + "]";
        }
    }
}

