/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.neeve.query.QueryException;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAbstractField;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryImpl;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryMonotonicField;
import com.neeve.query.impl.QueryResultImpl;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.QuerySortArea;
import com.neeve.query.impl.QueryStatsImpl;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.impl.util.collect.UtlSorted;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxFieldPredicate;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxRange;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.query.predicates.Predicate;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;

public class QueryPlanImpl<ID, REC>
implements QueryPlan {
    private static final int MAX_INDEX_READ_SIZE = 10000;
    private static final PredicatesImpl predicates = PredicatesImpl.get();
    private List<StepImpl<ID, REC>> steps = Lists.newArrayList();
    private boolean generateQueryStats;
    private QueryResultSetImpl<ID, REC> resultSet;

    private static boolean isUnitTest() {
        String unitTestProperty = System.getProperty("nv.unittest");
        return unitTestProperty != null && Boolean.parseBoolean(unitTestProperty);
    }

    private static <REC> int getUpperLimit(QueryImpl<REC> query) {
        int upperEndpoint = Integer.MAX_VALUE;
        Range<Integer> limitRange = query.getLimitRange();
        if (limitRange != null && limitRange.hasUpperBound()) {
            upperEndpoint = (Integer)limitRange.upperEndpoint();
        }
        return upperEndpoint;
    }

    public void addStep(StepImpl<ID, REC> step) {
        step.setGenerateLatencies(this.generateQueryStats);
        step.associateResultSet(this.resultSet);
        this.steps.add(step);
    }

    public List<StepImpl<ID, REC>> getSteps() {
        return this.steps;
    }

    @Override
    public QueryStatsImpl getQueryStats() {
        QueryStatsImpl stats = new QueryStatsImpl();
        for (StepImpl<ID, REC> step : this.steps) {
            stats.addStepLatencies(step.getLatencies());
        }
        return stats;
    }

    public PlanQueryResult<REC> getResult(QueryIndexableRepository<ID, REC> repository) {
        StepResult<ID, REC> stepResult = null;
        for (StepImpl<ID, REC> step : this.getSteps()) {
            stepResult = step.getResult(repository, stepResult);
        }
        PlanQueryResult queryResult = stepResult.getQueryResult();
        queryResult.setPlan(this);
        return queryResult;
    }

    public void close() {
        for (StepImpl<ID, REC> step : this.getSteps()) {
            step.close();
        }
    }

    public boolean isFullScan() {
        for (StepImpl<ID, REC> step : this.steps) {
            if (!(step instanceof FullRead)) continue;
            return true;
        }
        return false;
    }

    public void setGenerateQueryStats(boolean generateQueryStats) {
        this.generateQueryStats = generateQueryStats;
        for (StepImpl<ID, REC> step : this.steps) {
            step.setGenerateLatencies(generateQueryStats);
        }
    }

    public void associateResultSet(QueryResultSetImpl<ID, REC> resultSet) {
        this.resultSet = resultSet;
        for (StepImpl<ID, REC> step : this.getSteps()) {
            step.associateResultSet(resultSet);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("QueryPlan\n");
        boolean first = true;
        for (QueryPlan.Step step : this.steps) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append("  ").append(step.toString());
        }
        return sb.toString();
    }

    public static class OrderBy<ID, REC>
    extends CachingStep<ID, REC> {
        private static final Ordering ASCENDING = Ordering.natural().nullsLast();
        private static final Ordering DESCENDING = ASCENDING.reverse();
        private QueryImpl<REC> query;

        public static <T> Comparator<QueryResultSet.Row<T>> createComparator(List<QueryImpl.OrderByField<T, ?>> orderBy) {
            ArrayList fieldComparators = Lists.newArrayList();
            for (final QueryImpl.OrderByField<T, ?> orderByField : orderBy) {
                Comparator fieldComparator = new Comparator<QueryResultSet.Row<T>>(){
                    private IdxField<T, ?> field;
                    private Comparator valueComparator;
                    {
                        this.field = orderByField.getField();
                        this.valueComparator = orderByField.isAscending() ? ASCENDING : DESCENDING;
                    }

                    @Override
                    public int compare(QueryResultSet.Row<T> row1, QueryResultSet.Row<T> row2) {
                        Comparable value1 = (Comparable)row1.getValue(this.field);
                        Comparable value2 = (Comparable)row2.getValue(this.field);
                        return this.valueComparator.compare(value1, value2);
                    }
                };
                fieldComparators.add(fieldComparator);
            }
            return Ordering.compound((Iterable)fieldComparators);
        }

        public OrderBy(QueryImpl<REC> query) {
            this.query = query;
        }

        @Override
        protected CachingStep.StepCache createCache(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            return new SortCache(repository, priorResult);
        }

        @Override
        public String description() {
            return this.getName();
        }

        private class SortCache
        extends CachingStep.StepCache {
            private NavigableSet<QueryResultSet.Row<REC>> sorted;

            public SortCache(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
                super(repository, priorResult);
            }

            @Override
            public String cachePriorResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
                List orderBy = OrderBy.this.query.getOrderBy();
                Comparator<QueryResultSet.Row<QueryResultSet.Row>> rowComparator = OrderBy.createComparator(orderBy);
                String setId = this.sortArea.createCollectionId();
                this.sorted = this.sortArea.getNavigableSet(setId, rowComparator);
                PlanQueryResult<?> queryResult = priorResult.getQueryResult();
                int upperLimit = QueryPlanImpl.getUpperLimit(OrderBy.this.query);
                boolean topN = upperLimit < Integer.MAX_VALUE;
                for (QueryResultSet.Row row : queryResult) {
                    if (OrderBy.this.generateLatencies) {
                        OrderBy.this.latencies.start();
                    }
                    if (topN) {
                        if (this.sorted.size() < upperLimit) {
                            this.sorted.add(row);
                        } else {
                            QueryResultSet.Row lastRow = (QueryResultSet.Row)this.sorted.last();
                            if (rowComparator.compare(row, lastRow) < 0) {
                                this.sorted.add(row);
                                this.sorted.remove(lastRow);
                            }
                        }
                    } else {
                        this.sorted.add(row);
                    }
                    if (!OrderBy.this.generateLatencies) continue;
                    OrderBy.this.latencies.stop();
                }
                if (OrderBy.this.generateLatencies) {
                    OrderBy.this.latencies.compute();
                }
                return setId;
            }

            @Override
            public Iterator<QueryResultSet.Row<REC>> iterator() {
                return this.sorted.iterator();
            }

            @Override
            public int getEstimatedSize() {
                return this.sorted.size();
            }
        }
    }

    public static class Aggregation<ID, REC>
    extends CachingStep<ID, REC> {
        private QueryImpl<REC> query;

        public Aggregation(QueryImpl<REC> query) {
            this.query = query;
        }

        @Override
        protected CachingStep.StepCache createCache(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            return new AggregationCache(repository, priorResult);
        }

        private class AggregationCache
        extends CachingStep.StepCache {
            private Map<QueryAggregateField.Key, QueryAggregateField.Aggregate<REC>> aggregationMap;

            public AggregationCache(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
                super(repository, priorResult);
            }

            @Override
            public String cachePriorResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
                ArrayList aggregateFields = Lists.newArrayList();
                for (IdxField field : Aggregation.this.query.getSelect()) {
                    if (!(field instanceof QueryAggregateField)) continue;
                    aggregateFields.add((QueryAggregateField)field);
                }
                List groupBy = Aggregation.this.query.getGroupBy();
                IdxField[] groupByArray = new IdxField[groupBy.size()];
                groupByArray = groupBy.toArray(groupByArray);
                int keySize = groupBy.size();
                String mapId = this.sortArea.createCollectionId();
                this.aggregationMap = this.sortArea.getHashMap(mapId);
                int upperLimit = QueryPlanImpl.getUpperLimit(Aggregation.this.query);
                boolean topN = upperLimit < Integer.MAX_VALUE && Aggregation.this.query.getOrderBy().isEmpty();
                int numEntries = 0;
                PlanQueryResult<?> priorQueryResult = priorResult.getQueryResult();
                for (QueryResultSet.Row row : priorQueryResult) {
                    QueryAggregateField.Aggregate aggregate;
                    if (Aggregation.this.generateLatencies) {
                        Aggregation.this.latencies.start();
                    }
                    QueryResultSetImpl.RowImpl rowImpl = (QueryResultSetImpl.RowImpl)row;
                    rowImpl.reloadRecord(repository);
                    Object record = row.getRecord();
                    Serializable[] keys = new Serializable[keySize];
                    for (int i = 0; i < keySize; ++i) {
                        IdxField keyField = groupBy.get(i);
                        Object key = keyField.apply(record);
                        keys[i] = (Serializable)key;
                    }
                    QueryAggregateField.Key aggregationKey = QueryAggregateField.createKey(groupByArray, keys);
                    if (this.aggregationMap.containsKey(aggregationKey)) {
                        aggregate = this.aggregationMap.get(aggregationKey);
                        aggregate.addRecord(record);
                        this.aggregationMap.put(aggregationKey, (QueryAggregateField.Aggregate)aggregate.clone());
                    } else if (!topN || numEntries <= upperLimit) {
                        aggregate = QueryAggregateField.createAggregate(aggregationKey);
                        aggregate.registerFields(aggregateFields);
                        aggregate.addRecord(record);
                        this.aggregationMap.put(aggregationKey, aggregate);
                        ++numEntries;
                    }
                    if (!Aggregation.this.generateLatencies) continue;
                    Aggregation.this.latencies.stop();
                }
                if (Aggregation.this.generateLatencies) {
                    Aggregation.this.latencies.compute();
                }
                return mapId;
            }

            @Override
            public Iterator<QueryResultSet.Row<REC>> iterator() {
                return new Iterator<QueryResultSet.Row<REC>>(){
                    Iterator<QueryAggregateField.Aggregate<REC>> aggregateIter;
                    {
                        this.aggregateIter = AggregationCache.this.aggregationMap.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.aggregateIter.hasNext();
                    }

                    @Override
                    public QueryResultSet.Row<REC> next() {
                        QueryAggregateField.Aggregate aggregate = this.aggregateIter.next();
                        return Aggregation.this.getResultSet().forAggregate(aggregate);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int getEstimatedSize() {
                return this.aggregationMap.size();
            }
        }
    }

    public static class Distinct<ID, REC>
    extends StepImpl<ID, REC> {
        private static Object nullPlaceholder = new Object();
        private String backingSetId;

        private Set<Object> getBackingSet() {
            QuerySortArea sortArea = this.getResultSet().getSortArea();
            if (this.backingSetId != null) {
                sortArea.dropCollection(this.backingSetId);
            }
            this.backingSetId = sortArea.createCollectionId();
            return sortArea.getHashSet(this.backingSetId);
        }

        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, final StepResult<ID, ?> priorResult) {
            Iterable rows = new Iterable<QueryResultSet.Row<REC>>(){

                @Override
                public Iterator<QueryResultSet.Row<REC>> iterator() {
                    return new AbstractIterator<QueryResultSet.Row<REC>>(){
                        private Set<Object> uniqueRowValues;
                        private Iterator<QueryResultSet.Row<REC>> priorResultIterator;
                        private List<IdxField<REC, ?>> selectedFields;
                        private int numFields;
                        private IdxField<REC, ?> firstField;
                        {
                            this.uniqueRowValues = this.getBackingSet();
                            this.priorResultIterator = null;
                            this.selectedFields = this.getResultSet().getSelectedFields();
                            this.numFields = this.selectedFields.size();
                            this.firstField = this.selectedFields.get(0);
                        }

                        protected QueryResultSet.Row<REC> computeNext() {
                            if (this.priorResultIterator == null) {
                                PlanQueryResult queryResult = priorResult.getQueryResult();
                                this.priorResultIterator = queryResult.iterator();
                            }
                            while (this.priorResultIterator.hasNext()) {
                                QueryResultSet.Row row = this.priorResultIterator.next();
                                Object selectedValues = this.extractSelectedValues(row);
                                if (this.uniqueRowValues.contains(selectedValues)) continue;
                                this.uniqueRowValues.add(selectedValues);
                                return row;
                            }
                            return (QueryResultSet.Row)this.endOfData();
                        }

                        private Object extractSelectedValues(QueryResultSet.Row<REC> row) {
                            Object fieldValues = null;
                            if (this.numFields == 1) {
                                fieldValues = row.getValue(this.firstField);
                                if (fieldValues == null) {
                                    fieldValues = nullPlaceholder;
                                }
                            } else {
                                ArrayList fieldValueList = Lists.newArrayListWithCapacity((int)this.numFields);
                                for (IdxField field : this.selectedFields) {
                                    fieldValueList.add(row.getValue(field));
                                }
                                fieldValues = fieldValueList;
                            }
                            return fieldValues;
                        }
                    };
                }
            };
            StepResult stepResult = new StepResult(repository, rows, ((StepResult)priorResult).estimatedSize);
            return stepResult;
        }

        @Override
        public void close() {
            if (this.backingSetId != null) {
                QuerySortArea sortArea = this.getResultSet().getSortArea();
                sortArea.dropCollection(this.backingSetId);
            }
        }
    }

    public static class FilterImpl<ID, REC>
    extends StepImpl<ID, REC>
    implements Filter<REC> {
        private RowPredicate<REC> predicate;

        public FilterImpl(Predicate<REC> predicate) {
            this.predicate = new RowPredicate<REC>(predicate);
        }

        @Override
        public Predicate<REC> getPredicate() {
            return this.predicate.getRecordPredicate();
        }

        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            Iterable filtered;
            PlanQueryResult<?> unfiltered = priorResult.getQueryResult();
            if (this.generateLatencies) {
                QueryStatsImpl.TimedPredicate<REC> timedPredicate = new QueryStatsImpl.TimedPredicate<REC>(this.predicate, this.latencies);
                filtered = Iterables.filter(unfiltered, timedPredicate);
            } else {
                filtered = Iterables.filter(unfiltered, this.predicate);
            }
            StepResult stepResult = new StepResult(repository, filtered, ((StepResult)priorResult).estimatedSize);
            stepResult.setFullScan(((StepResult)priorResult).fullScan);
            return stepResult;
        }

        @Override
        public final String description() {
            return "FILTER(" + this.predicate.toString() + ")";
        }
    }

    public static interface Filter<REC>
    extends FilteringStep<REC> {
    }

    public static class OrExpansion<ID, REC>
    extends IndexRead<ID, REC> {
        private List<IndexRead<ID, REC>> readSteps;
        private Comparator<ID> idSorter;

        public OrExpansion(Iterable<IndexRead<ID, REC>> readSteps, Comparator<ID> idSorter) {
            this.idSorter = idSorter;
            this.readSteps = Lists.newArrayList(readSteps);
        }

        @Override
        public boolean hasOrderedIds() {
            return this.idSorter != null;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            if (this.readSteps.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.readSteps.size() == 1) {
                IndexRead<ID, REC> indexRead = this.readSteps.get(0);
                return indexRead.getIds(repository);
            }
            ArrayList stepIdsList = Lists.newArrayList();
            for (IndexRead<ID, REC> readStep : this.readSteps) {
                Iterable<ID> stepIds = readStep.getIds(repository);
                stepIdsList.add(stepIds);
            }
            return UtlSorted.mergeUnique(stepIdsList, this.idSorter);
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            int repoSize = repository.getSize();
            double stepRatioInverseProduct = 1.0;
            for (IndexRead<ID, REC> readStep : this.readSteps) {
                int stepSize = readStep.estimateSize(repository);
                if (stepSize < repoSize) {
                    double stepReadRatio = (double)stepSize / (double)repoSize;
                    stepRatioInverseProduct *= 1.0 - stepReadRatio;
                    continue;
                }
                return repoSize;
            }
            double repoReadRatio = 1.0 - stepRatioInverseProduct;
            return (int)Math.round((double)repoSize * repoReadRatio);
        }

        @Override
        public Predicate<REC> getPredicate() {
            ArrayList stepPredicates = Lists.newArrayList();
            for (IndexRead<ID, REC> readStep : this.readSteps) {
                stepPredicates.add(readStep.getPredicate());
            }
            return predicates.or(stepPredicates);
        }

        @Override
        public String description() {
            return this.getName();
        }

        @Override
        public String getFieldNames() {
            return "";
        }
    }

    public static class SortedIntersectionRead<ID, REC>
    extends IntersectionRead<ID, REC> {
        private Comparator<ID> idSorter;

        public SortedIntersectionRead(Iterable<IndexRead<ID, REC>> readSteps, Comparator<ID> idSorter) {
            super(readSteps);
            this.idSorter = idSorter;
        }

        @Override
        public boolean hasOrderedIds() {
            return true;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            ArrayList stepIdsList = Lists.newArrayList();
            for (IndexRead readStep : this.readSteps) {
                Iterable<ID> stepIds = readStep.getIds(repository);
                stepIdsList.add(stepIds);
            }
            return UtlSorted.intersect(stepIdsList, this.idSorter);
        }
    }

    public static class HashIntersectionRead<ID, REC>
    extends IntersectionRead<ID, REC> {
        private QuerySortArea<REC> sortArea;
        private String hashTargetName;

        public HashIntersectionRead(Iterable<IndexRead<ID, REC>> readSteps) {
            super(readSteps);
        }

        @Override
        public boolean hasOrderedIds() {
            return false;
        }

        @Override
        protected Iterable<ID> getIds(final QueryIndexableRepository<ID, REC> repository) {
            Comparator readStepComparator = new Comparator<IndexRead<ID, REC>>(){

                @Override
                public int compare(IndexRead<ID, REC> read1, IndexRead<ID, REC> read2) {
                    int size2;
                    int size1 = read1.estimateSize(repository);
                    if (size1 < (size2 = read2.estimateSize(repository))) {
                        return -1;
                    }
                    if (size1 == size2) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(this.readSteps, readStepComparator);
            this.sortArea = this.getResultSet().getSortArea();
            this.hashTargetName = "hashjoin:" + this.sortArea.createCollectionId();
            Set hashTarget = this.sortArea.getHashSet(this.hashTargetName);
            String probeName = "hashjoin:" + this.sortArea.createCollectionId();
            Set probe = this.sortArea.getHashSet(probeName);
            boolean first = true;
            for (IndexRead readStep : this.readSteps) {
                if (first) {
                    for (ID recordId : readStep.getIds(repository)) {
                        hashTarget.add(recordId);
                    }
                    first = false;
                    continue;
                }
                Set temp = probe;
                String tempName = probeName;
                probe = hashTarget;
                probeName = this.hashTargetName;
                hashTarget = temp;
                this.hashTargetName = tempName;
                hashTarget.clear();
                for (ID recordId : readStep.getIds(repository)) {
                    if (!probe.contains(recordId)) continue;
                    hashTarget.add(recordId);
                }
            }
            this.sortArea.dropCollection(probeName);
            return hashTarget;
        }

        @Override
        public void close() {
            super.close();
            if (this.sortArea != null) {
                this.sortArea.dropCollection(this.hashTargetName);
            }
        }
    }

    public static abstract class IntersectionRead<ID, REC>
    extends IndexRead<ID, REC> {
        protected ArrayList<IndexRead<ID, REC>> readSteps;

        public IntersectionRead(Iterable<IndexRead<ID, REC>> readSteps) {
            this.readSteps = Lists.newArrayList(readSteps);
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            int repoSize = repository.getSize();
            double repoReadRatio = 1.0;
            for (IndexRead<ID, REC> step : this.readSteps) {
                int readSize = step.estimateSize(repository);
                if (readSize >= repoSize) continue;
                double stepReadRatio = (double)readSize / (double)repoSize;
                repoReadRatio *= stepReadRatio;
            }
            return (int)Math.round((double)repoSize * repoReadRatio);
        }

        @Override
        public Predicate<REC> getPredicate() {
            ArrayList stepPredicates = Lists.newArrayList();
            for (IndexRead<ID, REC> readStep : this.readSteps) {
                stepPredicates.add(readStep.getPredicate());
            }
            return predicates.and(stepPredicates);
        }

        @Override
        public final String description() {
            return this.getName() + "(" + this.getFieldNames() + ")";
        }

        @Override
        public final String getFieldNames() {
            String names = "";
            boolean first = true;
            for (IndexRead<ID, REC> readStep : this.readSteps) {
                if (!first) {
                    names = names + ", ";
                } else {
                    first = false;
                }
                names = names + readStep.getFieldNames();
            }
            return names;
        }
    }

    public static class MonotonicRangeScan<ID, REC, T extends Comparable<T>>
    extends MonotonicScan<ID, REC, T> {
        private IdxRange<T> range;

        public MonotonicRangeScan(QueryMonotonicField<REC, T, ID> monotonicField, IdxRange<T> range) {
            super(monotonicField);
            this.range = range;
        }

        private int compareToRange(T value) {
            int comparison = this.range.compare(value);
            if (!this.monotonicField.isAscending()) {
                comparison = -comparison;
            }
            return comparison;
        }

        @Override
        protected Iterable<REC> scanForRecords(final QueryIndexableRepository<ID, REC> repository) {
            return new Iterable<REC>(){

                @Override
                public Iterator<REC> iterator() {
                    return new AbstractIterator<REC>(){
                        Iterator<REC> recordIter;
                        boolean foundFirstValue;
                        REC lastRecord;
                        boolean pastRange;
                        {
                            this.recordIter = repository.retrieveAll().iterator();
                            this.foundFirstValue = false;
                            this.lastRecord = null;
                            this.pastRange = false;
                            Object firstValue = monotonicField.getFirstValue();
                            if (firstValue != null) {
                                if (this.compareToRange(firstValue) > 0) {
                                    this.pastRange = true;
                                } else {
                                    Object lastValue = monotonicField.getLastValue();
                                    if (lastValue != null && this.compareToRange(lastValue) < 0) {
                                        this.pastRange = true;
                                    }
                                }
                            }
                        }

                        protected REC computeNext() {
                            while (!this.pastRange && this.recordIter.hasNext()) {
                                Object record = this.recordIter.next();
                                Object value = monotonicField.apply(record);
                                if (value == null) continue;
                                if (!this.foundFirstValue) {
                                    Object recordId = repository.getRecordId(record);
                                    monotonicField.setFirstValue(recordId, value);
                                    this.foundFirstValue = true;
                                }
                                this.lastRecord = record;
                                int comparison = this.compareToRange((Comparable)value);
                                if (comparison == 0) {
                                    return record;
                                }
                                if (comparison <= 0) continue;
                                this.pastRange = true;
                            }
                            if (this.lastRecord != null && !this.recordIter.hasNext()) {
                                Object recordId = repository.getRecordId(this.lastRecord);
                                Object lastValue = monotonicField.apply(this.lastRecord);
                                monotonicField.setLastValue(recordId, lastValue);
                            }
                            return this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            int estSize = repository.getSize() / 2;
            return estSize;
        }
    }

    public static class MonotonicValueScan<ID, REC, T extends Comparable<T>>
    extends MonotonicScan<ID, REC, T> {
        private List<T> fieldValues = Lists.newArrayList();
        private boolean fieldValuesAreOrdered = false;

        public MonotonicValueScan(QueryMonotonicField<REC, T, ID> monotonicField) {
            super(monotonicField);
        }

        public MonotonicValueScan(QueryMonotonicField<REC, T, ID> monotonicField, Collection<T> fieldValues) {
            super(monotonicField);
            this.fieldValues = Lists.newArrayList(fieldValues);
        }

        public void addFieldValue(T fieldValue) {
            this.fieldValues.add(fieldValue);
        }

        @Override
        public Iterable<REC> scanForRecords(final QueryIndexableRepository<ID, REC> repository) {
            if (this.fieldValues.isEmpty()) {
                return Collections.emptyList();
            }
            if (!this.fieldValuesAreOrdered) {
                Collections.sort(this.fieldValues);
                if (!this.monotonicField.isAscending()) {
                    Collections.reverse(this.fieldValues);
                }
                this.fieldValuesAreOrdered = true;
            }
            return new Iterable<REC>(){

                @Override
                public Iterator<REC> iterator() {
                    return new AbstractIterator<REC>(){
                        private final int fieldValueSize;
                        private int fieldValueIndex;
                        private T fieldValue;
                        private Iterator<REC> recordIter;
                        private boolean firstRecordFound;
                        private REC lastRecord;
                        {
                            this.fieldValueSize = fieldValues.size();
                            this.fieldValueIndex = 0;
                            this.fieldValue = (Comparable)fieldValues.get(this.fieldValueIndex);
                            this.recordIter = repository.retrieveAll().iterator();
                            this.firstRecordFound = monotonicField.getFirstValue() != null;
                            this.lastRecord = null;
                        }

                        protected REC computeNext() {
                            while (this.recordIter.hasNext()) {
                                Object record = this.recordIter.next();
                                Object recordValue = monotonicField.apply(record);
                                if (recordValue == null) continue;
                                if (!this.firstRecordFound) {
                                    monotonicField.setFirstValue(repository.getRecordId(record), recordValue);
                                    this.firstRecordFound = true;
                                }
                                this.lastRecord = record;
                                int comparison = monotonicField.compare(this.fieldValue, recordValue);
                                while (comparison < 0) {
                                    ++this.fieldValueIndex;
                                    if (this.fieldValueIndex < this.fieldValueSize) {
                                        this.fieldValue = (Comparable)fieldValues.get(this.fieldValueIndex);
                                        comparison = monotonicField.compare(this.fieldValue, recordValue);
                                        continue;
                                    }
                                    return this.endOfData();
                                }
                                if (comparison != 0) continue;
                                return record;
                            }
                            if (this.lastRecord != null) {
                                Object lastValue = monotonicField.apply(this.lastRecord);
                                monotonicField.setLastValue(repository.getRecordId(this.lastRecord), lastValue);
                            }
                            return this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            return this.fieldValues.size();
        }
    }

    public static abstract class MonotonicScan<ID, REC, T extends Comparable<T>>
    extends StepImpl<ID, REC> {
        protected QueryMonotonicField<REC, T, ID> monotonicField;
        private Predicate<REC> predicate;

        public MonotonicScan(QueryMonotonicField<REC, T, ID> monotonicField) {
            this.monotonicField = monotonicField;
        }

        @Override
        public Predicate<REC> getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate<REC> predicate) {
            this.predicate = predicate;
        }

        @Override
        public String description() {
            return this.getName() + "(" + this.monotonicField + ")";
        }

        protected abstract Iterable<REC> scanForRecords(QueryIndexableRepository<ID, REC> var1);

        protected abstract int estimateSize(QueryIndexableRepository<ID, REC> var1);

        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            Iterable<REC> records = this.scanForRecords(repository);
            Iterable rows = this.getResultSet().forRecords(records, repository);
            StepResult stepResult = new StepResult(repository, rows, this.estimateSize(repository));
            stepResult.setFullScan(false);
            return stepResult;
        }
    }

    public static class IndexDataRead<ID, REC, T>
    extends StepImpl<ID, REC> {
        IndexReadBase<ID, REC, T> indexRead;

        public IndexDataRead(IndexReadBase<ID, REC, T> indexRead) {
            this.indexRead = indexRead;
        }

        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            Iterable<Map.Entry<T, ID>> entries = this.indexRead.getEntries(repository);
            Iterable rows = this.getResultSet().forEntries(this.indexRead.field, entries);
            int estSize = this.indexRead.estimateSize(repository);
            StepResult stepResult = new StepResult(repository, rows, estSize);
            stepResult.setFullScan(false);
            return stepResult;
        }
    }

    public static class NonUniqueRangeRead<ID, REC, T extends Comparable<T>>
    extends IndexReadBase<ID, REC, T> {
        private final IdxRange<T> range;
        private final Comparator<ID> sorter;
        private double fetchRatio;

        public NonUniqueRangeRead(IdxField<REC, T> field, IdxRange<T> range, Comparator<ID> sorter, double fetchRatio) {
            super(field);
            this.range = range;
            this.sorter = sorter;
            this.fetchRatio = fetchRatio;
        }

        @Override
        public boolean hasOrderedIds() {
            return this.sorter != null;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            IdxNonUniqueIndex index = repository.getNonUniqueIndex(this.field);
            return index.getIds(this.range, this.sorter);
        }

        @Override
        protected Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> repository) {
            IdxNonUniqueIndex index = repository.getNonUniqueIndex(this.field);
            return index.getEntries(this.range, true);
        }

        @Override
        public int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            IdxIndex index = repository.getIndex(this.field);
            if (index == null) {
                if (!QueryPlanImpl.isUnitTest()) {
                    throw new QueryException("Could not find index for: " + this.field);
                }
                return super.estimateSize(repository);
            }
            int indexSize = index.getStats().getCardinality();
            int readSize = (int)((double)indexSize * this.fetchRatio);
            if (readSize <= 10000) {
                return super.estimateSize(repository);
            }
            return readSize;
        }
    }

    public static class NonUniqueIndexRead<ID, REC, T>
    extends IndexReadBase<ID, REC, T> {
        private final Comparator<ID> idSorter;

        public NonUniqueIndexRead(IdxField<REC, T> field, Comparator<ID> sorter) {
            super(field);
            this.idSorter = sorter;
        }

        @Override
        public boolean hasOrderedIds() {
            return this.idSorter != null;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            final IdxNonUniqueIndex index = repository.getNonUniqueIndex(this.field);
            if (this.idSorter != null) {
                ArrayList idIterables = Lists.newArrayList();
                for (Object indexKey : this.fieldValues) {
                    Iterable idIter = index.get(indexKey);
                    idIterables.add(idIter);
                }
                if (idIterables.isEmpty()) {
                    return Collections.emptyList();
                }
                if (idIterables.size() == 1) {
                    return (Iterable)idIterables.get(0);
                }
                return UtlSorted.merge(idIterables, this.idSorter);
            }
            return new Iterable<ID>(){

                @Override
                public Iterator<ID> iterator() {
                    return new Iterator<ID>(){
                        private Iterator<T> fieldValueIter;
                        private Iterator<ID> idIter;
                        {
                            this.fieldValueIter = fieldValues.iterator();
                            this.idIter = ImmutableSet.of().iterator();
                        }

                        private void locateIdIter() {
                            while (!this.idIter.hasNext() && this.fieldValueIter.hasNext()) {
                                Object fieldKey = this.fieldValueIter.next();
                                Iterable ids = index.get(fieldKey);
                                this.idIter = ids.iterator();
                            }
                        }

                        @Override
                        public boolean hasNext() {
                            this.locateIdIter();
                            return this.idIter.hasNext();
                        }

                        @Override
                        public ID next() {
                            this.locateIdIter();
                            return this.idIter.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        @Override
        protected Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> repository) {
            final IdxNonUniqueIndex index = repository.getNonUniqueIndex(this.field);
            return new Iterable<Map.Entry<T, ID>>(){
                private Iterator<T> fieldValueIter;
                {
                    this.fieldValueIter = fieldValues.iterator();
                }

                @Override
                public Iterator<Map.Entry<T, ID>> iterator() {
                    return new AbstractIterator<Map.Entry<T, ID>>(){
                        private T fieldValue = null;
                        private Iterator<ID> idIter = Lists.newArrayList().iterator();

                        protected Map.Entry<T, ID> computeNext() {
                            while (!this.idIter.hasNext() && fieldValueIter.hasNext()) {
                                this.fieldValue = fieldValueIter.next();
                                if (!index.containsKey(this.fieldValue)) continue;
                                Iterable ids = index.get(this.fieldValue);
                                this.idIter = ids.iterator();
                            }
                            if (this.fieldValue != null && this.idIter.hasNext()) {
                                Object id = this.idIter.next();
                                return new AbstractMap.SimpleEntry(this.fieldValue, id);
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            IdxNonUniqueIndex index = repository.getNonUniqueIndex(this.field);
            if (index == null) {
                if (!QueryPlanImpl.isUnitTest()) {
                    throw new QueryException("Could not find index for: " + this.field);
                }
                return super.estimateSize(repository);
            }
            IdxIndex.Stats stats = index.getStats();
            int keySize = stats.getKeyCardinality();
            int indexSize = stats.getCardinality();
            int valuesPerKey = indexSize == 0 ? 0 : indexSize / keySize;
            int estimatedSize = this.fieldValues.size() * valuesPerKey;
            if (estimatedSize <= 10000) {
                return super.estimateSize(repository);
            }
            return estimatedSize;
        }
    }

    public static class UniqueRangeRead<ID, REC, T extends Comparable<T>>
    extends IndexReadBase<ID, REC, T> {
        private final IdxRange<T> range;
        private final Comparator<ID> sorter;
        private double fetchRatio;

        public UniqueRangeRead(IdxField<REC, T> field, IdxRange<T> range, Comparator<ID> sorter, double fetchRatio) {
            super(field);
            this.range = range;
            this.sorter = sorter;
            this.fetchRatio = fetchRatio;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            IdxUniqueIndex index = repository.getUniqueIndex(this.field);
            return index.getIds(this.range, this.sorter);
        }

        @Override
        protected Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> repository) {
            IdxUniqueIndex index = repository.getUniqueIndex(this.field);
            return index.getEntries(this.range, true);
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            IdxUniqueIndex index = repository.getUniqueIndex(this.field);
            if (index == null) {
                if (!QueryPlanImpl.isUnitTest()) {
                    throw new QueryException("Could not find index for: " + this.field);
                }
                return super.estimateSize(repository);
            }
            int keySize = index.getStats().getKeyCardinality();
            int readSize = (int)((double)keySize * this.fetchRatio);
            if (readSize <= 10000) {
                return super.estimateSize(repository);
            }
            return readSize;
        }

        @Override
        public boolean hasOrderedIds() {
            return this.sorter != null;
        }
    }

    public static class UniqueIndexRead<ID, REC, T>
    extends IndexReadBase<ID, REC, T> {
        private final Comparator<ID> sorter;

        public UniqueIndexRead(IdxField<REC, T> field, Comparator<ID> sorter) {
            super(field);
            this.sorter = sorter;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            final IdxUniqueIndex index = repository.getUniqueIndex(this.field);
            if (this.sorter != null) {
                ArrayList ids = Lists.newArrayList();
                for (Object indexKey : this.fieldValues) {
                    Object id = index.getId(indexKey);
                    if (id == null) continue;
                    ids.add(id);
                }
                Collections.sort(ids, this.sorter);
                return ids;
            }
            return new Iterable<ID>(){

                @Override
                public Iterator<ID> iterator() {
                    return new AbstractIterator<ID>(){
                        private Iterator<T> fieldValueIter;
                        {
                            this.fieldValueIter = fieldValues.iterator();
                        }

                        protected ID computeNext() {
                            while (this.fieldValueIter.hasNext()) {
                                Object fieldValue = this.fieldValueIter.next();
                                Object id = index.getId(fieldValue);
                                if (id == null) continue;
                                return id;
                            }
                            return this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        protected Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> repository) {
            final IdxUniqueIndex index = repository.getUniqueIndex(this.field);
            return new Iterable<Map.Entry<T, ID>>(){

                @Override
                public Iterator<Map.Entry<T, ID>> iterator() {
                    return new AbstractIterator<Map.Entry<T, ID>>(){
                        private Iterator<T> fieldValueIter;
                        {
                            this.fieldValueIter = fieldValues.iterator();
                        }

                        protected Map.Entry<T, ID> computeNext() {
                            while (this.fieldValueIter.hasNext()) {
                                Object fieldValue = this.fieldValueIter.next();
                                if (!index.containsKey(fieldValue)) continue;
                                Object id = index.getId(fieldValue);
                                return new AbstractMap.SimpleEntry(fieldValue, id);
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }
            };
        }

        @Override
        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            if (this.fieldValues.size() <= 10000) {
                return super.estimateSize(repository);
            }
            return this.fieldValues.size();
        }

        @Override
        public boolean hasOrderedIds() {
            return this.sorter != null;
        }
    }

    public static class FullIndexRead<ID, REC, T>
    extends IndexReadBase<ID, REC, T> {
        private boolean ascending;

        public FullIndexRead(IdxField<REC, T> field, boolean ascending) {
            super(field);
            this.ascending = ascending;
        }

        @Override
        protected Iterable<ID> getIds(QueryIndexableRepository<ID, REC> repository) {
            IdxIndex index = repository.getIndex(this.field);
            return index.allIds(this.ascending);
        }

        @Override
        protected Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> repository) {
            IdxIndex index = repository.getIndex(this.field);
            return index.allEntries(this.ascending);
        }

        @Override
        public boolean hasOrderedIds() {
            return false;
        }
    }

    public static abstract class IndexReadBase<ID, REC, T>
    extends IndexRead<ID, REC> {
        protected QueryAbstractField<REC, T> field;
        protected List<T> fieldValues = Lists.newArrayList();

        public IndexReadBase(IdxField<REC, T> field) {
            this.field = (QueryAbstractField)field;
        }

        public void addFieldValue(T fieldValue) {
            this.fieldValues.add(fieldValue);
        }

        protected abstract Iterable<Map.Entry<T, ID>> getEntries(QueryIndexableRepository<ID, REC> var1);

        @Override
        public final String getFieldNames() {
            return this.field.getName();
        }

        @Override
        public final String description() {
            return this.getName() + "(" + this.getFieldNames() + ")";
        }
    }

    public static abstract class IndexRead<ID, REC>
    extends StepImpl<ID, REC>
    implements FilteringStep<REC> {
        private Predicate<REC> predicate = null;

        protected abstract Iterable<ID> getIds(QueryIndexableRepository<ID, REC> var1);

        public abstract boolean hasOrderedIds();

        @Override
        public Predicate<REC> getPredicate() {
            return this.predicate;
        }

        public void setPredicate(Predicate<REC> predicate) {
            this.predicate = predicate;
        }

        protected int estimateSize(QueryIndexableRepository<ID, REC> repository) {
            Iterable<ID> ids = this.getIds(repository);
            return Iterables.size(ids);
        }

        @Override
        public final StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            Iterable<ID> ids = this.getIds(repository);
            Iterable records = repository.retrieve(ids);
            Iterable rows = this.getResultSet().forRecords(records, repository);
            if (this.generateLatencies) {
                rows = QueryStatsImpl.timeIteration(rows, this.latencies);
            }
            int estimatedSize = this.estimateSize(repository);
            StepResult stepResult = new StepResult(repository, rows, estimatedSize);
            stepResult.setFullScan(false);
            return stepResult;
        }

        public abstract String getFieldNames();
    }

    public static class FullRead<ID, REC>
    extends StepImpl<ID, REC> {
        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            Iterable all = repository.retrieveAll();
            Iterable rows = this.getResultSet().forRecords(all, repository);
            if (this.generateLatencies) {
                rows = QueryStatsImpl.timeIteration(rows, this.latencies);
            }
            StepResult stepResult = new StepResult(repository, rows, repository.getSize());
            stepResult.setFullScan(true);
            return stepResult;
        }

        @Override
        public String description() {
            return this.getName();
        }
    }

    private static abstract class CachingStep<ID, REC>
    extends StepImpl<ID, REC> {
        protected StepCache cache = null;

        private CachingStep() {
        }

        protected abstract StepCache createCache(QueryIndexableRepository<ID, REC> var1, StepResult<ID, ?> var2);

        @Override
        public StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
            if (this.cache == null) {
                this.cache = this.createCache(repository, priorResult);
            }
            StepResult stepResult = new StepResult(repository, this.cache, this.cache.getEstimatedSize());
            stepResult.setFullScan(((StepResult)priorResult).fullScan);
            return stepResult;
        }

        @Override
        public final void close() {
            this.cache.close();
        }

        protected abstract class StepCache
        implements Iterable<QueryResultSet.Row<REC>> {
            protected final QuerySortArea<REC> sortArea;
            protected String backingCollectionId;

            public StepCache(QueryIndexableRepository<ID, REC> repository, StepResult<ID, ?> priorResult) {
                this.sortArea = CachingStep.this.getResultSet().getSortArea();
                this.backingCollectionId = this.cachePriorResult(repository, priorResult);
            }

            public abstract String cachePriorResult(QueryIndexableRepository<ID, REC> var1, StepResult<ID, ?> var2);

            public abstract int getEstimatedSize();

            public final void close() {
                if (this.backingCollectionId != null) {
                    this.sortArea.dropCollection(this.backingCollectionId);
                }
            }
        }
    }

    public static abstract class StepImpl<ID, REC>
    implements QueryPlan.Step {
        protected QueryStatsImpl.DeltaLatencies latencies = new QueryStatsImpl.DeltaLatencies(this.getName());
        protected boolean generateLatencies;
        private QueryResultSetImpl<ID, REC> resultSet = null;

        @Override
        public String getName() {
            return this.getClass().getSimpleName();
        }

        @Override
        public String description() {
            return this.getName();
        }

        public Predicate<REC> getPredicate() {
            return predicates.alwaysTrue();
        }

        public abstract StepResult<ID, REC> getResult(QueryIndexableRepository<ID, REC> var1, StepResult<ID, ?> var2);

        public void associateResultSet(QueryResultSetImpl<ID, REC> resultSet) {
            this.resultSet = resultSet;
        }

        public void setGenerateLatencies(boolean generateLatencies) {
            this.generateLatencies = generateLatencies;
        }

        protected QueryResultSetImpl<ID, REC> getResultSet() {
            if (this.resultSet == null) {
                throw new QueryException("There is no result set associated with this Step.");
            }
            return this.resultSet;
        }

        @Override
        public final QueryStatsImpl.DeltaLatencies getLatencies() {
            return this.latencies;
        }

        public void close() {
        }

        public String toString() {
            return this.description();
        }
    }

    public static interface FilteringStep<REC>
    extends QueryPlan.Step {
        public Predicate<REC> getPredicate();
    }

    public static class StepResult<ID, REC> {
        private QueryIndexableRepository<ID, REC> repo;
        private Iterable<QueryResultSet.Row<REC>> records;
        private int estimatedSize;
        private boolean fullScan = false;

        private StepResult(QueryIndexableRepository<ID, REC> repo, Iterable<QueryResultSet.Row<REC>> records, int estimatedSize) {
            this.repo = repo;
            this.records = records;
            this.estimatedSize = estimatedSize;
        }

        public void setFullScan(boolean fullScan) {
            this.fullScan = fullScan;
        }

        public PlanQueryResult<REC> getQueryResult() {
            QueryResultImpl<ID, REC> queryResult = new QueryResultImpl<ID, REC>(this.repo, this.records, this.estimatedSize);
            queryResult.setFullScan(this.fullScan);
            return queryResult;
        }
    }

    public static interface PlanQueryResult<REC>
    extends QueryResult<REC> {
        public void setRepositoryAlias(String var1);

        public void setPlan(QueryPlan var1);
    }

    public static final class RowPredicate<REC>
    implements com.google.common.base.Predicate<QueryResultSet.Row<REC>> {
        private final Predicate<REC> basePredicate;

        public RowPredicate(Predicate<REC> predicate) {
            this.basePredicate = predicate;
        }

        public Predicate<REC> getRecordPredicate() {
            return this.basePredicate;
        }

        private boolean apply(Predicate<REC> predicate, QueryResultSet.Row<REC> row) {
            REC record = row.getRecord();
            if (record != null) {
                return predicate.apply(record);
            }
            if (predicate instanceof IdxFieldPredicate) {
                IdxFieldPredicate fieldPredicate = (IdxFieldPredicate)predicate;
                IdxField field = fieldPredicate.getField();
                Object value = row.getValue(field);
                return fieldPredicate.applyToSubject(value);
            }
            if (predicate instanceof PredicatesImpl.And) {
                PredicatesImpl.And and = (PredicatesImpl.And)predicate;
                for (Predicate child : and.getChildPredicates()) {
                    if (this.apply(child, row)) continue;
                    return false;
                }
                return true;
            }
            if (predicate instanceof PredicatesImpl.Or) {
                PredicatesImpl.Or or = (PredicatesImpl.Or)predicate;
                for (Predicate child : or.getChildPredicates()) {
                    if (!this.apply(child, row)) continue;
                    return true;
                }
                return false;
            }
            if (predicate instanceof PredicatesImpl.Not) {
                PredicatesImpl.Not not = (PredicatesImpl.Not)predicate;
                Predicate child = not.getChildPredicates().get(0);
                return !this.apply(child, row);
            }
            throw new QueryException("Unable to resolve field for predicate: " + this.basePredicate.getClass().getSimpleName());
        }

        public final boolean apply(QueryResultSet.Row<REC> row) {
            return this.apply(this.basePredicate, row);
        }

        public String toString() {
            return this.basePredicate.toString();
        }
    }
}

