/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt.types;

import com.neeve.pkt.PktBodyVariable;
import java.util.Properties;

public abstract class PktBodyOdsMemberConnectRequestReply
extends PktBodyVariable {
    private int ROLE_POS;
    private int MEMBERNAMELEN_POS;
    private int MEMBERNAME_POS;
    private short memberNameLen;
    private byte[] memberName;

    protected PktBodyOdsMemberConnectRequestReply(int type, Properties props) {
        super(type);
    }

    private final void updateFieldOffsets() {
        this.ROLE_POS = 0;
        this.MEMBERNAMELEN_POS = this.ROLE_POS + 1;
        this.MEMBERNAME_POS = this.MEMBERNAMELEN_POS + 2;
    }

    private final void initMemberNameFromBuffer(boolean onlyOffset) {
        if (this.memberName == null) {
            this.memberNameLen = this.buffer.getShort(this.MEMBERNAMELEN_POS);
            if (!onlyOffset) {
                if (this.memberNameLen == 0) {
                    this.memberName = null;
                } else {
                    this.memberName = new byte[this.memberNameLen];
                    this.buffer.getTo(this.MEMBERNAME_POS, this.memberName, 0, (int)this.memberNameLen);
                }
            }
        }
    }

    public final void initialize() {
        this.updateFieldOffsets();
    }

    public final int doGetSerializedLength() {
        return 3 + this.memberNameLen;
    }

    public final void doDesync(int len) {
        this.initMemberNameFromBuffer(true);
    }

    public final void setRole(Role role) {
        this.buffer.put(this.ROLE_POS, role.serialize());
    }

    public final Role getRole() {
        return Role.deserialize(this.buffer.get(this.ROLE_POS));
    }

    public final void setMemberName(String memberName) {
        if (memberName == null) {
            this.memberName = null;
            this.memberNameLen = 0;
        } else {
            try {
                this.memberName = memberName.getBytes("UTF-8");
                this.memberNameLen = (short)this.memberName.length;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateFieldOffsets();
        this.buffer.putShort(this.MEMBERNAMELEN_POS, this.memberNameLen);
        if (this.memberName != null) {
            this.buffer.putFrom(this.MEMBERNAME_POS, this.memberName, 0, (int)this.memberNameLen);
        }
    }

    public final String getMemberName() {
        if (this.memberName == null) {
            this.initMemberNameFromBuffer(false);
        }
        if (this.memberName == null) {
            return null;
        }
        try {
            return new String(this.memberName, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return "<member=" + this.getMemberName() + ", role=" + (Object)((Object)this.getRole()) + ">";
    }

    public static enum Role {
        Primary(1),
        Backup(2);

        private int val;

        private Role(int val) {
            this.val = val;
        }

        final byte serialize() {
            return (byte)this.val;
        }

        static final Role deserialize(byte val) {
            switch (val) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Primary;
                }
                case 2: {
                    return Backup;
                }
            }
            return null;
        }
    }
}

