/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.equinix.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.cloud.equinix.messages.INetwork;
import com.neeve.cloud.equinix.messages.MessageFactory;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.IXStringFactory;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.lang.XStringDeserializer;
import com.neeve.lang.XStringIterator;
import com.neeve.lang.XStringSequence;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.quark.IQuarkChildSerializationCompletionCallback;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.rog.impl.RogNonTransactionalField;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="quark", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 594)", date="1/8/26 7:24 PM", buildInfo="nvx-rumi-cloud-2.0.56 (Rumi ADM Maven Plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=1000)
@JsonPropertyOrder(value={"id", "description", "vxlan", "tags"})
public final class Network
implements INetwork,
MessageReflector,
IdxMappable,
UtlPool.Item<Network>,
AdmRuntime.BufferSizer {
    private static final RogNonTransactionalField<Network, String> _idReflector = new RogNonTransactionalField<Network, String>("id", Network.class, "id", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<IdDeserializer> _fieldDeserializer = new ThreadLocal();

        private final IdDeserializer getFieldDeserializer() {
            IdDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new IdDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.hasId();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                IdDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.getIdUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(Network node, String value) {
            if (value == null) {
                node.clearId();
            } else {
                node.setId(value);
            }
        }

        public final boolean hasValue(Network node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(Network node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(Network node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<Network, String> _descriptionReflector = new RogNonTransactionalField<Network, String>("description", Network.class, "description", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<DescriptionDeserializer> _fieldDeserializer = new ThreadLocal();

        private final DescriptionDeserializer getFieldDeserializer() {
            DescriptionDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new DescriptionDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.hasDescription();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                DescriptionDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.getDescriptionUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(Network node, String value) {
            if (value == null) {
                node.clearDescription();
            } else {
                node.setDescription(value);
            }
        }

        public final boolean hasValue(Network node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(Network node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(Network node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<Network, String> _vxlanReflector = new RogNonTransactionalField<Network, String>("vxlan", Network.class, "vxlan", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<VxlanDeserializer> _fieldDeserializer = new ThreadLocal();

        private final VxlanDeserializer getFieldDeserializer() {
            VxlanDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new VxlanDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.hasVxlan();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                VxlanDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(Network node) {
            if (node.hasPojo()) {
                return node.getVxlanUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(Network node, String value) {
            if (value == null) {
                node.clearVxlan();
            } else {
                node.setVxlan(value);
            }
        }

        public final boolean hasValue(Network node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(Network node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(Network node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final HashMap<String, IRogFieldReflector<Network, ?>> _fieldReflectors = new HashMap(3);
    private static final boolean _conserveMemory;
    private static final boolean _freeBackingStorageOnClear;
    private static final MemoryStats _memstats;
    private static final NetworkPoolFactory _networkFactory;
    private static final NetworkPojoPoolFactory _networkPojoFactory;
    private static final NetworkSerializerPoolFactory _networkSerializerFactory;
    private static final NetworkDeserializerPoolFactory _networkDeserializerFactory;
    static final UtlPool<Network> _entityPool;
    static final UtlPool<Pojo> _entityPojoPool;
    static final UtlPool<Serializer> _entitySerializerPool;
    static final UtlPool<Deserializer> _entityDeserializerPool;
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<Network> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final Network[] EMPTY_ARRAY;

    Network() {
    }

    public static Network create() {
        Network entity = (Network)_entityPool.get(null);
        _memstats.onEntityAllocated(Network.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 3);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(Network.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers, boolean freeBackingStorage) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this._pojo.clear(freeBackingStorage);
                this.disposePojo(false);
            } else {
                this._pojo.reset(freeBackingStorage);
            }
        }
        if (freeBackingStorage || disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear(boolean disposeMembers) {
        this.clear(disposeMembers, _freeBackingStorageOnClear);
    }

    public final void clear() {
        this.clear(_conserveMemory, _freeBackingStorageOnClear);
    }

    public final void reset(boolean disposeMembers, boolean freeBackingStorage) {
        this.clear(disposeMembers, freeBackingStorage);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset(boolean disposeMembers) {
        this.reset(disposeMembers, _conserveMemory);
    }

    public final void reset() {
        this.reset(_conserveMemory, _conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final Network deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Network deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final Network deserializeFrom(Network val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final Network wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final Network deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final Network deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final Network deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final Network deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final Network deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final Network deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final Network deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final Network deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            Network network = this.deserializeFrom(buffer, 0, buffer.getLength());
            return network;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final Network deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    public final Network deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(Network copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final Network copy() {
        Network copy = Network.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<Network, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<Network, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<Network, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getIdFieldId() {
        return 1;
    }

    @Override
    @JsonProperty(value="id")
    public final void setId(String val) {
        this.pojo().setIdFrom(val);
    }

    @Override
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getId() {
        if (!this.hasId()) {
            return null;
        }
        return this.pojo()._usrId.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendId(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setIdFrom(long val) {
        this.pojo().setIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getIdTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setIdFrom(XString val) {
        this.pojo().setIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getIdTo(XString val) {
        this.pojo().getIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getIdUnsafe() {
        return this.pojo().getId();
    }

    @Override
    public final boolean hasId() {
        return this.pojo().hasId();
    }

    @Override
    public final void clearId() {
        this.pojo().clearId();
    }

    public static final int getDescriptionFieldId() {
        return 2;
    }

    @Override
    @JsonProperty(value="description")
    public final void setDescription(String val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getDescription() {
        if (!this.hasDescription()) {
            return null;
        }
        return this.pojo()._usrDescription.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendDescription(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setDescription(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setDescriptionFrom(long val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getDescriptionTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getDescriptionTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setDescriptionFrom(XString val) {
        this.pojo().setDescriptionFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getDescriptionTo(XString val) {
        this.pojo().getDescriptionTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getDescriptionUnsafe() {
        return this.pojo().getDescription();
    }

    @Override
    public final boolean hasDescription() {
        return this.pojo().hasDescription();
    }

    @Override
    public final void clearDescription() {
        this.pojo().clearDescription();
    }

    public static final int getVxlanFieldId() {
        return 3;
    }

    @Override
    @JsonProperty(value="vxlan")
    public final void setVxlan(String val) {
        this.pojo().setVxlanFrom(val);
    }

    @Override
    @JsonProperty(value="vxlan")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getVxlan() {
        if (!this.hasVxlan()) {
            return null;
        }
        return this.pojo()._usrVxlan.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendVxlan(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setVxlan(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setVxlanFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setVxlanFrom(long val) {
        this.pojo().setVxlanFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getVxlanTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getVxlanTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setVxlanFrom(XString val) {
        this.pojo().setVxlanFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getVxlanTo(XString val) {
        this.pojo().getVxlanTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getVxlanUnsafe() {
        return this.pojo().getVxlan();
    }

    @Override
    public final boolean hasVxlan() {
        return this.pojo().hasVxlan();
    }

    @Override
    public final void clearVxlan() {
        this.pojo().clearVxlan();
    }

    public static final int getTagsFieldId() {
        return 4;
    }

    @Override
    @JsonProperty(value="tags")
    public final void setTags(String[] val) {
        this.pojo().clearTags();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToTags(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setTagsFrom(XIterator<String> val) {
        this.pojo().clearTags();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                String v = (String)val.next();
                if (v == null) continue;
                this.pojo().addToTags(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void addTags(String val) {
        this.pojo().addToTags(val);
    }

    @Override
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final String[] getTags() {
        XStringIterator iterator = this.pojo().getTagsIterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.size() > 0 ? list.toArray(new String[list.size()]) : null;
    }

    @Override
    public final String[] getTagsEmptyIfNull() {
        String[] val = this.getTags();
        return val != null ? val : AdmRuntime.EMPTY_STRING_ARRAY;
    }

    @Override
    @JsonIgnore
    public final XStringIterator getTagsIterator() {
        return this.pojo().getTagsIterator();
    }

    @Override
    public final void clearTags() {
        this.pojo().clearTags();
    }

    public static final <T> IRogFieldReflector<Network, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return Network.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<Network, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<Network, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final Network init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final Network setPool(UtlPool<Network> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<Network> getPool() {
        return this._pool;
    }

    public final Network acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose(boolean freeBackingStorage) {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            if (freeBackingStorage) {
                this.clear(true);
            }
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final void dispose() {
        this.dispose(false);
    }

    public final Object clone() {
        String[] cloner_tags;
        Network clonee = Network.create();
        if (this.hasId()) {
            clonee.setId(this.getId());
        }
        if (this.hasDescription()) {
            clonee.setDescription(this.getDescription());
        }
        if (this.hasVxlan()) {
            clonee.setVxlan(this.getVxlan());
        }
        if ((cloner_tags = this.getTags()) != null) {
            clonee.setTags((String[])cloner_tags.clone());
        } else {
            clonee.clearTags();
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasId()) {
            builder.append(0 == c++ ? "" : ",").append("Id=").append(this.getId());
        }
        if (this.hasDescription()) {
            builder.append(0 == c++ ? "" : ",").append("Description=").append(this.getDescription());
        }
        if (this.hasVxlan()) {
            builder.append(0 == c++ ? "" : ",").append("Vxlan=").append(this.getVxlan());
        }
        builder.append(0 == c++ ? "" : ",").append("Tags=").append(Arrays.toString(this.getTags()));
        builder.append("}");
        return builder.toString();
    }

    static {
        _fieldReflectors.put("Id", (IRogFieldReflector<Network, ?>)_idReflector);
        _fieldReflectors.put("id", (IRogFieldReflector<Network, ?>)_idReflector);
        _fieldReflectors.put("Description", (IRogFieldReflector<Network, ?>)_descriptionReflector);
        _fieldReflectors.put("description", (IRogFieldReflector<Network, ?>)_descriptionReflector);
        _fieldReflectors.put("Vxlan", (IRogFieldReflector<Network, ?>)_vxlanReflector);
        _fieldReflectors.put("vxlan", (IRogFieldReflector<Network, ?>)_vxlanReflector);
        _conserveMemory = Config.conserveMemory();
        _freeBackingStorageOnClear = Config.getValue((String)("nv.tuning.memory." + Network.class.getName() + ".freeBackingStorageOnClear"), (boolean)Config.getValue((String)"nv.tuning.memory.freeBackingStorageOnClear", (boolean)_conserveMemory));
        _memstats = MemoryStats.getInstance();
        _networkFactory = new NetworkPoolFactory();
        _networkPojoFactory = new NetworkPojoPoolFactory();
        _networkSerializerFactory = new NetworkSerializerPoolFactory();
        _networkDeserializerFactory = new NetworkDeserializerPoolFactory();
        _entityPool = UtlPool.create((String)"quark.entity", (String)"NetworkQuarkEntity.1.1000", (UtlPool.Factory)_networkFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Network.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new NetworkPoolEvictedItemReceiver());
        _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"NetworkQuarkEntityPojo.1.1000", (UtlPool.Factory)_networkPojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new NetworkPojoPoolEvictedItemReceiver());
        _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"NetworkQuarkEntitySerializer.1.1000", (UtlPool.Factory)_networkSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new NetworkSerializerPoolEvictedItemReceiver());
        _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"NetworkQuarkEntityDeserializer.1.1000", (UtlPool.Factory)_networkDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new NetworkDeserializerPoolEvictedItemReceiver());
        EMPTY_ARRAY = new Network[0];
    }

    private static final class VxlanDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private VxlanDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleVxlan(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class DescriptionDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private DescriptionDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleDescription(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class IdDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private IdDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleId(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private int _serializedLength;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private XString _usrId = XString.create();
        private XString _usrDescription = XString.create();
        private XString _usrVxlan = XString.create();
        private final XStringSequence _tagsDeserializer = XStringSequence.create();
        private IOBuffer _usrTagsSerialized;
        private int _usrTagsSerializedLen;

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(Network.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasId() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final XString getId() {
            if (!this.hasId() || this._usrId.isNull()) {
                return null;
            }
            return this._usrId;
        }

        public final void getIdTo(XString val) {
            if (!this.hasId() || this._usrId.isNull()) {
                val.clear();
                return;
            }
            this._usrId.getTo(val);
        }

        public final void setIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearId();
                return;
            }
            int nbytes1 = this._usrId.serializedLength();
            this._usrId.setFrom(val);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearId();
                return;
            }
            int nbytes1 = this._usrId.serializedLength();
            this._usrId.setFrom(val);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrId.serializedLength();
            this._usrId.setFrom(val);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearId();
                return;
            }
            int nbytes1 = this._usrId.serializedLength();
            this._usrId.setFrom(val, offset, len);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearId();
                return;
            }
            int nbytes1 = this._usrId.serializedLength();
            this._usrId.setFrom(val);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setIdFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearId();
                return;
            }
            int nbytes1 = this._usrId.serializedLength();
            val.getTo(this._usrId);
            int nbytes2 = this._usrId.serializedLength();
            if (this.hasId()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void clearId(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasId()) {
                return;
            }
            this._serializedLength -= this._usrId.serializedLength() + 6;
            this._usrId.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final void clearId() {
            this.clearId(false);
        }

        public final boolean hasDescription() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final XString getDescription() {
            if (!this.hasDescription() || this._usrDescription.isNull()) {
                return null;
            }
            return this._usrDescription;
        }

        public final void getDescriptionTo(XString val) {
            if (!this.hasDescription() || this._usrDescription.isNull()) {
                val.clear();
                return;
            }
            this._usrDescription.getTo(val);
        }

        public final void setDescriptionFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val, offset, len);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            this._usrDescription.setFrom(val);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setDescriptionFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearDescription();
                return;
            }
            int nbytes1 = this._usrDescription.serializedLength();
            val.getTo(this._usrDescription);
            int nbytes2 = this._usrDescription.serializedLength();
            if (this.hasDescription()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void clearDescription(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasDescription()) {
                return;
            }
            this._serializedLength -= this._usrDescription.serializedLength() + 6;
            this._usrDescription.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final void clearDescription() {
            this.clearDescription(false);
        }

        public final boolean hasVxlan() {
            return (this._fieldBitmask[0] & 4L) != 0L;
        }

        public final XString getVxlan() {
            if (!this.hasVxlan() || this._usrVxlan.isNull()) {
                return null;
            }
            return this._usrVxlan;
        }

        public final void getVxlanTo(XString val) {
            if (!this.hasVxlan() || this._usrVxlan.isNull()) {
                val.clear();
                return;
            }
            this._usrVxlan.getTo(val);
        }

        public final void setVxlanFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVxlan();
                return;
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            this._usrVxlan.setFrom(val);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setVxlanFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVxlan();
                return;
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            this._usrVxlan.setFrom(val);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setVxlanFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            this._usrVxlan.setFrom(val);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setVxlanFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVxlan();
                return;
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            this._usrVxlan.setFrom(val, offset, len);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setVxlanFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearVxlan();
                return;
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            this._usrVxlan.setFrom(val);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void setVxlanFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVxlan();
                return;
            }
            int nbytes1 = this._usrVxlan.serializedLength();
            val.getTo(this._usrVxlan);
            int nbytes2 = this._usrVxlan.serializedLength();
            if (this.hasVxlan()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            }
            this._dirty = true;
        }

        public final void clearVxlan(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasVxlan()) {
                return;
            }
            this._serializedLength -= this._usrVxlan.serializedLength() + 6;
            this._usrVxlan.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
            this._dirty = true;
        }

        public final void clearVxlan() {
            this.clearVxlan(false);
        }

        public final XStringSequence getTagsDeserializer() {
            if (this._usrTagsSerialized != null) {
                this._tagsDeserializer.wrap(this._usrTagsSerialized, 0, this._usrTagsSerializedLen);
            } else {
                this._tagsDeserializer.wrap(0L, 0, 0);
            }
            return this._tagsDeserializer;
        }

        public final XStringIterator getTagsIterator() {
            if (this._usrTagsSerialized != null) {
                this._tagsDeserializer.wrap(this._usrTagsSerialized, 0, this._usrTagsSerializedLen);
            } else {
                this._tagsDeserializer.wrap(0L, 0, 0);
            }
            return this._tagsDeserializer.iterator();
        }

        public final void addToTags(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                return;
            }
            int serializedLength = 2 + val.length();
            this._usrTagsSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrTagsSerialized, (int)(this._usrTagsSerializedLen + serializedLength), (boolean)true);
            IOBuffer.putShort((long)this._usrTagsSerialized.getNativeAddress(), (int)this._usrTagsSerializedLen, (short)((short)val.length()));
            val.getTo(this._usrTagsSerialized.getNativeAddress(), this._usrTagsSerializedLen + 2);
            this._serializedLength += this._usrTagsSerializedLen > 0 ? serializedLength : 6 + serializedLength;
            this._usrTagsSerializedLen += serializedLength;
            this._dirty = true;
        }

        public final void addToTags(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            int serializedLength = 2 + val.length();
            this._usrTagsSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrTagsSerialized, (int)(this._usrTagsSerializedLen + serializedLength), (boolean)true);
            IOBuffer.putShort((long)this._usrTagsSerialized.getNativeAddress(), (int)this._usrTagsSerializedLen, (short)((short)val.length()));
            IOBuffer.putASCIICharSequence((long)this._usrTagsSerialized.getNativeAddress(), (int)(this._usrTagsSerializedLen + 2), (CharSequence)val, (int)0, (int)val.length());
            this._serializedLength += this._usrTagsSerializedLen > 0 ? serializedLength : 6 + serializedLength;
            this._usrTagsSerializedLen += serializedLength;
            this._dirty = true;
        }

        public final void addToTagsFrom(XStringDeserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            int serializedLength = 2 + deserializer.serializedLength();
            this._usrTagsSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrTagsSerialized, (int)(this._usrTagsSerializedLen + serializedLength), (boolean)true);
            IOBuffer.putShort((long)this._usrTagsSerialized.getNativeAddress(), (int)this._usrTagsSerializedLen, (short)((short)deserializer.serializedLength()));
            int len = deserializer.getTo(this._usrTagsSerialized, this._usrTagsSerializedLen + 2);
            this._serializedLength += this._usrTagsSerializedLen > 0 ? len : len + 6;
            this._usrTagsSerializedLen += serializedLength;
            this._dirty = true;
        }

        public final void addToTagsFrom(XStringSequence deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            this._usrTagsSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrTagsSerialized, (int)(this._usrTagsSerializedLen + deserializer.serializedLength()), (boolean)true);
            int len = deserializer.getTo(this._usrTagsSerialized, this._usrTagsSerializedLen);
            this._serializedLength += this._usrTagsSerializedLen > 0 ? len : len + 6;
            this._usrTagsSerializedLen += len;
            this._dirty = true;
        }

        public final void setTagsFrom(XStringSequence deserializer) {
            this.clearTags();
            this.addToTagsFrom(deserializer);
        }

        public final void addToTagsFrom(XStringIterator iterator) {
            if (iterator == null) {
                return;
            }
            if (iterator instanceof XStringSequence) {
                this.addToTagsFrom((XStringSequence)iterator);
            } else {
                iterator.toFirst();
                while (iterator.hasNext()) {
                    this.addToTags((String)iterator.next());
                }
            }
        }

        public final void setTagsFrom(XStringIterator iterator) {
            this.clearTags();
            this.addToTagsFrom(iterator);
        }

        public final void addToTagsFrom(XString[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.length == 0) {
                return;
            }
            for (int i = offset; i < offset + len; ++i) {
                this.addToTags(val[i]);
            }
        }

        public final void setTagsFrom(XString[] val, int offset, int len) {
            this.clearTags();
            this.addToTagsFrom(val, offset, len);
        }

        public final void addToTagsFrom(String[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.length == 0) {
                return;
            }
            for (int i = offset; i < offset + len; ++i) {
                this.addToTags(val[i]);
            }
        }

        public final void setTagsFrom(String[] val, int offset, int len) {
            this.clearTags();
            this.addToTagsFrom(val, offset, len);
        }

        public final void clearTags(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrTagsSerializedLen == 0) {
                return;
            }
            this._serializedLength -= this._usrTagsSerializedLen + 6;
            this._usrTagsSerializedLen = 0;
            if (freeBackingStorage && this._usrTagsSerialized != null) {
                this._usrTagsSerialized.dispose();
                this._usrTagsSerialized = null;
            }
            this._dirty = true;
        }

        public final void clearTags() {
            this.clearTags(false);
        }

        public final void clear(boolean freeBackingStorage) {
            this._readonly = false;
            if (freeBackingStorage) {
                this.clearId(true);
            }
            if (freeBackingStorage) {
                this.clearDescription(true);
            }
            if (freeBackingStorage) {
                this.clearVxlan(true);
            }
            if (freeBackingStorage) {
                this.clearTags(true);
            } else {
                this._usrTagsSerializedLen = 0;
            }
            this._fieldBitmask[0] = 0L;
            this._serializedLength = 0;
            this._dirty = true;
        }

        public final void clear() {
            this.clear(_freeBackingStorageOnClear);
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = this._serializedLength;
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasId()) {
                serializer.id(this._usrId);
            }
            if (this.hasDescription()) {
                serializer.description(this._usrDescription);
            }
            if (this.hasVxlan()) {
                serializer.vxlan(this._usrVxlan);
            }
            if (this._usrTagsSerializedLen > 0) {
                serializer.tags(this._usrTagsSerialized, 0, this._usrTagsSerializedLen);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset(boolean freeBackingStorage) {
            this.clear(freeBackingStorage);
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo reset() {
            return this.reset(_conserveMemory);
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleId(XStringDeserializer val) {
                Pojo.this.setIdFrom(val);
            }

            @Override
            public final void handleDescription(XStringDeserializer val) {
                Pojo.this.setDescriptionFrom(val);
            }

            @Override
            public final void handleVxlan(XStringDeserializer val) {
                Pojo.this.setVxlanFrom(val);
            }

            @Override
            public final void handleTags(XStringSequence val) {
                Pojo.this.setTagsFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final XStringDeserializer _stringDeserializer = XStringDeserializer.create();
        private final XStringSequence _stringArrayDeserializer = XStringSequence.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(Network.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block13: for (int pos = this._offset; !this._stopped && pos < lim; pos += 2 + flen) {
                switch ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3) {
                    case 1: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleId(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block13;
                    }
                    case 2: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleDescription(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block13;
                    }
                    case 3: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleVxlan(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block13;
                    }
                    case 4: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleTags(this._stringArrayDeserializer.wrap(addr, pos + 6, flen));
                        flen += 4;
                        continue block13;
                    }
                    default: {
                        switch (IOBuffer.getShort((long)addr, (int)pos) & 3) {
                            case 0: {
                                flen = 4 + IOBuffer.getInt((long)addr, (int)(pos + 2));
                                continue block13;
                            }
                            case 1: {
                                flen = 1;
                                continue block13;
                            }
                            case 2: {
                                flen = 2;
                                continue block13;
                            }
                            case 3: {
                                flen = 4;
                                continue block13;
                            }
                            case 4: {
                                flen = 8;
                                continue block13;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleId(XStringDeserializer val) {
            }

            @Override
            public void handleDescription(XStringDeserializer val) {
            }

            @Override
            public void handleVxlan(XStringDeserializer val) {
            }

            @Override
            public void handleTags(XStringSequence val) {
            }
        }

        public static interface Callback {
            public void handleId(XStringDeserializer var1);

            public void handleDescription(XStringDeserializer var1);

            public void handleVxlan(XStringDeserializer var1);

            public void handleTags(XStringSequence var1);
        }
    }

    public static final class Serializer
    implements IQuarkChildSerializationCompletionCallback,
    UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private Network _entity;
        private IQuarkChildSerializationCompletionCallback _parent;
        private int _mark;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(Network.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        public final Serializer init(long addr, int len, IQuarkChildSerializationCompletionCallback parent) {
            this._entity = null;
            this._parent = parent;
            this._mark = -1;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), len, parent);
        }

        public final Serializer init(IOBuffer buffer, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), 0, parent);
        }

        final Serializer init(Network entity) {
            this.init(entity.getSerializedBuffer(), 0, null);
            this._entity = entity;
            return this;
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer id(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer id(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer id(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer id(byte[] val) {
            return this.id(val, 0, val.length);
        }

        public final Serializer id(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer id(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)8);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer description(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer description(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer description(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer description(byte[] val) {
            return this.description(val, 0, val.length);
        }

        public final Serializer description(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer description(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer vxlan(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer vxlan(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer vxlan(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer vxlan(byte[] val) {
            return this.vxlan(val, 0, val.length);
        }

        public final Serializer vxlan(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer vxlan(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer tags(XString[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            int serializedLengthPos = this._len;
            this._len += 4;
            for (int i = offset; i < len; ++i) {
                short valSerializedLength = (short)val[i].serializedLength();
                if (this.hasSizer()) {
                    this.ensureCapacity(this._len + 2 + valSerializedLength);
                }
                IOBuffer.putShort((long)this._addr, (int)this._len, (short)valSerializedLength);
                this._len += 2;
                val[i].getTo(this._addr, this._len);
                this._len += valSerializedLength;
            }
            IOBuffer.putInt((long)this._addr, (int)serializedLengthPos, (int)(this._len - (serializedLengthPos + 4)));
            return this;
        }

        public final Serializer tags(String[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            int serializedLengthPos = this._len;
            this._len += 4;
            for (int i = offset; i < len; ++i) {
                short valSerializedLength = (short)val[i].length();
                if (this.hasSizer()) {
                    this.ensureCapacity(this._len + 2 + valSerializedLength);
                }
                IOBuffer.putShort((long)this._addr, (int)this._len, (short)valSerializedLength);
                this._len += 2;
                IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val[i], (int)0, (int)valSerializedLength);
                this._len += valSerializedLength;
            }
            IOBuffer.putInt((long)this._addr, (int)serializedLengthPos, (int)(this._len - (serializedLengthPos + 4)));
            return this;
        }

        public final Serializer tags(String[] val) {
            if (val == null) {
                return this;
            }
            return this.tags(val, 0, val.length);
        }

        public final Serializer tags(XStringIterator val) {
            if (val instanceof XStringSequence) {
                return this.tags((XStringSequence)val);
            }
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            int serializedLengthPos = this._len;
            this._len += 4;
            while (val.hasNext()) {
                if (this.hasSizer()) {
                    this.ensureCapacity(this._len + 2 + val.nextLength(false));
                }
                int stringLengthPos = this._len;
                this._len += 2;
                short stringLength = val.nextInto(this._addr, this._len);
                this._len += stringLength;
                IOBuffer.putShort((long)this._addr, (int)stringLengthPos, (short)stringLength);
            }
            IOBuffer.putInt((long)this._addr, (int)serializedLengthPos, (int)(this._len - (serializedLengthPos + 4)));
            return this;
        }

        public final Serializer tags(XStringSequence val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer tags(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            if (this._parent != null) {
                this._parent.childSerializeComplete(this._len);
                this._parent = null;
            }
            this._mark = -1;
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(Network.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final void childSerializeComplete(int len) {
            if (this._mark < 0) {
                throw new IllegalStateException("child object serialization in not in progress");
            }
            IOBuffer.putInt((long)this._addr, (int)this._mark, (int)(len - this._len));
            this._len = len;
            this._mark = -1;
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class NetworkDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private NetworkDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(Network.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class NetworkDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private NetworkDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class NetworkSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private NetworkSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(Network.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class NetworkSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private NetworkSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class NetworkPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private NetworkPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            evictedItem.clear(true);
            _memstats.onEntityPojoLeaked(Network.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class NetworkPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private NetworkPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class NetworkPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Network> {
        private NetworkPoolEvictedItemReceiver() {
        }

        public final void process(Network evictedItem) {
            evictedItem.clear(false, true);
            _memstats.onEntityLeaked(Network.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class NetworkPoolFactory
    implements UtlPool.Factory<Network> {
        private NetworkPoolFactory() {
        }

        public final Network createItem(Object object) {
            return new Network();
        }

        public final Network[] createItemArray(int size) {
            return new Network[size];
        }
    }

    static final class NetworkPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        NetworkPoolFactoryItemCreateArgument() {
        }

        NetworkPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }
}

