/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.equinix;

import com.neeve.cloud.equinix.EquinixRequestType;
import com.neeve.cloud.equinix.messages.GetNetworksRequestMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

final class EquinixRequestParameterFactory {
    EquinixRequestParameterFactory() {
    }

    private static final Map<String, String> createMap(Consumer<Map<String, String>> populateFunction) {
        HashMap<String, String> map = new HashMap<String, String>();
        populateFunction.accept(map);
        return map;
    }

    private static final Map<String, String> createGetNetworksQueryParams(String metro) {
        return EquinixRequestParameterFactory.createMap(map -> map.put("metro", metro));
    }

    static final Map<String, String> createHeaders(EquinixRequestType requestType, Object o) {
        switch (requestType) {
            case GetNetworks: 
            case CreateNetwork: 
            case DeleteNetwork: {
                return new HashMap<String, String>();
            }
        }
        throw new IllegalArgumentException("Unsupported request type: " + (Object)((Object)requestType));
    }

    static final Map<String, String> createQueryParams(EquinixRequestType requestType, Object o) {
        switch (requestType) {
            case GetNetworks: {
                return EquinixRequestParameterFactory.createGetNetworksQueryParams(((GetNetworksRequestMessage)o).getMetro());
            }
            case CreateNetwork: 
            case DeleteNetwork: {
                return new HashMap<String, String>();
            }
        }
        throw new IllegalArgumentException("Unsupported request type: " + (Object)((Object)requestType));
    }
}

