/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo;

import com.neeve.cloud.civo.CivoClient;
import com.neeve.cloud.civo.messages.CreateFirewallRequestMessage;
import com.neeve.cloud.civo.messages.CreateFirewallResponseMessage;
import com.neeve.cloud.civo.messages.CreateFirewallRuleRequestMessage;
import com.neeve.cloud.civo.messages.CreateFirewallRuleResponseMessage;
import com.neeve.cloud.civo.messages.CreateInstanceRequestMessage;
import com.neeve.cloud.civo.messages.CreateInstanceResponseMessage;
import com.neeve.cloud.civo.messages.CreateNetworkRequestMessage;
import com.neeve.cloud.civo.messages.CreateNetworkResponseMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRequestMessage;
import com.neeve.cloud.civo.messages.DeleteFirewallRuleRequestMessage;
import com.neeve.cloud.civo.messages.DeleteInstanceRequestMessage;
import com.neeve.cloud.civo.messages.DeleteNetworkRequestMessage;
import com.neeve.cloud.civo.messages.DeleteNetworkResponseMessage;
import com.neeve.cloud.civo.messages.DiskImage;
import com.neeve.cloud.civo.messages.Firewall;
import com.neeve.cloud.civo.messages.FirewallRule;
import com.neeve.cloud.civo.messages.GetDiskImagesResponseMessage;
import com.neeve.cloud.civo.messages.GetFirewallRulesRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallRulesResponseMessage;
import com.neeve.cloud.civo.messages.GetFirewallsRequestMessage;
import com.neeve.cloud.civo.messages.GetFirewallsResponseMessage;
import com.neeve.cloud.civo.messages.GetInstanceRequestMessage;
import com.neeve.cloud.civo.messages.GetInstanceResponseMessage;
import com.neeve.cloud.civo.messages.GetInstanceSizesResponseMessage;
import com.neeve.cloud.civo.messages.GetInstancesRequestMessage;
import com.neeve.cloud.civo.messages.GetInstancesResponseMessage;
import com.neeve.cloud.civo.messages.GetNetworksRequestMessage;
import com.neeve.cloud.civo.messages.GetNetworksResponseMessage;
import com.neeve.cloud.civo.messages.GetSSHKeysResponseMessage;
import com.neeve.cloud.civo.messages.Instance;
import com.neeve.cloud.civo.messages.InstanceSize;
import com.neeve.cloud.civo.messages.Network;
import com.neeve.cloud.civo.messages.SSHKey;
import com.neeve.cloud.civo.messages.StartInstanceRequestMessage;
import com.neeve.cloud.civo.messages.StopInstanceRequestMessage;
import com.neeve.cloud.util.Helper;
import com.neeve.lang.XIterator;
import com.neeve.trace.Tracer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CivoProvisioner {
    private static final String RUMI_JUMP_SERVER_INSTANCE_SIZE = "g4s.small";
    private static final String RUMI_ADMIN_SERVER_INSTANCE_SIZE = "g4s.medium";
    private static final String RUMI_MONITOR_SERVER_INSTANCE_SIZE = "g4s.xsmall";
    private static final String RUMI_SOLACE_BROKER_INSTANCE_SIZE = "g4s.small";
    private static final String RUMI_KAFKA_BROKER_INSTANCE_SIZE = "g4s.small";
    private static final String RUMI_JUMP_SERVER_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_ADMIN_SERVER_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_MONITOR_SERVER_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_SOLACE_BROKER_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_KAFKA_BROKER_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_SERVICE_INSTANCE_IMAGE = "rocky-9-1";
    private static final String RUMI_JUMP_SERVER_INSTANCE_SHORTNAME = "jump";
    private static final String RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME = "admin";
    private static final String RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME = "monitor";
    private static final String RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME = "solace";
    private static final String RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME = "kafka";
    private static final Set<String> RUMI_PLATFORM_INSTANCE_SHORTNAMES = Stream.of("jump", "admin", "monitor", "solace", "kafka").collect(Collectors.toCollection(HashSet::new));
    private static final String RUMI_JUMP_SERVER_ADD_ZONE_RECORD_SCRIPT = "scripts/add_zone_record.sh";
    private static final String RUMI_JUMP_SERVER_REMOVE_ZONE_RECORD_SCRIPT = "scripts/remove_zone_record.sh";
    private static final String RUMI_JUMP_SERVER_UPDATE_CONFIG_SCRIPT = "scripts/update_config.sh";
    private static final String RUMI_JUMP_SERVER_COPY_FILE_SCRIPT = "scripts/copy_file.sh";
    private static final String RUMI_JUMP_SERVER_UPLOAD_XAR_SCRIPT = "scripts/upload_xar.sh";
    private static final String RUMI_JUMP_SERVER_MOUNT_DISK_SCRIPT = "scripts/mount_disk.sh";
    private static final String RUMI_JUMP_SERVER_RUN_ADMIN_SCRIPT_SCRIPT = "scripts/run_admin_script.sh";
    private static final String RUMI_JUMP_SERVER_RUN_COMMAND_SCRIPT = "scripts/run_command.sh";
    private static final String RUMI_JUMP_SERVER_MONITOR_POST_LAUNCH_SCRIPT = "scripts/monitor_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_ADMIN_POST_LAUNCH_SCRIPT = "scripts/admin_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_SOLACE_POST_LAUNCH_SCRIPT = "scripts/solace_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_KAFKA_POST_LAUNCH_SCRIPT = "scripts/kafka_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT = "scripts/service_post_launch.sh";
    private static final String RUMI_HOSTED_ZONE = "rumi.local";
    private static final String RUMI_HOME_DIR = "/home/rumi";
    private static final String RUMI_STAGING_DIR = "/home/rumi/staging";
    private static final String RUMI_SYSTEMS_DEPLOY_DIR = "/home/rumi/nvx-rumi-agent/current/controller/deploy";
    private static final String RUMI_CONTROLLER_CONF_FILE = "/home/rumi/nvx-rumi-agent/data/controller/controller.conf";
    private final String apiKey;
    private final String region;
    private final Tracer tracer;
    private final CivoClient client;

    private CivoProvisioner(String apiKey, String region) {
        if (apiKey == null) {
            throw new IllegalArgumentException("non-null API key must be supplied");
        }
        this.apiKey = apiKey;
        this.region = region;
        this.tracer = Tracer.get((String)"nv.cloud");
        this.client = new CivoClient();
    }

    public static CivoProvisioner create(String apiKey, String region) {
        return new CivoProvisioner(apiKey, region);
    }

    public static CivoProvisioner create(String apiKey) {
        return new CivoProvisioner(apiKey, null);
    }

    private final String toSpaceSeparatedTags(String[] tags) {
        boolean containsRumiTag = false;
        StringBuilder sb = new StringBuilder();
        if (tags != null && tags.length > 0) {
            for (int i = 0; i < tags.length; ++i) {
                String tag = tags[i];
                sb.append(tag).append(" ");
                if (!tag.equals("rumi")) continue;
                containsRumiTag = true;
            }
        }
        if (!containsRumiTag) {
            sb.append("rumi");
        }
        return sb.toString().trim();
    }

    private final String fullyQualifiedInstanceName(String instanceShortName) {
        return instanceShortName + "." + RUMI_HOSTED_ZONE;
    }

    private final String networkNameToRpnName(String networkName) {
        return networkName + "-rpn";
    }

    private final String instanceName(String instanceShortName, String networkName) {
        return networkName + "-" + instanceShortName;
    }

    private final boolean isPlatformInstance(String instanceShortName) {
        return RUMI_PLATFORM_INSTANCE_SHORTNAMES.contains(instanceShortName);
    }

    private final String readScriptFile(String filename) throws Exception {
        if (filename != null) {
            File scriptFile = new File(filename);
            if (scriptFile.exists() && !scriptFile.isDirectory()) {
                return new String(Files.readAllBytes(Paths.get(filename, new String[0])));
            }
            throw new IllegalArgumentException("invalid or missing script file '" + scriptFile.getCanonicalPath() + "'");
        }
        return null;
    }

    private final GetSSHKeysResponseMessage getSSHKeysCore() {
        return this.client.getSSHKeys(this.apiKey, this.tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findSSHKeyId(String keyPairName) {
        GetSSHKeysResponseMessage response = this.getSSHKeysCore();
        try {
            XIterator<SSHKey> iterator = response.getSSHKeysIterator();
            while (iterator.hasNext()) {
                SSHKey key = (SSHKey)iterator.next();
                if (!keyPairName.equals(key.getName())) continue;
                String string = key.getId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    private final String findSSHKeyIdThrowException(String val) {
        String sshKeyId = this.findSSHKeyId(val);
        if (sshKeyId == null) {
            throw new IllegalArgumentException("invalid ssh key '" + val + "'");
        }
        return sshKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createNetworkCore(String rpnName) {
        CreateNetworkRequestMessage request = CreateNetworkRequestMessage.create();
        request.setRegion(this.region);
        request.setName(rpnName);
        try {
            String string;
            CreateNetworkResponseMessage response = this.client.createNetwork(this.apiKey, request, this.tracer);
            try {
                string = response.getId();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    private final GetNetworksResponseMessage getNetworksCore() {
        GetNetworksRequestMessage request = GetNetworksRequestMessage.create();
        request.setRegion(this.region);
        try {
            GetNetworksResponseMessage getNetworksResponseMessage = this.client.getNetworks(this.apiKey, request, this.tracer);
            return getNetworksResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DeleteNetworkResponseMessage deleteNetworkCore(String id) {
        DeleteNetworkRequestMessage request = DeleteNetworkRequestMessage.create();
        request.setRegion(this.region);
        request.setId(id);
        try {
            DeleteNetworkResponseMessage deleteNetworkResponseMessage = this.client.deleteNetwork(this.apiKey, request, this.tracer);
            return deleteNetworkResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findNetworkId(String networkName) {
        GetNetworksResponseMessage response = this.getNetworksCore();
        try {
            XIterator<Network> iterator = response.getNetworksIterator();
            while (iterator.hasNext()) {
                Network network = (Network)iterator.next();
                if (!networkName.equals(network.getLabel())) continue;
                String string = network.getId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findNetworkCidrBlock(String networkName) {
        GetNetworksResponseMessage response = this.getNetworksCore();
        try {
            XIterator<Network> iterator = response.getNetworksIterator();
            while (iterator.hasNext()) {
                Network network = (Network)iterator.next();
                if (!networkName.equals(network.getLabel())) continue;
                String string = network.getCidrBlock();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createFirewallCore(String networkId, String name) {
        CreateFirewallRequestMessage request = CreateFirewallRequestMessage.create();
        request.setRegion(this.region);
        request.setNetworkId(networkId);
        request.setName(name);
        try {
            String string;
            CreateFirewallResponseMessage response = this.client.createFirewall(this.apiKey, request, this.tracer);
            try {
                string = response.getId();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createFirewallRuleCore(String firewallId, String protocol, String startPort, String endPort, String[] cidr, String label) {
        CreateFirewallRuleRequestMessage request = CreateFirewallRuleRequestMessage.create();
        request.setRegion(this.region);
        request.setProtocol(protocol);
        request.setStartPort(startPort);
        if (endPort != null) {
            request.setEndPort(endPort);
        }
        if (cidr != null && cidr.length > 0) {
            request.setCidr(cidr);
        }
        request.setLabel(label);
        try {
            String string;
            CreateFirewallRuleResponseMessage response = this.client.createFirewallRule(this.apiKey, firewallId, request, this.tracer);
            try {
                string = response.getId();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GetFirewallRulesResponseMessage getFirewallRulesCore(String firewallId) {
        GetFirewallRulesRequestMessage request = GetFirewallRulesRequestMessage.create();
        request.setRegion(this.region);
        request.setFirewallId(firewallId);
        try {
            GetFirewallRulesResponseMessage getFirewallRulesResponseMessage = this.client.getFirewallRules(this.apiKey, request, this.tracer);
            return getFirewallRulesResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteFirewallRuleCore(String firewallId, String ruleId) {
        DeleteFirewallRuleRequestMessage request = DeleteFirewallRuleRequestMessage.create();
        request.setRegion(this.region);
        request.setFirewallId(firewallId);
        request.setId(ruleId);
        try {
            this.client.deleteFirewallRule(this.apiKey, request, this.tracer).dispose();
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> getFirewallRuleIds(String firewallId) {
        ArrayList<String> ids = new ArrayList<String>();
        GetFirewallRulesResponseMessage response = this.getFirewallRulesCore(firewallId);
        try {
            XIterator<FirewallRule> iterator = response.getRulesIterator();
            while (iterator.hasNext()) {
                ids.add(((FirewallRule)iterator.next()).getId());
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> getFirewallIngressRuleIds(String firewallId) {
        ArrayList<String> ids = new ArrayList<String>();
        GetFirewallRulesResponseMessage response = this.getFirewallRulesCore(firewallId);
        try {
            XIterator<FirewallRule> iterator = response.getRulesIterator();
            while (iterator.hasNext()) {
                FirewallRule rule = (FirewallRule)iterator.next();
                if (!rule.getDirection().equalsIgnoreCase("ingress")) continue;
                ids.add(rule.getId());
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    private final GetFirewallsResponseMessage getFirewallsCore() {
        GetFirewallsRequestMessage request = GetFirewallsRequestMessage.create();
        request.setRegion(this.region);
        try {
            GetFirewallsResponseMessage getFirewallsResponseMessage = this.client.getFirewalls(this.apiKey, request, this.tracer);
            return getFirewallsResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    private final void deleteFirewallCore(String firewallId) {
        DeleteFirewallRequestMessage request = DeleteFirewallRequestMessage.create();
        request.setRegion(this.region);
        request.setId(firewallId);
        try {
            this.client.deleteFirewall(this.apiKey, request, this.tracer).dispose();
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findFirewallId(String firewallName) {
        GetFirewallsResponseMessage response = this.getFirewallsCore();
        try {
            XIterator<Firewall> iterator = response.getFirewallsIterator();
            while (iterator.hasNext()) {
                Firewall firewall = (Firewall)iterator.next();
                if (!firewallName.equals(firewall.getName())) continue;
                String string = firewall.getId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    private final String findFirewallIdThrowException(String val) {
        String firewallId = this.findFirewallId(val);
        if (firewallId == null) {
            throw new IllegalArgumentException("invalid firewall '" + val + "'");
        }
        return firewallId;
    }

    private final String createEmptyFirewall(String networkId, String name) {
        String firewallId = this.createFirewallCore(networkId, name);
        for (String ruleId : this.getFirewallIngressRuleIds(firewallId)) {
            this.deleteFirewallRuleCore(firewallId, ruleId);
        }
        return firewallId;
    }

    private final String jumpServerFirewallName(String networkName) {
        return networkName + "-rumi-jump-firewall";
    }

    private final void createJumpServerFirewall(String networkName, String networkId) {
        String firewallId = this.createEmptyFirewall(networkId, this.jumpServerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "80", null, new String[]{"0.0.0.0/0"}, "Allow HTTP from anywhere");
        this.createFirewallRuleCore(firewallId, "tcp", "8001", null, new String[]{"0.0.0.0/0"}, "Allow TCP 8001 from anywhere");
        this.createFirewallRuleCore(firewallId, "tcp", "3000", null, new String[]{"0.0.0.0/0"}, "Allow TCP 3000 from anywhere");
        this.createFirewallRuleCore(firewallId, "tcp", "8080", null, new String[]{"0.0.0.0/0"}, "Allow TCP 8080 from anywhere");
        this.createFirewallRuleCore(firewallId, "tcp", "8161", null, new String[]{"0.0.0.0/0"}, "Allow TCP 8161 from anywhere");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{"0.0.0.0/0"}, "Allow SSH from anywhere");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final String adminServerFirewallName(String networkName) {
        return networkName + "-rumi-admin-firewall";
    }

    private final void createAdminServerFirewall(String networkName, String networkId, String networkCidrBlock) {
        String firewallId = this.createEmptyFirewall(networkId, this.adminServerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "8001", null, new String[]{networkCidrBlock}, "Allow TCP 8001 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "8161", null, new String[]{networkCidrBlock}, "Allow TCP 8161 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "8086", null, new String[]{networkCidrBlock}, "Allow TCP 3000 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "7778", null, new String[]{networkCidrBlock}, "Allow TCP 8080 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "8083", null, new String[]{networkCidrBlock}, "Allow TCP 8083 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "61616", null, new String[]{networkCidrBlock}, "Allow TCP 61616 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{networkCidrBlock}, "Allow SSH within the network");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final String monitorServerFirewallName(String networkName) {
        return networkName + "-rumi-monitor-firewall";
    }

    private final void createMonitorServerFirewall(String networkName, String networkId, String networkCidrBlock) {
        String firewallId = this.createEmptyFirewall(networkId, this.monitorServerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "3000", null, new String[]{networkCidrBlock}, "Allow TCP 3000 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{networkCidrBlock}, "Allow SSH within the network");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final String solaceBrokerFirewallName(String networkName) {
        return networkName + "-rumi-solace-firewall";
    }

    private final void createSolaceBrokerFirewall(String networkName, String networkId, String networkCidrBlock) {
        String firewallId = this.createEmptyFirewall(networkId, this.solaceBrokerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "8080", null, new String[]{networkCidrBlock}, "Allow TCP 8080 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "2222", null, new String[]{networkCidrBlock}, "Allow TCP 2222 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "55003", null, new String[]{networkCidrBlock}, "Allow TCP 55003 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "55443", null, new String[]{networkCidrBlock}, "Allow TCP 55443 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "55555", "55556", new String[]{networkCidrBlock}, "Allow TCP 55555 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{networkCidrBlock}, "Allow SSH within the network");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final String kafkaBrokerFirewallName(String networkName) {
        return networkName + "-rumi-kafka-firewall";
    }

    private final void createKafkaBrokerFirewall(String networkName, String networkId, String networkCidrBlock) {
        String firewallId = this.createEmptyFirewall(networkId, this.kafkaBrokerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "9092", "9094", new String[]{networkCidrBlock}, "Allow TCP 9092-9094 within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{networkCidrBlock}, "Allow SSH within the network");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final String serviceWorkerFirewallName(String networkName) {
        return networkName + "-rumi-service-firewall";
    }

    private final void createServiceWorkerFirewall(String networkName, String networkId, String networkCidrBlock) {
        String firewallId = this.createEmptyFirewall(networkId, this.serviceWorkerFirewallName(networkName));
        this.createFirewallRuleCore(firewallId, "tcp", "1", "65535", new String[]{networkCidrBlock}, "Allow all TCP within the network");
        this.createFirewallRuleCore(firewallId, "tcp", "22", null, new String[]{networkCidrBlock}, "Allow SSH within the network");
        this.createFirewallRuleCore(firewallId, "icmp", "8", null, new String[]{"0.0.0.0/0"}, "Allow ICMP Echo Request from anywhere");
    }

    private final GetDiskImagesResponseMessage getDiskImagesCore() {
        return this.client.getDiskImages(this.apiKey, this.tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findDiskImageId(String imageName) {
        GetDiskImagesResponseMessage response = this.getDiskImagesCore();
        try {
            XIterator<DiskImage> iterator = response.getImagesIterator();
            while (iterator.hasNext()) {
                DiskImage image = (DiskImage)iterator.next();
                if (!imageName.equals(image.getName())) continue;
                String string = image.getId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    private final String findDiskImageIdThrowException(String val) {
        String diskImageId = this.findDiskImageId(val);
        if (diskImageId == null) {
            throw new IllegalArgumentException("invalid disk image '" + val + "'");
        }
        return diskImageId;
    }

    private final GetInstanceSizesResponseMessage getInstanceSizesCore() {
        return this.client.getInstanceSizes(this.apiKey, this.tracer);
    }

    private final String validateInstanceSize(String val) {
        GetInstanceSizesResponseMessage response = this.client.getInstanceSizes(this.apiKey, this.tracer);
        try {
            XIterator<InstanceSize> iterator = response.getInstanceSizesIterator();
            while (iterator.hasNext()) {
                InstanceSize size = (InstanceSize)iterator.next();
                if (!val.equals(size.getName())) continue;
                String string = val;
                return string;
            }
            throw new IllegalArgumentException("invalid instance size '" + val + "'");
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String createInstanceCore(String networkId, String keyPair, String instanceImage, String instanceSize, String firewall, boolean assignPublicIP, String instanceName, String script, String[] tags) {
        CreateInstanceRequestMessage request = CreateInstanceRequestMessage.create();
        request.setRegion(this.region);
        request.setHostName(instanceName);
        request.setSizeCode(this.validateInstanceSize(instanceSize));
        request.setNetworkId(networkId);
        request.setFirewallId(this.findFirewallIdThrowException(firewall));
        request.setDiskImageId(this.findDiskImageIdThrowException(instanceImage));
        request.setSshKeyId(this.findSSHKeyIdThrowException(keyPair));
        request.setScript(script);
        request.setPublicIP(assignPublicIP ? "create" : "none");
        request.setInitialUser("root");
        request.setTags(this.toSpaceSeparatedTags(tags));
        try {
            String string;
            CreateInstanceResponseMessage response = this.client.createInstance(this.apiKey, request, this.tracer);
            try {
                string = response.getId();
                response.dispose();
            }
            catch (Throwable throwable) {
                response.dispose();
                throw throwable;
            }
            return string;
        }
        finally {
            request.dispose();
        }
    }

    private final void startInstanceCore(String id) {
        StartInstanceRequestMessage request = StartInstanceRequestMessage.create();
        request.setRegion(this.region);
        request.setId(id);
        try {
            this.client.startInstance(this.apiKey, request, this.tracer).dispose();
        }
        finally {
            request.dispose();
        }
    }

    private final void stopInstanceCore(String id) {
        StopInstanceRequestMessage request = StopInstanceRequestMessage.create();
        request.setRegion(this.region);
        request.setId(id);
        try {
            this.client.stopInstance(this.apiKey, request, this.tracer).dispose();
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GetInstanceResponseMessage getInstanceCore(String id) {
        GetInstanceRequestMessage request = GetInstanceRequestMessage.create();
        request.setRegion(this.region);
        request.setId(id);
        try {
            GetInstanceResponseMessage getInstanceResponseMessage = this.client.getInstance(this.apiKey, request, this.tracer);
            return getInstanceResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GetInstancesResponseMessage getInstancesCore(String[] tags) {
        GetInstancesRequestMessage request = GetInstancesRequestMessage.create();
        request.setRegion(this.region);
        request.setPage(1);
        request.setNumPerPage(250);
        request.setTags(this.toSpaceSeparatedTags(tags));
        try {
            GetInstancesResponseMessage getInstancesResponseMessage = this.client.getInstances(this.apiKey, request, this.tracer);
            return getInstancesResponseMessage;
        }
        finally {
            request.dispose();
        }
    }

    private final void deleteInstanceCore(String id) {
        DeleteInstanceRequestMessage request = DeleteInstanceRequestMessage.create();
        request.setRegion(this.region);
        request.setId(id);
        try {
            this.client.deleteInstance(this.apiKey, request, this.tracer).dispose();
        }
        finally {
            request.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T getInstanceField(String instanceId, Function<GetInstanceResponseMessage, T> getter) {
        GetInstanceResponseMessage response = this.getInstanceCore(instanceId);
        try {
            T t = getter.apply(response);
            return t;
        }
        finally {
            response.dispose();
        }
    }

    private final String getInstanceStatus(String instanceId) {
        return this.getInstanceField(instanceId, response -> response.getStatus());
    }

    private final String getInstancePrivateIP(String instanceId) {
        return this.getInstanceField(instanceId, response -> response.getPrivateIP());
    }

    private final String getInstancePublicIP(String instanceId) {
        return this.getInstanceField(instanceId, response -> response.getPublicIP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String findInstanceId(String instanceName) {
        GetInstancesResponseMessage response = this.getInstancesCore(new String[]{"rumi"});
        try {
            XIterator<Instance> iterator = response.getInstancesIterator();
            while (iterator.hasNext()) {
                Instance instance = (Instance)iterator.next();
                if (!instanceName.equals(instance.getHostname())) continue;
                String string = instance.getId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            response.dispose();
        }
    }

    private final <T> T waitForInstanceFieldValue(String fieldName, String instanceId, Function<String, T> getter, int timeoutSeconds) {
        T val = null;
        int count = 0;
        long timeoutMillis = timeoutSeconds * 1000;
        long startTime = System.currentTimeMillis();
        while (true) {
            T t = getter.apply(instanceId);
            val = t;
            if (t != null || System.currentTimeMillis() - startTime >= timeoutMillis) break;
            if (++count % 10 == 0) {
                this.tracer.log("Still waiting for '" + fieldName + "' to be provisioned.", Tracer.Level.VERBOSE);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (val == null) {
            throw new IllegalStateException("timed out on waiting for " + fieldName + " to be provisioned");
        }
        return val;
    }

    private final <T> T waitForInstanceFieldValue(String fieldName, String instanceId, Function<String, T> getter) {
        return this.waitForInstanceFieldValue(fieldName, instanceId, getter, 300);
    }

    private final <T> void waitForInstanceCondition(String conditionName, T param, Function<T, Boolean> condition, int timeoutSeconds) {
        boolean success = false;
        int count = 0;
        long timeoutMillis = timeoutSeconds * 1000;
        long startTime = System.currentTimeMillis();
        while (!(success = condition.apply(param).booleanValue()) && System.currentTimeMillis() - startTime < timeoutMillis) {
            if (++count % 10 == 0) {
                this.tracer.log("Still waiting on " + conditionName + " to complete.", Tracer.Level.VERBOSE);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!success) {
            throw new IllegalStateException("timed out on waiting for " + conditionName + " to complete");
        }
    }

    private final <T> void waitForInstanceCondition(String conditionName, T param, Function<T, Boolean> condition) {
        this.waitForInstanceCondition(conditionName, param, condition, 300);
    }

    private final void addToHostedZone(String networkName, String keyPair, String name, String ip) {
        String nameInZone = this.fullyQualifiedInstanceName(name);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_ADD_ZONE_RECORD_SCRIPT, new String[]{"--host", nameInZone, "--addr", ip});
    }

    private final void removeFromHostedZone(String networkName, String keyPair, String name) {
        String nameInZone = this.fullyQualifiedInstanceName(name);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_REMOVE_ZONE_RECORD_SCRIPT, new String[]{"--name", nameInZone});
    }

    private final String createInstance(String networkName, String keyPair, String instanceImage, String instanceSize, String firewall, boolean assignPublicIP, String instanceShortName, String instanceNameInHostedZone, String[] additionalNamesInHostedZone, String initScript, Function<InstanceInitScriptCompleteCheckFunctionParams, Boolean> initScriptCompleteCheck, String[] scriptsToCopy, String[] tags) {
        String publicIP;
        String networkId;
        String rpnName = this.networkNameToRpnName(networkName);
        if (this.tracer.debug) {
            this.tracer.log("Verifying network '" + rpnName + "' exists", Tracer.Level.DEBUG);
        }
        if ((networkId = this.findNetworkId(rpnName)) == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceName = this.instanceName(instanceShortName, networkName);
        if (this.findInstanceId(instanceName) != null) {
            throw new IllegalStateException("instance already launched");
        }
        this.tracer.log("Launching instance '" + instanceName + "'.", Tracer.Level.INFO);
        String instanceId = this.createInstanceCore(rpnName, keyPair, instanceImage, instanceSize, firewall, assignPublicIP, instanceName, initScript, tags);
        this.tracer.log("Instance launched. Waiting for launch to complete.", Tracer.Level.INFO);
        this.waitForInstanceCondition("launch", instanceId, id -> this.getInstanceStatus((String)id).equalsIgnoreCase("ACTIVE"), 600);
        this.tracer.log("Ensuring private IP address has been provisioned.", Tracer.Level.INFO);
        String privateIP = this.waitForInstanceFieldValue("private ip", instanceId, id -> this.getInstancePrivateIP((String)id));
        if (assignPublicIP) {
            this.tracer.log("Ensuring public IP address has been provisioned.", Tracer.Level.INFO);
            publicIP = this.waitForInstanceFieldValue("public ip", instanceId, id -> this.getInstancePublicIP((String)id));
        } else {
            publicIP = null;
        }
        if (publicIP != null && initScriptCompleteCheck != null) {
            this.tracer.log("Waiting for instance initialization to complete.", Tracer.Level.INFO);
            this.waitForInstanceCondition("instance initialization", new InstanceInitScriptCompleteCheckFunctionParams(publicIP, keyPair), initScriptCompleteCheck, 600);
        }
        this.tracer.log("Instance is ready.", Tracer.Level.INFO);
        if (publicIP != null && scriptsToCopy != null) {
            this.tracer.log("Copying scripts.", Tracer.Level.INFO);
            Helper.copyScriptsToServer(publicIP, keyPair, scriptsToCopy, this.tracer);
        }
        this.tracer.log("Updating the hosted zone.", Tracer.Level.INFO);
        this.addToHostedZone(networkName, keyPair, instanceNameInHostedZone, privateIP);
        if (additionalNamesInHostedZone != null) {
            for (String additionalName : additionalNamesInHostedZone) {
                this.addToHostedZone(networkName, keyPair, additionalName, privateIP);
            }
        }
        this.tracer.log("Instance launched and initialized successfully.", Tracer.Level.INFO);
        if (publicIP != null) {
            this.tracer.log("Instance public IP address is " + publicIP + ".", Tracer.Level.INFO);
            if (instanceShortName.equals(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME)) {
                this.tracer.log("  This is the jump (bastion) server. You can log into this instance using ssh and the '" + keyPair + "' key pair", Tracer.Level.INFO);
            } else {
                this.tracer.log("  This instance is not open to public access. However, you can ping the instance.", Tracer.Level.INFO);
            }
        } else {
            this.tracer.log(" This instance does not have a public IP address.", Tracer.Level.INFO);
        }
        this.tracer.log("Instance private IP address is " + privateIP + ".", Tracer.Level.INFO);
        this.tracer.log("  This instance can be reached within the network using the following names.", Tracer.Level.INFO);
        this.tracer.log("    " + this.fullyQualifiedInstanceName(instanceNameInHostedZone), Tracer.Level.INFO);
        if (additionalNamesInHostedZone != null) {
            for (String additionalName : additionalNamesInHostedZone) {
                this.tracer.log("    " + this.fullyQualifiedInstanceName(additionalName), Tracer.Level.INFO);
            }
        }
        return instanceId;
    }

    private final void startInstance(String networkName, String instanceShortName, String instanceDesc, boolean wait) {
        if (this.findNetworkId(this.networkNameToRpnName(networkName)) == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findInstanceId(this.instanceName(instanceShortName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("the instance '" + instanceShortName + "' has not been provisioned");
        }
        this.tracer.log("Starting the " + instanceDesc + ".", Tracer.Level.INFO);
        this.startInstanceCore(instanceId);
        if (wait) {
            this.tracer.log("Waiting for instance to start.", Tracer.Level.INFO);
            this.waitForInstanceCondition("state transition", instanceId, id -> this.getInstanceStatus((String)id).equalsIgnoreCase("ACTIVE"));
        }
        this.tracer.log("Instance started successfully.", Tracer.Level.INFO);
    }

    private final void stopInstance(String networkName, String instanceShortName, String instanceDesc, boolean wait) {
        if (this.findNetworkId(this.networkNameToRpnName(networkName)) == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findInstanceId(this.instanceName(instanceShortName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("the instance '" + instanceShortName + "' has not been provisioned");
        }
        this.tracer.log("Stopping the " + instanceDesc + ".", Tracer.Level.INFO);
        this.stopInstanceCore(instanceId);
        if (wait) {
            this.tracer.log("Waiting for instance to stop.", Tracer.Level.INFO);
            this.waitForInstanceCondition("state transition", instanceId, id -> this.getInstanceStatus((String)id).equalsIgnoreCase("SHUTOFF"));
        }
        this.tracer.log("Instance stopped successfully", Tracer.Level.INFO);
    }

    private final void deleteInstance(String networkName, String keyPair, String instanceShortName, String[] additionalNamesInHostedZone, String instanceDesc, boolean wait) {
        if (this.findNetworkId(this.networkNameToRpnName(networkName)) == null) {
            throw new IllegalArgumentException("The '" + networkName + "' network does not exist or is not a Rumi managed network");
        }
        String instanceId = this.findInstanceId(this.instanceName(instanceShortName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("instance not launched");
        }
        this.tracer.log("Updating the hosted zone.", Tracer.Level.INFO);
        this.removeFromHostedZone(networkName, keyPair, instanceShortName);
        if (additionalNamesInHostedZone != null) {
            for (String additionalName : additionalNamesInHostedZone) {
                this.removeFromHostedZone(networkName, keyPair, additionalName);
            }
        }
        this.tracer.log("Deleting the " + instanceDesc + " instance.", Tracer.Level.INFO);
        this.deleteInstanceCore(instanceId);
        if (wait) {
            this.tracer.log("Waiting for instance to be deleted", Tracer.Level.INFO);
            this.waitForInstanceCondition("state transition", instanceId, id -> this.findInstanceId(this.instanceName(instanceShortName, networkName)) == null);
        }
        this.tracer.log("Instance deleted successfully", Tracer.Level.INFO);
    }

    private final String isJumpServerRunning(String networkName) {
        String instanceId = this.findInstanceId(this.instanceName(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, networkName));
        if (instanceId != null && "ACTIVE".equalsIgnoreCase(this.getInstanceStatus(instanceId))) {
            return instanceId;
        }
        return null;
    }

    private final void copyFileToJumpServer(String networkName, String keyPair, String sourceFile, String targetDir, String targetFilePermissions) {
        String instanceId = this.isJumpServerRunning(networkName);
        if (instanceId == null) {
            throw new IllegalStateException("jump server is either not provisioned or running");
        }
        Helper.copyFileToServer(this.getInstancePublicIP(instanceId), keyPair, sourceFile, targetDir, targetFilePermissions, this.tracer);
    }

    private final void executeScriptOnJumpServer(String networkName, String keyPair, String scriptFilename, String[] scriptArgs) {
        String instanceId = this.isJumpServerRunning(networkName);
        if (instanceId == null) {
            throw new IllegalStateException("jump server is either not provisioned or running");
        }
        Helper.executeScriptOnServer(this.getInstancePublicIP(instanceId), keyPair, scriptFilename, scriptArgs, this.tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getSSHKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        GetSSHKeysResponseMessage response = this.getSSHKeysCore();
        try {
            XIterator<SSHKey> iterator = response.getSSHKeysIterator();
            while (iterator.hasNext()) {
                keys.add(((SSHKey)iterator.next()).getName());
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getDiskImages() {
        ArrayList<String> images = new ArrayList<String>();
        GetDiskImagesResponseMessage response = this.getDiskImagesCore();
        try {
            XIterator<DiskImage> iterator = response.getImagesIterator();
            while (iterator.hasNext()) {
                images.add(((DiskImage)iterator.next()).getName());
            }
            ArrayList<String> arrayList = images;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getInstanceSizes() {
        ArrayList<String> sizes = new ArrayList<String>();
        GetInstanceSizesResponseMessage response = this.getInstanceSizesCore();
        try {
            XIterator<InstanceSize> iterator = response.getInstanceSizesIterator();
            while (iterator.hasNext()) {
                sizes.add(((InstanceSize)iterator.next()).getName());
            }
            ArrayList<String> arrayList = sizes;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    public final void createNetwork(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        String rpnName = this.networkNameToRpnName(networkName);
        if (this.tracer.debug) {
            this.tracer.log("Verifying network '" + rpnName + " does not already exist", Tracer.Level.DEBUG);
        }
        if (this.findNetworkId(rpnName) != null) {
            throw new IllegalArgumentException("the network '" + networkName + "' already exists");
        }
        this.tracer.log("Creating network '" + rpnName + "' (CIDR block 192.168.1.0/24).", Tracer.Level.INFO);
        String networkId = this.createNetworkCore(rpnName);
        String networkCidrBlock = this.findNetworkCidrBlock(rpnName);
        this.tracer.log("Creating firewalls.", Tracer.Level.INFO);
        this.tracer.log("...jump server.", Tracer.Level.VERBOSE);
        this.createJumpServerFirewall(networkName, networkId);
        this.tracer.log("...admin server.", Tracer.Level.VERBOSE);
        this.createAdminServerFirewall(networkName, networkId, networkCidrBlock);
        this.tracer.log("...monitor server.", Tracer.Level.VERBOSE);
        this.createMonitorServerFirewall(networkName, networkId, networkCidrBlock);
        this.tracer.log("...messaging broker (solace).", Tracer.Level.VERBOSE);
        this.createSolaceBrokerFirewall(networkName, networkId, networkCidrBlock);
        this.tracer.log("...messaging broker (kafka).", Tracer.Level.VERBOSE);
        this.createKafkaBrokerFirewall(networkName, networkId, networkCidrBlock);
        this.tracer.log("...service.", Tracer.Level.VERBOSE);
        this.createServiceWorkerFirewall(networkName, networkId, networkCidrBlock);
        this.tracer.log("Network created successfully.", Tracer.Level.INFO);
    }

    public final void createHostedZone(String networkName, String hostedZoneName) {
        String rpnName = this.networkNameToRpnName(networkName);
        String networkId = this.findNetworkId(rpnName);
        if (networkId == null) {
            throw new IllegalArgumentException("The '" + networkName + "' network does not exist or is not a Rumi managed network");
        }
        throw new UnsupportedOperationException("additional hosted zones are not supported on the Civo cloud");
    }

    public final List<String> getHostedZones(String networkName) {
        String rpnName = this.networkNameToRpnName(networkName);
        String networkId = this.findNetworkId(rpnName);
        if (networkId == null) {
            throw new IllegalArgumentException("The '" + networkName + "' network does not exist or is not a Rumi managed network");
        }
        throw new UnsupportedOperationException("this operation is not currently supported");
    }

    public final CivoProvisioner launchJumpServer(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        String instancePublicIP = this.getInstancePublicIP(this.createInstance(networkName, keyPair, "rocky-9-1", "g4s.small", this.jumpServerFirewallName(networkName), true, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, new String[]{"bastion"}, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "init.sh"), p -> Helper.waitForServerToBeReachable(p.publicIP, 300, 80, this.tracer), new String[]{"scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "add_zone_record.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "remove_zone_record.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "add_proxy.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "set_dns_resolver.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "update_config.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "copy_file.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "upload_xar.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "mount_disk.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "run_admin_script.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "run_command.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "admin_post_launch.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "monitor_post_launch.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "solace_post_launch.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "kafka_post_launch.sh", "scripts" + File.separator + "rocky" + File.separator + RUMI_JUMP_SERVER_INSTANCE_SHORTNAME + File.separator + "service_post_launch.sh"}, null));
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        Helper.copyPrivateKeyToServer(instancePublicIP, keyPair, this.tracer);
        this.tracer.log("Jump server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final CivoProvisioner startJumpServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, "jump server", wait);
        return this;
    }

    public final CivoProvisioner stopJumpServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, "jump server", wait);
        return this;
    }

    public final CivoProvisioner terminateJumpServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        List<String> instances = this.getPlatformInstances(networkName);
        if (instances.stream().filter(n -> !n.equals(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME)).collect(Collectors.toList()).size() > 0) {
            throw new IllegalStateException("cannot terminate the jump server while other provisioned instances are present");
        }
        this.deleteInstance(networkName, keyPair, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, new String[]{"bastion"}, "jump server", wait);
        return this;
    }

    public final CivoProvisioner launchAdminServer(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launchany instance");
        }
        String instanceId = this.createInstance(networkName, keyPair, "rocky-9-1", RUMI_ADMIN_SERVER_INSTANCE_SIZE, this.adminServerFirewallName(networkName), true, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, new String[]{"discovery", "influxdb"}, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME + File.separator + "init.sh"), null, null, null);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_ADMIN_POST_LAUNCH_SCRIPT, null);
        this.tracer.log("Admin server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final CivoProvisioner startAdminServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, "admin server", wait);
        return this;
    }

    public final CivoProvisioner stopAdminServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, "admin server", wait);
        return this;
    }

    public final CivoProvisioner terminateAdminServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to terminate any instance");
        }
        this.deleteInstance(networkName, keyPair, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, new String[]{"discovery", "influxdb"}, "admin server", wait);
        return this;
    }

    public final CivoProvisioner launchMonitorServer(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        String instanceId = this.createInstance(networkName, keyPair, "rocky-9-1", RUMI_MONITOR_SERVER_INSTANCE_SIZE, this.monitorServerFirewallName(networkName), true, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, null, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME + File.separator + "init.sh"), null, null, null);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_MONITOR_POST_LAUNCH_SCRIPT, null);
        this.tracer.log("Monitor server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final CivoProvisioner startMonitorServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, "monitor server", wait);
        return this;
    }

    public final CivoProvisioner stopMonitorServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, "monitor server", wait);
        return this;
    }

    public final CivoProvisioner terminateMonitorServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to terminate any instance");
        }
        this.deleteInstance(networkName, keyPair, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, null, "monitor server", wait);
        return this;
    }

    public final CivoProvisioner launchSolaceBroker(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        String instanceId = this.createInstance(networkName, keyPair, "rocky-9-1", "g4s.small", this.solaceBrokerFirewallName(networkName), true, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, null, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME + File.separator + "init.sh"), null, null, null);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SOLACE_POST_LAUNCH_SCRIPT, null);
        this.tracer.log("Solace broker launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final CivoProvisioner startSolaceBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, "solace broker", wait);
        return this;
    }

    public final CivoProvisioner stopSolaceBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, "solace broker", wait);
        return this;
    }

    public final CivoProvisioner terminateSolaceBroker(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to terminate any instance");
        }
        this.deleteInstance(networkName, keyPair, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, null, "solace broker", wait);
        return this;
    }

    public final CivoProvisioner launchKafkaBroker(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        String instanceId = this.createInstance(networkName, keyPair, "rocky-9-1", "g4s.small", this.kafkaBrokerFirewallName(networkName), true, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, null, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME + File.separator + "init.sh"), null, null, null);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_KAFKA_POST_LAUNCH_SCRIPT, null);
        this.tracer.log("Kafka broker launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final CivoProvisioner startKafkaBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, "kafka broker", wait);
        return this;
    }

    public final CivoProvisioner stopKafkaBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, "kafka broker", wait);
        return this;
    }

    public final CivoProvisioner terminateKafkaBroker(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to terminate any instance");
        }
        this.deleteInstance(networkName, keyPair, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, null, "kafka broker", wait);
        return this;
    }

    public final CivoProvisioner launchPlatform(String networkName, String keyPair) {
        return this.launchJumpServer(networkName, keyPair).launchSolaceBroker(networkName, keyPair).launchAdminServer(networkName, keyPair).launchMonitorServer(networkName, keyPair);
    }

    public final CivoProvisioner startPlatform(String networkName, boolean wait) {
        return this.startJumpServer(networkName, wait).startSolaceBroker(networkName, wait).startAdminServer(networkName, wait).startMonitorServer(networkName, wait);
    }

    public final CivoProvisioner stopPlatform(String networkName, boolean wait) {
        return this.stopJumpServer(networkName, wait).stopSolaceBroker(networkName, wait).stopAdminServer(networkName, wait).stopMonitorServer(networkName, wait);
    }

    public final CivoProvisioner terminatePlatform(String networkName, String keyPair, boolean wait) {
        return this.terminateMonitorServer(networkName, keyPair, wait).terminateAdminServer(networkName, keyPair, wait).terminateSolaceBroker(networkName, keyPair, wait).terminateJumpServer(networkName, keyPair, wait);
    }

    public final CivoProvisioner launchServiceInstance(String networkName, String keyPair, String instanceSize, boolean assignPublicIP, String hostedZoneName, String instanceName, String instanceNameInHostedZone, String[] additionalNamesInHostedZone, int rumiVolumeSize) throws Exception {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceSize == null) {
            throw new IllegalArgumentException("instance size cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (rumiVolumeSize > 0) {
            throw new UnsupportedOperationException("rumi volume functionality is currently not supported on Civo cloud instances");
        }
        if (hostedZoneName != null && !hostedZoneName.equals(RUMI_HOSTED_ZONE)) {
            throw new UnsupportedOperationException("hosted zones other than 'rumi.local' are not supported on the Civo cloud");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        instanceNameInHostedZone = instanceNameInHostedZone == null ? instanceName : instanceNameInHostedZone;
        String instanceId = this.createInstance(networkName, keyPair, "rocky-9-1", instanceSize, this.serviceWorkerFirewallName(networkName), assignPublicIP, instanceName, instanceNameInHostedZone, additionalNamesInHostedZone, Helper.readResourceFile("scripts" + File.separator + "rocky" + File.separator + "service" + File.separator + "init.sh"), null, null, null);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT, new String[]{"--host", instanceNameInHostedZone + "." + RUMI_HOSTED_ZONE});
        if (additionalNamesInHostedZone != null) {
            for (String additionalNameInHostedZone : additionalNamesInHostedZone) {
                this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT, new String[]{"--host", additionalNameInHostedZone + "." + RUMI_HOSTED_ZONE});
            }
        }
        return this;
    }

    public final CivoProvisioner startServiceInstance(String networkName, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        this.startInstance(networkName, instanceName, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final CivoProvisioner startAllServiceInstances(String networkName, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.startServiceInstance(networkName, instanceName, wait);
        }
        return this;
    }

    public final CivoProvisioner stopServiceInstance(String networkName, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        this.stopInstance(networkName, instanceName, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final CivoProvisioner stopAllServiceInstances(String networkName, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.stopServiceInstance(networkName, instanceName, wait);
        }
        return this;
    }

    public final CivoProvisioner terminateServiceInstance(String networkName, String keyPair, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to terminate any instance");
        }
        this.deleteInstance(networkName, keyPair, instanceName, null, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final CivoProvisioner terminateAllServiceInstances(String networkName, String keyPair, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.terminateServiceInstance(networkName, keyPair, instanceName, wait);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getPlatformInstances(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        ArrayList<String> instances = new ArrayList<String>();
        GetInstancesResponseMessage response = this.getInstancesCore(new String[]{"rumi"});
        try {
            XIterator<Instance> iterator = response.getInstancesIterator();
            while (iterator.hasNext()) {
                String instanceShortName;
                Instance instance = (Instance)iterator.next();
                String instanceFullName = instance.getHostname();
                if (!instanceFullName.startsWith(networkName + "-") || !this.isPlatformInstance(instanceShortName = instanceFullName.substring((networkName + "-").length()))) continue;
                instances.add(instanceShortName);
            }
            ArrayList<String> arrayList = instances;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getServiceInstances(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        ArrayList<String> instances = new ArrayList<String>();
        GetInstancesResponseMessage response = this.getInstancesCore(new String[]{"rumi"});
        try {
            XIterator<Instance> iterator = response.getInstancesIterator();
            while (iterator.hasNext()) {
                String instanceShortName;
                Instance instance = (Instance)iterator.next();
                String instanceFullName = instance.getHostname();
                if (!instanceFullName.startsWith(networkName + "-") || this.isPlatformInstance(instanceShortName = instanceFullName.substring((networkName + "-").length()))) continue;
                instances.add(instanceShortName);
            }
            ArrayList<String> arrayList = instances;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getNetworks() {
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        ArrayList<String> networks = new ArrayList<String>();
        GetNetworksResponseMessage response = this.getNetworksCore();
        try {
            XIterator<Network> iterator = response.getNetworksIterator();
            while (iterator.hasNext()) {
                Network network = (Network)iterator.next();
                String label = network.getLabel();
                if (!label.endsWith("-rpn")) continue;
                networks.add(label.substring(0, label.lastIndexOf(45)));
            }
            ArrayList<String> arrayList = networks;
            return arrayList;
        }
        finally {
            response.dispose();
        }
    }

    public final void deleteNetwork(String networkName, String keyPair) {
        String networkId;
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.region == null) {
            throw new IllegalStateException("a region needs to be supplied is needed for this method");
        }
        String rpnName = this.networkNameToRpnName(networkName);
        if (this.tracer.debug) {
            this.tracer.log("Verifying network '" + rpnName + "' exists", Tracer.Level.DEBUG);
        }
        if ((networkId = this.findNetworkId(rpnName)) == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        this.tracer.log("Terminating all instances.", Tracer.Level.INFO);
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.deleteInstance(networkName, keyPair, instanceName, null, "'" + instanceName + "' service instance", true);
        }
        for (String instanceName : this.getPlatformInstances(networkName).stream().filter(n -> !n.equals(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME)).collect(Collectors.toList())) {
            this.deleteInstance(networkName, keyPair, instanceName, null, "'" + instanceName + "' platform instance", true);
        }
        String jumpServerInstanceId = this.findInstanceId(this.instanceName(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, networkName));
        if (jumpServerInstanceId != null) {
            this.terminateJumpServer(networkName, keyPair, true);
        }
        this.tracer.log("Deleting the network.", Tracer.Level.INFO);
        this.deleteNetworkCore(networkId);
        this.tracer.log("Network deleted successfully.", Tracer.Level.INFO);
    }

    public final void provisionEnvironment(String name, String keyPair) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        String rpnName = this.networkNameToRpnName(name);
        if (this.findNetworkId(rpnName) != null) {
            throw new IllegalArgumentException("a Rumi environment with the name '" + name + "' already exists");
        }
        this.createNetwork(name);
        this.launchPlatform(name, keyPair);
    }

    public final void deploySystem(String name, String keyPair, File xar) {
        if (name == null) {
            throw new IllegalArgumentException("environment name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (xar == null) {
            throw new IllegalArgumentException("xar file needs to be specified");
        }
        if (!xar.exists()) {
            throw new IllegalArgumentException("the specified xar file does not exist");
        }
        this.tracer.log("Deploying the '" + xar.getName() + "' system to the '" + name + " environment", Tracer.Level.INFO);
        if (this.isJumpServerRunning(name) == null) {
            throw new IllegalStateException("jump server needs to be running to deploy a system");
        }
        this.copyFileToJumpServer(name, keyPair, xar.getAbsolutePath(), RUMI_STAGING_DIR, null);
        this.executeScriptOnJumpServer(name, keyPair, RUMI_JUMP_SERVER_UPLOAD_XAR_SCRIPT, new String[]{"--file", "/home/rumi/staging/" + xar.getName()});
        this.tracer.log("System successfully deployed", Tracer.Level.INFO);
    }

    public final void updateConfig(String name, String keyPair, String section, String key, String value) {
        if (name == null) {
            throw new IllegalArgumentException("environment name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (section == null) {
            throw new IllegalArgumentException("property section needs to be specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("property key needs to be specified");
        }
        this.tracer.log("Setting configuration property '" + key + "=" + value + "' in the '" + name + "' environment", Tracer.Level.INFO);
        value = value == null ? "null" : value;
        this.executeScriptOnJumpServer(name, keyPair, RUMI_JUMP_SERVER_UPDATE_CONFIG_SCRIPT, new String[]{"--section", section, "--key", key, "--value", value, "--file", RUMI_CONTROLLER_CONF_FILE, "--host", this.fullyQualifiedInstanceName(RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME)});
        this.tracer.log("Configuration successfully changed", Tracer.Level.INFO);
    }

    public final void startEnvironment(String name, boolean wait) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startPlatform(name, wait);
        this.startAllServiceInstances(name, wait);
    }

    public final void stopEnvironment(String name, boolean wait) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopAllServiceInstances(name, wait);
        this.stopPlatform(name, wait);
    }

    public final void deprovisionEnvironment(String name, String keyPair) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        String rpnName = this.networkNameToRpnName(name);
        if (this.findNetworkId(rpnName) == null) {
            throw new IllegalArgumentException("a Rumi environment with the name '" + name + "' does not exist");
        }
        this.deleteNetwork(name, keyPair);
    }

    private final class InstanceInitScriptCompleteCheckFunctionParams {
        final String publicIP;
        final String keyPair;

        InstanceInitScriptCompleteCheckFunctionParams(String publicIP, String keyPair) {
            this.publicIP = publicIP;
            this.keyPair = keyPair;
        }
    }
}

