/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.aws;

import com.neeve.cloud.util.Helper;
import com.neeve.trace.Tracer;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.AssociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.AttachVolumeRequest;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.CreateInternetGatewayResponse;
import software.amazon.awssdk.services.ec2.model.CreateRouteRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupResponse;
import software.amazon.awssdk.services.ec2.model.CreateSubnetRequest;
import software.amazon.awssdk.services.ec2.model.CreateSubnetResponse;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.services.ec2.model.CreateVpcResponse;
import software.amazon.awssdk.services.ec2.model.DeleteInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteNatGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSecurityGroupRequest;
import software.amazon.awssdk.services.ec2.model.DeleteSubnetRequest;
import software.amazon.awssdk.services.ec2.model.DeleteVpcRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DetachInternetGatewayRequest;
import software.amazon.awssdk.services.ec2.model.DisassociateRouteTableRequest;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InternetGateway;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.ModifyVpcAttributeRequest;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.services.ec2.model.NatGatewayState;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.VolumeState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.Route53ClientBuilder;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeAction;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.model.TagResourceType;
import software.amazon.awssdk.services.route53.model.VPC;

public final class AwsProvisioner {
    private static final String RUMI_JUMP_SERVER_AMI_V11 = "ami-0df3fd4a1c610f37b";
    private static final String RUMI_ADMIN_SERVER_AMI_V2_0_25 = "ami-0854cef1cb9021944";
    private static final String RUMI_MONITOR_SERVER_AMI_V10_1_1_7 = "ami-0dee1629c94b67043";
    private static final String RUMI_SERVICE_WORKER_AMI_V1 = "ami-007009ba912f34d31";
    private static final String RUMI_SOLACE_BROKER_AMI_V10_25_0 = "ami-022ffbdfdc14378ba";
    private static final String RUMI_KAFKA_BROKER_AMI_V3_9_0 = "ami-07667608f4ab62111";
    private static final String RUMI_ACTIVEMQ_BROKER_AMI_V3_19_0 = "ami-0fbc9f169d7d4eeec";
    private static final String RUMI_JUMP_SERVER_AMI_LATEST = "ami-0df3fd4a1c610f37b";
    private static final String RUMI_ADMIN_SERVER_AMI_LATEST = "ami-0854cef1cb9021944";
    private static final String RUMI_MONITOR_SERVER_AMI_LATEST = "ami-0dee1629c94b67043";
    private static final String RUMI_SOLACE_BROKER_AMI_LATEST = "ami-022ffbdfdc14378ba";
    private static final String RUMI_KAFKA_BROKER_AMI_LATEST = "ami-07667608f4ab62111";
    private static final String RUMI_ACTIVEMQ_BROKER_AMI_LATEST = "ami-0fbc9f169d7d4eeec";
    private static final String RUMI_SERVICE_WORKER_AMI_LATEST = "ami-007009ba912f34d31";
    private static final InstanceType RUMI_JUMP_SERVER_INSTANCE_TYPE = InstanceType.T3_NANO;
    private static final InstanceType RUMI_ADMIN_SERVER_INSTANCE_TYPE = InstanceType.T3_MEDIUM;
    private static final InstanceType RUMI_MONITOR_SERVER_INSTANCE_TYPE = InstanceType.T3_NANO;
    private static final InstanceType RUMI_SOLACE_BROKER_INSTANCE_TYPE = InstanceType.T3_LARGE;
    private static final InstanceType RUMI_KAFKA_BROKER_INSTANCE_TYPE = InstanceType.T3_SMALL;
    private static final InstanceType RUMI_ACTIVEMQ_BROKER_INSTANCE_TYPE = InstanceType.T3_SMALL;
    private static final String RUMI_JUMP_SERVER_INSTANCE_SHORTNAME = "jump";
    private static final String RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME = "admin";
    private static final String RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME = "monitor";
    private static final Set<String> RUMI_PLATFORM_INSTANCE_SHORTNAMES = Stream.of("jump", "admin", "monitor").collect(Collectors.toCollection(HashSet::new));
    private static final String RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME = "solace";
    private static final String RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME = "kafka";
    private static final String RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME = "activemq";
    private static final Set<String> RUMI_MESSAGE_BROKER_INSTANCE_SHORTNAMES = Stream.of("solace", "kafka", "activemq").collect(Collectors.toCollection(HashSet::new));
    private static final String RUMI_JUMP_SERVER_UPDATE_CONFIG_SCRIPT = "scripts/update_config.sh";
    private static final String RUMI_JUMP_SERVER_COPY_FILE_SCRIPT = "scripts/copy_file.sh";
    private static final String RUMI_JUMP_SERVER_UPLOAD_XAR_SCRIPT = "scripts/upload_xar.sh";
    private static final String RUMI_JUMP_SERVER_MOUNT_DISK_SCRIPT = "scripts/mount_disk.sh";
    private static final String RUMI_JUMP_SERVER_RUN_ADMIN_SCRIPT_SCRIPT = "scripts/run_admin_script.sh";
    private static final String RUMI_JUMP_SERVER_RUN_COMMAND_SCRIPT = "scripts/run_command.sh";
    private static final String RUMI_JUMP_SERVER_MONITOR_POST_LAUNCH_SCRIPT = "scripts/monitor_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_ADMIN_POST_LAUNCH_SCRIPT = "scripts/admin_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_SOLACE_POST_LAUNCH_SCRIPT = "scripts/solace_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_KAFKA_POST_LAUNCH_SCRIPT = "scripts/kafka_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_ACTIVEMQ_POST_LAUNCH_SCRIPT = "scripts/activemq_post_launch.sh";
    private static final String RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT = "scripts/service_post_launch.sh";
    private static final String RUMI_HOSTED_ZONE = "rumi.local";
    private static final String RUMI_HOME_DIR = "/home/rumi";
    private static final String RUMI_STAGING_DIR = "/home/rumi/staging";
    private static final String RUMI_CONTROLLER_CONF_FILE = "/home/rumi/nvx-rumi-agent/data/controller/controller.conf";
    private static final String TAG_NAME_KEY = "Name";
    private static final String TAG_PROVISIONEDBY_KEY = "ProvisionedBy";
    private final String region;
    private final String provisioner;
    private final Tracer tracer;
    private final Ec2Client ec2Client;
    private final Route53Client r53Client;

    private AwsProvisioner(String profile, String region, String provisioner) {
        if (profile == null) {
            throw new IllegalArgumentException("non-null profile must be supplied");
        }
        if (region == null) {
            throw new IllegalArgumentException("non-null region must be supplied");
        }
        this.region = region;
        this.provisioner = provisioner;
        this.tracer = Tracer.get((String)"nv.cloud");
        if (this.tracer.debug) {
            this.tracer.log("Using AWS profile '" + profile + "' in the '" + region + "' region", Tracer.Level.DEBUG);
        }
        this.ec2Client = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)profile))).build();
        this.r53Client = (Route53Client)((Route53ClientBuilder)((Route53ClientBuilder)Route53Client.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)profile))).build();
    }

    public static AwsProvisioner create(String profile, String region, String provisioner) {
        return new AwsProvisioner(profile, region, provisioner);
    }

    public static AwsProvisioner create(String profile, String region) {
        return new AwsProvisioner(profile, region, "Rumi");
    }

    private final String availabilityZone() {
        return this.region + "a";
    }

    private final String waitForInstanceIPs(String instanceId, boolean checkPublicIP) {
        String privateIp = null;
        while (privateIp == null) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            DescribeInstancesResponse describeResponse = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
            Instance instance = (Instance)((Reservation)describeResponse.reservations().get(0)).instances().get(0);
            if (!(instance.state().name() != InstanceStateName.RUNNING || instance.privateIpAddress() == null || checkPublicIP && instance.publicIpAddress() == null)) {
                privateIp = instance.privateIpAddress();
                continue;
            }
            this.tracer.log("Still waiting for IP addresses to be provisioned.", Tracer.Level.VERBOSE);
        }
        return privateIp;
    }

    private final String getVpcSubnetId(String vpcId) {
        DescribeSubnetsResponse response = this.ec2Client.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build()}).build());
        if (!response.subnets().isEmpty()) {
            return ((Subnet)response.subnets().get(0)).subnetId();
        }
        return null;
    }

    private final String fullyQualifiedInstanceName(String instanceShortName, String hostedZoneName) {
        return instanceShortName + "." + (hostedZoneName == null ? RUMI_HOSTED_ZONE : hostedZoneName);
    }

    private final String instanceName(String instanceShortName, String networkName) {
        return networkName + "-" + instanceShortName;
    }

    private final boolean isPlatformInstance(String instanceShortName) {
        return RUMI_PLATFORM_INSTANCE_SHORTNAMES.contains(instanceShortName);
    }

    private final boolean isMessageBrokerInstance(String instanceShortName) {
        return RUMI_MESSAGE_BROKER_INSTANCE_SHORTNAMES.contains(instanceShortName);
    }

    private final String findVpcInstanceByName(String vpcId, String instanceName) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build(), (Filter)Filter.builder().name("tag:Name").values(new String[]{instanceName}).build(), (Filter)Filter.builder().name("tag:ProvisionedBy").values(new String[]{this.provisioner}).build(), (Filter)Filter.builder().name("instance-state-name").values(new String[]{InstanceStateName.PENDING.toString(), InstanceStateName.RUNNING.toString(), InstanceStateName.STOPPING.toString(), InstanceStateName.STOPPED.toString()}).build()}).build());
        return response.reservations().stream().flatMap(reservation -> reservation.instances().stream()).map(Instance::instanceId).findFirst().orElse(null);
    }

    private final String findInstanceByName(String networkName, String instanceName) {
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        return this.findVpcInstanceByName(vpcId, instanceName);
    }

    private final boolean isInstanceInVpc(String vpcId, String instanceName) {
        return this.findVpcInstanceByName(vpcId, instanceName) != null;
    }

    private final List<String> listInstancesInVpc(String vpcId) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build(), (Filter)Filter.builder().name("tag:ProvisionedBy").values(new String[]{this.provisioner}).build()}).build());
        return response.reservations().stream().flatMap(reservation -> reservation.instances().stream()).map(instance -> instance.tags().stream().filter(tag -> tag.key().equals(TAG_NAME_KEY)).map(Tag::value).findFirst().orElse("<noname>")).collect(Collectors.toList());
    }

    private final String getInstancePublicIP(String instanceId) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        return response.reservations().stream().flatMap(reservation -> reservation.instances().stream()).map(Instance::publicIpAddress).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private final void addToHostedZone(String hostedZoneId, String hostedZoneName, String name, String ip) {
        ChangeResourceRecordSetsRequest dnsRequest = (ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(hostedZoneId).changeBatch((ChangeBatch)ChangeBatch.builder().changes(new Change[]{(Change)Change.builder().action(ChangeAction.UPSERT).resourceRecordSet((ResourceRecordSet)ResourceRecordSet.builder().name(this.fullyQualifiedInstanceName(name, hostedZoneName)).type(RRType.A).ttl(Long.valueOf(60L)).resourceRecords(new ResourceRecord[]{(ResourceRecord)ResourceRecord.builder().value(ip).build()}).build()).build()}).build()).build();
        this.r53Client.changeResourceRecordSets(dnsRequest);
    }

    private final String launchInstance(String instanceName, String amiId, InstanceType instanceType, String keyPair, String vpcId, String securityGroupId, String subnetId, boolean assignPublicIP, String hostedZoneId, String hostedZoneName, String nameInHostedZone, String[] additionalNamesInHostedZone, int bootVolumeSize, int rumiVolumeSize) {
        if (this.tracer.verbose) {
            this.tracer.log("Launching instance '" + instanceName + "' (AMI='" + amiId + "').", Tracer.Level.VERBOSE);
        } else {
            this.tracer.log("Launching instance '" + instanceName + "'.", Tracer.Level.INFO);
        }
        ArrayList<Object> blockDeviceMappings = new ArrayList<Object>();
        blockDeviceMappings.add(BlockDeviceMapping.builder().deviceName("/dev/xvda").ebs((EbsBlockDevice)EbsBlockDevice.builder().volumeSize(Integer.valueOf(bootVolumeSize)).deleteOnTermination(Boolean.valueOf(true)).volumeType(VolumeType.GP3).build()).build());
        if (rumiVolumeSize > 0) {
            blockDeviceMappings.add(BlockDeviceMapping.builder().deviceName("/dev/sdb").ebs((EbsBlockDevice)EbsBlockDevice.builder().volumeSize(Integer.valueOf(rumiVolumeSize)).deleteOnTermination(Boolean.valueOf(true)).volumeType(VolumeType.GP3).build()).build());
        }
        RunInstancesResponse response = this.ec2Client.runInstances((RunInstancesRequest)RunInstancesRequest.builder().imageId(amiId).instanceType(instanceType).keyName(keyPair).maxCount(Integer.valueOf(1)).minCount(Integer.valueOf(1)).networkInterfaces(new InstanceNetworkInterfaceSpecification[]{(InstanceNetworkInterfaceSpecification)InstanceNetworkInterfaceSpecification.builder().subnetId(subnetId).associatePublicIpAddress(Boolean.valueOf(assignPublicIP)).deviceIndex(Integer.valueOf(0)).groups(new String[]{securityGroupId}).build()}).blockDeviceMappings(blockDeviceMappings).build());
        String instanceId = ((Instance)response.instances().get(0)).instanceId();
        this.tracer.log("Instance launched. Waiting for launch to complete.", Tracer.Level.INFO);
        String privateIP = this.waitForInstanceIPs(instanceId, assignPublicIP);
        String publicIP = this.getInstancePublicIP(instanceId);
        this.tracer.log("Tagging the instance.", Tracer.Level.INFO);
        CreateTagsRequest tagRequest = (CreateTagsRequest)CreateTagsRequest.builder().resources(new String[]{instanceId}).tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(instanceName).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build();
        this.ec2Client.createTags(tagRequest);
        this.tracer.log("Updating the hosted zone.", Tracer.Level.INFO);
        this.addToHostedZone(hostedZoneId, hostedZoneName, nameInHostedZone, privateIP);
        if (additionalNamesInHostedZone != null) {
            for (String additionalName : additionalNamesInHostedZone) {
                this.addToHostedZone(hostedZoneId, hostedZoneName, additionalName, privateIP);
            }
        }
        this.tracer.log("Instance launched successfully.", Tracer.Level.INFO);
        if (assignPublicIP) {
            this.tracer.log("Instance public IP address is '" + publicIP + "'.", Tracer.Level.INFO);
            if (nameInHostedZone.equals(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME)) {
                this.tracer.log("  This is the jump (bastion) server. You can log into this instance using ssh and the '" + keyPair + "' key pair", Tracer.Level.INFO);
            } else {
                this.tracer.log("  This instance is not open to public access. However, you can ping the instance.", Tracer.Level.INFO);
            }
        } else {
            this.tracer.log(" This instance does not have a public IP address.", Tracer.Level.INFO);
        }
        this.tracer.log("Instance private IP address is " + privateIP + ".", Tracer.Level.INFO);
        this.tracer.log(" This instance can be reached within the VPC using the following names.", Tracer.Level.INFO);
        this.tracer.log("   " + this.fullyQualifiedInstanceName(nameInHostedZone, hostedZoneName), Tracer.Level.INFO);
        if (additionalNamesInHostedZone != null) {
            for (String additionalName : additionalNamesInHostedZone) {
                this.tracer.log("   " + this.fullyQualifiedInstanceName(additionalName, hostedZoneName), Tracer.Level.INFO);
            }
        }
        return instanceId;
    }

    private final String launchInstance(String networkName, String amiId, InstanceType instanceType, String keyPair, String securityGroupName, boolean assignPublicIP, String hostedZoneName, String instanceShortName, String instanceNameInHostedZone, String[] additionalNamesInHostedZone, int bootVolumeSize, int rumiVolumeSize) {
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network name '" + networkName + "'");
        }
        if (!this.validateKeyPair(keyPair)) {
            throw new IllegalArgumentException("invalid key pair '" + keyPair + "'");
        }
        String subnetId = this.getVpcSubnetId(vpcId);
        if (subnetId == null) {
            throw new IllegalArgumentException("no subnet in specified network '" + networkName + "'");
        }
        String securityGroupId = this.findVpcSecurityGroupByName(vpcId, securityGroupName);
        if (securityGroupId == null) {
            throw new IllegalArgumentException("specified network '" + networkName + "' does not have the '" + securityGroupName + "' security group.");
        }
        String hostedZoneId = this.findHostedZone(hostedZoneName, vpcId);
        if (hostedZoneId == null) {
            throw new IllegalArgumentException("specified network '" + networkName + "' is not associated with the '" + hostedZoneName + "' hosted zone.");
        }
        String instanceName = this.instanceName(instanceShortName, networkName);
        if (this.isInstanceInVpc(vpcId, instanceName)) {
            throw new IllegalStateException("an instance with the same name '" + instanceShortName + "' has already been launched in the specified network");
        }
        return this.launchInstance(instanceName, amiId, instanceType, keyPair, vpcId, securityGroupId, subnetId, assignPublicIP, hostedZoneId, hostedZoneName, instanceNameInHostedZone, additionalNamesInHostedZone, bootVolumeSize, rumiVolumeSize);
    }

    private final void startInstance(String networkName, String instanceShortName, String instanceDesc, boolean wait) {
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findVpcInstanceByName(vpcId, this.instanceName(instanceShortName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("the instance '" + instanceShortName + "' has not been provisioned");
        }
        this.tracer.log("Starting the " + instanceDesc + ".", Tracer.Level.INFO);
        this.ec2Client.startInstances((StartInstancesRequest)StartInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        if (wait) {
            this.tracer.log("Waiting for instance to start.", Tracer.Level.INFO);
            this.waitForInstancesToReachState(Collections.singleton(instanceId), InstanceStateName.RUNNING);
        }
        this.tracer.log("Instance started successfully.", Tracer.Level.INFO);
    }

    private final void stopInstance(String networkName, String instanceShortName, String instanceDesc, boolean wait) {
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findVpcInstanceByName(vpcId, this.instanceName(instanceShortName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("the instance '" + instanceShortName + "' has not been provisioned");
        }
        this.tracer.log("Stopping the " + instanceDesc + ".", Tracer.Level.INFO);
        this.ec2Client.stopInstances((StopInstancesRequest)StopInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        if (wait) {
            this.tracer.log("Waiting for instance to stop.", Tracer.Level.INFO);
            this.waitForInstancesToReachState(Collections.singleton(instanceId), InstanceStateName.STOPPED);
        }
        this.tracer.log("Instance stopped successfully", Tracer.Level.INFO);
    }

    private final void terminateInstance(String networkName, String instanceShortName, String instanceDesc, boolean wait) {
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findVpcInstanceByName(vpcId, this.instanceName(instanceShortName, networkName));
        if (instanceId != null) {
            this.tracer.log("Terminating the " + instanceDesc + ".", Tracer.Level.INFO);
            this.ec2Client.terminateInstances((TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
            if (wait) {
                this.tracer.log("Waiting for instance to terminate", Tracer.Level.INFO);
                this.waitForInstancesToReachState(Collections.singleton(instanceId), InstanceStateName.TERMINATED);
            }
            this.tracer.log("Instance terminated successfully", Tracer.Level.INFO);
        } else {
            this.tracer.log("The " + instanceDesc + " does not exist.", Tracer.Level.INFO);
        }
    }

    private final String findVpcByName(String vpcName) {
        DescribeVpcsResponse response = this.ec2Client.describeVpcs((DescribeVpcsRequest)DescribeVpcsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("tag:Name").values(new String[]{vpcName}).build(), (Filter)Filter.builder().name("tag:ProvisionedBy").values(new String[]{this.provisioner}).build()}).build());
        return response.vpcs().stream().findFirst().map(Vpc::vpcId).orElse(null);
    }

    private final Set<String> terminateAllInstancesInVpc(String vpcId) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build()}).build());
        HashSet<String> instanceIds = new HashSet<String>();
        for (Reservation reservation : response.reservations()) {
            for (Instance instance : reservation.instances()) {
                if (instance.state().name().equals((Object)InstanceStateName.TERMINATED)) continue;
                instanceIds.add(instance.instanceId());
            }
        }
        if (!instanceIds.isEmpty()) {
            this.ec2Client.terminateInstances((TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(instanceIds).build());
        }
        this.tracer.log("Terminated " + instanceIds.size() + " instances", Tracer.Level.VERBOSE);
        return instanceIds;
    }

    private final InstanceStateName getInstanceState(String instanceId) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        return response.reservations().stream().flatMap(reservation -> reservation.instances().stream()).map(instance -> instance.state().name()).findFirst().orElse(null);
    }

    private final void waitForInstancesToReachState(Set<String> instanceIds, InstanceStateName instanceStateName) {
        if (!instanceIds.isEmpty()) {
            boolean allTerminated = false;
            while (!allTerminated) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                DescribeInstancesResponse instanceResponse = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(instanceIds).build());
                allTerminated = instanceResponse.reservations().stream().flatMap(reservation -> reservation.instances().stream()).allMatch(instance -> instance.state().name().equals((Object)instanceStateName));
            }
        }
    }

    private final boolean hostedZoneIsAssociatedWithVpc(String hostedZoneId, String vpcId) {
        GetHostedZoneResponse zoneDetails = this.r53Client.getHostedZone((GetHostedZoneRequest)GetHostedZoneRequest.builder().id(hostedZoneId).build());
        for (VPC vpc : zoneDetails.vpCs()) {
            if (!vpc.vpcId().equals(vpcId)) continue;
            return true;
        }
        return false;
    }

    private final boolean hostedZoneIsProvisionedByRumi(String hostedZoneId) {
        ListTagsForResourceResponse tagResponse = this.r53Client.listTagsForResource((ListTagsForResourceRequest)ListTagsForResourceRequest.builder().resourceType(TagResourceType.HOSTEDZONE).resourceId(hostedZoneId).build());
        return tagResponse.resourceTagSet().tags().stream().anyMatch(tag -> tag.key().equals(TAG_PROVISIONEDBY_KEY) && tag.value().equals(this.provisioner));
    }

    private final String findHostedZone(String hostedZoneName, String vpcId) {
        return this.r53Client.listHostedZones().hostedZones().stream().filter(zone -> zone.name().equalsIgnoreCase(hostedZoneName + ".") && this.hostedZoneIsProvisionedByRumi(zone.id()) && this.hostedZoneIsAssociatedWithVpc(zone.id(), vpcId)).map(zone -> zone.id()).findFirst().orElse(null);
    }

    private final List<String> listHostedZones(String vpcId) {
        return this.r53Client.listHostedZones().hostedZones().stream().filter(zone -> this.hostedZoneIsProvisionedByRumi(zone.id()) && this.hostedZoneIsAssociatedWithVpc(zone.id(), vpcId)).map(zone -> {
            String name = zone.name();
            return name.endsWith(".") ? name.substring(0, name.length() - 1) : name;
        }).collect(Collectors.toList());
    }

    private final void createAndAssociateHostedZone(String vpcId, String hostedZoneName) {
        String hostedZoneId = null;
        this.tracer.log("...creating private hosted zone '" + hostedZoneName + "'.", Tracer.Level.VERBOSE);
        hostedZoneId = this.findHostedZone(hostedZoneName, vpcId);
        if (hostedZoneId == null) {
            CreateHostedZoneResponse createResponse = this.r53Client.createHostedZone((CreateHostedZoneRequest)CreateHostedZoneRequest.builder().name(hostedZoneName).vpc((VPC)VPC.builder().vpcId(vpcId).vpcRegion(this.region).build()).callerReference(String.valueOf(System.currentTimeMillis())).hostedZoneConfig((HostedZoneConfig)HostedZoneConfig.builder().privateZone(Boolean.valueOf(true)).build()).build());
            hostedZoneId = createResponse.hostedZone().id();
            this.r53Client.changeTagsForResource((ChangeTagsForResourceRequest)ChangeTagsForResourceRequest.builder().resourceType(TagResourceType.HOSTEDZONE).resourceId(hostedZoneId).addTags(new software.amazon.awssdk.services.route53.model.Tag[]{(software.amazon.awssdk.services.route53.model.Tag)software.amazon.awssdk.services.route53.model.Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build());
        } else {
            this.tracer.log("...zone already exists.", Tracer.Level.VERBOSE);
        }
    }

    private final void deleteAllHostedZoneRecords(String hostedZoneId) {
        ListResourceRecordSetsResponse listResponse = this.r53Client.listResourceRecordSets((ListResourceRecordSetsRequest)ListResourceRecordSetsRequest.builder().hostedZoneId(hostedZoneId).build());
        for (ResourceRecordSet recordSet : listResponse.resourceRecordSets()) {
            if (recordSet.type().equals((Object)RRType.SOA) || recordSet.type().equals((Object)RRType.NS)) continue;
            ChangeBatch changeBatch = (ChangeBatch)ChangeBatch.builder().changes(new Change[]{(Change)Change.builder().action(ChangeAction.DELETE).resourceRecordSet(recordSet).build()}).build();
            ChangeResourceRecordSetsRequest deleteRequest = (ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(hostedZoneId).changeBatch(changeBatch).build();
            this.r53Client.changeResourceRecordSets(deleteRequest);
        }
    }

    private final void disassociateAndDeleteHostedZones(String vpcId) {
        for (String hostedZoneName : this.listHostedZones(vpcId)) {
            String hostedZoneId = this.findHostedZone(hostedZoneName, vpcId);
            if (hostedZoneId == null) continue;
            this.tracer.log("...deleting hosted zone '" + hostedZoneName + "'", Tracer.Level.VERBOSE);
            this.deleteAllHostedZoneRecords(hostedZoneId);
            this.r53Client.deleteHostedZone((DeleteHostedZoneRequest)DeleteHostedZoneRequest.builder().id(hostedZoneId).build());
        }
    }

    final String createVpcInternetGateway(String vpcId, String igwName) {
        this.tracer.log("...creating internet gateway '" + igwName + "'.", Tracer.Level.VERBOSE);
        CreateInternetGatewayResponse igwResponse = this.ec2Client.createInternetGateway((CreateInternetGatewayRequest)CreateInternetGatewayRequest.builder().build());
        String igwId = igwResponse.internetGateway().internetGatewayId();
        this.ec2Client.createTags((CreateTagsRequest)CreateTagsRequest.builder().resources(new String[]{igwId}).tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(igwName).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build());
        this.ec2Client.attachInternetGateway((AttachInternetGatewayRequest)AttachInternetGatewayRequest.builder().internetGatewayId(igwId).vpcId(vpcId).build());
        return igwId;
    }

    private final void deleteVpcInternetGateway(String vpcId) {
        DescribeInternetGatewaysResponse response = this.ec2Client.describeInternetGateways();
        for (InternetGateway igw : response.internetGateways()) {
            boolean attachedToVpc = igw.attachments().stream().anyMatch(a -> a.vpcId().equals(vpcId));
            if (!attachedToVpc) continue;
            String igwName = igw.tags().stream().filter(tag -> tag.key().equals(TAG_NAME_KEY)).map(Tag::value).findFirst().orElse("<noname>");
            this.tracer.log("...deleting internet gateway '" + igwName + "'", Tracer.Level.VERBOSE);
            this.ec2Client.detachInternetGateway((DetachInternetGatewayRequest)DetachInternetGatewayRequest.builder().internetGatewayId(igw.internetGatewayId()).vpcId(vpcId).build());
            this.ec2Client.deleteInternetGateway((DeleteInternetGatewayRequest)DeleteInternetGatewayRequest.builder().internetGatewayId(igw.internetGatewayId()).build());
        }
    }

    private final void waitForNatGatewayDeletion(String natGatewayId) {
        boolean isDeleted = false;
        while (!isDeleted) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            isDeleted = this.ec2Client.describeNatGateways((DescribeNatGatewaysRequest)DescribeNatGatewaysRequest.builder().natGatewayIds(new String[]{natGatewayId}).build()).natGateways().stream().allMatch(gateway -> gateway.state().equals((Object)NatGatewayState.DELETED));
        }
    }

    private final void deleteVpcNatGateways(String vpcId) {
        DescribeNatGatewaysResponse response = this.ec2Client.describeNatGateways((DescribeNatGatewaysRequest)DescribeNatGatewaysRequest.builder().filter(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build()}).build());
        List natGatewayIds = response.natGateways().stream().map(NatGateway::natGatewayId).collect(Collectors.toList());
        if (!natGatewayIds.isEmpty()) {
            for (String natGatewayId : natGatewayIds) {
                this.tracer.log("...deleting NAT gateway '" + natGatewayId + "'.", Tracer.Level.VERBOSE);
                this.ec2Client.deleteNatGateway((DeleteNatGatewayRequest)DeleteNatGatewayRequest.builder().natGatewayId(natGatewayId).build());
                this.waitForNatGatewayDeletion(natGatewayId);
            }
        }
    }

    final String createVpcRouteTable(String vpcId, String routeTableName) {
        this.tracer.log("...creating route table '" + routeTableName + "'.", Tracer.Level.VERBOSE);
        CreateRouteTableResponse routeTableResponse = this.ec2Client.createRouteTable((CreateRouteTableRequest)CreateRouteTableRequest.builder().vpcId(vpcId).build());
        String routeTableId = routeTableResponse.routeTable().routeTableId();
        this.ec2Client.createTags((CreateTagsRequest)CreateTagsRequest.builder().resources(new String[]{routeTableId}).tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(routeTableName).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build());
        return routeTableId;
    }

    private final void deleteVpcRouteTables(String vpcId) {
        DescribeRouteTablesResponse response = this.ec2Client.describeRouteTables();
        for (RouteTable routeTable : response.routeTables()) {
            if (!routeTable.vpcId().equals(vpcId)) continue;
            String routeTableName = routeTable.tags().stream().filter(tag -> tag.key().equals(TAG_NAME_KEY)).map(Tag::value).findFirst().orElse("<noname>");
            boolean mainRouteTable = false;
            for (RouteTableAssociation association : routeTable.associations()) {
                if (!association.main().booleanValue()) {
                    this.ec2Client.disassociateRouteTable((DisassociateRouteTableRequest)DisassociateRouteTableRequest.builder().associationId(association.routeTableAssociationId()).build());
                    continue;
                }
                mainRouteTable = true;
            }
            if (mainRouteTable) continue;
            this.tracer.log("...deleting route table '" + routeTableName + "' (id=" + routeTable.routeTableId() + ")", Tracer.Level.VERBOSE);
            this.ec2Client.deleteRouteTable((DeleteRouteTableRequest)DeleteRouteTableRequest.builder().routeTableId(routeTable.routeTableId()).build());
        }
    }

    final String createVpcSubnet(String vpcId, String subnetName, String cidrBlock, String availabilityZone) {
        this.tracer.log("...creating public subnet '" + subnetName + "' (AZ=" + availabilityZone + ").", Tracer.Level.VERBOSE);
        CreateSubnetResponse subnetResponse = this.ec2Client.createSubnet((CreateSubnetRequest)CreateSubnetRequest.builder().vpcId(vpcId).cidrBlock(cidrBlock).availabilityZone(availabilityZone).build());
        String subnetId = subnetResponse.subnet().subnetId();
        this.ec2Client.createTags((CreateTagsRequest)CreateTagsRequest.builder().resources(new String[]{subnetId}).tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(subnetName).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build());
        return subnetId;
    }

    private final void deleteVpcSubnets(String vpcId) {
        DescribeSubnetsResponse response = this.ec2Client.describeSubnets();
        for (Subnet subnet : response.subnets()) {
            if (!subnet.vpcId().equals(vpcId)) continue;
            String subnetName = subnet.tags().stream().filter(tag -> tag.key().equals(TAG_NAME_KEY)).map(Tag::value).findFirst().orElse("<noname>");
            this.tracer.log("...deleting subnet '" + subnetName + "'", Tracer.Level.VERBOSE);
            this.ec2Client.deleteSubnet((DeleteSubnetRequest)DeleteSubnetRequest.builder().subnetId(subnet.subnetId()).build());
        }
    }

    private final String jumpServerSecurityGroupName(String networkName) {
        return networkName + "-rumi-jump-sg";
    }

    private final String createJumpServerSecurityGroup(String name, String vpcId, List<Integer> ports) {
        String groupName = this.jumpServerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Jump (Bastion) server";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Jump (Bastion) server").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        List<Integer> effectivePorts = ports != null ? ports : Arrays.asList(8001, 3000, 8080, 8161, 8162, 9094);
        ArrayList<Object> ipPermissions = new ArrayList<Object>();
        for (Integer port : effectivePorts) {
            ipPermissions.add(IpPermission.builder().ipProtocol("tcp").fromPort(port).toPort(port).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow TCP " + port + " from anywhere").build()}).build());
        }
        ipPermissions.add(IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow SSH from anywhere").build()}).build());
        ipPermissions.add(IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build());
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(ipPermissions).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String adminServerSecurityGroupName(String networkName) {
        return networkName + "-rumi-admin-sg";
    }

    private final String createAdminServerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.adminServerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Admin server";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Admin server").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8001)).toPort(Integer.valueOf(8001)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8001 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8161)).toPort(Integer.valueOf(8161)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8161 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8086)).toPort(Integer.valueOf(8086)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8086 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(7778)).toPort(Integer.valueOf(7778)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 7778 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8083)).toPort(Integer.valueOf(8083)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8083 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(61616)).toPort(Integer.valueOf(61616)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 61616 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String monitorServerSecurityGroupName(String networkName) {
        return networkName + "-rumi-monitor-sg";
    }

    private final String createMonitorServerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.monitorServerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Monitor server";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Monitor server").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(3000)).toPort(Integer.valueOf(3000)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 3000 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String solaceBrokerSecurityGroupName(String networkName) {
        return networkName + "-rumi-solace-sg";
    }

    private final String createSolaceBrokerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.solaceBrokerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Messaging Server (Solace)";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Messaging Server (Solace)").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8080)).toPort(Integer.valueOf(8080)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8080 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(2222)).toPort(Integer.valueOf(2222)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 2222 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(55003)).toPort(Integer.valueOf(55003)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 55003 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(55443)).toPort(Integer.valueOf(55443)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 55443 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(55555)).toPort(Integer.valueOf(55556)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 55555-55556 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String kafkaBrokerSecurityGroupName(String networkName) {
        return networkName + "-rumi-kafka-sg";
    }

    private final String createKafkaBrokerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.kafkaBrokerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Messaging Server (Kafka)";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Messaging Server (Kafka)").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(9092)).toPort(Integer.valueOf(9094)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8080 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String activeMQBrokerSecurityGroupName(String networkName) {
        return networkName + "-rumi-activemq-sg";
    }

    private final String createActiveMQBrokerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.activeMQBrokerSecurityGroupName(name);
        String description = "Allows necessary access for the Rumi Messaging Server (ActiveMQ)";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Allows necessary access for the Rumi Messaging Server (ActiveMQ)").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(8161)).toPort(Integer.valueOf(8161)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 8161 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(61616)).toPort(Integer.valueOf(61616)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow TCP 61616 within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String serviceWorkerSecurityGroupName(String networkName) {
        return networkName + "-rumi-worker-sg";
    }

    private final String createServiceWorkerSecurityGroup(String name, String vpcId, String vpcCidrBlock) {
        String groupName = this.serviceWorkerSecurityGroupName(name);
        String description = "Security Group to be used with Rumi Service Instances";
        CreateSecurityGroupResponse sgResponse = this.ec2Client.createSecurityGroup((CreateSecurityGroupRequest)CreateSecurityGroupRequest.builder().groupName(groupName).description("Security Group to be used with Rumi Service Instances").vpcId(vpcId).build());
        String securityGroupId = sgResponse.groupId();
        AuthorizeSecurityGroupIngressRequest ingressRequest = (AuthorizeSecurityGroupIngressRequest)AuthorizeSecurityGroupIngressRequest.builder().groupId(securityGroupId).ipPermissions(new IpPermission[]{(IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(0)).toPort(Integer.valueOf(65535)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow all TCP within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("tcp").fromPort(Integer.valueOf(22)).toPort(Integer.valueOf(22)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp(vpcCidrBlock).description("Allow SSH within VPC").build()}).build(), (IpPermission)IpPermission.builder().ipProtocol("icmp").fromPort(Integer.valueOf(8)).toPort(Integer.valueOf(-1)).ipRanges(new IpRange[]{(IpRange)IpRange.builder().cidrIp("0.0.0.0/0").description("Allow ICMP Echo Request from anywhere").build()}).build()}).build();
        this.ec2Client.authorizeSecurityGroupIngress(ingressRequest);
        return securityGroupId;
    }

    private final String findVpcSecurityGroupByName(String vpcId, String groupName) {
        DescribeSecurityGroupsResponse response = this.ec2Client.describeSecurityGroups((DescribeSecurityGroupsRequest)DescribeSecurityGroupsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build(), (Filter)Filter.builder().name("group-name").values(new String[]{groupName}).build()}).build());
        if (!response.securityGroups().isEmpty()) {
            return ((SecurityGroup)response.securityGroups().get(0)).groupId();
        }
        return null;
    }

    private final void deleteVpcSecurityGroups(String vpcId) {
        DescribeSecurityGroupsResponse response = this.ec2Client.describeSecurityGroups((DescribeSecurityGroupsRequest)DescribeSecurityGroupsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(new String[]{vpcId}).build()}).build());
        for (SecurityGroup sg : response.securityGroups()) {
            if (sg.groupName().equals("default")) continue;
            this.ec2Client.deleteSecurityGroup((DeleteSecurityGroupRequest)DeleteSecurityGroupRequest.builder().groupId(sg.groupId()).build());
        }
    }

    private final String enableVpcDnsSettings(String vpcId) {
        ModifyVpcAttributeRequest dnsSupportRequest = (ModifyVpcAttributeRequest)ModifyVpcAttributeRequest.builder().vpcId(vpcId).enableDnsSupport((AttributeBooleanValue)AttributeBooleanValue.builder().value(Boolean.valueOf(true)).build()).build();
        this.ec2Client.modifyVpcAttribute(dnsSupportRequest);
        ModifyVpcAttributeRequest dnsHostnamesRequest = (ModifyVpcAttributeRequest)ModifyVpcAttributeRequest.builder().vpcId(vpcId).enableDnsHostnames((AttributeBooleanValue)AttributeBooleanValue.builder().value(Boolean.valueOf(true)).build()).build();
        this.ec2Client.modifyVpcAttribute(dnsHostnamesRequest);
        return vpcId;
    }

    private final String networkNameToVpcName(String networkName) {
        return networkName + "-vpc";
    }

    private final String createVpc(String vpcName, String cidrBlock) {
        CreateVpcResponse vpcResponse = this.ec2Client.createVpc((CreateVpcRequest)CreateVpcRequest.builder().cidrBlock(cidrBlock).build());
        String vpcId = vpcResponse.vpc().vpcId();
        this.ec2Client.createTags((CreateTagsRequest)CreateTagsRequest.builder().resources(new String[]{vpcId}).tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(vpcName).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build());
        return this.enableVpcDnsSettings(vpcId);
    }

    private final List<String> listVpcs() {
        DescribeVpcsResponse response = this.ec2Client.describeVpcs((DescribeVpcsRequest)DescribeVpcsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("tag:ProvisionedBy").values(new String[]{this.provisioner}).build()}).build());
        return response.vpcs().stream().map(vpc -> {
            String vpcName = vpc.tags().stream().filter(tag -> tag.key().equals(TAG_NAME_KEY)).map(Tag::value).findFirst().orElse("<noname>");
            return vpcName;
        }).collect(Collectors.toList());
    }

    private final void deleteVpc(String vpcId) {
        this.ec2Client.deleteVpc((DeleteVpcRequest)DeleteVpcRequest.builder().vpcId(vpcId).build());
    }

    private final boolean validateKeyPair(String keyPairName) {
        try {
            DescribeKeyPairsResponse response = this.ec2Client.describeKeyPairs((DescribeKeyPairsRequest)DescribeKeyPairsRequest.builder().keyNames(new String[]{keyPairName}).build());
            return !response.keyPairs().isEmpty();
        }
        catch (Ec2Exception e) {
            return false;
        }
    }

    private final void waitForVolumeToBecomeAvailable(String volumeId) {
        boolean isAvailable = false;
        while (!isAvailable) {
            DescribeVolumesResponse describeResponse = this.ec2Client.describeVolumes((DescribeVolumesRequest)DescribeVolumesRequest.builder().volumeIds(new String[]{volumeId}).build());
            isAvailable = describeResponse.volumes().stream().anyMatch(volume -> volume.state() == VolumeState.AVAILABLE);
            if (isAvailable) continue;
            try {
                this.tracer.log("...still waiting for volume to become available.", Tracer.Level.VERBOSE);
                Thread.sleep(Duration.ofSeconds(5L).toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private final String createEBSVolume(String name, VolumeType type, String snapshotId, String availabilityZone, int sizeInGib, boolean wait) {
        this.tracer.log("...creating the " + sizeInGib + "Gib volume (type='" + type + "').", Tracer.Level.VERBOSE);
        CreateVolumeRequest.Builder requestBuilder = CreateVolumeRequest.builder().availabilityZone(availabilityZone).volumeType(type).size(Integer.valueOf(sizeInGib)).tagSpecifications(new TagSpecification[]{(TagSpecification)TagSpecification.builder().resourceType("volume").tags(new Tag[]{(Tag)Tag.builder().key(TAG_NAME_KEY).value(name == null ? "<Noname>" : name).build(), (Tag)Tag.builder().key(TAG_PROVISIONEDBY_KEY).value(this.provisioner).build()}).build()});
        if (snapshotId != null) {
            requestBuilder.snapshotId(snapshotId);
        }
        String volumeId = this.ec2Client.createVolume((CreateVolumeRequest)requestBuilder.build()).volumeId();
        if (wait) {
            this.tracer.log("...waiting for volume to become available.", Tracer.Level.VERBOSE);
            this.waitForVolumeToBecomeAvailable(volumeId);
        }
        return volumeId;
    }

    private final String getActualDeviceName(String instanceId, String volumeId) {
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        for (Reservation reservation : response.reservations()) {
            for (Instance instance : reservation.instances()) {
                List blockDevices = instance.blockDeviceMappings();
                for (InstanceBlockDeviceMapping mapping : blockDevices) {
                    if (mapping.ebs() == null || !mapping.ebs().volumeId().equals(volumeId)) continue;
                    return mapping.deviceName();
                }
            }
        }
        return null;
    }

    private final String getNextAvailableDeviceName(String instanceId) {
        char[] possibleDevices;
        DescribeInstancesResponse response = this.ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{instanceId}).build());
        HashSet<String> usedDevices = new HashSet<String>();
        for (Reservation reservation : response.reservations()) {
            for (Instance instance : reservation.instances()) {
                for (InstanceBlockDeviceMapping mapping : instance.blockDeviceMappings()) {
                    usedDevices.add(mapping.deviceName());
                }
            }
        }
        for (char letter : possibleDevices = "fghijklmnopqrstuvwxyz".toCharArray()) {
            String candidate = "/dev/sd" + letter;
            if (usedDevices.contains(candidate)) continue;
            return candidate;
        }
        throw new IllegalStateException("unable to find an available device name for the additional volume!");
    }

    private final void modifyDeleteOnTermination(String instanceId, String volumeId, String deviceName) {
        InstanceBlockDeviceMappingSpecification blockDeviceMapping = (InstanceBlockDeviceMappingSpecification)InstanceBlockDeviceMappingSpecification.builder().deviceName(deviceName).ebs((EbsInstanceBlockDeviceSpecification)EbsInstanceBlockDeviceSpecification.builder().volumeId(volumeId).deleteOnTermination(Boolean.valueOf(true)).build()).build();
        this.ec2Client.modifyInstanceAttribute((ModifyInstanceAttributeRequest)ModifyInstanceAttributeRequest.builder().instanceId(instanceId).blockDeviceMappings(new InstanceBlockDeviceMappingSpecification[]{blockDeviceMapping}).build());
    }

    private final String attachVolumeToInstance(String volumeId, String instanceId) {
        this.tracer.log("...attaching the volume to instance.", Tracer.Level.VERBOSE);
        String deviceName = this.getNextAvailableDeviceName(instanceId);
        this.ec2Client.attachVolume((AttachVolumeRequest)AttachVolumeRequest.builder().volumeId(volumeId).instanceId(instanceId).device(deviceName).build());
        this.modifyDeleteOnTermination(instanceId, volumeId, deviceName);
        return this.getActualDeviceName(instanceId, volumeId);
    }

    private final String isJumpServerRunning(String networkName) {
        String instanceId = this.findInstanceByName(networkName, this.instanceName(RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, networkName));
        if (instanceId != null && this.getInstanceState(instanceId) == InstanceStateName.RUNNING) {
            return instanceId;
        }
        return null;
    }

    private final void copyFileToJumpServer(String networkName, String keyPair, String sourceFile, String targetDir, String targetFilePermissions) {
        String instanceId = this.isJumpServerRunning(networkName);
        if (instanceId == null) {
            throw new IllegalStateException("jump server is either not provisioned or running");
        }
        Helper.copyFileToServer(this.getInstancePublicIP(instanceId), keyPair, sourceFile, targetDir, targetFilePermissions, this.tracer);
    }

    private final void executeScriptOnJumpServer(String networkName, String keyPair, String scriptFilename, String[] scriptArgs) {
        String instanceId = this.isJumpServerRunning(networkName);
        if (instanceId == null) {
            throw new IllegalStateException("jump server is either not provisioned or running");
        }
        Helper.executeScriptOnServer(this.getInstancePublicIP(instanceId), keyPair, scriptFilename, scriptArgs, this.tracer);
    }

    public final void createNetwork(String name, String networkAddress, List<Integer> firewallPorts) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (networkAddress == null) {
            throw new IllegalArgumentException("network address cannot be null");
        }
        if (networkAddress.split("\\.").length != 2) {
            throw new IllegalArgumentException("network address ('" + networkAddress + "') must be of the form x.y (this is expanded to CIDR block of x.y.0.0/16)");
        }
        String vpcName = this.networkNameToVpcName(name);
        if (this.tracer.debug) {
            this.tracer.log("Verifying network '" + name + " does not already exist", Tracer.Level.DEBUG);
        }
        if (this.findVpcByName(vpcName) != null) {
            throw new IllegalArgumentException("the network '" + name + "' already exists");
        }
        String vpcCidrBlock = networkAddress + ".0.0/16";
        String publicSubnetCidrBlock = networkAddress + ".1.0/24";
        this.tracer.log("Creating VPC '" + vpcName + "' (CIDR block " + vpcCidrBlock + ").", Tracer.Level.INFO);
        String vpcId = this.createVpc(vpcName, vpcCidrBlock);
        this.tracer.log("Creating security groups.", Tracer.Level.INFO);
        this.tracer.log("...jump server.", Tracer.Level.VERBOSE);
        this.createJumpServerSecurityGroup(name, vpcId, firewallPorts);
        this.tracer.log("...admin server.", Tracer.Level.VERBOSE);
        this.createAdminServerSecurityGroup(name, vpcId, vpcCidrBlock);
        this.tracer.log("...monitor server.", Tracer.Level.VERBOSE);
        this.createMonitorServerSecurityGroup(name, vpcId, vpcCidrBlock);
        this.tracer.log("...solace broker.", Tracer.Level.VERBOSE);
        this.createSolaceBrokerSecurityGroup(name, vpcId, vpcCidrBlock);
        this.tracer.log("...kafka broker.", Tracer.Level.VERBOSE);
        this.createKafkaBrokerSecurityGroup(name, vpcId, vpcCidrBlock);
        this.tracer.log("...activeMQ broker.", Tracer.Level.VERBOSE);
        this.createActiveMQBrokerSecurityGroup(name, vpcId, vpcCidrBlock);
        this.tracer.log("...service worker.", Tracer.Level.VERBOSE);
        this.createServiceWorkerSecurityGroup(name, vpcId, vpcCidrBlock);
        String publicSubnetName = name + "-subnet-public";
        String availabilityZone = this.availabilityZone();
        this.tracer.log("Creating subnets.", Tracer.Level.INFO);
        String publicSubnetId = this.createVpcSubnet(vpcId, publicSubnetName, publicSubnetCidrBlock, availabilityZone);
        String igwName = name + "-igw";
        this.tracer.log("Creating internet gateway.", Tracer.Level.INFO);
        String igwId = this.createVpcInternetGateway(vpcId, igwName);
        String rtbPublicName = name + "-rtb-public";
        this.tracer.log("Creating route tables.", Tracer.Level.INFO);
        String rtbPublicId = this.createVpcRouteTable(vpcId, rtbPublicName);
        this.ec2Client.createRoute((CreateRouteRequest)CreateRouteRequest.builder().routeTableId(rtbPublicId).destinationCidrBlock("0.0.0.0/0").gatewayId(igwId).build());
        this.ec2Client.associateRouteTable((AssociateRouteTableRequest)AssociateRouteTableRequest.builder().subnetId(publicSubnetId).routeTableId(rtbPublicId).build());
        this.tracer.log("Creating private hosted zones.", Tracer.Level.INFO);
        this.createAndAssociateHostedZone(vpcId, RUMI_HOSTED_ZONE);
        this.tracer.log("Network created successfully.", Tracer.Level.INFO);
    }

    public final void createNetwork(String name, String networkAddress) {
        this.createNetwork(name, networkAddress, null);
    }

    public final void createHostedZone(String networkName, String hostedZoneName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (hostedZoneName == null) {
            throw new IllegalArgumentException("zone name cannot be null");
        }
        String vpcName = this.networkNameToVpcName(networkName);
        String vpcId = this.findVpcByName(vpcName);
        if (vpcId == null) {
            throw new IllegalArgumentException("The '" + networkName + "' network does not exist or is not a Rumi managed network");
        }
        this.tracer.log("Creating private hosted zone.", Tracer.Level.INFO);
        this.createAndAssociateHostedZone(vpcId, hostedZoneName);
    }

    public final List<String> getHostedZones(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        String vpcName = this.networkNameToVpcName(networkName);
        String vpcId = this.findVpcByName(vpcName);
        if (vpcId == null) {
            throw new IllegalArgumentException("The '" + networkName + "' network does not exist or is not a Rumi managed network");
        }
        return this.listHostedZones(vpcId);
    }

    public final AwsProvisioner launchJumpServer(String networkName, String keyPair) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        String instancePublicIp = this.getInstancePublicIP(this.launchInstance(networkName, "ami-0df3fd4a1c610f37b", RUMI_JUMP_SERVER_INSTANCE_TYPE, keyPair, this.jumpServerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, new String[]{"bastion"}, 8, 8));
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        Helper.copyPrivateKeyToServer(instancePublicIp, keyPair, this.tracer);
        this.tracer.log("Jump server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final String getJumpServerPublicIP(String networkName) {
        String instanceId = this.isJumpServerRunning(networkName);
        if (instanceId == null) {
            throw new IllegalStateException("jump server is either not provisioned or running");
        }
        return this.getInstancePublicIP(instanceId);
    }

    public final AwsProvisioner startJumpServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, "jump server", wait);
        return this;
    }

    public final AwsProvisioner stopJumpServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, "jump server", wait);
        return this;
    }

    public final AwsProvisioner terminateJumpServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_JUMP_SERVER_INSTANCE_SHORTNAME, "jump server", wait);
        return this;
    }

    public final AwsProvisioner launchAdminServer(String networkName, String keyPair, PlatformServiceProxyInfo adminProxyInfo, PlatformServiceProxyInfo discoveryProxyInfo) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        this.launchInstance(networkName, "ami-0854cef1cb9021944", RUMI_ADMIN_SERVER_INSTANCE_TYPE, keyPair, this.adminServerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, new String[]{"discovery", "influxdb", "agent"}, 8, 32);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (adminProxyInfo != null) {
            if (adminProxyInfo.proxyPort > 0) {
                scriptArgs.add("--admin-proxy-port");
                scriptArgs.add(String.valueOf(adminProxyInfo.proxyPort));
            }
            if (adminProxyInfo.proxyServer != null) {
                scriptArgs.add("--admin-proxy-server");
                scriptArgs.add(adminProxyInfo.proxyServer);
            }
        }
        if (discoveryProxyInfo != null) {
            if (discoveryProxyInfo.proxyPort > 0) {
                scriptArgs.add("--discovery-proxy-port");
                scriptArgs.add(String.valueOf(discoveryProxyInfo.proxyPort));
            }
            if (discoveryProxyInfo.proxyServer != null) {
                scriptArgs.add("--discovery-proxy-server");
                scriptArgs.add(discoveryProxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_ADMIN_POST_LAUNCH_SCRIPT, scriptArgs.size() > 0 ? scriptArgs.toArray(new String[scriptArgs.size()]) : null);
        this.tracer.log("Admin server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner launchAdminServer(String networkName, String keyPair) {
        return this.launchAdminServer(networkName, keyPair, null, null);
    }

    public final AwsProvisioner runAdminScript(String networkName, String keyPair, String system, String script, String params) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (system == null) {
            throw new IllegalArgumentException("system name cannot be null");
        }
        if (script == null) {
            throw new IllegalArgumentException("script name cannot be null");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        this.tracer.log("Executing admin script '" + script + "' on the '" + system + "' system with '" + params + "'.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_RUN_ADMIN_SCRIPT_SCRIPT, new String[]{"--system", system, "--script", script, "--param", params == null ? "dummy=value" : params});
        this.tracer.log("Successfully run admin script.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner startAdminServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, "admin server", wait);
        return this;
    }

    public final AwsProvisioner stopAdminServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, "admin server", wait);
        return this;
    }

    public final AwsProvisioner terminateAdminServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, "admin server", wait);
        return this;
    }

    public final AwsProvisioner launchMonitorServer(String networkName, String keyPair, PlatformServiceProxyInfo proxyInfo) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        this.launchInstance(networkName, "ami-0dee1629c94b67043", RUMI_MONITOR_SERVER_INSTANCE_TYPE, keyPair, this.monitorServerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, null, 8, 16);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (proxyInfo != null) {
            if (proxyInfo.proxyPort > 0) {
                scriptArgs.add("--proxy-port");
                scriptArgs.add(String.valueOf(proxyInfo.proxyPort));
            }
            if (proxyInfo.proxyServer != null) {
                scriptArgs.add("--proxy-server");
                scriptArgs.add(proxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_MONITOR_POST_LAUNCH_SCRIPT, scriptArgs.size() > 0 ? scriptArgs.toArray(new String[scriptArgs.size()]) : null);
        this.tracer.log("Monitor server launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner launchMonitorServer(String networkName, String keyPair) {
        return this.launchMonitorServer(networkName, keyPair, null);
    }

    public final AwsProvisioner startMonitorServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, "monitor server", wait);
        return this;
    }

    public final AwsProvisioner stopMonitorServer(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, "monitor server", wait);
        return this;
    }

    public final AwsProvisioner terminateMonitorServer(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_MONITOR_SERVER_INSTANCE_SHORTNAME, "monitor server", wait);
        return this;
    }

    public final AwsProvisioner launchSolaceBroker(String networkName, String keyPair, PlatformServiceProxyInfo proxyInfo) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        this.launchInstance(networkName, "ami-022ffbdfdc14378ba", RUMI_SOLACE_BROKER_INSTANCE_TYPE, keyPair, this.solaceBrokerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, null, 32, 0);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (proxyInfo != null) {
            if (proxyInfo.proxyPort > 0) {
                scriptArgs.add("--proxy-port");
                scriptArgs.add(String.valueOf(proxyInfo.proxyPort));
            }
            if (proxyInfo.proxyServer != null) {
                scriptArgs.add("--proxy-server");
                scriptArgs.add(proxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SOLACE_POST_LAUNCH_SCRIPT, scriptArgs.size() > 0 ? scriptArgs.toArray(new String[scriptArgs.size()]) : null);
        this.tracer.log("Solace broker launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner launchSolaceBroker(String networkName, String keyPair) {
        return this.launchSolaceBroker(networkName, keyPair, null);
    }

    public final AwsProvisioner startSolaceBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, "solace broker", wait);
        return this;
    }

    public final AwsProvisioner stopSolaceBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, "solace broker", wait);
        return this;
    }

    public final AwsProvisioner terminateSolaceBroker(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME, "solace broker", wait);
        return this;
    }

    public final AwsProvisioner launchKafkaBroker(String networkName, String keyPair, PlatformServiceProxyInfo proxyInfo) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        this.launchInstance(networkName, "ami-07667608f4ab62111", RUMI_KAFKA_BROKER_INSTANCE_TYPE, keyPair, this.kafkaBrokerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, null, 32, 0);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (proxyInfo != null) {
            if (proxyInfo.proxyPort > 0) {
                scriptArgs.add("--proxy-port");
                scriptArgs.add(String.valueOf(proxyInfo.proxyPort));
            }
            if (proxyInfo.proxyServer != null) {
                scriptArgs.add("--proxy-server");
                scriptArgs.add(proxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_KAFKA_POST_LAUNCH_SCRIPT, scriptArgs.size() > 0 ? scriptArgs.toArray(new String[scriptArgs.size()]) : null);
        this.tracer.log("Kafka broker launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner launchKafkaBroker(String networkName, String keyPair) {
        return this.launchKafkaBroker(networkName, keyPair, null);
    }

    public final AwsProvisioner startKafkaBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, "kafka broker", wait);
        return this;
    }

    public final AwsProvisioner stopKafkaBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, "kafka broker", wait);
        return this;
    }

    public final AwsProvisioner terminateKafkaBroker(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME, "kafka broker", wait);
        return this;
    }

    public final AwsProvisioner launchActiveMQBroker(String networkName, String keyPair, PlatformServiceProxyInfo proxyInfo) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (this.isJumpServerRunning(networkName) == null) {
            throw new IllegalStateException("jump server needs to be running to launch any instance");
        }
        this.launchInstance(networkName, "ami-0fbc9f169d7d4eeec", RUMI_ACTIVEMQ_BROKER_INSTANCE_TYPE, keyPair, this.activeMQBrokerSecurityGroupName(networkName), true, RUMI_HOSTED_ZONE, RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME, RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME, null, 32, 0);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        if (proxyInfo != null) {
            if (proxyInfo.proxyPort > 0) {
                scriptArgs.add("--proxy-port");
                scriptArgs.add(String.valueOf(proxyInfo.proxyPort));
            }
            if (proxyInfo.proxyServer != null) {
                scriptArgs.add("--proxy-server");
                scriptArgs.add(proxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_ACTIVEMQ_POST_LAUNCH_SCRIPT, scriptArgs.size() > 0 ? scriptArgs.toArray(new String[scriptArgs.size()]) : null);
        this.tracer.log("ActiveMQ broker launch complete.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner launchActiveMQBroker(String networkName, String keyPair) {
        return this.launchActiveMQBroker(networkName, keyPair, null);
    }

    public final AwsProvisioner startActiveMQBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startInstance(networkName, RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME, "activemq broker", wait);
        return this;
    }

    public final AwsProvisioner stopActiveMQBroker(String networkName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopInstance(networkName, RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME, "activemq broker", wait);
        return this;
    }

    public final AwsProvisioner terminateActiveMQBroker(String networkName, String keyPair, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        this.terminateInstance(networkName, RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME, "activemq broker", wait);
        return this;
    }

    public final List<String> getMessageBrokerInstances(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        ArrayList<String> instances = new ArrayList<String>();
        for (String instanceName : this.listInstancesInVpc(vpcId)) {
            String instanceShortName;
            if (!instanceName.startsWith(networkName + "-") || !this.isMessageBrokerInstance(instanceShortName = instanceName.substring((networkName + "-").length()))) continue;
            instances.add(instanceShortName);
        }
        return instances;
    }

    public final AwsProvisioner startAllMessageBrokerInstances(String networkName, boolean wait) {
        for (String instanceName : this.getMessageBrokerInstances(networkName)) {
            if (instanceName.equals(RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME)) {
                this.startSolaceBroker(networkName, wait);
                continue;
            }
            if (instanceName.equals(RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME)) {
                this.startKafkaBroker(networkName, wait);
                continue;
            }
            if (instanceName.equals(RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME)) {
                this.startActiveMQBroker(networkName, wait);
                continue;
            }
            this.tracer.log("Encountered unknown message broker instance name '" + instanceName + "'. Ignoring...", Tracer.Level.WARNING);
        }
        return this;
    }

    public final AwsProvisioner stopAllMessageBrokerInstances(String networkName, boolean wait) {
        for (String instanceName : this.getMessageBrokerInstances(networkName)) {
            if (instanceName.equals(RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME)) {
                this.stopSolaceBroker(networkName, wait);
                continue;
            }
            if (instanceName.equals(RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME)) {
                this.stopKafkaBroker(networkName, wait);
                continue;
            }
            if (instanceName.equals(RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME)) {
                this.stopActiveMQBroker(networkName, wait);
                continue;
            }
            this.tracer.log("Encountered unknown message broker instance name '" + instanceName + "'. Ignoring...", Tracer.Level.WARNING);
        }
        return this;
    }

    public final AwsProvisioner terminateAllMessageBrokerInstances(String networkName, String keyPair, boolean wait) {
        for (String instanceName : this.getMessageBrokerInstances(networkName)) {
            if (instanceName.equals(RUMI_SOLACE_BROKER_INSTANCE_SHORTNAME)) {
                this.terminateSolaceBroker(networkName, keyPair, wait);
                continue;
            }
            if (instanceName.equals(RUMI_KAFKA_BROKER_INSTANCE_SHORTNAME)) {
                this.terminateKafkaBroker(networkName, keyPair, wait);
                continue;
            }
            if (instanceName.equals(RUMI_ACTIVEMQ_BROKER_INSTANCE_SHORTNAME)) {
                this.terminateActiveMQBroker(networkName, keyPair, wait);
                continue;
            }
            this.tracer.log("Encountered unknown message broker instance name '" + instanceName + "'. Ignoring...", Tracer.Level.WARNING);
        }
        return this;
    }

    public final AwsProvisioner launchPlatform(String networkName, String keyPair, Map<ProxiedService, PlatformServiceProxyInfo> proxyInfo) {
        return this.launchJumpServer(networkName, keyPair).launchAdminServer(networkName, keyPair, proxyInfo != null ? proxyInfo.get((Object)ProxiedService.admin) : null, proxyInfo != null ? proxyInfo.get((Object)ProxiedService.discovery) : null).launchMonitorServer(networkName, keyPair, proxyInfo != null ? proxyInfo.get((Object)ProxiedService.monitor) : null);
    }

    public final AwsProvisioner launchPlatform(String networkName, String keyPair) {
        return this.launchPlatform(networkName, keyPair, null);
    }

    public final AwsProvisioner startPlatform(String networkName, boolean wait) {
        return this.startJumpServer(networkName, wait).startAdminServer(networkName, wait).startMonitorServer(networkName, wait);
    }

    public final AwsProvisioner stopPlatform(String networkName, boolean wait) {
        return this.stopJumpServer(networkName, wait).stopAdminServer(networkName, wait).stopMonitorServer(networkName, wait);
    }

    public final AwsProvisioner terminatePlatform(String networkName, String keyPair, boolean wait) {
        return this.terminateMonitorServer(networkName, keyPair, wait).terminateAdminServer(networkName, keyPair, wait).terminateJumpServer(networkName, keyPair, wait);
    }

    public final List<String> getPlatformInstances(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        ArrayList<String> instances = new ArrayList<String>();
        for (String instanceName : this.listInstancesInVpc(vpcId)) {
            String instanceShortName;
            if (!instanceName.startsWith(networkName + "-") || !this.isPlatformInstance(instanceShortName = instanceName.substring((networkName + "-").length()))) continue;
            instances.add(instanceShortName);
        }
        return instances;
    }

    public final AwsProvisioner launchServiceInstance(String networkName, String keyPair, String amiId, String instanceType, boolean assignPublicIP, String hostedZoneName, String instanceName, String instanceNameInHostedZone, UserServiceProxyInfo instanceNameProxyInfo, String[] additionalNamesInHostedZone, UserServiceProxyInfo[] additionalNamesProxyInfo, int rumiVolumeSize) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceType == null) {
            throw new IllegalArgumentException("instance type cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        hostedZoneName = hostedZoneName == null ? RUMI_HOSTED_ZONE : hostedZoneName;
        instanceNameInHostedZone = instanceNameInHostedZone == null ? instanceName : instanceNameInHostedZone;
        this.launchInstance(networkName, amiId != null ? amiId : "ami-007009ba912f34d31", InstanceType.fromValue((String)instanceType), keyPair, this.serviceWorkerSecurityGroupName(networkName), assignPublicIP, hostedZoneName, instanceName, instanceNameInHostedZone, additionalNamesInHostedZone, rumiVolumeSize > 0 ? 8 : 32, rumiVolumeSize);
        this.tracer.log("Running post launch scripts.", Tracer.Level.INFO);
        ArrayList<String> scriptArgs = new ArrayList<String>();
        scriptArgs.add("--host");
        scriptArgs.add(instanceNameInHostedZone + "." + hostedZoneName);
        if (instanceNameProxyInfo != null && instanceNameProxyInfo.servicePort > 0) {
            scriptArgs.add("--port");
            scriptArgs.add(String.valueOf(instanceNameProxyInfo.servicePort));
            if (instanceNameProxyInfo.proxyPort > 0) {
                scriptArgs.add("--proxy-port");
                scriptArgs.add(String.valueOf(instanceNameProxyInfo.proxyPort));
            }
            if (instanceNameProxyInfo.proxyServer != null) {
                scriptArgs.add("--proxy-server");
                scriptArgs.add(instanceNameProxyInfo.proxyServer);
            }
        }
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT, scriptArgs.toArray(new String[scriptArgs.size()]));
        if (additionalNamesInHostedZone != null) {
            for (int i = 0; i < additionalNamesInHostedZone.length; ++i) {
                String additionalNameInHostedZone = additionalNamesInHostedZone[i];
                UserServiceProxyInfo additionalNameProxyInfo = additionalNamesProxyInfo != null ? additionalNamesProxyInfo[i] : null;
                scriptArgs.clear();
                scriptArgs.add("--host");
                scriptArgs.add(additionalNameInHostedZone + "." + hostedZoneName);
                if (additionalNameProxyInfo != null && additionalNameProxyInfo.servicePort > 0) {
                    scriptArgs.add("--port");
                    scriptArgs.add(String.valueOf(additionalNameProxyInfo.servicePort));
                    if (additionalNameProxyInfo.proxyPort > 0) {
                        scriptArgs.add("--proxy-port");
                        scriptArgs.add(String.valueOf(additionalNameProxyInfo.proxyPort));
                    }
                    if (additionalNameProxyInfo.proxyServer != null) {
                        scriptArgs.add("--proxy-server");
                        scriptArgs.add(additionalNameProxyInfo.proxyServer);
                    }
                }
                this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_SERVICE_POST_LAUNCH_SCRIPT, scriptArgs.toArray(new String[scriptArgs.size()]));
            }
        }
        return this;
    }

    public final AwsProvisioner launchServiceInstance(String networkName, String keyPair, String instanceType, boolean assignPublicIP, String hostedZoneName, String instanceName, String instanceNameInHostedZone, String[] additionalNamesInHostedZone, int rumiVolumeSize) {
        return this.launchServiceInstance(networkName, keyPair, null, instanceType, assignPublicIP, hostedZoneName, instanceName, instanceNameInHostedZone, null, additionalNamesInHostedZone, null, rumiVolumeSize);
    }

    public final AwsProvisioner attachNewVolumeToServiceInstance(String networkName, String keyPair, String hostedZoneName, String instanceName, String instanceNameInHostedZone, String volumeName, String volumeTypeStr, int volumeSize, String snapshotId, String mountPoint) {
        VolumeType volumeType;
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        if (volumeSize <= 0) {
            throw new IllegalArgumentException("size must be > 0 for GP3 and >= 125 for SC1/ST1 disks");
        }
        if (volumeTypeStr == null) {
            throw new IllegalArgumentException("volume type cannot be null");
        }
        if (!(volumeTypeStr.equalsIgnoreCase("GP3") || volumeTypeStr.equalsIgnoreCase("SC1") || volumeTypeStr.equalsIgnoreCase("ST1"))) {
            throw new IllegalArgumentException("volume type must be GP3, SC1 or ST1");
        }
        VolumeType volumeType2 = volumeTypeStr.equalsIgnoreCase("GP3") ? VolumeType.GP3 : (volumeType = volumeTypeStr.equalsIgnoreCase("SC1") ? VolumeType.SC1 : VolumeType.ST1);
        if (volumeType != VolumeType.GP3 && volumeSize < 125) {
            throw new IllegalArgumentException("size must be > 0 for GP3 and >= 125 for SC1/ST1 disks");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        String instanceId = this.findVpcInstanceByName(vpcId, this.instanceName(instanceName, networkName));
        if (instanceId == null) {
            throw new IllegalArgumentException("instance '" + instanceName + "' is not provisioned.");
        }
        this.tracer.log("Creating and attaching a " + volumeSize + "Gib volume (type='" + volumeType + "') to instance '" + instanceName + "'.", Tracer.Level.INFO);
        String deviceName = this.attachVolumeToInstance(this.createEBSVolume(volumeName, volumeType, snapshotId, this.availabilityZone(), volumeSize, true), instanceId);
        if (mountPoint != null) {
            this.tracer.log("Mounting the volume at '" + mountPoint + "'.", Tracer.Level.INFO);
            this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_MOUNT_DISK_SCRIPT, new String[]{"--device", deviceName, "--mount-point", mountPoint, "--host", this.fullyQualifiedInstanceName(instanceNameInHostedZone != null ? instanceNameInHostedZone : instanceName, hostedZoneName)});
        } else {
            this.tracer.log("Not mounting the volume.", Tracer.Level.INFO);
        }
        this.tracer.log("Successfully attached new volume to instance.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner runCommandOnServiceInstance(String networkName, String keyPair, String hostedZoneName, String instanceNameInHostedZone, String command) {
        if (networkName == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceNameInHostedZone == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        ArrayList<String> scriptArguments = new ArrayList<String>();
        scriptArguments.add("--host");
        scriptArguments.add(this.fullyQualifiedInstanceName(instanceNameInHostedZone, hostedZoneName));
        scriptArguments.add("--command");
        for (String s : command.split(" ")) {
            scriptArguments.add(s);
        }
        this.tracer.log("Executing command '" + command + "' on '" + this.fullyQualifiedInstanceName(instanceNameInHostedZone, hostedZoneName) + "'.", Tracer.Level.INFO);
        this.executeScriptOnJumpServer(networkName, keyPair, RUMI_JUMP_SERVER_RUN_COMMAND_SCRIPT, scriptArguments.toArray(new String[scriptArguments.size()]));
        this.tracer.log("Successfully run command on instance.", Tracer.Level.INFO);
        return this;
    }

    public final AwsProvisioner startServiceInstance(String networkName, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        this.startInstance(networkName, instanceName, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final AwsProvisioner startAllServiceInstances(String networkName, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.startServiceInstance(networkName, instanceName, wait);
        }
        return this;
    }

    public final AwsProvisioner stopServiceInstance(String networkName, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        this.stopInstance(networkName, instanceName, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final AwsProvisioner stopAllServiceInstances(String networkName, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.stopServiceInstance(networkName, instanceName, wait);
        }
        return this;
    }

    public final AwsProvisioner terminateServiceInstance(String networkName, String keyPair, String instanceName, boolean wait) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("instance name cannot be null");
        }
        this.terminateInstance(networkName, instanceName, "'" + instanceName + "' service instance", wait);
        return this;
    }

    public final AwsProvisioner terminateAllServiceInstances(String networkName, String keyPair, boolean wait) {
        for (String instanceName : this.getServiceInstances(networkName)) {
            this.terminateServiceInstance(networkName, keyPair, instanceName, wait);
        }
        return this;
    }

    public final List<String> getServiceInstances(String networkName) {
        if (networkName == null) {
            throw new IllegalArgumentException("network cannot be null");
        }
        String vpcId = this.findVpcByName(this.networkNameToVpcName(networkName));
        if (vpcId == null) {
            throw new IllegalArgumentException("invalid network '" + networkName + "' or not a Rumi managed network");
        }
        ArrayList<String> instances = new ArrayList<String>();
        for (String instanceName : this.listInstancesInVpc(vpcId)) {
            String instanceShortName;
            if (!instanceName.startsWith(networkName + "-") || this.isPlatformInstance(instanceShortName = instanceName.substring((networkName + "-").length())) || this.isMessageBrokerInstance(instanceShortName)) continue;
            instances.add(instanceShortName);
        }
        return instances;
    }

    public final List<String> getNetworks() {
        ArrayList<String> networks = new ArrayList<String>();
        for (String vpc : this.listVpcs()) {
            if (!vpc.endsWith("-vpc")) continue;
            networks.add(vpc.substring(0, vpc.lastIndexOf(45)));
        }
        return networks;
    }

    public final void deleteNetwork(String name, String keyPair) {
        String vpcId;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        String vpcName = this.networkNameToVpcName(name);
        if (this.tracer.debug) {
            this.tracer.log("Verifying VPC '" + vpcName + "' exists", Tracer.Level.DEBUG);
        }
        if ((vpcId = this.findVpcByName(vpcName)) == null) {
            throw new IllegalArgumentException("invalid network '" + name + "' or not a Rumi managed network");
        }
        this.tracer.log("Terminating all instances.", Tracer.Level.INFO);
        Set<String> terminatedInstances = this.terminateAllInstancesInVpc(vpcId);
        this.tracer.log("Waiting for instances to terminate.", Tracer.Level.INFO);
        this.waitForInstancesToReachState(terminatedInstances, InstanceStateName.TERMINATED);
        this.tracer.log("Deleting private hosted zones.", Tracer.Level.INFO);
        this.disassociateAndDeleteHostedZones(vpcId);
        this.tracer.log("Deleting NAT gateways.", Tracer.Level.INFO);
        this.deleteVpcNatGateways(vpcId);
        this.tracer.log("Deleting internet gateway.", Tracer.Level.INFO);
        this.deleteVpcInternetGateway(vpcId);
        this.tracer.log("Deleting route tables.", Tracer.Level.INFO);
        this.deleteVpcRouteTables(vpcId);
        this.tracer.log("Deleting subnets.", Tracer.Level.INFO);
        this.deleteVpcSubnets(vpcId);
        this.tracer.log("Deleting security groups.", Tracer.Level.INFO);
        this.deleteVpcSecurityGroups(vpcId);
        this.tracer.log("Deleting VPC.", Tracer.Level.INFO);
        this.deleteVpc(vpcId);
        this.tracer.log("Done.", Tracer.Level.INFO);
    }

    public final void provisionEnvironment(String name, String networkAddr, String keyPair, List<Integer> firewallPorts, Map<ProxiedService, PlatformServiceProxyInfo> proxyInfo) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        String vpcName = this.networkNameToVpcName(name);
        if (this.findVpcByName(vpcName) != null) {
            throw new IllegalArgumentException("a Rumi environment with the name '" + name + "' already exists");
        }
        this.createNetwork(name, networkAddr, firewallPorts);
        this.launchPlatform(name, keyPair, proxyInfo);
    }

    public final void provisionEnvironment(String name, String networkAddr, String keyPair) {
        this.provisionEnvironment(name, networkAddr, keyPair, null, null);
    }

    public final void provisionEnvironmentWithMessageBroker(String name, String networkAddr, String keyPair, MessageBroker messageBroker, List<Integer> firewallPorts, Map<ProxiedService, PlatformServiceProxyInfo> platformProxyInfo, PlatformServiceProxyInfo brokerProxyInfo) {
        if (messageBroker != null) {
            switch (messageBroker) {
                case solace: 
                case kafka: 
                case activemq: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported message broker '" + (Object)((Object)messageBroker) + "'");
                }
            }
        }
        this.provisionEnvironment(name, networkAddr, keyPair, firewallPorts, platformProxyInfo);
        if (messageBroker != null) {
            switch (messageBroker) {
                case solace: {
                    this.launchSolaceBroker(name, keyPair, brokerProxyInfo);
                    break;
                }
                case kafka: {
                    this.launchKafkaBroker(name, keyPair, brokerProxyInfo);
                    break;
                }
                case activemq: {
                    this.launchActiveMQBroker(name, keyPair, brokerProxyInfo);
                }
            }
        }
    }

    public final void provisionEnvironmentWithMessageBroker(String name, String networkAddr, String keyPair, MessageBroker messageBroker) {
        this.provisionEnvironmentWithMessageBroker(name, networkAddr, keyPair, messageBroker);
    }

    public final void deploySystem(String name, String keyPair, File xar) {
        if (name == null) {
            throw new IllegalArgumentException("environment name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (xar == null) {
            throw new IllegalArgumentException("xar file needs to be specified");
        }
        if (!xar.exists()) {
            throw new IllegalArgumentException("the specified xar file does not exist");
        }
        this.tracer.log("Deploying the '" + xar.getName() + "' system to the '" + name + "' environment", Tracer.Level.INFO);
        if (this.isJumpServerRunning(name) == null) {
            throw new IllegalStateException("jump server needs to be running to deploy a system");
        }
        this.copyFileToJumpServer(name, keyPair, xar.getAbsolutePath(), RUMI_STAGING_DIR, null);
        this.executeScriptOnJumpServer(name, keyPair, RUMI_JUMP_SERVER_UPLOAD_XAR_SCRIPT, new String[]{"--file", "/home/rumi/staging/" + xar.getName()});
        this.tracer.log("System successfully deployed", Tracer.Level.INFO);
    }

    public final void updateConfig(String name, String keyPair, String section, String key, String value) {
        if (name == null) {
            throw new IllegalArgumentException("environment name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("key pair cannot be null");
        }
        if (section == null) {
            throw new IllegalArgumentException("property section needs to be specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("property key needs to be specified");
        }
        this.tracer.log("Setting configuration property '" + key + "=" + value + "' in the '" + name + "' environment", Tracer.Level.INFO);
        value = value == null ? "null" : value;
        this.executeScriptOnJumpServer(name, keyPair, RUMI_JUMP_SERVER_UPDATE_CONFIG_SCRIPT, new String[]{"--section", section, "--key", key, "--value", value, "--file", RUMI_CONTROLLER_CONF_FILE, "--host", this.fullyQualifiedInstanceName(RUMI_ADMIN_SERVER_INSTANCE_SHORTNAME, RUMI_HOSTED_ZONE)});
        this.tracer.log("Configuration successfully changed", Tracer.Level.INFO);
    }

    public final void startEnvironment(String name, boolean wait) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.startPlatform(name, wait);
        this.startAllMessageBrokerInstances(name, wait);
        this.startAllServiceInstances(name, wait);
    }

    public final void stopEnvironment(String name, boolean wait) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        this.stopAllServiceInstances(name, wait);
        this.stopAllMessageBrokerInstances(name, wait);
        this.stopPlatform(name, wait);
    }

    public final void deprovisionEnvironment(String name, String keyPair) {
        if (name == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("network name cannot be null");
        }
        String vpcName = this.networkNameToVpcName(name);
        if (this.findVpcByName(vpcName) == null) {
            throw new IllegalArgumentException("a Rumi environment with the name '" + name + "' does not exist");
        }
        this.deleteNetwork(name, keyPair);
    }

    public static final class UserServiceProxyInfo {
        final int servicePort;
        final String proxyServer;
        final int proxyPort;

        public UserServiceProxyInfo(int servicePort, String proxyServer, int proxyPort) {
            this.servicePort = servicePort;
            this.proxyServer = proxyServer;
            this.proxyPort = proxyPort;
        }
    }

    public static final class PlatformServiceProxyInfo {
        final String proxyServer;
        final int proxyPort;

        public PlatformServiceProxyInfo(String proxyServer, int proxyPort) {
            this.proxyServer = proxyServer;
            this.proxyPort = proxyPort;
        }
    }

    public static enum ProxiedService {
        admin,
        discovery,
        monitor;

    }

    public static enum MessageBroker {
        solace,
        kafka,
        activemq;

    }
}

