/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.sma.SmaException;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public final class MessageMetadata
extends UtlListElement
implements UtlPool.Item<MessageMetadata> {
    private static final int VERSION_POS = 0;
    private static final int V1_MESSAGE_ENCODING_TYPE_POS = 1;
    private static final int V1_MESSAGE_VIEW_FACTORY_POS = 2;
    private static final int V1_MESSAGE_SENDER_POS = 4;
    private static final int V1_MESSAGE_FLOW_POS = 8;
    private static final int V1_MESSAGE_SNO_POS = 12;
    private static final int V1_MESSAGE_CHANNEL_ID_POS = 20;
    private static final int V1_MESSAGE_CHANNEL_NAME_LEN_POS = 22;
    private static final int V1_MESSAGE_CHANNEL_NAME_POS = 24;
    private static final int V2_MESSAGE_ENCODING_TYPE_POS = 1;
    private static final int V2_MESSAGE_VIEW_FACTORY_POS = 2;
    private static final int V2_MESSAGE_VIEW_TYPE_POS = 4;
    private static final int V2_MESSAGE_SENDER_POS = 6;
    private static final int V2_MESSAGE_FLOW_POS = 10;
    private static final int V2_MESSAGE_SNO_POS = 14;
    private static final int V2_MESSAGE_CHANNEL_ID_POS = 22;
    private static final int V2_MESSAGE_CHANNEL_NAME_LEN_POS = 24;
    private static final int V2_MESSAGE_CHANNEL_NAME_POS = 26;
    private static final int V3_MESSAGE_ENCODING_TYPE_POS = 1;
    private static final int V3_MESSAGE_VIEW_FACTORY_POS = 2;
    private static final int V3_MESSAGE_VIEW_TYPE_POS = 4;
    private static final int V3_MESSAGE_SENDER_POS = 6;
    private static final int V3_MESSAGE_FLOW_POS = 10;
    private static final int V3_MESSAGE_SNO_POS = 14;
    private static final int V3_MESSAGE_CHANNEL_ID_POS = 22;
    private static final int V3_REQUEST_ID_POS = 24;
    private static final int V3_MESSAGE_CHANNEL_NAME_LEN_POS = 32;
    private static final int V3_REQUESTOR_ID_LEN_POS = 34;
    private static final int V3_MESSAGE_CHANNEL_NAME_POS = 36;
    public static final int FIXED_WIRE_LENGTH_V1 = 24;
    public static final int FIXED_WIRE_LENGTH_V2 = 26;
    public static final int FIXED_WIRE_LENGTH_V3 = 36;
    public static final int FIXED_WIRE_LENGTH = 36;
    public static final byte V1 = 1;
    public static final byte V2 = 2;
    public static final byte V3 = 3;
    public static final byte VERSION = 3;
    private final IOElasticBuffer buffer;
    private final XString channelName = XString.create();
    private final XString requestorId = XString.create();
    private UtlPool<MessageMetadata> pool;
    private AtomicInteger ownershipCount = new AtomicInteger(1);
    private final UtlReferenceTracker refTracker;

    MessageMetadata() {
        this.buffer = IOElasticBuffer.create((int)36);
        this.ownershipCount = new AtomicInteger(1);
        if (UtlReferenceTracker.enabled(((Object)((Object)this)).getClass())) {
            this.refTracker = new UtlReferenceTracker((Object)this);
            this.refTracker.onInit(1);
        } else {
            this.refTracker = null;
        }
    }

    public static final short getLatestVersion() {
        return 3;
    }

    private static final short getVersion(IOBuffer buffer, int offset) {
        return (short)(0xFF & buffer.getByte(offset + 0));
    }

    private static final short getVersion(IOBuffer buffer) {
        return MessageMetadata.getVersion(buffer, 0);
    }

    private static final short getVersion(ByteBuffer buffer, int offset) {
        return (short)(0xFF & buffer.get(offset + 0));
    }

    private static final short getVersion(ByteBuffer buffer) {
        return MessageMetadata.getVersion(buffer, 0);
    }

    private static final int getFixedSerializedLength(short version) {
        int len;
        switch (version) {
            case 1: {
                len = 24;
                break;
            }
            case 2: {
                len = 26;
                break;
            }
            case 3: {
                len = 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid version '" + version + "'");
            }
        }
        return len;
    }

    private final int getSerializedLength(short version) {
        switch (version) {
            case 1: {
                return 24 + Math.max(this.buffer.getShort(22), 0);
            }
            case 2: {
                return 26 + Math.max(this.buffer.getShort(24), 0);
            }
            case 3: {
                return 36 + Math.max(this.buffer.getShort(32), 0) + Math.max(this.buffer.getShort(34), 0);
            }
        }
        throw new IllegalArgumentException("invalid version '" + version + "'");
    }

    public static final int getSerializedLength(short version, ByteBuffer buffer, int offset) {
        switch (version) {
            case 1: {
                return 24 + Math.max(buffer.getShort(offset + 22), 0);
            }
            case 2: {
                return 26 + Math.max(buffer.getShort(offset + 24), 0);
            }
            case 3: {
                return 36 + Math.max(buffer.getShort(offset + 32), 0) + Math.max(buffer.getShort(offset + 34), 0);
            }
        }
        throw new IllegalArgumentException("invalid version '" + version + "'");
    }

    public static final int getSerializedLength(short version, ByteBuffer buffer) {
        return MessageMetadata.getSerializedLength(version, buffer, 0);
    }

    public static final int getSerializedLength(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return 24 + Math.max(IOBuffer.getShort((long)addr, (int)(offset + 22)), 0);
            }
            case 2: {
                return 26 + Math.max(IOBuffer.getShort((long)addr, (int)(offset + 24)), 0);
            }
            case 3: {
                return 36 + Math.max(IOBuffer.getShort((long)addr, (int)(offset + 32)), 0) + Math.max(IOBuffer.getShort((long)addr, (int)(offset + 34)), 0);
            }
        }
        throw new IllegalArgumentException("invalid version '" + version + "'");
    }

    public static final short getVersion(long addr, int offset) {
        return (short)(0xFF & IOBuffer.getByte((long)addr, (int)(offset + 0)));
    }

    public final short getVersion() {
        return (short)(0xFF & this.buffer.get(0));
    }

    public static final byte getMessageEncodingType(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.get(offset + 1);
            }
            case 2: {
                return buffer.get(offset + 1);
            }
            case 3: {
                return buffer.get(offset + 1);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final byte getMessageEncodingType(ByteBuffer buffer) {
        return MessageMetadata.getMessageEncodingType(buffer, 0);
    }

    public static final byte getMessageEncodingType(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getByte((long)addr, (int)(offset + 1));
            }
            case 2: {
                return IOBuffer.getByte((long)addr, (int)(offset + 1));
            }
            case 3: {
                return IOBuffer.getByte((long)addr, (int)(offset + 1));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final byte getMessageEncodingType(long addr, int offset) {
        return MessageMetadata.getMessageEncodingType(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final byte getMessageEncodingType() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.get(1);
            }
            case 2: {
                return this.buffer.get(1);
            }
            case 3: {
                return this.buffer.get(1);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageViewFactory(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getShort(offset + 2);
            }
            case 2: {
                return buffer.getShort(offset + 2);
            }
            case 3: {
                return buffer.getShort(offset + 2);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageViewFactory(ByteBuffer buffer) {
        return MessageMetadata.getMessageViewFactory(buffer, 0);
    }

    public static final short getMessageViewFactory(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getShort((long)addr, (int)(offset + 2));
            }
            case 2: {
                return IOBuffer.getShort((long)addr, (int)(offset + 2));
            }
            case 3: {
                return IOBuffer.getShort((long)addr, (int)(offset + 2));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final short getMessageViewFactory(long addr, int offset) {
        return MessageMetadata.getMessageViewFactory(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final short getMessageViewFactory() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getShort(2);
            }
            case 2: {
                return this.buffer.getShort(2);
            }
            case 3: {
                return this.buffer.getShort(2);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageViewType(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return 0;
            }
            case 2: {
                return buffer.getShort(offset + 4);
            }
            case 3: {
                return buffer.getShort(offset + 4);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageViewType(ByteBuffer buffer) {
        return MessageMetadata.getMessageViewType(buffer, 0);
    }

    public static final short getMessageViewType(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return 0;
            }
            case 2: {
                return IOBuffer.getShort((long)addr, (int)(offset + 4));
            }
            case 3: {
                return IOBuffer.getShort((long)addr, (int)(offset + 4));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final short getMessageViewType(long addr, int offset) {
        return MessageMetadata.getMessageViewType(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final short getMessageViewType() {
        switch (this.getVersion()) {
            case 1: {
                return 0;
            }
            case 2: {
                return this.buffer.getShort(4);
            }
            case 3: {
                return this.buffer.getShort(4);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final int getMessageSender(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getInt(offset + 4);
            }
            case 2: {
                return buffer.getInt(offset + 6);
            }
            case 3: {
                return buffer.getInt(offset + 6);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final int getMessageSender(ByteBuffer buffer) {
        return MessageMetadata.getMessageSender(buffer, 0);
    }

    public static final int getMessageSender(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getInt((long)addr, (int)(offset + 4));
            }
            case 2: {
                return IOBuffer.getInt((long)addr, (int)(offset + 6));
            }
            case 3: {
                return IOBuffer.getInt((long)addr, (int)(offset + 6));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final int getMessageSender(long addr, int offset) {
        return MessageMetadata.getMessageSender(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final int getMessageSender() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getInt(4);
            }
            case 2: {
                return this.buffer.getInt(6);
            }
            case 3: {
                return this.buffer.getInt(6);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final int getMessageFlow(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getInt(offset + 8);
            }
            case 2: {
                return buffer.getInt(offset + 10);
            }
            case 3: {
                return buffer.getInt(offset + 10);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final int getMessageFlow(ByteBuffer buffer) {
        return MessageMetadata.getMessageFlow(buffer, 0);
    }

    public static final int getMessageFlow(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getInt((long)addr, (int)(offset + 8));
            }
            case 2: {
                return IOBuffer.getInt((long)addr, (int)(offset + 10));
            }
            case 3: {
                return IOBuffer.getInt((long)addr, (int)(offset + 10));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final int getMessageFlow(long addr, int offset) {
        return MessageMetadata.getMessageFlow(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final int getMessageFlow() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getInt(8);
            }
            case 2: {
                return this.buffer.getInt(10);
            }
            case 3: {
                return this.buffer.getInt(10);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final long getMessageSno(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getLong(offset + 12);
            }
            case 2: {
                return buffer.getLong(offset + 14);
            }
            case 3: {
                return buffer.getLong(offset + 14);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final long getMessageSno(ByteBuffer buffer) {
        return MessageMetadata.getMessageSno(buffer, 0);
    }

    public static final long getMessageSno(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getLong((long)addr, (int)(offset + 12));
            }
            case 2: {
                return IOBuffer.getLong((long)addr, (int)(offset + 14));
            }
            case 3: {
                return IOBuffer.getLong((long)addr, (int)(offset + 14));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final long getMessageSno(long addr, int offset) {
        return MessageMetadata.getMessageSno(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final long getMessageSno() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getLong(12);
            }
            case 2: {
                return this.buffer.getLong(14);
            }
            case 3: {
                return this.buffer.getLong(14);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final short getMessageChannelId(IOBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getShort(offset + 20);
            }
            case 2: {
                return buffer.getShort(offset + 22);
            }
            case 3: {
                return buffer.getShort(offset + 22);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageChannelId(IOBuffer buffer) {
        return MessageMetadata.getMessageChannelId(buffer, 0);
    }

    public static final short getMessageChannelId(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                return buffer.getShort(offset + 20);
            }
            case 2: {
                return buffer.getShort(offset + 22);
            }
            case 3: {
                return buffer.getShort(offset + 22);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final short getMessageChannelId(ByteBuffer buffer) {
        return MessageMetadata.getMessageChannelId(buffer, 0);
    }

    public static final short getMessageChannelId(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getShort((long)addr, (int)(offset + 20));
            }
            case 2: {
                return IOBuffer.getShort((long)addr, (int)(offset + 22));
            }
            case 3: {
                return IOBuffer.getShort((long)addr, (int)(offset + 22));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final short getMessageChannelId(long addr, int offset) {
        return MessageMetadata.getMessageChannelId(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final short getMessageChannelId() {
        switch (this.getVersion()) {
            case 1: {
                return this.buffer.getShort(20);
            }
            case 2: {
                return this.buffer.getShort(22);
            }
            case 3: {
                return this.buffer.getShort(22);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final long getRequestId(IOBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: 
            case 2: {
                return 0L;
            }
            case 3: {
                return buffer.getLong(offset + 24);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final long getRequestId(IOBuffer buffer) {
        return MessageMetadata.getRequestId(buffer, 0);
    }

    public static final long getRequestId(ByteBuffer buffer, int offset) {
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: 
            case 2: {
                return 0L;
            }
            case 3: {
                return buffer.getLong(offset + 24);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
    }

    public static final long getRequestId(ByteBuffer buffer) {
        return MessageMetadata.getRequestId(buffer, 0);
    }

    public static final long getRequestId(short version, long addr, int offset) {
        switch (version) {
            case 1: 
            case 2: {
                return 0L;
            }
            case 3: {
                return IOBuffer.getLong((long)addr, (int)(offset + 24));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final long getRequestId(long addr, int offset) {
        return MessageMetadata.getRequestId(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final long getRequestId() {
        switch (this.getVersion()) {
            case 1: 
            case 2: {
                return 0L;
            }
            case 3: {
                return this.buffer.getLong(24);
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
    }

    public static final String getMessageChannelName(ByteBuffer buffer, int offset) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                channelNameLenPos = 22;
                channelNamePos = 24;
                break;
            }
            case 2: {
                channelNameLenPos = 24;
                channelNamePos = 26;
                break;
            }
            case 3: {
                channelNameLenPos = 32;
                channelNamePos = 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(offset + channelNameLenPos);
        if (len >= 0) {
            byte[] name = new byte[len];
            UtlBuffer.copy((ByteBuffer)buffer, (int)channelNamePos, (byte[])name, (int)0, (int)len);
            try {
                return new String(name, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final String getMessageChannelName(ByteBuffer buffer) {
        return MessageMetadata.getMessageChannelName(buffer, 0);
    }

    public static final String getMessageChannelName(long addr, int offset) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(addr, offset)) {
            case 1: {
                channelNameLenPos = 22;
                channelNamePos = 24;
                break;
            }
            case 2: {
                channelNameLenPos = 24;
                channelNamePos = 26;
                break;
            }
            case 3: {
                channelNameLenPos = 32;
                channelNamePos = 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
            }
        }
        short len = IOBuffer.getShort((long)addr, (int)(offset + channelNameLenPos));
        if (len >= 0) {
            byte[] name = new byte[len];
            IOBuffer.getTo((long)addr, (int)channelNamePos, (byte[])name, (int)0, (int)len);
            try {
                return new String(name, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final void getMessageChannelNameToRaw(IOBuffer buffer, int offset, XString target) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                channelNameLenPos = offset + 22;
                channelNamePos = offset + 24;
                break;
            }
            case 2: {
                channelNameLenPos = offset + 24;
                channelNamePos = offset + 26;
                break;
            }
            case 3: {
                channelNameLenPos = offset + 32;
                channelNamePos = offset + 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(channelNameLenPos);
        if (len < 0) {
            target.clear(false);
            return;
        }
        target.setValue(buffer, channelNamePos, (int)len);
    }

    public static final void getMessageChannelNameToRaw(IOBuffer buffer, XString target) {
        MessageMetadata.getMessageChannelNameToRaw(buffer, 0, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getMessageChannelNameToRaw(ByteBuffer buffer, int offset, XString target) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: {
                channelNameLenPos = offset + 22;
                channelNamePos = offset + 24;
                break;
            }
            case 2: {
                channelNameLenPos = offset + 24;
                channelNamePos = offset + 26;
                break;
            }
            case 3: {
                channelNameLenPos = offset + 32;
                channelNamePos = offset + 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(channelNameLenPos);
        int limit = buffer.limit();
        if (len < 0) {
            target.clear(false);
            return;
        }
        buffer.mark();
        try {
            buffer.position(channelNamePos);
            buffer.limit(channelNamePos + len);
            target.setValue(buffer);
        }
        finally {
            buffer.reset();
            buffer.limit(limit);
        }
    }

    public static final void getMessageChannelNameToRaw(ByteBuffer buffer, XString target) {
        MessageMetadata.getMessageChannelNameToRaw(buffer, 0, target);
    }

    public static final void getMessageChannelNameToRaw(long addr, int offset, XString target) {
        int channelNamePos;
        int channelNameLenPos;
        switch (MessageMetadata.getVersion(addr, offset)) {
            case 1: {
                channelNameLenPos = offset + 22;
                channelNamePos = offset + 24;
                break;
            }
            case 2: {
                channelNameLenPos = offset + 24;
                channelNamePos = offset + 26;
                break;
            }
            case 3: {
                channelNameLenPos = offset + 32;
                channelNamePos = offset + 36;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
            }
        }
        short len = IOBuffer.getShort((long)addr, (int)channelNameLenPos);
        if (len < 0) {
            target.clear(false);
            return;
        }
        target.setValueFromMemory(addr + (long)channelNamePos, (int)len);
    }

    public static final int getMessageChannelNamePos(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return 24;
            }
            case 2: {
                return 26;
            }
            case 3: {
                return 36;
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final int getMessageChannelNamePos(long addr, int offset) {
        return MessageMetadata.getMessageChannelNamePos(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public static final int getMessageChannelNameLength(short version, long addr, int offset) {
        switch (version) {
            case 1: {
                return IOBuffer.getShort((long)addr, (int)(offset + 22));
            }
            case 2: {
                return IOBuffer.getShort((long)addr, (int)(offset + 24));
            }
            case 3: {
                return IOBuffer.getShort((long)addr, (int)(offset + 32));
            }
        }
        throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
    }

    public static final int getMessageChannelNameLength(long addr, int offset) {
        return MessageMetadata.getMessageChannelNameLength(MessageMetadata.getVersion(addr, offset), addr, offset);
    }

    public final XString getMessageChannelNameAsRaw() {
        if (!this.channelName.hasValue()) {
            int channelNamePos;
            int channelNameLenPos;
            switch (this.getVersion()) {
                case 1: {
                    channelNameLenPos = 22;
                    channelNamePos = 24;
                    break;
                }
                case 2: {
                    channelNameLenPos = 24;
                    channelNamePos = 26;
                    break;
                }
                case 3: {
                    channelNameLenPos = 32;
                    channelNamePos = 36;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
                }
            }
            short len = this.buffer.getShort(channelNameLenPos);
            if (len >= 0) {
                this.channelName.setValue(this.buffer, channelNamePos, (int)len);
            }
        }
        return this.channelName.hasValue() ? this.channelName : null;
    }

    public final String getMessageChannelName() {
        this.getMessageChannelNameAsRaw();
        return this.channelName.getValue();
    }

    public static final String getRequestorId(ByteBuffer buffer, int offset) {
        int requestorIdPos;
        int requestorIdLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                requestorIdLenPos = 34;
                requestorIdPos = 36 + Math.max(0, buffer.getShort(32));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(offset + requestorIdLenPos);
        if (len >= 0) {
            byte[] name = new byte[len];
            UtlBuffer.copy((ByteBuffer)buffer, (int)requestorIdPos, (byte[])name, (int)0, (int)len);
            try {
                return new String(name, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final String getRequestorId(ByteBuffer buffer) {
        return MessageMetadata.getRequestorId(buffer, 0);
    }

    public static final String getRequestorId(long addr, int offset) {
        int requestorIdPos;
        int requestorIdLenPos;
        switch (MessageMetadata.getVersion(addr, offset)) {
            case 1: 
            case 2: {
                return null;
            }
            case 3: {
                requestorIdLenPos = 34;
                requestorIdPos = 36 + Math.max(0, IOBuffer.getShort((long)addr, (int)32));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
            }
        }
        short len = IOBuffer.getShort((long)addr, (int)(offset + requestorIdLenPos));
        if (len >= 0) {
            byte[] name = new byte[len];
            IOBuffer.getTo((long)addr, (int)requestorIdPos, (byte[])name, (int)0, (int)len);
            try {
                return new String(name, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static final void getRequestorIdToRaw(IOBuffer buffer, int offset, XString target) {
        int requestorIdPos;
        int requestorIdLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: 
            case 2: {
                target.clear(false);
                return;
            }
            case 3: {
                requestorIdLenPos = 34;
                requestorIdPos = 36 + Math.max(0, buffer.getShort(32));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(requestorIdLenPos);
        if (len < 0) {
            target.clear(false);
            return;
        }
        target.setValue(buffer, requestorIdPos, (int)len);
    }

    public static final void getRequestorIdToRaw(IOBuffer buffer, XString target) {
        MessageMetadata.getRequestorIdToRaw(buffer, 0, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getRequestorIdToRaw(ByteBuffer buffer, int offset, XString target) {
        int requestorIdPos;
        int requestorIdLenPos;
        switch (MessageMetadata.getVersion(buffer, offset)) {
            case 1: 
            case 2: {
                target.clear(false);
                return;
            }
            case 3: {
                requestorIdLenPos = 34;
                requestorIdPos = 36 + Math.max(0, buffer.getShort(32));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(buffer, offset) + "'");
            }
        }
        short len = buffer.getShort(requestorIdLenPos);
        int limit = buffer.limit();
        if (len < 0) {
            target.clear(false);
            return;
        }
        buffer.mark();
        try {
            buffer.position(requestorIdPos);
            buffer.limit(requestorIdPos + len);
            target.setValue(buffer);
        }
        finally {
            buffer.reset();
            buffer.limit(limit);
        }
    }

    public static final void getRequestorIdToRaw(ByteBuffer buffer, XString target) {
        MessageMetadata.getRequestorIdToRaw(buffer, 0, target);
    }

    public static final XString getRequestorIdToRaw(short version, long addr, int offset, XString target) {
        int requestorIdPos;
        int requestorIdLenPos;
        switch (version) {
            case 1: 
            case 2: {
                target.clear(false);
                return target;
            }
            case 3: {
                requestorIdLenPos = 34;
                requestorIdPos = 36 + Math.max(0, IOBuffer.getShort((long)addr, (int)32));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown metadata version '" + MessageMetadata.getVersion(addr, offset) + "'");
            }
        }
        short len = IOBuffer.getShort((long)addr, (int)requestorIdLenPos);
        if (len < 0) {
            target.clear(false);
        } else {
            target.setValueFromMemory(addr + (long)requestorIdPos, (int)len);
        }
        return target;
    }

    public static final XString getRequestorIdToRaw(long addr, int offset, XString target) {
        return MessageMetadata.getRequestorIdToRaw(MessageMetadata.getVersion(addr, offset), addr, offset, target);
    }

    public final XString getRequestorIdAsRaw() {
        if (!this.requestorId.hasValue()) {
            int requestorIdPos;
            int requestorIdLenPos;
            switch (this.getVersion()) {
                case 1: 
                case 2: {
                    return null;
                }
                case 3: {
                    requestorIdLenPos = 34;
                    requestorIdPos = 36 + Math.max(0, this.buffer.getShort(32));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown metadata version '" + this.getVersion() + "'");
                }
            }
            short len = this.buffer.getShort(requestorIdLenPos);
            if (len >= 0) {
                this.requestorId.setValue(this.buffer, requestorIdPos, (int)len);
            }
        }
        return this.requestorId.hasValue() ? this.requestorId : null;
    }

    public final String getRequestorId() {
        this.getRequestorIdAsRaw();
        return this.requestorId.getValue();
    }

    public final IOElasticBuffer getBuffer() {
        return this.buffer;
    }

    public static final int serializeV1(byte encodingType, short vfid, int sender, int flow, long sno, short channelId, XString channelName, IOElasticBuffer buffer) {
        buffer.setLength(0);
        buffer.put(0, (byte)1);
        buffer.put(1, encodingType);
        buffer.putShort(2, vfid);
        buffer.putInt(4, sender);
        buffer.putInt(8, flow);
        buffer.putLong(12, sno);
        buffer.putShort(20, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.serializedLength();
            buffer.putShort(22, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.getTo(buffer, 24);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 24 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength());
    }

    public final void serializeV1(byte encodingType, short vfid, int sender, int flow, long sno, short channelId, XString channelName) {
        MessageMetadata.serializeV1(encodingType, vfid, sender, flow, sno, channelId, channelName, this.buffer);
        if (channelName != null && !channelName.isNull()) {
            channelName.getTo(this.channelName);
        }
    }

    public static final int serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)2);
        buffer.put(offset + 1, encodingType);
        buffer.putShort(offset + 2, vfid);
        buffer.putShort(offset + 4, vid);
        buffer.putInt(offset + 6, sender);
        buffer.putInt(offset + 10, flow);
        buffer.putLong(offset + 14, sno);
        buffer.putShort(offset + 22, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.serializedLength();
            buffer.putShort(offset + 24, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.getTo(buffer, offset + 26);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 26 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength());
    }

    public static final int serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, IOElasticBuffer buffer) {
        buffer.setLength(0);
        buffer.put(0, (byte)2);
        buffer.put(1, encodingType);
        buffer.putShort(2, vfid);
        buffer.putShort(4, vid);
        buffer.putInt(6, sender);
        buffer.putInt(10, flow);
        buffer.putLong(14, sno);
        buffer.putShort(22, channelId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.serializedLength();
            buffer.putShort(24, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.getTo(buffer, 26);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 26 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength());
    }

    public final void serializeV2(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName) {
        MessageMetadata.serializeV2(encodingType, vfid, vid, sender, flow, sno, channelId, channelName, this.buffer);
        if (channelName != null && !channelName.isNull()) {
            channelName.getTo(this.channelName);
        }
    }

    public static final int serializeV3(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, long requestId, XString requestorId, ByteBuffer buffer, int offset) {
        buffer.put(offset + 0, (byte)3);
        buffer.put(offset + 1, encodingType);
        buffer.putShort(offset + 2, vfid);
        buffer.putShort(offset + 4, vid);
        buffer.putInt(offset + 6, sender);
        buffer.putInt(offset + 10, flow);
        buffer.putLong(offset + 14, sno);
        buffer.putShort(offset + 22, channelId);
        buffer.putLong(offset + 24, requestId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.serializedLength();
            buffer.putShort(offset + 32, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.getTo(buffer, offset + 36);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            short serializedRequestorIdLen = requestorId == null || requestorId.isNull() ? (short)-1 : (short)requestorId.serializedLength();
            buffer.putShort(offset + 34, serializedRequestorIdLen);
            if (requestorId != null && !requestorId.isNull()) {
                requestorId.getTo(buffer, offset + 36 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 36 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength()) + (requestorId == null || requestorId.isNull() ? 0 : requestorId.serializedLength());
    }

    public static final int serializeV3(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, long requestId, XString requestorId, IOElasticBuffer buffer) {
        buffer.setLength(0);
        buffer.put(0, (byte)3);
        buffer.put(1, encodingType);
        buffer.putShort(2, vfid);
        buffer.putShort(4, vid);
        buffer.putInt(6, sender);
        buffer.putInt(10, flow);
        buffer.putLong(14, sno);
        buffer.putShort(22, channelId);
        buffer.putLong(24, requestId);
        try {
            short serializedChannelNameLen = channelName == null || channelName.isNull() ? (short)-1 : (short)channelName.serializedLength();
            buffer.putShort(32, serializedChannelNameLen);
            if (channelName != null && !channelName.isNull()) {
                channelName.getTo(buffer, 36);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            short serializedRequestorIdLen = requestorId == null || requestorId.isNull() ? (short)-1 : (short)requestorId.serializedLength();
            buffer.putShort(34, serializedRequestorIdLen);
            if (requestorId != null && !requestorId.isNull()) {
                requestorId.getTo(buffer, 36 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return 36 + (channelName == null || channelName.isNull() ? 0 : channelName.serializedLength()) + (requestorId == null || requestorId.isNull() ? 0 : requestorId.serializedLength());
    }

    public final void serializeV3(byte encodingType, short vfid, short vid, int sender, int flow, long sno, short channelId, XString channelName, long requestId, XString requestorId) {
        MessageMetadata.serializeV3(encodingType, vfid, vid, sender, flow, sno, channelId, channelName, requestId, requestorId, this.buffer);
        if (channelName != null && !channelName.isNull()) {
            channelName.getTo(this.channelName);
        }
        if (requestorId != null && !requestorId.isNull()) {
            requestorId.getTo(this.requestorId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void tryWrap(long serializedMetadata, int serializedMetadataLength) throws SmaException {
        if (serializedMetadataLength <= 1) throw new SmaException("supplied buffer too small to deserialize message metadata from");
        short version = MessageMetadata.getVersion(serializedMetadata, 0);
        if (version < 1 || version > 3) {
            throw new SmaException("Invalid message metadata wire format version [max supported=3 received=" + version);
        }
        if (serializedMetadataLength < MessageMetadata.getFixedSerializedLength(version)) throw new SmaException("supplied buffer too small to deserialize message metadata from");
        if (serializedMetadataLength >= MessageMetadata.getSerializedLength(version, serializedMetadata, 0)) return;
        throw new SmaException("supplied buffer too small to deserialize message metadata from");
    }

    public final int wrap(IOBuffer serializedMetadata, int serializedMetadataLength) throws SmaException {
        ByteBuffer serializedMetadataByteBuffer = serializedMetadata.getBufferUnsafe();
        if (serializedMetadataLength > 1) {
            short version = MessageMetadata.getVersion(serializedMetadataByteBuffer);
            if (version < 1 || version > 3) {
                throw new SmaException("Invalid message metadata wire format version [max supported=3 received=" + version);
            }
            int length = MessageMetadata.getSerializedLength(version, serializedMetadataByteBuffer);
            if (serializedMetadataLength >= length) {
                this.buffer.wrapBackingBuffer(serializedMetadata, 0, length);
                return length;
            }
            throw new SmaException("supplied buffer too small to deserialize message metadata from");
        }
        throw new SmaException("supplied buffer too small to deserialize message metadata from");
    }

    public final int wrap(IOBuffer serializedMetadata) throws SmaException {
        return this.wrap(serializedMetadata, serializedMetadata.getLength());
    }

    public final int deserialize(ByteBuffer serializedMetadata) throws SmaException {
        IOBuffer ioBuffer = IOBuffer.create((int)serializedMetadata.remaining());
        UtlBuffer.copy((ByteBuffer)serializedMetadata, (int)serializedMetadata.position(), (ByteBuffer)ioBuffer.getBufferUnsafe(), (int)0, (int)serializedMetadata.remaining());
        try {
            return this.wrap(ioBuffer);
        }
        catch (SmaException e) {
            ioBuffer.dispose();
            throw e;
        }
    }

    public final int getSerializedLength() {
        return this.getSerializedLength(this.getVersion());
    }

    public final MessageMetadata acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed MessageMetaData");
        }
        return this;
    }

    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed MessageMetaData");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    public final MessageMetadata init() {
        this.buffer.reset();
        this.channelName.clear(false);
        this.requestorId.clear(false);
        this.ownershipCount.set(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        return this;
    }

    public final MessageMetadata setPool(UtlPool<MessageMetadata> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<MessageMetadata> getPool() {
        return this.pool;
    }

    public static final String toString(long addr, int offset) {
        String str = "";
        str = str + "[";
        try {
            str = str + MessageMetadata.getVersion(addr, offset) + ",";
            str = str + MessageMetadata.getMessageEncodingType(addr, offset) + ",";
            str = str + MessageMetadata.getMessageViewFactory(addr, offset) + ",";
            str = str + MessageMetadata.getMessageViewType(addr, offset) + ",";
            str = str + MessageMetadata.getMessageSender(addr, offset) + ",";
            str = str + MessageMetadata.getMessageFlow(addr, offset) + ",";
            str = str + MessageMetadata.getMessageSno(addr, offset) + ",";
            str = str + MessageMetadata.getMessageChannelId(addr, offset) + ",";
            str = str + MessageMetadata.getMessageChannelName(addr, offset) + ",";
            str = str + MessageMetadata.getRequestId(addr, offset) + ",";
            str = str + MessageMetadata.getRequestorId(addr, offset);
        }
        catch (Throwable thrown) {
            str = str + " INVALID (" + thrown.getMessage() + ")";
        }
        str = str + "]";
        return str;
    }

    public final String toString() {
        String str = "";
        str = str + "[";
        try {
            str = str + this.getVersion() + ",";
            str = str + this.getMessageEncodingType() + ",";
            str = str + this.getMessageViewFactory() + ",";
            str = str + this.getMessageViewType() + ",";
            str = str + this.getMessageSender() + ",";
            str = str + this.getMessageFlow() + ",";
            str = str + this.getMessageSno() + ",";
            str = str + this.getMessageChannelId() + ",";
            str = str + this.getMessageChannelName() + ",";
            str = str + this.getRequestId() + ",";
            str = str + this.getRequestorId();
        }
        catch (Throwable thrown) {
            str = str + " INVALID (" + thrown.getMessage() + ")";
        }
        str = str + "]";
        return str;
    }
}

