/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.app;

import com.google.common.base.Strings;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.AepMessageSender;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepApplicationExceptionEvent;
import com.neeve.aep.event.AepBusBindingCreateFailedEvent;
import com.neeve.aep.event.AepBusBindingCreatedEvent;
import com.neeve.aep.event.AepBusBindingDestroyedEvent;
import com.neeve.aep.event.AepBusBindingDownEvent;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepBusBindingOpenedEvent;
import com.neeve.aep.event.AepBusBindingOpeningEvent;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepClientConnectedEvent;
import com.neeve.aep.event.AepClientDisconnectedEvent;
import com.neeve.aep.event.AepDuplicateAcknowledgementAlertEvent;
import com.neeve.aep.event.AepEngineActiveEvent;
import com.neeve.aep.event.AepEngineCreatedEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepEngineStoppedEvent;
import com.neeve.aep.event.AepEngineStoppingEvent;
import com.neeve.aep.event.AepFlowCreatedEvent;
import com.neeve.aep.event.AepInboundLogExceptionEvent;
import com.neeve.aep.event.AepMessageTraceLoggingExceptionEvent;
import com.neeve.aep.event.AepMessagingFailedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.aep.event.AepMessagingStartFailedEvent;
import com.neeve.aep.event.AepMessagingStartedEvent;
import com.neeve.aep.event.AepOutOfOrderSendCommitCompletionAlertEvent;
import com.neeve.aep.event.AepOutboundLogExceptionEvent;
import com.neeve.aep.event.AepSendExceptionEvent;
import com.neeve.aep.event.AepStatsAlertEvent;
import com.neeve.aep.event.AepStuckAlertEvent;
import com.neeve.aep.event.AepUnhandledMessageEvent;
import com.neeve.cli.ArgumentHandler;
import com.neeve.cli.CliException;
import com.neeve.cli.CommandExecutor;
import com.neeve.cli.ConfigInjector;
import com.neeve.cli.OptionHandler;
import com.neeve.cli.RemainingArgsHandler;
import com.neeve.cli.annotations.Argument;
import com.neeve.cli.annotations.Command;
import com.neeve.config.Config;
import com.neeve.event.IEventHandler;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XLinkedList;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreNonUniqueIndex;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStoreUniqueIndex;
import com.neeve.ods.impl.StoreBindingFailedEvent;
import com.neeve.ods.impl.StoreBindingRoleChangedEvent;
import com.neeve.ods.impl.StoreMemberDownEvent;
import com.neeve.ods.impl.StoreMemberInitCompleteEvent;
import com.neeve.ods.impl.StoreMemberUpEvent;
import com.neeve.ods.impl.StoreTransactionLogRepairedEvent;
import com.neeve.rog.log.RogLog;
import com.neeve.server.app.ESrvAppCommandFailure;
import com.neeve.server.app.ESrvAppException;
import com.neeve.server.app.ISrvAppWatcher;
import com.neeve.server.app.SrvAppManager;
import com.neeve.server.app.SrvAppObject;
import com.neeve.server.app.annotations.AppCommandHandler;
import com.neeve.server.app.annotations.AppCommandHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppConfiguredAccessor;
import com.neeve.server.app.annotations.AppEventHandlerAccessor;
import com.neeve.server.app.annotations.AppEventHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppFinalizer;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInitializer;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppIntrospectionPoints;
import com.neeve.server.app.annotations.AppMain;
import com.neeve.server.app.annotations.AppStat;
import com.neeve.server.app.annotations.AppStatContainersAccessor;
import com.neeve.server.app.annotations.AppStateFactoryAccessor;
import com.neeve.server.app.annotations.AppStoreNonUniqueIndex;
import com.neeve.server.app.annotations.AppStoreUniqueIndex;
import com.neeve.server.app.annotations.AppVersion;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.mon.alert.SrvMonAppDuplicateAcknowledgementAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppInboundLogExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppOutOfOrderSendCommitCompletionAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppOutboundLogExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppSendExceptionMessage;
import com.neeve.server.mon.alert.SrvMonAppStatsAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppStoreTransactionLogRepairedMessage;
import com.neeve.server.mon.alert.SrvMonAppStuckAlertMessage;
import com.neeve.server.mon.alert.SrvMonAppUnhandledMessageMessage;
import com.neeve.server.mon.alert.SrvMonMessageTraceLoggingExceptionMessage;
import com.neeve.server.mon.alert.SrvMonUnhandledMessageMessage;
import com.neeve.server.mon.cnc.SrvMonArgumentDescription;
import com.neeve.server.mon.cnc.SrvMonCommandDescription;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonListCommandsResponse;
import com.neeve.server.mon.cnc.SrvMonOptionDescription;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreateFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpeningMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineActiveMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppingMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingPrestartMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingStartFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppMessagingStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreBindingFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreBindingRoleChangedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberInitCompleteMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStoreMemberUpMessage;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.stats.FieldReflectingGauge;
import com.neeve.stats.IStats;
import com.neeve.stats.MethodReflectingGauge;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Manifest;
import org.apache.commons.lang.WordUtils;

public final class SrvAppLoader
extends SrvAppObject {
    private final String name;
    private final SrvConfigDescriptor configDescriptor;
    private final SrvAppManager appManager;
    private final ISrvAppWatcher appWatcher;
    private final SrvConfigAppDescriptor appDescriptor;
    private final App app;
    private volatile Thread appStarter;

    SrvAppLoader(String name, SrvConfigDescriptor configDescriptor, SrvAppManager appManager, ISrvAppWatcher appWatcher) throws Exception {
        this.name = name;
        this.configDescriptor = configDescriptor;
        this.appManager = appManager;
        this.appWatcher = appWatcher;
        this.tracer.log("Loading application [" + this.getAppName() + "]...", Tracer.Level.INFO);
        try {
            this.appDescriptor = SrvConfigAppDescriptor.load(configDescriptor.getName(), this.getAppName());
            this.app = this.loadApp(this.appDescriptor.getMainClass());
            if (appWatcher != null) {
                appWatcher.onAppLoaded(this);
            }
        }
        catch (Exception e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log("...load failed [" + error + "]", Tracer.Level.WARNING);
            throw new Exception(error, e);
        }
    }

    private static final String getClassLoaderDetails(ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        if (loader instanceof URLClassLoader) {
            return Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
        }
        return loader.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static final String findJarVersion(Class<?> clazz) {
        try {
            block13: {
                className = clazz.getSimpleName() + ".class";
                classPath = clazz.getResource(className).toString();
                classRoot = null;
                if (classPath.startsWith("jar")) {
                    classRoot = classPath.substring(0, classPath.lastIndexOf("!") + 1);
                } else if (classPath.startsWith("file")) {
                    classRoot = classPath.substring(0, classPath.length() - clazz.getName().length() - 7);
                }
                if (classRoot == null) ** break block14
                is = new URL(classRoot + "/META-INF/MANIFEST.MF").openStream();
                try {
                    manifest = new Manifest(is);
                    attr = manifest.getMainAttributes();
                    implVersion = attr.getValue("Implementation-Version");
                    if (implVersion == null || implVersion.trim().length() <= 0) break block13;
                    var8_10 = implVersion;
                }
                catch (Throwable var9_12) {
                    try {
                        is.close();
                        throw var9_12;
                    }
                    catch (Throwable var4_6) {
                        try {
                        }
                        catch (Throwable thrown) {}
                    }
                }
                is.close();
                return var8_10;
            }
            var8_11 = attr.getValue("Specification-Version");
            is.close();
            return var8_11;
        }
        finally {
            return null;
        }
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getCurrentJarVersion(File dir) throws Exception {
        File verinfoFile = new File(dir + "/.verinfo");
        if (!verinfoFile.exists()) return 0;
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(verinfoFile);
            try {
                props.load(fis);
                int n = Integer.valueOf(props.getProperty("current", "0"));
                return n;
            }
            catch (IOException e) {
                throw new Exception("I/O exception encountered while loading .verinfo property file [" + e.toString() + "]");
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return 0;
    }

    private final URL[] prepareApplicationJarUrls() throws Exception {
        int version;
        File dir = new File(Config.getJavaLibDirectory() + "/apps/" + this.appDescriptor.getName());
        if (dir.exists() && (version = this.getCurrentJarVersion(dir)) > 0) {
            dir = new File(dir + "/" + version);
        }
        if (dir.exists()) {
            File[] files;
            if (this.tracer.debug) {
                this.tracer.log("Adding directory '" + dir + "' to application classpath.", Tracer.Level.DEBUG);
            }
            if ((files = dir.listFiles(new FilenameFilter(){

                @Override
                public final boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })).length > 0) {
                URL[] urls = new URL[files.length];
                for (int i = 0; i < files.length; ++i) {
                    try {
                        urls[i] = new URL("file://localhost/" + files[i].getAbsolutePath());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new InternalError("Received a 'malformed URL' exception for a hand crafted URL string!");
                    }
                }
                return urls;
            }
        } else if (this.tracer.debug) {
            this.tracer.log("Using server classpath as application classpath (application artifact directory '" + dir + "' does not exist).", Tracer.Level.DEBUG);
        }
        return null;
    }

    private final App loadApp(String className) throws Exception {
        if (className != null) {
            Class<?> appClass;
            block18: {
                appClass = null;
                try {
                    ClassLoader loader;
                    block19: {
                        URL[] urls = this.prepareApplicationJarUrls();
                        if (urls != null) {
                            loader = new URLClassLoader(urls);
                            try {
                                appClass = loader.loadClass(className);
                                break block18;
                            }
                            catch (ClassNotFoundException e) {
                                this.tracer.log("failed to load main class [" + className + "] from application jars: " + SrvAppLoader.getClassLoaderDetails(loader), Tracer.Level.SEVERE);
                                throw new Exception("application main class [" + className + "] could not be found");
                            }
                        }
                        loader = Thread.currentThread().getContextClassLoader();
                        if (loader != null) {
                            try {
                                appClass = loader.loadClass(className);
                            }
                            catch (ClassNotFoundException e) {
                                if (!this.tracer.debug) break block19;
                                this.tracer.log("failed to load main class [" + className + "] from context loader: " + SrvAppLoader.getClassLoaderDetails(loader), Tracer.Level.DEBUG);
                            }
                        }
                    }
                    if (appClass != null) break block18;
                    loader = ((Object)((Object)this)).getClass().getClassLoader();
                    try {
                        appClass = loader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        if (this.tracer.debug) {
                            this.tracer.log("failed to load main class [" + className + "] from current classloader: " + SrvAppLoader.getClassLoaderDetails(loader), Tracer.Level.SEVERE);
                        }
                        throw new Exception("application main class [" + className + "] could not be found");
                    }
                }
                catch (UnsupportedClassVersionError e) {
                    throw new Exception("application main class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
                }
            }
            Constructor<?> constructor = null;
            try {
                Class[] parameterTypes = new Class[]{};
                constructor = appClass.getConstructor(parameterTypes);
            }
            catch (SecurityException e) {
                throw new Exception("access to the default constructor in application main class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("the default constructor could not be found in the application main class [" + className + "]");
            }
            App app = null;
            try {
                Object[] parameters = new Object[]{};
                app = new App(constructor.newInstance(parameters));
            }
            catch (IllegalAccessException e) {
                throw new Exception("access to constructor in application main class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return app;
        }
        throw new Exception("application main class not specified");
    }

    final boolean isAdminApp() {
        return this.app.getMain().getClass().getSimpleName().equals("SrvControllerAdminApp");
    }

    final void open() throws Exception {
        this.tracer.log("Opening application [" + this.getAppName() + "]...", Tracer.Level.INFO);
        try {
            this.app.injectLoader();
            AepEngineDescriptor engineDescriptor = AepEngineDescriptor.exists((String)this.getAppName()) ? AepEngineDescriptor.load((String)this.getAppName()) : AepEngineDescriptor.create((String)this.getAppName());
            if (this.app.main.getClass().getAnnotation(AppHAPolicy.class) != null) {
                AppHAPolicy haPolicyAnnotation = this.app.main.getClass().getAnnotation(AppHAPolicy.class);
                engineDescriptor.setHAPolicy(haPolicyAnnotation.value());
            }
            this.app.injectEngineDescriptor(engineDescriptor);
            this.app.populateConfiguredObjects();
            this.app.initCommandHandlers();
            Set<Object> eventHandlerContainers = this.app.getEventHandlerContainers();
            IEventHandler defaultEventHandler = this.app.getDefaultEventHandler();
            this.app.initStatProviders();
            this.app.injectMessageSender();
            AepEngine engine = AepEngine.create((AepEngineDescriptor)engineDescriptor, (IAepApplicationStateFactory)this.app.getStateFactory(), eventHandlerContainers, (IEventHandler)defaultEventHandler, this.app.getMessageSender() == null ? null : Arrays.asList(this.app.getMessageSender()), null);
            this.app.injectEngine(engine);
            this.app.injectIndexes();
            for (IStats.Counter counter : this.app.counterStats.values()) {
                engine.registerCounterStat(counter);
            }
            for (IStats.Gauge gauge : this.app.gaugeStats.values()) {
                engine.registerGaugeStat(gauge);
            }
            for (IStats.Series latencies : this.app.seriesStats.values()) {
                engine.registerSeriesStat(latencies);
            }
            this.app.setEventDispatcher(AepEventDispatcher.create(eventHandlerContainers, (IEventHandler)defaultEventHandler));
            this.app.initialize();
            if (this.appWatcher != null) {
                this.appWatcher.onAppInitialized(this, System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log("...open failed [" + error + "]", Tracer.Level.WARNING);
            throw new Exception(error, e);
        }
    }

    final void start(boolean async) throws Exception {
        if (this.appStarter != null) {
            throw new IllegalStateException("app has already been scheduled previously for start");
        }
        if (async) {
            this.tracer.log("Scheduling application [" + this.getAppName() + "] start...", Tracer.Level.INFO);
            this.appStarter = new Thread(){

                @Override
                public final void run() {
                    try {
                        SrvAppLoader.this.app.start();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            this.appStarter.start();
        } else {
            this.app.start();
        }
    }

    final Object issueAppCommand(String command, String[] args) throws Exception {
        return this.app.issueCommand(command, args);
    }

    final SrvMonListCommandsResponse getAppCommands(SrvMonListCommandsRequest request) throws Exception {
        return this.app.getCommands(request);
    }

    final void dispatchEvent(Object event) {
        this.app.dispatchEvent(event);
    }

    final void stop() throws Exception {
        this.tracer.log("Stopping application [" + this.getAppName() + "]...", Tracer.Level.INFO);
        Thread appStarter = this.appStarter;
        if (appStarter != null) {
            while (true) {
                try {
                    appStarter.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        try {
            this.app.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log("...stop failed [" + error + "]", Tracer.Level.WARNING);
            throw new Exception(error);
        }
    }

    final void close() {
        try {
            this.tracer.log("Unloading application [" + this.getAppName() + "]...", Tracer.Level.INFO);
            this.stop();
            this.app.finalise();
            if (this.appWatcher != null) {
                this.appWatcher.onAppUnloaded(this.appDescriptor.getName(), System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            String error = e.getMessage() == null ? e.toString() : e.getMessage();
            this.tracer.log("...unload error [" + error + "]", Tracer.Level.WARNING);
        }
    }

    public final SrvConfigDescriptor getServerDescriptor() {
        return this.configDescriptor;
    }

    public final SrvConfigAppDescriptor getAppDescriptor() {
        return this.appDescriptor;
    }

    public final String getAppName() {
        return this.name;
    }

    public final short getAppVersion() {
        return this.app.getVersion();
    }

    public final String getAppJarVersion() {
        return this.app.getJarVersion();
    }

    public final Object getAppMain() {
        return this.app.getMain();
    }

    public final IAepApplicationStateFactory getAppStateFactory() throws Exception {
        return this.app.getStateFactory();
    }

    public final AepEngine getAppEngine() {
        return this.app.getEngine();
    }

    public final SrvAppManager getAppManager() {
        return this.appManager;
    }

    public final void scheduleAppUnload() throws ESrvAppException {
        this.appManager.scheduleAppUnload(this.getAppName());
    }

    public final void scheduleAppReload() throws ESrvAppException {
        this.appManager.scheduleAppReload(this.getAppName());
    }

    public final void scheduleAppEvent(Object event) throws ESrvAppException {
        this.appManager.scheduleAppEvent(this.getAppName(), event);
    }

    public final void scheduleServerStop() {
        this.appManager.getServerStopper().stop();
    }

    public static final void main(String[] args) {
        System.out.println("Manifest.class: " + SrvAppLoader.findJarVersion(Manifest.class));
        System.out.println("SrvAppLoader.class: " + SrvAppLoader.findJarVersion(SrvAppLoader.class));
    }

    public final class AepEngineWatcher {
        @EventHandler
        public final void onBusBindingCreated(AepBusBindingCreatedEvent event) {
            SrvMonAppBusBindingCreatedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingCreated(message);
            }
        }

        @EventHandler
        public final void onBusBindingCreateFailed(AepBusBindingCreateFailedEvent event) {
            SrvMonAppBusBindingCreateFailedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onEngineCreated(AepEngineCreatedEvent event) {
            SrvMonAppEngineCreatedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStoreMemberUp(StoreMemberUpEvent event) {
            SrvMonAppStoreMemberUpMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStoreMemberInitComplete(StoreMemberInitCompleteEvent event) {
            SrvMonAppStoreMemberInitCompleteMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onEngineStarted(AepEngineStartedEvent event) {
            SrvMonAppEngineStartedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppStarted(message);
            }
        }

        @EventHandler
        public final void onBusBindingOpening(AepBusBindingOpeningEvent event) {
            SrvMonAppBusBindingOpeningMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingOpening(message);
            }
        }

        @EventHandler
        public final void onBusBindingOpened(AepBusBindingOpenedEvent event) {
            SrvMonAppBusBindingOpenedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingOpened(message);
            }
        }

        @EventHandler
        public final void onBusBindingOpenFailed(AepBusBindingOpenFailedEvent event) {
            SrvMonAppBusBindingOpenFailedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingOpenFailed(message);
            }
        }

        @EventHandler
        public final void onChannelUp(AepChannelUpEvent event) {
            SrvMonAppChannelUpMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppChannelUp(message);
            }
        }

        @EventHandler
        public final void onBusBindingUp(AepBusBindingUpEvent event) {
            SrvMonAppBusBindingUpMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onMessagingPrestart(AepMessagingPrestartEvent event) {
            SrvMonAppMessagingPrestartMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onMessagingStarted(AepMessagingStartedEvent event) {
            SrvMonAppMessagingStartedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onMessagingStartFailed(AepMessagingStartFailedEvent event) {
            SrvMonAppMessagingStartFailedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onEngineActive(AepEngineActiveEvent event) {
            SrvMonAppEngineActiveMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppActive(message);
            }
            SrvAppLoader.this.app.activate();
        }

        @EventHandler
        public final void onStoreBindingRoleChange(StoreBindingRoleChangedEvent event) {
            SrvMonAppStoreBindingRoleChangedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStoreMemberDown(StoreMemberDownEvent event) {
            SrvMonAppStoreMemberDownMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStoreBindingFailed(StoreBindingFailedEvent event) {
            SrvMonAppStoreBindingFailedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onChannelDown(AepChannelDownEvent event) {
            SrvMonAppChannelDownMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppChannelDown(message);
            }
        }

        @EventHandler
        public final void onBusBindingDown(AepBusBindingDownEvent event) {
            SrvMonAppBusBindingDownMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingFailed(message);
            }
        }

        @EventHandler
        public final void onMessagingFailed(AepMessagingFailedEvent event) {
            SrvMonAppMessagingFailedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onBusBindingDestroyed(AepBusBindingDestroyedEvent event) {
            SrvMonAppBusBindingDestroyedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppBusBindingDestroyed(message);
            }
        }

        @EventHandler
        public final void onClientConnected(AepClientConnectedEvent event) {
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppClientConnected(SrvAppLoader.this.getAppName(), event.getClient().getName());
            }
        }

        @EventHandler
        public final void onClientDisconnected(AepClientDisconnectedEvent event) {
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppClientDisconnected(SrvAppLoader.this.getAppName(), event.getClient().getName());
            }
        }

        @EventHandler
        public final void onFlowCreated(AepFlowCreatedEvent event) {
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppFlowCreated(SrvAppLoader.this.getAppName(), event.getEventTime(), event.getFlowId());
            }
        }

        @EventHandler
        public final void onEngineStopped(AepEngineStoppedEvent event) {
            SrvMonAppEngineStoppedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppStopped(message);
            }
            SrvAppLoader.this.appManager.onAppStopped(SrvAppLoader.this);
        }

        @EventHandler
        public final void onEngineStopping(AepEngineStoppingEvent event) {
            SrvMonAppEngineStoppingMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStoreTransactionLogRepaired(StoreTransactionLogRepairedEvent event) {
            SrvMonAppStoreTransactionLogRepairedMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onDuplicateAcknowledgement(AepDuplicateAcknowledgementAlertEvent event) {
            SrvMonAppDuplicateAcknowledgementAlertMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onInboundLogException(AepInboundLogExceptionEvent event) {
            SrvMonAppInboundLogExceptionMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onOutboundLogException(AepOutboundLogExceptionEvent event) {
            SrvMonAppOutboundLogExceptionMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onOutOfOrderSendCommitCompletion(AepOutOfOrderSendCommitCompletionAlertEvent event) {
            SrvMonAppOutOfOrderSendCommitCompletionAlertMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onSendException(AepSendExceptionEvent event) {
            SrvMonAppSendExceptionMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStatsAlert(AepStatsAlertEvent event) {
            SrvMonAppStatsAlertMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onStuckAlert(AepStuckAlertEvent event) {
            SrvMonAppStuckAlertMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onAepUnhandledMessage(AepUnhandledMessageEvent event) {
            SrvMonAppUnhandledMessageMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onUnhandledMessage(UnhandledMessageEvent event) {
            SrvMonUnhandledMessageMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onTrappedException(AepMessageTraceLoggingExceptionEvent event) {
            SrvMonMessageTraceLoggingExceptionMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }

        @EventHandler
        public final void onAepApplicationExceptionEvent(AepApplicationExceptionEvent event) {
            SrvMonAppExceptionMessage message = SrvMonUtil.setBackingMessage(SrvAppLoader.this.getAppName(), event);
            if (SrvAppLoader.this.appWatcher != null) {
                SrvAppLoader.this.appWatcher.onAppMonEvent(SrvAppLoader.this.getAppName(), message);
            }
        }
    }

    private final class App {
        private final XLinkedHashMap<String, CommandHandler> commandHandlers = new XLinkedHashMap();
        private final XLinkedHashMap<String, CommandHandler> commandHandlersAliases = new XLinkedHashMap();
        private final Object main;
        private final short version;
        private final String jarVersion;
        private final MainThread mainThread;
        private Method initializer;
        private Method eventHandlerAccessor;
        private Method eventHandlerContainersAccessor;
        private Method commandHandlerContainersAccessor;
        private SrvMonListCommandsResponse commandListResponse;
        private Method configuredObjectAccessor;
        private Method statContainersAccessor;
        private Method stateFactoryAccessor;
        private Method appIntrospectionPointsAccessor;
        private HashMap<Class<?>, IntrospectedClass> introspectionCache = new HashMap();
        private Method mainMethod;
        private Method finalizer;
        private AepEventDispatcher eventDispatcher;
        private AepEngine engine;
        private AepMessageSender messageSender;
        private TreeMap<String, IStats.Series> seriesStats = new TreeMap();
        private TreeMap<String, IStats.Counter> counterStats = new TreeMap();
        private TreeMap<String, IStats.Gauge> gaugeStats = new TreeMap();
        private Set<String> indexNames = new HashSet<String>();
        private Map<Object, Field> uniqueStoreIndexFields = new XLinkedHashMap();
        private Map<Object, Field> nonUniqueStoreIndexFields = new XLinkedHashMap();

        App(Object object) throws Exception {
            AppVersion appVersion;
            this.main = object;
            Class<?> clazz = this.main.getClass();
            if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                SrvAppLoader.this.tracer.log("...main class='" + clazz.getName() + "'", Tracer.Level.DEBUG);
            }
            this.version = (appVersion = clazz.getAnnotation(AppVersion.class)) == null ? (short)1 : appVersion.value();
            this.jarVersion = SrvAppLoader.findJarVersion(clazz);
            if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                SrvAppLoader.this.tracer.log("...version=" + this.version, Tracer.Level.DEBUG);
            }
            this.mainThread = new MainThread();
            Collection methodList = UtlReflection.collectAllMethods(clazz);
            Method[] methods = methodList.toArray(new Method[0]);
            for (int i = 0; i < methods.length; ++i) {
                Class<?> returnType;
                Class<?>[] paramTypes;
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("...method=" + methods[i], Tracer.Level.DEBUG);
                }
                if (methods[i].isAnnotationPresent(AppInitializer.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 0) {
                        if (this.initializer == null) {
                            if (!this.ensureAccessible(clazz, methods[i], AppInitializer.class)) continue;
                            this.initializer = methods[i];
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....application initializer", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (duplicate initializer)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (initializer but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppFinalizer.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 0) {
                        if (this.finalizer == null) {
                            if (!this.ensureAccessible(clazz, methods[i], AppFinalizer.class)) continue;
                            this.finalizer = methods[i];
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....application finalizer", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (duplicate finalizer)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (finalizer but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppMain.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 1) {
                        if (paramTypes[0].isArray() && paramTypes[0].getComponentType() == String.class) {
                            if (this.mainMethod == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppMain.class)) continue;
                                this.mainMethod = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application main", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate main)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (main but invalid parameter type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (main but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppEventHandlerAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    returnType = methods[i].getReturnType();
                    if (paramTypes.length == 0) {
                        if (returnType == IEventHandler.class) {
                            if (this.eventHandlerAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppEventHandlerAccessor.class)) continue;
                                this.eventHandlerAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application event handler accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate event handler accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (event handler accessor but invalid return type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (event handler accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppEventHandlerContainersAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 1) {
                        if (paramTypes[0] == Set.class) {
                            if (this.eventHandlerContainersAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppEventHandlerContainersAccessor.class)) continue;
                                this.eventHandlerContainersAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application event handler containers accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate event handler accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (event handler container accessor but invalid parameter type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (event handler container accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppCommandHandlerContainersAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 1) {
                        if (paramTypes[0] == Set.class) {
                            if (this.commandHandlerContainersAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppCommandHandlerContainersAccessor.class)) continue;
                                this.commandHandlerContainersAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application command handler containers accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate command handler accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (command handler container accessor but invalid parameter type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (command handler container accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppStatContainersAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 1) {
                        if (paramTypes[0] == Set.class) {
                            if (this.statContainersAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppStatContainersAccessor.class)) continue;
                                this.statContainersAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application stat containers accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate stat containers accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (stats container accessor but invalid parameter type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (stats container accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppConfiguredAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    if (paramTypes.length == 1) {
                        if (paramTypes[0] == Set.class) {
                            if (this.configuredObjectAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppConfiguredAccessor.class)) continue;
                                this.configuredObjectAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application configured objects accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate configured accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (configured object accessor but invalid parameter type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (configured object accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (methods[i].isAnnotationPresent(AppStateFactoryAccessor.class)) {
                    paramTypes = methods[i].getParameterTypes();
                    returnType = methods[i].getReturnType();
                    if (paramTypes.length == 0) {
                        if (returnType == IAepApplicationStateFactory.class) {
                            if (this.stateFactoryAccessor == null) {
                                if (!this.ensureAccessible(clazz, methods[i], AppStateFactoryAccessor.class)) continue;
                                this.stateFactoryAccessor = methods[i];
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....application state factory accessor", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate state factory accessor)", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (state factory accessor but invalid return type)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (state factory accessor but param count != 0)", Tracer.Level.DEBUG);
                    continue;
                }
                if (!methods[i].isAnnotationPresent(AppIntrospectionPoints.class)) continue;
                paramTypes = methods[i].getParameterTypes();
                if (paramTypes.length == 1) {
                    if (paramTypes[0] == Set.class) {
                        if (this.appIntrospectionPointsAccessor == null) {
                            if (!this.ensureAccessible(clazz, methods[i], AppIntrospectionPoints.class)) continue;
                            this.appIntrospectionPointsAccessor = methods[i];
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....application introspection points accessor", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (duplicate introspection points accessor)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (introspection points container accessor but invalid parameter type)", Tracer.Level.DEBUG);
                    continue;
                }
                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                SrvAppLoader.this.tracer.log(".....ignored (introspection points accessor but param count != 0)", Tracer.Level.DEBUG);
            }
        }

        @Command(name="role", displayName="Get App Role", group={"App", "Admin", "Loader"}, hidden=true, description="Gets the app's current HA role")
        public final String role() throws Exception {
            return this.engine.getStore() != null ? this.engine.getStore().getRole().toString() : "Standalone";
        }

        @Command(name="appstartdone", displayName="Get App Start Status", group={"App", "Admin", "Loader"}, hidden=true, description="Tests whether the application has finished starting")
        public final String appStartDone() throws Exception {
            switch (this.engine.getState()) {
                case Init: {
                    throw new IllegalStateException("app has not been started");
                }
                case Starting: {
                    return "NOK App is still starting";
                }
            }
            return "OK ";
        }

        @Command(name="appstate", displayName="Get App State", group={"App", "Admin", "Loader"}, hidden=true, description="Gets the app's current state")
        public final String appState() throws Exception {
            return this.engine.getState().toString();
        }

        @Command(name="scheduletxnlogcompaction", displayName="Trigger Log Compaction", group={"App", "Admin"}, hidden=true, description="Schedule compaction (on next write) to the application's transaction log")
        public final String scheduleTransactionLogCompaction() throws Exception {
            IStoreBinding store = this.engine.getStore();
            if (store != null) {
                IStorePersister persister = store.getPersister();
                if (persister != null) {
                    if (persister instanceof RogLog) {
                        ((RogLog)persister).scheduleCompactionOnNextWrite();
                        SrvAppLoader.this.tracer.log("Scheduled compaction on next write to transaction log for the '" + this.engine.getName() + "' app.", Tracer.Level.INFO);
                        return "OK ";
                    }
                    return "NOK Compaction scheduling is only supported on the platform's native log";
                }
                return "NOK App store is non persistent";
            }
            return "NOK App does not have a store";
        }

        @Command(name="settxnlogcompactionthreshold", displayName="Set Log Compaction Threshold", group={"App", "Admin"}, hidden=true, description="Sets the compaction threshold for the app's persister. When no unit is specified this value is interpretted as being in megabytes.")
        public final String setTransactionLogCompactionThreshold(@Argument(position=1, name="threshold", required=true, description="The new compaction threshold") String val) throws Exception {
            IStoreBinding store = this.engine.getStore();
            if (store != null) {
                IStorePersister persister = store.getPersister();
                if (persister != null) {
                    if (persister instanceof RogLog) {
                        int threshold = (int)UtlUnit.parseBytes((String)val, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes);
                        ((RogLog)persister).setCompactionThreshold(threshold);
                        SrvAppLoader.this.tracer.log("Set compaction threshold on the transaction log for the '" + this.engine.getName() + "' app to " + UtlUnit.readableBytesSize((long)threshold), Tracer.Level.INFO);
                        return "OK ";
                    }
                    return "NOK Compaction scheduling is only supported on the platform's native log";
                }
                return "NOK App store is non persistent";
            }
            return "NOK App does not have a store";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void initCommandHandlers() throws Exception {
            if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                SrvAppLoader.this.tracer.log("...command handlers containers...", Tracer.Level.DEBUG);
            }
            Set<Object> commandHandlerContainers = this.getCommandHandlerContainers();
            for (Object object : commandHandlerContainers) {
                if (object == null) {
                    throw new IllegalArgumentException("Adding a null command handler container in to the set of handler containers set is not supported.");
                }
                Class<?> clazz = object.getClass();
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("......class='" + clazz.getName() + "'", Tracer.Level.DEBUG);
                }
                Collection methodList = UtlReflection.collectAllMethods(clazz);
                Method[] methods = methodList.toArray(new Method[0]);
                for (int i = 0; i < methods.length; ++i) {
                    if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                        SrvAppLoader.this.tracer.log(".........method=" + methods[i], Tracer.Level.DEBUG);
                    }
                    AppCommandHandler srvAnnotation = methods[i].getAnnotation(AppCommandHandler.class);
                    Command cliAnnotation = methods[i].getAnnotation(Command.class);
                    if (srvAnnotation != null || cliAnnotation != null) {
                        if (srvAnnotation != null && !this.ensureAccessible(clazz, methods[i], AppCommandHandler.class) || cliAnnotation != null && !this.ensureAccessible(clazz, methods[i], Command.class)) continue;
                        try {
                            CommandHandler handler = new CommandHandler(object, methods[i]);
                            CommandHandler existing = (CommandHandler)this.commandHandlers.get((Object)handler.command);
                            if (existing == null) {
                                if (!handler.validateCommand(SrvAppLoader.this.tracer)) {
                                    SrvAppLoader.this.tracer.log(".....ignored invalid command handler for '" + handler.command + "' command", Tracer.Level.WARNING);
                                    continue;
                                }
                                this.commandHandlers.put((Object)handler.command, (Object)handler);
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....handler for '" + handler.command + "' command", Tracer.Level.DEBUG);
                                continue;
                            }
                            SrvAppLoader.this.tracer.log(".....ignored (duplicate '" + handler.command + "' command handler)", Tracer.Level.WARNING);
                        }
                        catch (Exception e) {
                            SrvAppLoader.this.tracer.log(".....invalid command handler: " + e.getMessage() + " " + methods[i] + " will not be available as a command handler.", Tracer.Level.WARNING);
                        }
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (not annotated)", Tracer.Level.DEBUG);
                }
            }
            this.commandListResponse = SrvMonListCommandsResponse.create();
            if (this.commandHandlers.size() > 0) {
                Iterator<Object> iterator = this.commandHandlers;
                synchronized (iterator) {
                    XIterator commandIterator = this.commandHandlers.reuseableValueIterator();
                    while (commandIterator.hasNext()) {
                        String[] aliases;
                        CommandHandler handler = (CommandHandler)commandIterator.next();
                        this.commandListResponse.addCommands(handler.createCommandDescription());
                        if (handler.executor == null || (aliases = handler.executor.getCommandAliases()) == null) continue;
                        for (int a = 0; a < aliases.length; ++a) {
                            CommandHandler old = (CommandHandler)this.commandHandlersAliases.put((Object)aliases[a], (Object)handler);
                            if (old == null) continue;
                            SrvAppLoader.this.tracer.log(".....duplicate command handler alias '" + aliases[a] + "' '" + handler.command + "' replaced '" + old.command + "'", Tracer.Level.WARNING);
                        }
                    }
                }
            }
            this.commandListResponse.sync();
        }

        private boolean ensureAccessible(Class<?> containerClass, Method method, Class<? extends Annotation> annotation) {
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    SrvAppLoader.this.tracer.log(annotation.getSimpleName() + " annotated method '" + method.toString() + " declared in " + containerClass.getCanonicalName() + " is not accessible and will be ingnored.", Tracer.Level.WARNING);
                    return false;
                }
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("....." + annotation.getSimpleName() + " annotated method '" + method.toString() + " declared in " + containerClass.getCanonicalName() + " was made accessible.", Tracer.Level.DEBUG);
                }
            }
            return true;
        }

        private boolean ensureAccessible(Class<?> containerClass, Field field, Class<? extends Annotation> annotation) {
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException se) {
                    SrvAppLoader.this.tracer.log(annotation.getSimpleName() + " annotated field '" + field.toString() + " declared in " + containerClass.getCanonicalName() + " is not accessible and will be ingnored.", Tracer.Level.WARNING);
                    return false;
                }
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("....." + annotation.getSimpleName() + " annotated field '" + field.toString() + " declared in " + containerClass.getCanonicalName() + " was made accessible.", Tracer.Level.DEBUG);
                }
            }
            return true;
        }

        final void initStatProviders() throws Exception {
            if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                SrvAppLoader.this.tracer.log("...stat provider containers...", Tracer.Level.DEBUG);
            }
            Set<Object> statContainers = this.getStatContainers();
            for (Object object : statContainers) {
                Class<?> clazz = object.getClass();
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("......class='" + clazz.getName() + "'", Tracer.Level.DEBUG);
                }
                Collection methodList = UtlReflection.collectAllMethods(clazz);
                Method[] methods = methodList.toArray(new Method[0]);
                for (int i = 0; i < methods.length; ++i) {
                    if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                        SrvAppLoader.this.tracer.log(".........method=" + methods[i], Tracer.Level.DEBUG);
                    }
                    if (UtlReflection.isAnnotationPresent((Method)methods[i], AppStat.class)) {
                        Class<?>[] paramTypes = methods[i].getParameterTypes();
                        Class<?> returnType = methods[i].getReturnType();
                        if (paramTypes.length == 0) {
                            if (!this.ensureAccessible(clazz, methods[i], AppStat.class)) {
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....ignored inaccessible AppStat", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (IStats.Series.class.isAssignableFrom(returnType)) {
                                IStats.Series series = (IStats.Series)methods[i].invoke(object, new Object[0]);
                                if (series != null) {
                                    this.seriesStats.put(series.getName(), series);
                                    continue;
                                }
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....ignored null AppStat", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (IStats.Counter.class.isAssignableFrom(returnType)) {
                                IStats.Counter counter = (IStats.Counter)methods[i].invoke(object, new Object[0]);
                                if (counter != null) {
                                    this.counterStats.put(counter.getName(), counter);
                                    continue;
                                }
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....ignored null AppStat", Tracer.Level.DEBUG);
                                continue;
                            }
                            if (IStats.Gauge.class.isAssignableFrom(returnType)) {
                                IStats.Gauge gauge = (IStats.Gauge)methods[i].invoke(object, new Object[0]);
                                if (gauge != null) {
                                    this.gaugeStats.put(gauge.getName(), gauge);
                                    continue;
                                }
                                if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                                SrvAppLoader.this.tracer.log(".....ignored null AppStat", Tracer.Level.DEBUG);
                                continue;
                            }
                            AppStat appStat = (AppStat)UtlReflection.getAnnotation((Method)methods[i], AppStat.class);
                            if (appStat.gauge()) {
                                String name = appStat.name();
                                if (name.length() == 0) {
                                    name = clazz.getSimpleName() + "." + methods[i].getName();
                                }
                                try {
                                    this.gaugeStats.put(name, (IStats.Gauge)new MethodReflectingGauge(name, object, methods[i]));
                                }
                                catch (Throwable thrown) {
                                    SrvAppLoader.this.tracer.log(".....could not use method as Gauge stat: " + thrown.getMessage(), Tracer.Level.WARNING);
                                }
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored non stat return type: " + returnType.getCanonicalName(), Tracer.Level.DEBUG);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (AppStat provider handler param count != 0)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (not annotated)", Tracer.Level.DEBUG);
                }
                Collection fieldList = UtlReflection.collectAllFields(clazz);
                Field[] fields = fieldList.toArray(new Field[0]);
                for (int i = 0; i < fields.length; ++i) {
                    if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                        SrvAppLoader.this.tracer.log(".........field=" + fields[i], Tracer.Level.DEBUG);
                    }
                    if (fields[i].isAnnotationPresent(AppStat.class)) {
                        Class<?> fieldType = fields[i].getType();
                        if (IStats.Series.class.isAssignableFrom(fieldType)) {
                            IStats.Series series;
                            if (!fields[i].isAccessible()) {
                                fields[i].setAccessible(true);
                            }
                            if ((series = (IStats.Series)fields[i].get(object)) != null) {
                                this.seriesStats.put(series.getName(), series);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored null " + methods[i].getName() + "' AppStat", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (IStats.Counter.class.isAssignableFrom(fieldType)) {
                            IStats.Counter counter;
                            if (!fields[i].isAccessible()) {
                                fields[i].setAccessible(true);
                            }
                            if ((counter = (IStats.Counter)fields[i].get(object)) != null) {
                                this.counterStats.put(counter.getName(), counter);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored null " + methods[i].getName() + "' AppStat", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (IStats.Gauge.class.isAssignableFrom(fieldType)) {
                            IStats.Gauge gauge;
                            if (!fields[i].isAccessible()) {
                                fields[i].setAccessible(true);
                            }
                            if ((gauge = (IStats.Gauge)fields[i].get(object)) != null) {
                                this.gaugeStats.put(gauge.getName(), gauge);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log(".....ignored null " + methods[i].getName() + "' AppStat", Tracer.Level.DEBUG);
                            continue;
                        }
                        AppStat appStat = fields[i].getAnnotation(AppStat.class);
                        if (appStat.gauge()) {
                            String name = appStat.name();
                            if (name.length() == 0) {
                                name = clazz.getSimpleName() + "." + fields[i].getName();
                            }
                            try {
                                this.gaugeStats.put(name, (IStats.Gauge)new FieldReflectingGauge(name, object, fields[i]));
                            }
                            catch (Throwable thrown) {
                                SrvAppLoader.this.tracer.log(".....could not use field as Gauge stat: " + thrown.getMessage(), Tracer.Level.WARNING);
                            }
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored non stat field type: " + fieldType.getCanonicalName(), Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (not annotated)", Tracer.Level.DEBUG);
                }
            }
        }

        final void populateConfiguredObjects() throws Exception {
            if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                SrvAppLoader.this.tracer.log("...configured objects...", Tracer.Level.DEBUG);
            }
            Set<Object> cfgObjects = this.getConfiguredObjects();
            for (Object obj : cfgObjects) {
                Class<?> clazz = obj.getClass();
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("......class='" + clazz.getName() + "'", Tracer.Level.DEBUG);
                }
                ConfigInjector cfgInjector = ConfigInjector.createInjector((Object)obj);
                cfgInjector.populate();
            }
        }

        final void setEventDispatcher(AepEventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        final Object getMain() {
            return this.main;
        }

        final void injectLoader() throws Exception {
            this.doInjection(SrvAppLoader.class, SrvAppLoader.this);
        }

        final void injectEngineDescriptor(AepEngineDescriptor descriptor) throws Exception {
            this.doInjection(AepEngineDescriptor.class, descriptor);
        }

        final void injectEngine(AepEngine engine) throws Exception {
            this.engine = engine;
            this.doInjection(AepEngine.class, engine);
        }

        final void injectMessageSender() throws Exception {
            this.doInjection(AepMessageSender.class, this.messageSender);
        }

        private final <T> void doInjection(Class<T> injectionType, T object) throws Exception {
            Object[] parameters = new Object[]{object};
            for (Object appBean : this.getAppIntrospectionPoints()) {
                IntrospectedClass introspected = this.introspectionCache.get(appBean.getClass());
                if (introspected == null) {
                    introspected = new IntrospectedClass(appBean.getClass());
                    this.introspectionCache.put(appBean.getClass(), introspected);
                }
                if (injectionType == SrvAppLoader.class) {
                    if (introspected.appLoaderInjectionMethod != null) {
                        introspected.appLoaderInjectionMethod.invoke(appBean, parameters);
                    }
                    if (introspected.appLoaderInjectionFields == null) continue;
                    for (Field field : introspected.appLoaderInjectionFields) {
                        field.set(appBean, object);
                    }
                    continue;
                }
                if (injectionType == AepEngine.class) {
                    if (introspected.engineInjectionMethod != null) {
                        introspected.engineInjectionMethod.invoke(appBean, parameters);
                    }
                    if (introspected.engineInjectionFields == null) continue;
                    for (Field field : introspected.engineInjectionFields) {
                        field.set(appBean, object);
                    }
                    continue;
                }
                if (injectionType == AepEngineDescriptor.class) {
                    if (introspected.engineDescriptorInjectionMethod != null) {
                        introspected.engineDescriptorInjectionMethod.invoke(appBean, parameters);
                    }
                    if (introspected.engineDescriptorInjectionFields == null) continue;
                    for (Field field : introspected.engineDescriptorInjectionFields) {
                        field.set(appBean, object);
                    }
                    continue;
                }
                if (injectionType == AepMessageSender.class) {
                    if (introspected.messageSenderInjectionMethod != null) {
                        if (parameters[0] == null) {
                            parameters[0] = this.getOrCreateMessageSender();
                        }
                        introspected.messageSenderInjectionMethod.invoke(appBean, parameters);
                    }
                    if (introspected.messageSenderInjectionFields == null) continue;
                    for (Field field : introspected.messageSenderInjectionFields) {
                        if (object == null) {
                            object = this.getOrCreateMessageSender();
                        }
                        field.set(appBean, object);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unspported Injection type: " + injectionType.getName());
            }
        }

        private AepMessageSender getOrCreateMessageSender() {
            if (this.messageSender == null) {
                this.messageSender = AepMessageSender.create();
            }
            return this.messageSender;
        }

        final void injectIndexes() throws Exception {
            if (this.engine == null) {
                throw new IllegalStateException("Engine not injected yet.");
            }
            for (Map.Entry<Object, Field> kv : this.uniqueStoreIndexFields.entrySet()) {
                Field uniqueIdxField = kv.getValue();
                Object appBean = kv.getKey();
                if (!uniqueIdxField.getType().isAssignableFrom(IStoreUniqueIndex.class)) {
                    throw new RuntimeException("Unique index declared on non-compatible type '" + uniqueIdxField.getType().getName() + "'. Field must be assignable from " + IStoreUniqueIndex.class.getName());
                }
                AppStoreUniqueIndex idxDeclaration = uniqueIdxField.getAnnotation(AppStoreUniqueIndex.class);
                IStoreUniqueIndex idx = this.engine.createStoreUniqueIndex(idxDeclaration.fieldPath(), idxDeclaration.name());
                uniqueIdxField.set(appBean, idx);
            }
            for (Map.Entry<Object, Field> kv : this.nonUniqueStoreIndexFields.entrySet()) {
                Field nonUniqueIdxField = kv.getValue();
                Object appBean = kv.getKey();
                if (!nonUniqueIdxField.getType().isAssignableFrom(IStoreNonUniqueIndex.class)) {
                    throw new RuntimeException("Non-unique index declared on non-compatible type '" + nonUniqueIdxField.getType().getName() + "'. Field must be assignable from " + IStoreNonUniqueIndex.class.getName());
                }
                AppStoreNonUniqueIndex idxDeclaration = nonUniqueIdxField.getAnnotation(AppStoreNonUniqueIndex.class);
                IStoreNonUniqueIndex idx = this.engine.createStoreNonUniqueIndex(idxDeclaration.fieldPath(), idxDeclaration.name());
                nonUniqueIdxField.set(appBean, idx);
            }
        }

        final short getVersion() {
            return this.version;
        }

        final String getJarVersion() {
            return this.jarVersion;
        }

        final void initialize() throws Exception {
            if (this.initializer != null) {
                try {
                    Object[] parameters = new Object[]{};
                    this.initializer.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
        }

        final void activate() {
            this.mainThread.start();
        }

        final Object issueCommand(String command, String[] args) throws Exception {
            if (this.commandHandlers.size() > 0) {
                CommandHandler commandHandler = (CommandHandler)this.commandHandlers.get((Object)command);
                if (commandHandler == null) {
                    commandHandler = (CommandHandler)this.commandHandlersAliases.get((Object)command);
                }
                if (commandHandler != null) {
                    return commandHandler.dispatch(args);
                }
            }
            throw new Exception("unknown command '" + command + "'");
        }

        final SrvMonListCommandsResponse getCommands(SrvMonListCommandsRequest request) throws Exception {
            return ((SrvAppLoader)SrvAppLoader.this).app.commandListResponse.copy();
        }

        final void dispatchEvent(Object event) {
            if (this.eventDispatcher == null) {
                throw new IllegalStateException("event cannot be dispatched before the app loader is opened");
            }
            this.eventDispatcher.dispatchToEventHandlers(event);
        }

        final IAepApplicationStateFactory getStateFactory() throws Exception {
            IAepApplicationStateFactory factory = null;
            if (this.stateFactoryAccessor != null) {
                try {
                    Object[] parameters = new Object[]{};
                    factory = (IAepApplicationStateFactory)this.stateFactoryAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            return factory;
        }

        final Set<Object> getEventHandlerContainers() throws Exception {
            LinkedHashSet<Object> containers = new LinkedHashSet<Object>();
            containers.add(new AepEngineWatcher());
            containers.add(this.main);
            if (this.eventHandlerContainersAccessor != null) {
                try {
                    Object[] parameters = new Object[]{containers};
                    this.eventHandlerContainersAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            containers.addAll(this.getAppIntrospectionPoints());
            return containers;
        }

        final Set<Object> getCommandHandlerContainers() throws Exception {
            LinkedHashSet<Object> containers = new LinkedHashSet<Object>();
            containers.add(this);
            containers.add(this.main);
            if (this.commandHandlerContainersAccessor != null) {
                try {
                    Object[] parameters = new Object[]{containers};
                    this.commandHandlerContainersAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            containers.addAll(this.getAppIntrospectionPoints());
            return containers;
        }

        final Set<Object> getStatContainers() throws Exception {
            HashSet<Object> containers = new HashSet<Object>();
            containers.add(this.main);
            if (this.statContainersAccessor != null) {
                try {
                    Object[] parameters = new Object[]{containers};
                    this.statContainersAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            containers.addAll(this.getAppIntrospectionPoints());
            return containers;
        }

        final Set<Object> getConfiguredObjects() throws Exception {
            HashSet<Object> objects = new HashSet<Object>();
            objects.add(this.main);
            if (this.configuredObjectAccessor != null) {
                try {
                    Object[] parameters = new Object[]{objects};
                    this.configuredObjectAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            objects.addAll(this.getAppIntrospectionPoints());
            return objects;
        }

        final IEventHandler getDefaultEventHandler() throws Exception {
            IEventHandler eventHandler = null;
            if (this.eventHandlerAccessor != null) {
                try {
                    Object[] parameters = new Object[]{};
                    eventHandler = (IEventHandler)this.eventHandlerAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            return eventHandler;
        }

        final AepEngine getEngine() {
            return this.engine;
        }

        final AepMessageSender getMessageSender() {
            return this.messageSender;
        }

        final Set<Object> getAppIntrospectionPoints() throws Exception {
            LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
            objects.add(this.main);
            if (this.appIntrospectionPointsAccessor != null) {
                try {
                    Object[] parameters = new Object[]{objects};
                    this.appIntrospectionPointsAccessor.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            return objects;
        }

        final void start() throws Exception {
            SrvAppLoader.this.tracer.log("Starting application [" + SrvAppLoader.this.getAppName() + "]...", Tracer.Level.INFO);
            try {
                this.engine.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                String error = e.getMessage() == null ? e.toString() : e.getMessage();
                SrvAppLoader.this.tracer.log("...start failed [" + error + "]", Tracer.Level.WARNING);
                throw new Exception(error);
            }
        }

        final void stop() throws Exception {
            SrvAppLoader.this.appManager.releaseAppsTableLock();
            try {
                this.engine.stop();
            }
            finally {
                SrvAppLoader.this.appManager.acquireAppsTableLock();
            }
        }

        final void finalise() throws Exception {
            if (this.finalizer != null) {
                try {
                    Object[] parameters = new Object[]{};
                    this.finalizer.invoke(this.main, parameters);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new Exception(targetException);
                }
            }
            this.mainThread.interrupt();
            this.mainThread.join();
        }

        private final class MainThread
        extends Thread {
            MainThread() {
                this.setName("X-Server-" + SrvAppLoader.this.configDescriptor.getName() + "-App-" + SrvAppLoader.this.getAppName() + "-Main");
            }

            private final String[] parseAppMainArgs() {
                ArrayList<String> args = new ArrayList<String>();
                String mainArgs = SrvAppLoader.this.appDescriptor.getProperty("MainArgs");
                if (mainArgs != null) {
                    StringTokenizer tokenizer = new StringTokenizer(mainArgs, " ");
                    while (tokenizer.hasMoreTokens()) {
                        args.add(tokenizer.nextToken());
                    }
                }
                return args.toArray(new String[args.size()]);
            }

            @Override
            public final void run() {
                UtlThread.setDefaultCPUAffinityMask();
                if (App.this.mainMethod != null) {
                    try {
                        try {
                            Object[] parameters = new Object[]{this.parseAppMainArgs()};
                            App.this.mainMethod.invoke(App.this.main, parameters);
                        }
                        catch (InvocationTargetException e) {
                            throw new Exception(e.getTargetException());
                        }
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("App '" + SrvAppLoader.this.getAppName() + "' main thread faulted with error [" + e.toString() + "] with the following stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        SrvAppLoader.this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                    }
                }
            }
        }

        private final class CommandHandler {
            final Object container;
            final AppCommandHandler srvAnnotation;
            final CommandExecutor executor;
            final String command;
            private final Method method;
            private final Object[] parameters;

            CommandHandler(Object container, Method method) throws CliException {
                this.srvAnnotation = method.getAnnotation(AppCommandHandler.class);
                this.container = container;
                if (this.srvAnnotation != null) {
                    this.command = this.srvAnnotation.command();
                    this.executor = null;
                } else {
                    this.executor = CommandExecutor.createExecutor((Object)container, (Method)method);
                    this.command = this.executor.getCommandName();
                }
                this.method = method;
                this.parameters = new Object[method.getParameterTypes().length];
            }

            public SrvMonCommandDescription createCommandDescription() {
                SrvMonCommandDescription commandDescription = SrvMonCommandDescription.create();
                if (this.srvAnnotation != null) {
                    commandDescription.setName(this.command);
                    commandDescription.setDescription(WordUtils.wrap((String)("Invokes " + this.container.getClass().getName() + "." + this.method.getName() + "(...)."), (int)80, (String)"\n  ", (boolean)false));
                    commandDescription.setAdditionalArgs(true);
                    commandDescription.setReturnType(SrvMonUtil.convertToReturnType(this.method.getReturnType()));
                } else {
                    commandDescription.setName(this.executor.getCommandName());
                    commandDescription.setDisplayName(this.executor.getCommandDisplayName());
                    commandDescription.setAliases(this.executor.getCommandAliases());
                    commandDescription.setDescription(this.executor.getCommandDescription());
                    commandDescription.setReturnType(SrvMonUtil.convertToReturnType(this.executor.getReturnType()));
                    commandDescription.setGroup(this.executor.getCommandGroup());
                    commandDescription.setHidden(this.executor.isCommandHidden());
                    List argHandlers = this.executor.getArgumentHandlers();
                    for (int i = 0; i < argHandlers.size(); ++i) {
                        ArgumentHandler aHandler = (ArgumentHandler)argHandlers.get(i);
                        SrvMonArgumentDescription argument = SrvMonArgumentDescription.create();
                        argument.setName(aHandler.getName());
                        argument.setDisplayName(aHandler.getDisplayName());
                        argument.setPosition(aHandler.getPosition());
                        Object defaultValue = aHandler.getDefaultValue();
                        argument.setDefaultValue(defaultValue == null ? null : defaultValue.toString());
                        argument.setDescription(aHandler.getDescription());
                        argument.setRequired(aHandler.getRequired());
                        argument.setType(SrvMonUtil.convertToArgumentType(aHandler.getArgumentType()));
                        Set validValues = aHandler.getValidValues();
                        if (validValues == null) {
                            argument.setValidValues(null);
                        } else {
                            for (String val : validValues) {
                                argument.addValidValues(val);
                            }
                        }
                        commandDescription.addArguments(argument);
                    }
                    RemainingArgsHandler remainingArgsHandler = this.executor.getRemainingArgsHandler();
                    if (remainingArgsHandler != null) {
                        commandDescription.setAdditionalArgs(true);
                        commandDescription.setAdditionalArgsDisplayName(remainingArgsHandler.getDisplayName());
                        commandDescription.setAdditionalArgsDescription(remainingArgsHandler.getDescription());
                    }
                    List optionHandlers = this.executor.getOptionHandlers();
                    for (int i = 0; i < optionHandlers.size(); ++i) {
                        OptionHandler oHandler = (OptionHandler)optionHandlers.get(i);
                        SrvMonOptionDescription option = SrvMonOptionDescription.create();
                        option.setShortForm(oHandler.getShortForm());
                        option.setLongForm(oHandler.getLongForm());
                        option.setDisplayName(oHandler.getDisplayName());
                        String defaultValue = oHandler.getDefaultValue();
                        option.setDefaultValue(defaultValue == null ? null : defaultValue.toString());
                        option.setDescription(oHandler.getDescription());
                        option.setRequired(oHandler.getRequired());
                        option.setType(SrvMonUtil.convertToOptionType(oHandler.getOptionType()));
                        Set validValues = oHandler.getValidValues();
                        if (validValues == null) {
                            option.setValidValues(null);
                        } else {
                            for (String val : validValues) {
                                option.addValidValues(val);
                            }
                        }
                        commandDescription.addOptions(option);
                    }
                }
                return commandDescription;
            }

            public boolean validateCommand(Tracer tracer) {
                if (this.executor == null) {
                    if (this.method.getParameterTypes().length != 2 || this.method.getParameterTypes()[0] != String.class || this.method.getParameterTypes()[1] != String[].class) {
                        tracer.log("Invalid command parameter singature for AppCommandHandler annotated command, expected (String command, String [] args).", Tracer.Level.SEVERE);
                        return false;
                    }
                    Class<?> returnType = this.method.getReturnType();
                    if (returnType != String.class) {
                        tracer.log("Invalid command return type '" + returnType + "' for AppCommandHandler annotated command expected String return type.", Tracer.Level.SEVERE);
                        return false;
                    }
                    return true;
                }
                boolean valid = true;
                Class<?> returnType = this.method.getReturnType();
                if (returnType != Void.class) {
                    if (returnType.isArray()) {
                        valid = false;
                        tracer.log("Invalid command return type '" + returnType + "' is not a supported return type for command handlers, arrays aren't supported.", Tracer.Level.SEVERE);
                    }
                    if (!UtlDataTypes.canConvert(returnType, String.class)) {
                        tracer.log("Invalid command return type '" + returnType + "' is not a supported return type for command handlers.", Tracer.Level.SEVERE);
                    }
                }
                return valid;
            }

            final Object dispatch(String[] args) throws Exception {
                try {
                    if (this.executor == null) {
                        this.parameters[0] = this.command;
                        this.parameters[1] = args;
                        Object ret = this.method.invoke(this.container, this.parameters);
                        if (ret instanceof String) {
                            return ret;
                        }
                        throw new Exception("invalid command handler [returned value of invalid type]");
                    }
                    return this.executor.execute(args);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof ESrvAppCommandFailure) {
                        throw (ESrvAppCommandFailure)((Object)targetException);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("Application ('" + SrvAppLoader.this.getAppName() + "') command handler ('" + this.command + "') faulted with error [" + targetException.toString() + "].\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)targetException));
                    SrvAppLoader.this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    throw new Exception(targetException);
                }
            }
        }

        private final class IntrospectedClass {
            private final Class<?> introspectedClass;
            private Method appLoaderInjectionMethod;
            private Method engineDescriptorInjectionMethod;
            private Method engineInjectionMethod;
            private Method messageSenderInjectionMethod;
            private XLinkedList<Field> appLoaderInjectionFields;
            private XLinkedList<Field> engineDescriptorInjectionFields;
            private XLinkedList<Field> engineInjectionFields;
            private XLinkedList<Field> messageSenderInjectionFields;

            public IntrospectedClass(Class<?> introspectedClass) {
                this.introspectedClass = introspectedClass;
                Collection appBeanMethodList = UtlReflection.collectAllMethods(introspectedClass);
                Method[] appBeanMethods = appBeanMethodList.toArray(new Method[0]);
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("...introspecting class '" + introspectedClass + "' methods", Tracer.Level.DEBUG);
                }
                for (int i = 0; i < appBeanMethods.length; ++i) {
                    if (appBeanMethods[i].isAnnotationPresent(AppInjectionPoint.class)) {
                        Class<?>[] paramTypes = appBeanMethods[i].getParameterTypes();
                        if (paramTypes.length == 1) {
                            if (paramTypes[0] == SrvAppLoader.class) {
                                this.appLoaderInjectionMethod = this.introspectInjectionMethod(SrvAppLoader.class, appBeanMethods[i], this.appLoaderInjectionMethod);
                                continue;
                            }
                            if (paramTypes[0] == AepEngine.class) {
                                this.engineInjectionMethod = this.introspectInjectionMethod(AepEngine.class, appBeanMethods[i], this.engineInjectionMethod);
                                continue;
                            }
                            if (paramTypes[0] == AepEngineDescriptor.class) {
                                this.engineDescriptorInjectionMethod = this.introspectInjectionMethod(AepEngineDescriptor.class, appBeanMethods[i], this.engineDescriptorInjectionMethod);
                                continue;
                            }
                            if (paramTypes[0] == AepMessageSender.class) {
                                this.messageSenderInjectionMethod = this.introspectInjectionMethod(AepMessageSender.class, appBeanMethods[i], this.messageSenderInjectionMethod);
                                continue;
                            }
                            if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                            SrvAppLoader.this.tracer.log("......ignored  " + appBeanMethods[i].getName() + " (unknown injection type)", Tracer.Level.WARNING);
                            continue;
                        }
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log("......ignored (injection point but param count != 1)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log("......ignored (not annotated)", Tracer.Level.DEBUG);
                }
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("...introspecting class '" + introspectedClass + "' fields", Tracer.Level.DEBUG);
                }
                Collection fieldList = UtlReflection.collectAllFields(introspectedClass);
                Field[] fields = fieldList.toArray(new Field[0]);
                for (int i = 0; i < fields.length; ++i) {
                    if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                        SrvAppLoader.this.tracer.log("...field=" + fields[i], Tracer.Level.DEBUG);
                    }
                    if (!fields[i].isAnnotationPresent(AppInjectionPoint.class)) {
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....ignored (not annotated)", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].getType() == SrvAppLoader.class) {
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppInjectionPoint.class)) continue;
                        if (this.appLoaderInjectionFields == null) {
                            this.appLoaderInjectionFields = new XLinkedList();
                        }
                        this.appLoaderInjectionFields.add((Object)fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....SrvAppLoader field", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].getType() == AepEngine.class) {
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppInjectionPoint.class)) continue;
                        if (this.engineInjectionFields == null) {
                            this.engineInjectionFields = new XLinkedList();
                        }
                        this.engineInjectionFields.add((Object)fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....AepEngine field", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].getType() == AepEngineDescriptor.class) {
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppInjectionPoint.class)) continue;
                        if (this.engineDescriptorInjectionFields == null) {
                            this.engineDescriptorInjectionFields = new XLinkedList();
                        }
                        this.engineDescriptorInjectionFields.add((Object)fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....AepEngineDescriptor field", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].getType() == AepMessageSender.class) {
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppInjectionPoint.class)) continue;
                        if (this.messageSenderInjectionFields == null) {
                            this.messageSenderInjectionFields = new XLinkedList();
                        }
                        this.messageSenderInjectionFields.add((Object)fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".....AepMessageSender field", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].isAnnotationPresent(AppStoreUniqueIndex.class)) {
                        AppStoreUniqueIndex uniqueIndexDeclaration = fields[i].getAnnotation(AppStoreUniqueIndex.class);
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppStoreUniqueIndex.class)) continue;
                        if (Strings.isNullOrEmpty((String)uniqueIndexDeclaration.name())) {
                            throw new IllegalArgumentException("Index name is missing on field '" + fields[i].getName() + "'");
                        }
                        if (Strings.isNullOrEmpty((String)uniqueIndexDeclaration.fieldPath())) {
                            throw new IllegalArgumentException("Index fieldPath is missing on field '" + fields[i].getName() + "'");
                        }
                        if (App.this.indexNames.contains(uniqueIndexDeclaration.name())) {
                            throw new RuntimeException("Multiple index declarations. Index can be declared only once: '" + fields[i].getName() + "'");
                        }
                        App.this.uniqueStoreIndexFields.put(uniqueIndexDeclaration.name(), fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".........unique index '" + uniqueIndexDeclaration.name() + "' on field: " + fields[i], Tracer.Level.DEBUG);
                        continue;
                    }
                    if (fields[i].isAnnotationPresent(AppStoreNonUniqueIndex.class)) {
                        AppStoreNonUniqueIndex nonUniqueIndexDeclaration = fields[i].getAnnotation(AppStoreNonUniqueIndex.class);
                        if (!App.this.ensureAccessible(introspectedClass, fields[i], (Class<? extends Annotation>)AppStoreNonUniqueIndex.class)) continue;
                        if (Strings.isNullOrEmpty((String)nonUniqueIndexDeclaration.name())) {
                            throw new IllegalArgumentException("Index name is missing on field '" + fields[i].getName() + "'");
                        }
                        if (Strings.isNullOrEmpty((String)nonUniqueIndexDeclaration.fieldPath())) {
                            throw new IllegalArgumentException("Index fieldPath is missing on field '" + fields[i].getName() + "'");
                        }
                        if (App.this.indexNames.contains(nonUniqueIndexDeclaration.name())) {
                            throw new RuntimeException("Multiple index declarations. Index can be declared only once: '" + fields[i].getName() + "'");
                        }
                        App.this.nonUniqueStoreIndexFields.put(nonUniqueIndexDeclaration.name(), fields[i]);
                        if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                        SrvAppLoader.this.tracer.log(".........non-unique index '" + nonUniqueIndexDeclaration.name() + "' on field: " + fields[i], Tracer.Level.DEBUG);
                        continue;
                    }
                    if (!((SrvAppLoader)SrvAppLoader.this).tracer.debug) continue;
                    SrvAppLoader.this.tracer.log(".....ignored (unknown injection type)", Tracer.Level.DEBUG);
                }
            }

            private final Method introspectInjectionMethod(Class<?> injectionType, Method toCheck, Method existingMethod) {
                if (!App.this.ensureAccessible(this.introspectedClass, toCheck, (Class<? extends Annotation>)AppInjectionPoint.class)) {
                    return existingMethod;
                }
                if (existingMethod == null) {
                    if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                        SrvAppLoader.this.tracer.log("......" + injectionType.getSimpleName() + " injection method found: " + toCheck, Tracer.Level.DEBUG);
                    }
                    return toCheck;
                }
                if (((SrvAppLoader)SrvAppLoader.this).tracer.debug) {
                    SrvAppLoader.this.tracer.log("......ignored  " + toCheck + " (duplicate " + injectionType.getSimpleName() + " injector)", Tracer.Level.WARNING);
                }
                return existingMethod;
            }
        }
    }
}

