/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.JSQLType;
import com.akiban.sql.types.TypeId;

public abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        JavaValueNode other = (JavaValueNode)node;
        this.mustCastToPrimitive = other.mustCastToPrimitive;
        this.forCallStatement = other.forCallStatement;
        this.valueReturnedToSQLDomain = other.valueReturnedToSQLDomain;
        this.returnValueDiscarded = other.returnValueDiscarded;
        this.jsqlType = other.jsqlType;
    }

    public DataTypeDescriptor getType() throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(this.getJavaTypeName());
    }

    public boolean isPrimitiveType() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return false;
        }
        return myType.getCategory() == 2;
    }

    public String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 1: {
                return myType.getJavaClassName();
            }
            case 2: {
                return JSQLType.getPrimitiveName(myType.getPrimitiveKind());
            }
        }
        assert (false) : "Inappropriate JSQLType: " + myType;
        return "";
    }

    public void setJavaTypeName(String javaTypeName) {
        this.jsqlType = new JSQLType(javaTypeName);
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        switch (myType.getCategory()) {
            case 2: {
                return JSQLType.getPrimitiveName(myType.getPrimitiveKind());
            }
        }
        assert (false) : "Inappropriate JSQLType: " + myType;
        return "";
    }

    public void castToPrimitive(boolean booleanValue) {
        this.mustCastToPrimitive = booleanValue;
    }

    public boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    public JSQLType getJSQLType() throws StandardException {
        return this.jsqlType;
    }

    public TypeId mapToTypeID(JSQLType jsqlType) throws StandardException {
        DataTypeDescriptor dts = jsqlType.getSQLType();
        if (dts == null) {
            return null;
        }
        return dts.getTypeId();
    }

    public void markForCallStatement() {
        this.forCallStatement = true;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    protected void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    protected boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    protected void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    protected boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }
}

