/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlText;
import java.util.ArrayList;
import java.util.List;

final class Validate
extends Command {
    private String _command;
    private String _appName;
    private XVM _xvm;
    private List<String> _values;
    private String _args;

    Validate(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.syntaxError(null, lineNum);
    }

    private final void syntaxError(String message, int lineNum) {
        this.error((message != null ? message + ": " : "") + "Line " + lineNum + ": Syntax error: validate the <appName> app in the <xvmName> xvm <property> is <value> [or value2 [or valueN]] [with arg0 ... argN]");
    }

    @Override
    final String name() {
        return "validate";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._command = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("is")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._values = new ArrayList<String>();
        String[] remainingArgs = this.getRemainingArgs(tokenizer);
        int index = 0;
        boolean expectingValue = true;
        while (index < remainingArgs.length) {
            if ("with".equalsIgnoreCase(remainingArgs[index])) {
                if (!expectingValue) break;
                this.syntaxError("Expected <value> before 'with'", this.lineNum());
                break;
            }
            this._values.add(remainingArgs[index++]);
            expectingValue = false;
            if (index >= remainingArgs.length || !"or".equals(remainingArgs[index])) continue;
            expectingValue = true;
            ++index;
        }
        if (index < remainingArgs.length && !"with".equalsIgnoreCase(remainingArgs[index++])) {
            this.syntaxError("Expected 'with' instead of '" + remainingArgs[index - 1] + "'", this.lineNum());
        }
        if (index < remainingArgs.length) {
            StringBuilder sb = new StringBuilder();
            while (index < remainingArgs.length) {
                sb.append(UtlText.quoteAndEscape((String)remainingArgs[index++]));
                if (index >= remainingArgs.length) continue;
                sb.append(" ");
            }
            this._args = sb.toString();
        } else {
            this._args = "null";
        }
        return true;
    }

    @Override
    final void execute() {
        if (!this.mock()) {
            try {
                String result = ((String)UtlDataTypes.convert(String.class, (Object)this.remoteCommand(this._xvm.name(), this._appName, this._args.equalsIgnoreCase("null") ? this._command : this._command + " " + this._args, true, 5))).trim();
                if (!this._values.contains(result)) {
                    this.error("Line " + this.lineNum() + ": " + this._command + " is not as expected (expected=" + this._values.toString() + ", actual=" + result + ").");
                }
            }
            catch (Exception e) {
                if (e instanceof XVMUnreachableException && this.isTreatUnreachableXVMAsNonFatal()) {
                    this.info("......xvm '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                }
                this.error("Line " + this.lineNum() + ": Failed to validate property value [" + e.toString() + "].", e);
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

