#!/bin/bash

print_usage() {
    echo "Usage: $0 [--proxy-port <listen_port>] [--proxy-server <server_name>]" >&2
    exit 1
}

# Fixed upstream values
HOST_NAME="kafka.rumi.local"
HOST_PORT="9094"

# Defaults
PROXY_PORT=""
PROXY_SERVER="_"

# Parse input parameters
while [[ "$1" == -* ]]; do
    case "$1" in
    --proxy-port)
        shift
        PROXY_PORT="$1"
        shift
        ;;
    --proxy-server)
        shift
        PROXY_SERVER="$1"
        shift
        ;;
    --help|-h)
        print_usage
        ;;
    *)
        echo "Error: Unknown option: $1" >&2
        print_usage
        ;;
    esac
done

# Set PROXY_PORT to HOST_PORT if not specified
if [[ -z "$PROXY_PORT" ]]; then
    PROXY_PORT="$HOST_PORT"
fi

# Add proxy record and update DNS resolver
sudo /home/rumi/scripts/add_proxy.sh --host-name "$HOST_NAME" --host-port "$HOST_PORT" --port "$PROXY_PORT" --server "$PROXY_SERVER"

# update the DNS resolver on the monitor server
/home/rumi/scripts/set_dns_resolver.sh --target "$HOST_NAME" --namedaddr "$(hostname -I)"

