/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.config.Config;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLongIterator;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.lang.XLongMap;
import com.neeve.lang.XLongSet;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogLongMap;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXLongMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogLongMap<V> {
    private final int initialCapacity = Config.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XLongLinkedHashMap<V> map = this.initialCapacity > 0 ? new XLongLinkedHashMap(this.initialCapacity) : new XLongLinkedHashMap();
    private Set<Map.Entry<Long, V>> boxedEntrySet;
    private Set<Long> boxedKeySet;

    protected RogXLongMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put(this.getMapElementKey(element), element));
    }

    protected abstract long getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, long var2);

    @Override
    protected final XIterator<V> reusableChildIterator() {
        return this.reuseableValueIterator();
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        XIterator iterator = this.map.reuseableEntryIterator();
        while (iterator.hasNext()) {
            XLongMap.Entry entry = (XLongMap.Entry)iterator.next();
            this.visitField(visitor, "Key " + i, entry.getKey());
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    public void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
        element.dispose();
    }

    @Override
    public final int getNumChildren() {
        return this.map.size();
    }

    @Override
    public final int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public final IStoreObject setFieldValue(long fid, Object val) {
        return this;
    }

    @Override
    public final V put(long key, V value) {
        V rc;
        long currentKey = this.getMapElementKey(value);
        if (value.getParent() == this && key == currentKey) {
            return value;
        }
        if (currentKey != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove(key);
                this.map.put(key, rc);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(Long key, V value) {
        if (key == null) {
            throw new NullPointerException("Null values not supported");
        }
        return this.put((long)key, value);
    }

    @Override
    public final void putAll(Map<? extends Long, ? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V get(long key) {
        return (V)((IRogCollectionNodeElement)this.map.get(key));
    }

    @Override
    public final V get(Long key) {
        if (key == null) {
            return null;
        }
        return this.get((long)key);
    }

    @Override
    public final V get(Object key) {
        if (key instanceof Long) {
            return this.get((Long)key);
        }
        return null;
    }

    @Override
    public final boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsKey(Long key) {
        if (key == null) {
            return false;
        }
        return this.containsKey((long)key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Long> keySet() {
        if (this.boxedKeySet == null) {
            this.boxedKeySet = new KeySet();
        }
        return this.boxedKeySet;
    }

    @Override
    public final XLongSet keyLongSet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<Long, V>> entrySet() {
        if (this.boxedEntrySet == null) {
            this.boxedEntrySet = new EntrySet();
        }
        return this.boxedEntrySet;
    }

    @Override
    public final XLongIterator reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public final XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public final XIterator<XLongMap.Entry<V>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final V remove(long key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove(key);
        if (element != null) {
            this.removeChild(element);
        }
        return (V)element;
    }

    @Override
    public final V remove(Long key) {
        if (key == null) {
            return null;
        }
        return this.remove((long)key);
    }

    @Override
    public final V remove(Object key) {
        if (key instanceof Long) {
            return this.remove((Long)key);
        }
        return null;
    }

    @Override
    public final void clear() {
        XLongIterator iterator = this.map.reuseableKeyIterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
            this.map.reuseableKeyIterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXLongMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXLongMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<Long, V>> iterator() {
            final Iterator it = RogXLongMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<Long, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<Long, V> next() {
                    final XLongMap.Entry e = (XLongMap.Entry)it.next();
                    return new Map.Entry<Long, V>(){

                        @Override
                        public Long getKey() {
                            return e.getKey();
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Long, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Long, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Long> {
        KeySet() {
        }

        @Override
        public int size() {
            return RogXLongMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXLongMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXLongMap.this.containsKey(o);
        }

        @Override
        public Iterator<Long> iterator() {
            final XLongIterator it = RogXLongMap.this.map.keySet().iterator();
            return new Iterator<Long>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Long next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(Long e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

