/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.lang.XIterator;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogQueue;
import com.neeve.rog.IRogQueueElement;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class RogQueue<V extends IRogQueueElement>
extends RogCollectionNode<V>
implements IRogQueue<V> {
    private final UtlList queue = UtlList.create();
    private final IteratorImpl reusableIterator = new IteratorImpl(false);
    private int vpos;

    protected RogQueue(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
    }

    private final boolean inThisQueue(RogNode node) {
        return node.isLinked() && node.head == this.queue.head;
    }

    @Override
    protected final XIterator<V> reusableChildIterator() {
        return this.reusableIterator();
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        for (IRogNode node : this) {
            this.visitField(visitor, "Index " + i, (RogNode)node);
            ++i;
        }
    }

    @Override
    public final void addChild(IRogNode e) {
        this.offer((V)((IRogQueueElement)e));
    }

    @Override
    public final void removeChild(IRogNode e) {
        this.remove((IRogQueueElement)e);
        e.dispose();
    }

    @Override
    public final int getNumChildren() {
        return this.size();
    }

    @Override
    public final int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.queue.clear();
            this.vpos = 0;
        }
        return count;
    }

    @Override
    public final IStoreObject setFieldValue(long fid, Object val) {
        return this;
    }

    @Override
    public final boolean add(V e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("no space");
    }

    @Override
    public final V element() {
        Object e = this.peek();
        if (e != null) {
            return (V)e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final boolean offer(V e) {
        RogNode node = (RogNode)e;
        if (!this.inThisQueue(node)) {
            this.addChild(e);
            this.queue.append((UtlListElement)node);
            e.setVpos(++this.vpos);
            return true;
        }
        return false;
    }

    @Override
    public final V peek() {
        return (V)((IRogQueueElement)this.queue.first());
    }

    @Override
    public final V poll() {
        IRogQueueElement e = (IRogQueueElement)this.queue.first();
        if (e != null) {
            this.remove(e);
        }
        return (V)e;
    }

    @Override
    public final V remove() {
        Object e = this.poll();
        if (e != null) {
            return (V)e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final boolean addAll(Collection<? extends V> collection) {
        boolean changed = false;
        Iterator<V> iterator = collection.iterator();
        while (iterator.hasNext()) {
            changed |= this.add((V)((IRogQueueElement)iterator.next()));
        }
        return changed;
    }

    @Override
    public final void clear() {
        IRogQueueElement e = (IRogQueueElement)this.queue.first();
        while (e != null) {
            this.remove(e);
            e = (IRogQueueElement)this.queue.first();
        }
    }

    @Override
    public final boolean contains(Object o) {
        try {
            return this.inThisQueue((RogNode)o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        boolean contains = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext() && (contains &= this.contains(iterator.next()))) {
        }
        return contains;
    }

    @Override
    public final XIterator<V> iterator() {
        return new IteratorImpl(false);
    }

    @Override
    public final XIterator<V> reverseIterator() {
        return new IteratorImpl(true);
    }

    @Override
    public final XIterator<V> reusableIterator() {
        this.reusableIterator.reverse = false;
        this.reusableIterator.toFirst();
        return this.reusableIterator;
    }

    @Override
    public final XIterator<V> reusableReverseIterator() {
        this.reusableIterator.reverse = true;
        this.reusableIterator.toFirst();
        return this.reusableIterator;
    }

    @Override
    public final boolean remove(Object o) {
        IRogQueueElement e = (IRogQueueElement)o;
        RogNode node = (RogNode)o;
        if (this.inThisQueue(node)) {
            this.removeChild(e);
            node.unlink();
            return true;
        }
        return false;
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            changed |= this.remove(iterator.next());
        }
        return changed;
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <E> E[] toArray(E[] t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final int size() {
        return this.queue.count();
    }

    @Override
    public final boolean equals(Object o) {
        return this.queue.equals(o);
    }

    @Override
    public final int hashCode() {
        return this.queue.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private final class IteratorImpl
    implements XIterator<V> {
        private UtlListElement current;
        private UtlListElement last;
        private boolean reverse = false;

        IteratorImpl(boolean reverse) {
            this.reverse = reverse;
            this.toFirst();
        }

        public final boolean hasNext() {
            return this.current != null;
        }

        public final V next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.last = this.current;
            this.current = this.reverse ? this.current.previous() : this.current.next();
            return (IRogQueueElement)this.last;
        }

        public final void remove() {
            if (this.last != null) {
                RogQueue.this.remove((IRogQueueElement)this.last);
            }
            this.last = null;
        }

        public XIterator<V> toFirst() {
            if (this.reverse) {
                this.current = RogQueue.this.queue.last();
                this.last = null;
                return this;
            }
            this.current = RogQueue.this.queue.first();
            this.last = null;
            return this;
        }
    }
}

