/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.akiban.sql.parser.CreateIndexNode;
import com.akiban.sql.parser.DropIndexNode;
import com.akiban.sql.parser.IndexColumn;
import com.akiban.sql.parser.IndexColumnList;
import com.akiban.sql.parser.StatementNode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.neeve.query.Query;
import com.neeve.query.QueryEngine;
import com.neeve.query.QueryException;
import com.neeve.query.QueryParseException;
import com.neeve.query.QueryRepository;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryDefaultFieldResolver;
import com.neeve.query.impl.QueryFieldResolver;
import com.neeve.query.impl.QueryImpl;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryObject;
import com.neeve.query.impl.QueryOptimizer;
import com.neeve.query.impl.QueryParser;
import com.neeve.query.impl.QueryPlanImpl;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.QuerySortArea;
import com.neeve.query.impl.QuerySortAreaImpl;
import com.neeve.query.impl.QuerySortAreaProvider;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.query.impl.predicates.PredicateOperators;
import com.neeve.query.impl.predicates.Predicates;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxIndex;
import com.neeve.query.index.IdxNonUniqueIndex;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.query.predicates.Predicate;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryEngineImpl<ID, REC>
extends QueryObject
implements QueryEngine<ID, REC>,
QuerySortAreaProvider<REC> {
    private boolean autoIndex = false;
    private QueryEngine.BackgroundIndexingPolicy backgroundIndexingPolicy = QueryEngine.BackgroundIndexingPolicy.FLUSH_NEVER;
    private final Map<String, QueryIndexableRepository<ID, REC>> repos = Maps.newHashMap();
    private final Map<String, QueryIndexableRepository<ID, REC>> reposByName = Maps.newHashMap();
    private final QueryOptimizer<ID, REC> optimizer;
    private final QueryParser parser = new QueryParser();
    private final Predicates predicates = PredicatesImpl.get();
    private final QueryFieldResolver<REC> fieldResolver;
    private boolean createDefaultIndexes = false;
    private final List<IdxField<REC, ?>> defaultUniqueIndexFields = Lists.newArrayList();
    private final List<IdxField<REC, ?>> defaultNonUniqueIndexFields = Lists.newArrayList();
    private boolean generateQueryStats;
    private int sortAreaInMemoryCardinality = 500;
    private Set<QuerySortAreaImpl<ID, REC>> openSortAreas = Sets.newConcurrentHashSet();
    private int autoIndexLimit = 5;

    public QueryEngineImpl(Class<REC> recordBaseType) {
        super(QueryConfig.getConfig());
        this.fieldResolver = this.getQueryFieldResolver(recordBaseType);
        this.optimizer = new QueryOptimizer(this);
        this.optimizer.setNaturalKeyOrder(this.getNaturalKeyOrder());
    }

    @Override
    public QuerySortArea<REC> createSortArea() {
        QuerySortAreaImpl sortArea = new QuerySortAreaImpl();
        sortArea.open();
        sortArea.setInMemoryCardinality(this.sortAreaInMemoryCardinality);
        this.registerSortArea(sortArea);
        return sortArea;
    }

    private void registerSortArea(QuerySortAreaImpl<ID, REC> sortArea) {
        Iterator<QuerySortAreaImpl<ID, REC>> iter = this.openSortAreas.iterator();
        while (iter.hasNext()) {
            QuerySortAreaImpl<ID, REC> sa = iter.next();
            if (sa.isOpen() || !sa.awaitShutdown(0L)) continue;
            iter.remove();
        }
        this.openSortAreas.add(sortArea);
    }

    private void createDefaultIndex(QueryIndexableRepository<ID, REC> repository, IdxField<REC, ?> field, boolean unique) {
        IdxIndex index;
        if (this.createDefaultIndexes && (index = repository.getIndex(field)) == null) {
            repository.createIndex(field, unique);
        }
    }

    @Override
    public void setDefaultIndexing(boolean defaultIndexing) {
        this.createDefaultIndexes = defaultIndexing;
        if (defaultIndexing) {
            for (QueryIndexableRepository<ID, REC> repo : this.repos.values()) {
                for (IdxField<REC, ?> field : this.defaultUniqueIndexFields) {
                    this.createDefaultIndex(repo, field, true);
                }
                for (IdxField<REC, ?> field : this.defaultNonUniqueIndexFields) {
                    this.createDefaultIndex(repo, field, false);
                }
            }
        }
    }

    protected void registerDefaultIndexField(IdxField<REC, ?> field, boolean unique) {
        if (unique) {
            this.defaultUniqueIndexFields.add(field);
        } else {
            this.defaultNonUniqueIndexFields.add(field);
        }
        for (QueryIndexableRepository<ID, REC> repo : this.repos.values()) {
            this.createDefaultIndex(repo, field, unique);
        }
    }

    @Override
    public void addRepository(QueryRepository<ID, REC> repository, String alias) {
        QueryIndexableRepository repo;
        if (repository instanceof QueryIndexableRepository) {
            repo = (QueryIndexableRepository)repository;
            for (IdxField<REC, ?> field : this.defaultUniqueIndexFields) {
                this.createDefaultIndex(repo, field, true);
            }
            for (IdxField<REC, ?> field : this.defaultNonUniqueIndexFields) {
                this.createDefaultIndex(repo, field, false);
            }
            if (alias != null) {
                this.repos.put(alias.toLowerCase(), repo);
            } else {
                this.repos.put(repo.getName().toLowerCase(), repo);
            }
        } else {
            throw new IllegalArgumentException("this repository does not implement IndexableRepository and so cannot be queried");
        }
        this.reposByName.put(repo.getName().toLowerCase(), repo);
    }

    @Override
    public void removeRepository(String name) {
        QueryRepository repository = this.repos.remove(name.toLowerCase());
        if (repository != null) {
            this.reposByName.remove(repository.getName().toLowerCase());
        }
    }

    @Override
    public final void setDefaultPackage(Package pkg) {
        if (pkg != null) {
            this.fieldResolver.setDefaultPackage(pkg.getName());
        } else {
            this.fieldResolver.setDefaultPackage(null);
        }
    }

    @Override
    public Collection<? extends QueryRepository<ID, REC>> getRepositories() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.repos.values());
        return result;
    }

    @Override
    public void setFetchRatioThreshold(double threshold) {
        this.optimizer.setFetchRatioThreshold(threshold);
    }

    @Override
    public double getFetchRatioThreshold() {
        return this.optimizer.getFetchRatioThreshold();
    }

    @Override
    public <T> boolean createIndex(String columnDefinition, boolean unique) {
        return this.createIndex(this.getField(columnDefinition), unique, null);
    }

    @Override
    public <T> boolean createIndex(IdxField<REC, T> field, boolean unique) {
        return this.createIndex(field, unique, null);
    }

    @Override
    public <T> boolean createIndex(IdxField<REC, T> field, boolean unique, String name) throws QueryException {
        boolean result = false;
        for (QueryRepository queryRepository : this.repos.values()) {
            IdxIndex index = Strings.isNullOrEmpty((String)name) ? queryRepository.createIndex(field, unique) : queryRepository.createIndex(field, unique, name);
            result |= index != null;
        }
        if (result && this.backgroundIndexingPolicy == QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_CREATE) {
            try {
                this.waitForBackgroundIndexing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryException("Interrupted flushing repository indexes");
            }
        }
        return result;
    }

    @Override
    public <T> IdxUniqueIndex<T, ID> getUniqueIndex(IdxField<REC, T> field) throws QueryException {
        for (QueryRepository queryRepository : this.repos.values()) {
            IdxIndex idx = queryRepository.getIndex(field);
            if (idx == null) continue;
            if (idx.isUnique()) {
                return (IdxUniqueIndex)idx;
            }
            throw new QueryException("Index on field '" + field.getFieldPath() + "' is not unique.");
        }
        return null;
    }

    @Override
    public <T> IdxNonUniqueIndex<T, ID> getNonUniqueIndex(IdxField<REC, T> field) throws QueryException {
        for (QueryRepository queryRepository : this.repos.values()) {
            IdxIndex idx = queryRepository.getIndex(field);
            if (idx == null) continue;
            if (!idx.isUnique()) {
                return (IdxNonUniqueIndex)idx;
            }
            throw new QueryException("Index on field '" + field.getFieldPath() + "' is unique.");
        }
        return null;
    }

    @Override
    public boolean dropIndex(String indexName) throws QueryException {
        if (this.repos.isEmpty()) {
            throw new QueryException("There are no repositories, cannot drop index.");
        }
        boolean result = false;
        QueryException e = null;
        for (QueryRepository queryRepository : this.repos.values()) {
            try {
                result |= queryRepository.dropIndex(indexName);
            }
            catch (QueryException qe) {
                e = qe;
            }
        }
        if (e != null) {
            throw e;
        }
        return result;
    }

    @Override
    public boolean dropIndex(IdxField<REC, ?> field) {
        if (this.repos.isEmpty()) {
            throw new QueryException("There are no repositories, cannot drop index.");
        }
        boolean result = false;
        QueryException e = null;
        for (QueryRepository queryRepository : this.repos.values()) {
            try {
                result |= queryRepository.dropIndex(field);
            }
            catch (QueryException qe) {
                e = qe;
            }
        }
        if (e != null) {
            throw e;
        }
        return result;
    }

    @Override
    public Set<IdxField<REC, ?>> getIndexedFields() {
        HashSet indexedFields = new HashSet();
        for (QueryRepository queryRepository : this.repos.values()) {
            for (IdxIndex index : queryRepository.getIndexes()) {
                indexedFields.add(index.getField());
            }
        }
        return indexedFields;
    }

    @Override
    public void setAutoIndexing(boolean value) {
        this.autoIndex = value;
    }

    @Override
    public Query<REC> createQuery() {
        return new QueryImpl();
    }

    @Override
    public Query<REC> createQuery(String sql) throws QueryParseException {
        Query<REC> query = this.createQuery();
        QueryParser.Result parseResult = this.parser.parseQuery(sql);
        for (QueryParser.Column column : parseResult.getColumnList()) {
            IdxField<REC, ?> field = this.createField(column);
            query.select(field);
            if (column.getAs() == null) continue;
            query.as(column.getAs());
        }
        if (parseResult.isDistinct()) {
            query.distinct();
        }
        for (String table : parseResult.getFromList()) {
            if (this.isAllRepositoriesToken(table)) {
                query.from(table);
                continue;
            }
            if (this.repos.containsKey(table.toLowerCase())) {
                query.from(table);
                continue;
            }
            if (this.reposByName.containsKey(table.toLowerCase())) {
                query.from(table);
                continue;
            }
            throw new QueryException("Invalid repository: " + table);
        }
        QueryParser.Condition where = parseResult.getWhere();
        Predicate<REC> wherePredicate = this.createPredicate(where);
        query.where(wherePredicate);
        List<QueryParser.Column> groupBy = parseResult.getGroupBy();
        for (QueryParser.Column column : groupBy) {
            IdxField<REC, ?> field = this.createField(column);
            query.groupBy(field);
        }
        QueryParser.Condition having = parseResult.getHaving();
        if (having != null) {
            Predicate<REC> havingPredicate = this.createPredicate(having);
            query.having(havingPredicate);
        }
        List<QueryParser.Column> orderBy = parseResult.getOrderBy();
        for (QueryParser.Column column : orderBy) {
            IdxField<REC, ?> field = this.createField(column);
            Query.SortOrder sortOrder = Query.SortOrder.get(column.isAscending());
            query.orderBy(field, sortOrder);
        }
        if (parseResult.getLimitRange() != null) {
            ((QueryImpl)query).setLimitRange(parseResult.getLimitRange());
        }
        return query;
    }

    protected boolean isAllRepositoriesToken(String token) {
        return token.equalsIgnoreCase("Repositories");
    }

    private Predicate<REC> createPredicate(QueryParser.Condition condition) {
        Predicate<Object> predicate;
        if (condition == null) {
            return null;
        }
        if (condition instanceof QueryParser.CompoundCondition) {
            QueryParser.CompoundCondition compound = (QueryParser.CompoundCondition)condition;
            QueryParser.CompoundCondition.Type type = compound.getType();
            List<QueryParser.Condition> children = compound.getChildren();
            ArrayList childPredicates = Lists.newArrayList();
            for (QueryParser.Condition child : children) {
                Predicate<REC> childPredicate = this.createPredicate(child);
                childPredicates.add(childPredicate);
            }
            switch (type) {
                case AND: {
                    predicate = this.predicates.and(childPredicates);
                    break;
                }
                case OR: {
                    predicate = this.predicates.or(childPredicates);
                    break;
                }
                case NOT: {
                    if (childPredicates.size() != 1) {
                        throw new QueryParseException("NOT can only apply to one condition", 0);
                    }
                    Predicate child = (Predicate)childPredicates.get(0);
                    predicate = this.predicates.not(child);
                    break;
                }
                default: {
                    throw new QueryParseException("Unrecognized predicate type: " + (Object)((Object)type), 0);
                }
            }
        } else {
            QueryParser.LeafCondition leaf = (QueryParser.LeafCondition)condition;
            QueryParser.Column column = leaf.getColumn();
            IdxField<REC, ?> field = this.createField(column);
            String operatorSymbol = leaf.getOperator();
            List<Object> values = leaf.getValues();
            PredicateOperator operator = PredicateOperator.lookup(operatorSymbol);
            PredicateOperators publicOperator = operator.getPublicOperator();
            PredicateOperator.Arity arity = operator.getArity();
            try {
                switch (arity) {
                    case UNARY: {
                        predicate = this.predicates.createUnary(field, publicOperator);
                        break;
                    }
                    case BINARY: {
                        Object value = field.convertToFieldType(values.get(0));
                        if (operator.isRanged()) {
                            predicate = this.predicates.createBinary(field, publicOperator, (Comparable)value);
                            break;
                        }
                        predicate = this.predicates.createBinary(field, publicOperator, value);
                        break;
                    }
                    case TERNARY: {
                        Comparable low = (Comparable)field.convertToFieldType(values.get(0));
                        Comparable high = (Comparable)field.convertToFieldType(values.get(1));
                        predicate = this.predicates.createTernary(field, publicOperator, low, high);
                        break;
                    }
                    case NARY: {
                        predicate = this.predicates.createNary(field, publicOperator, QueryEngineImpl.attemptTypeConversion(field, values));
                        break;
                    }
                    default: {
                        throw new QueryParseException("Unrecognized operator arity: " + (Object)((Object)arity), 0);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new QueryParseException(e.getMessage(), 0);
            }
        }
        return predicate;
    }

    private static final <T> List<T> attemptTypeConversion(IdxField<?, ?> field, List<Object> values) {
        if (values.isEmpty() || field.getFieldType().isAssignableFrom(values.get(0).getClass())) {
            return values;
        }
        ArrayList converted = new ArrayList(values.size());
        for (int i = 0; i < values.size(); ++i) {
            converted.add(i, field.convertToFieldType(values.get(i)));
        }
        return converted;
    }

    private final IdxField<REC, ?> createField(QueryParser.Column column) throws QueryException {
        IdxField field = this.getField(column.getTableName(), column.getColumnName());
        if (Strings.isNullOrEmpty((String)column.getFunctionName())) {
            return field;
        }
        String functionName = column.getFunctionName();
        if ("COUNT".equals(functionName)) {
            return field.count();
        }
        if ("MIN".equals(functionName)) {
            return field.min();
        }
        if ("MAX".equals(functionName)) {
            return field.max();
        }
        if ("SUM".equals(functionName)) {
            Class fieldType = field.getFieldType();
            if (Double.class.isAssignableFrom(fieldType) || Float.class.isAssignableFrom(fieldType)) {
                return field.sumDouble();
            }
            return field.sumLong();
        }
        if ("AVG".equals(functionName)) {
            return field.average();
        }
        throw new QueryException(functionName + " is not a supported function");
    }

    @Override
    public <T> IdxField<REC, T> getField(String columnDefinition) throws QueryException, QueryParseException {
        return this.createField(this.parser.parseColumn(columnDefinition));
    }

    @Override
    public <T> IdxField<REC, T> getField(String objectTypeName, String fieldPath) {
        return this.fieldResolver.getField(objectTypeName, fieldPath);
    }

    @Override
    public <T> IdxField<REC, T> getField(Class<?> objectType, String fieldPath) {
        return this.fieldResolver.getField(objectType, fieldPath);
    }

    @Override
    public <T> IdxField<REC, T> getField(Class<?> objectType, String fieldPath, Class<T> fieldType, Class<?> ... pathTypes) {
        return this.fieldResolver.getField(objectType, fieldPath, fieldType, pathTypes);
    }

    @Override
    public QueryResultSet<REC> execute(Query<REC> query) throws QueryException {
        QueryPlanImpl<ID, REC> plan;
        Comparator orderByComparator;
        QueryImpl q = (QueryImpl)query;
        QueryResultSetImpl<ID, REC> resultSet = this.createResultSet();
        if (q.isAggregated()) {
            if (q.getOrderBy().isEmpty()) {
                resultSet.setCollation(QueryResultSet.Collation.AGGREGATE);
            } else {
                resultSet.setCollation(QueryResultSet.Collation.ORDERED_AGGREGATE);
                orderByComparator = QueryPlanImpl.OrderBy.createComparator(q.getOrderBy());
                resultSet.setInterleaveComparator(orderByComparator);
            }
        } else if (!q.getOrderBy().isEmpty()) {
            resultSet.setCollation(QueryResultSet.Collation.INTERLEAVE);
            orderByComparator = QueryPlanImpl.OrderBy.createComparator(q.getOrderBy());
            resultSet.setInterleaveComparator(orderByComparator);
        } else if (this.getCollationComparator() != null) {
            resultSet.setCollation(QueryResultSet.Collation.INTERLEAVE);
            resultSet.setInterleaveComparator(this.getCollationComparator());
        } else {
            resultSet.setCollation(QueryResultSet.Collation.CONCATENATE);
        }
        if (q.getLimitRange() != null) {
            resultSet.setLimit(q.getLimitRange());
        }
        int i = 0;
        for (IdxField idxField : q.getSelect()) {
            resultSet.addColumn(q.getSelectNames().get(i), idxField);
            ++i;
        }
        Iterable<String> from = q.getFromList();
        for (String repoName : q.getFromList()) {
            if (!this.isAllRepositoriesToken(repoName)) continue;
            from = this.repos.keySet();
            break;
        }
        HashMap hashMap = Maps.newHashMap();
        boolean performingFullScan = false;
        for (String string : from) {
            QueryIndexableRepository<ID, REC> queryRepo2 = this.findRepository(string);
            plan = this.optimizer.createPlan(queryRepo2, q);
            if (plan.isFullScan()) {
                performingFullScan = true;
            }
            hashMap.put(queryRepo2, plan);
        }
        if (this.autoIndex) {
            this.createIndexes(q);
            if (performingFullScan) {
                Set repos = hashMap.keySet();
                for (QueryIndexableRepository queryRepo : repos) {
                    plan = this.optimizer.createPlan(queryRepo, q);
                    hashMap.put(queryRepo, plan);
                }
            }
        }
        for (String string : from) {
            QueryIndexableRepository queryRepo;
            queryRepo = this.findRepository(string);
            if (this.backgroundIndexingPolicy == QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_QUERY) {
                queryRepo.flushIndexing();
            }
            plan = (QueryPlanImpl<ID, REC>)hashMap.get(queryRepo);
            plan.associateResultSet(resultSet);
            plan.setGenerateQueryStats(this.generateQueryStats);
            QueryPlanImpl.PlanQueryResult<REC> queryResult = plan.getResult(queryRepo);
            queryResult.setRepositoryAlias(string);
            resultSet.addQueryResult(queryResult);
        }
        return resultSet;
    }

    private QueryIndexableRepository<ID, REC> findRepository(String repoName) {
        String key = repoName.toLowerCase();
        QueryIndexableRepository<ID, REC> queryRepo = this.repos.get(key);
        if (queryRepo == null) {
            queryRepo = this.reposByName.get(repoName.toLowerCase());
        }
        if (queryRepo == null) {
            throw new QueryException("Referenced repository not found: " + key);
        }
        return queryRepo;
    }

    private void createIndexes(QueryImpl<REC> query) {
        int indexesCreated;
        Set<Object> fields;
        int fieldsToIndex = this.autoIndexLimit;
        HashSet fieldsAlreadyExamined = Sets.newHashSet();
        if (fieldsToIndex > 0) {
            fields = query.getWhereFields();
            indexesCreated = this.createIndexes(fields, fieldsToIndex);
            fieldsToIndex -= indexesCreated;
            fieldsAlreadyExamined.addAll(fields);
        }
        if (fieldsToIndex > 0) {
            fields = Sets.newHashSet();
            for (QueryImpl.OrderByField<REC, ?> orderBy : query.getOrderBy()) {
                fields.add(orderBy.getField());
            }
            fields.removeAll(fieldsAlreadyExamined);
            indexesCreated = this.createIndexes(fields, fieldsToIndex);
            fieldsToIndex -= indexesCreated;
            fieldsAlreadyExamined.addAll(fields);
        }
        if (fieldsToIndex > 0) {
            fields = Sets.newHashSet(query.getGroupBy());
            fields.removeAll(fieldsAlreadyExamined);
            indexesCreated = this.createIndexes(fields, fieldsToIndex);
            fieldsToIndex -= indexesCreated;
            fieldsAlreadyExamined.addAll(fields);
        }
        if (fieldsToIndex > 0) {
            fields = query.getAllFields();
            fields.removeAll(fieldsAlreadyExamined);
            this.createIndexes(fields, fieldsToIndex);
        }
    }

    private int createIndexes(Collection<IdxField<REC, ?>> fields, int maxIndexes) {
        int fieldsCreated = 0;
        for (IdxField<REC, Object> field : fields) {
            Class<?> fieldType;
            if (field instanceof QueryAggregateField) {
                field = ((QueryAggregateField)field).getBaseField();
            }
            if (!Serializable.class.isAssignableFrom(fieldType = field.getFieldType()) || field.equals(this.fieldResolver.getRepositoryNameField()) || field.equals(this.fieldResolver.getRecordField()) || field.equals(this.fieldResolver.getSelectAllField())) continue;
            boolean uniqueIndexExists = false;
            boolean nonUniqueIndexExists = false;
            ArrayList reposWithoutIndex = Lists.newArrayList();
            for (QueryIndexableRepository<ID, REC> repo : this.repos.values()) {
                IdxIndex.Stats<Object> stats = repo.getIndexStats(field);
                if (stats == null) {
                    reposWithoutIndex.add(repo);
                    continue;
                }
                if (stats.isUnique()) {
                    uniqueIndexExists = true;
                    continue;
                }
                nonUniqueIndexExists = true;
            }
            if (reposWithoutIndex.isEmpty()) continue;
            boolean unique = uniqueIndexExists && !nonUniqueIndexExists;
            for (QueryIndexableRepository repo : reposWithoutIndex) {
                repo.createIndex(field, unique);
            }
            if (++fieldsCreated < maxIndexes) continue;
            break;
        }
        if (this.backgroundIndexingPolicy == QueryEngine.BackgroundIndexingPolicy.FLUSH_ON_CREATE) {
            try {
                this.waitForBackgroundIndexing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryException("Interrupted flushing repository indexes");
            }
        }
        return fieldsCreated;
    }

    @Override
    public QueryResultSet<REC> execute(String xpql) {
        return this.execute(this.createQuery(xpql));
    }

    @Override
    public void close() throws Exception {
        for (QuerySortAreaImpl<ID, REC> querySortAreaImpl : this.openSortAreas) {
            querySortAreaImpl.close();
            querySortAreaImpl.awaitShutdown();
        }
        for (QueryRepository queryRepository : this.repos.values()) {
            queryRepository.close();
        }
    }

    protected QueryFieldResolver<REC> getQueryFieldResolver(Class<REC> recordBaseType) {
        return new QueryDefaultFieldResolver<REC>(recordBaseType);
    }

    public QueryResultSetImpl<ID, REC> createResultSet() {
        return new QueryResultSetImpl(this);
    }

    protected Comparator<ID> getNaturalKeyOrder() {
        return null;
    }

    protected Comparator<QueryResultSet.Row<REC>> getCollationComparator() {
        return null;
    }

    @Override
    public Object executeStatement(String sql) throws QueryException, QueryParseException {
        if (this.parser.isDDL(sql)) {
            String[] tokens;
            if (UtlText.startsWithIgnoreCase((String)sql, (String)"drop") && (tokens = sql.split("\\s+")).length == 3 && tokens[1].equalsIgnoreCase("index")) {
                String fieldText = tokens[2];
                try {
                    IdxField field = this.getField(fieldText);
                    this.dropIndex(field);
                }
                catch (QueryException field) {
                    // empty catch block
                }
            }
            StatementNode statement = this.parser.parseDDL(sql);
            switch (statement.getNodeType()) {
                case 146: {
                    CreateIndexNode createIndex = (CreateIndexNode)statement;
                    boolean unique = createIndex.getUniqueness();
                    String indexName = createIndex.getObjectName().getFullTableName();
                    IndexColumnList indexColumns = createIndex.getColumnList();
                    int numColumns = indexColumns.size();
                    if (numColumns != 1) {
                        throw new QueryParseException("Invalid index creation statement, too many columns", indexColumns.getBeginOffset());
                    }
                    IndexColumn indexColumn = (IndexColumn)indexColumns.get(0);
                    String className = indexColumn.getTableName().getFullTableName();
                    String fieldPath = indexColumn.getColumnName();
                    IdxField<REC, ?> field = this.createField(new QueryParser.Column(className, fieldPath));
                    this.createIndex(field, unique, indexName);
                    return null;
                }
                case 63: {
                    DropIndexNode dropIndex = (DropIndexNode)statement;
                    String indexName = dropIndex.getIndexName();
                    this.dropIndex(indexName);
                    return null;
                }
            }
            throw new QueryParseException("Unsupported statement type [" + statement + "]", 0);
        }
        return this.execute(sql);
    }

    @Override
    public void setBackgroundIndexingPolicy(QueryEngine.BackgroundIndexingPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Background indexing policy can't be null");
        }
        this.backgroundIndexingPolicy = policy;
    }

    public QueryEngine.BackgroundIndexingPolicy getBackgroundIndexingPolicy() {
        return this.backgroundIndexingPolicy;
    }

    @Override
    public void waitForBackgroundIndexing() throws InterruptedException {
        if (this.tracer.debug) {
            this.tracer.log("Flushing repository indexes", Tracer.Level.DEBUG);
        }
        for (QueryIndexableRepository<ID, REC> repo : this.repos.values()) {
            repo.flushIndexing();
        }
        if (this.tracer.debug) {
            this.tracer.log("Flushed repository indexes", Tracer.Level.DEBUG);
        }
    }

    @Override
    public void setQueryStatGeneration(boolean generateStats) {
        this.generateQueryStats = generateStats;
    }

    @Override
    public void setAutoIndexLimit(int autoIndexLimit) {
        this.autoIndexLimit = autoIndexLimit;
    }

    @Override
    public void setSortAreaInMemoryCardinality(int maxCardinality) {
        this.sortAreaInMemoryCardinality = maxCardinality;
    }
}

