/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmMessage;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModelElement;
import java.util.Set;

public final class AsmOperation
extends AsmModelElement {
    private final String name;
    private final AdmMessage inMessage;
    private final AdmMessage outMessage;
    private final String restPath;
    private final RestMethod restMethod;
    private final AsmDocumentation documentation;

    public AsmOperation(String name, AdmMessage inMessage, AdmMessage outMessage, String restPath, RestMethod restMethod, AsmDocumentation documentation) {
        if (inMessage == null) {
            throw new IllegalArgumentException("in message cannot be null");
        }
        this.name = name;
        this.inMessage = inMessage;
        this.outMessage = outMessage;
        this.restPath = restPath;
        this.restMethod = restMethod;
        this.documentation = documentation;
    }

    public AsmOperation(String name, AdmMessage inMessage, AdmMessage outMessage, String restPath, RestMethod restMethod) {
        this(name, inMessage, outMessage, restPath, restMethod, null);
    }

    public AsmOperation(String name, AdmMessage inMessage, AdmMessage outMessage, Set<AdmMessage> eventMessages) {
        this(name, inMessage, outMessage, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public AsmDocumentation getDocumentation() {
        return this.documentation;
    }

    public final AdmMessage getInMessage() {
        return this.inMessage;
    }

    public final AdmMessage getOutMessage() {
        return this.outMessage;
    }

    public final String getRESTPath() {
        return this.restPath;
    }

    public final RestMethod getRESTMethod() {
        return this.restMethod;
    }

    public final String toString() {
        return "[name=" + this.name + ", in=" + this.inMessage.getFullName() + ", out=" + (this.outMessage != null ? this.outMessage.getFullName() : "null") + ", RESTPath=" + this.restPath + "]";
    }

    public static enum RestMethod {
        GET,
        POST;

    }
}

