/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmType;

public final class AdmEntityArray
extends AdmArray {
    private final AdmEntity type;

    public AdmEntityArray(AdmModel model, AdmEntity type) {
        super(model, type.getName() + "[]");
        this.type = type;
        if (!type.isEmbedded()) {
            throw new IllegalArgumentException("an array type ('" + type.getJavaTypeName() + "') for an entity array ('" + this.getJavaTypeName() + "') must be designated as embedded");
        }
    }

    @Override
    public String getTemplatedJavaTypeName() {
        return this.type.getTemplatedJavaTypeName() + "[]";
    }

    @Override
    public final AdmType getComponentType() {
        return this.getType();
    }

    public final AdmEntity getType() {
        return this.type;
    }

    @Override
    public final String getFullName() {
        return this.type.getFullName() + "[]";
    }

    @Override
    public final String getJavaTypeName() {
        String name = this.getName();
        if (AdmModel.RESERVED_TYPE_NAMES.contains(this.type.getName())) {
            return this.getFullName();
        }
        return name;
    }
}

