/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon.controller;

import com.neeve.daemon.config.IDmnConfigDescriptor;
import com.neeve.daemon.controller.DmnControllerObject;
import com.neeve.daemon.controller.IDmnControllerEventHandler;
import com.neeve.daemon.controller.IDmnControllerLauncher;
import com.neeve.daemon.thread.DmnThreadManager;
import com.neeve.daemon.thread.DmnThreadPool;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DmnController
extends DmnControllerObject {
    private final StopEventHandler stopEventHandler = new StopEventHandler();
    private final AtomicInteger stopState = new AtomicInteger(0);
    private volatile int state = 0;
    private volatile IDmnControllerEventHandler eventHandler;
    private volatile IDmnControllerLauncher launcher;
    private final int STATE_CREATED = 0;
    private final int STATE_THREAD_MANAGER_INIT = 1;
    private final int STATE_DAEMON_INIT = 2;
    private final int STATE_DAEMON_START = 3;
    private final int STATE_THREAD_MANAGER_START = 4;
    private final int STOP_STATE_NOT_STOPPING = 0;
    private final int STOP_STATE_STOPPING = 1;
    private final int STOP_STATE_STOPPED = 2;
    public final int FLG_NON_BLOCKING = 1;

    protected DmnController(RootConfig.ObjectConfig config) {
        super(config);
    }

    private final void dispatchEvent(int type, Object data) {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.onEvent(type, data);
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append("Handler of the daemon lifecycle event #" + type + " failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
    }

    protected abstract IDmnConfigDescriptor getConfigDescriptor();

    protected abstract DmnThreadManager getThreadManager();

    protected abstract void doInit() throws Exception;

    protected abstract void doStart() throws Exception;

    protected abstract void doStop();

    protected abstract void doClose() throws Exception;

    protected final void restart() throws Exception {
        if (this.launcher == null) {
            throw new Exception("VM restart is not supported in this execution configuration");
        }
        this.launcher.executeVMRestart();
    }

    protected final void kill() throws Exception {
        if (this.launcher != null) {
            try {
                this.launcher.executeVMKill();
            }
            catch (Exception e) {
                Runtime.getRuntime().halt(1);
            }
        } else {
            Runtime.getRuntime().halt(1);
        }
    }

    public final void setEventHandler(IDmnControllerEventHandler eventHandler) {
        if (this.state != 0) {
            throw new IllegalStateException("event handler must be set prior to daemon start");
        }
        this.eventHandler = eventHandler;
    }

    public final IDmnControllerEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public final void setLauncher(IDmnControllerLauncher launcher) {
        if (this.state != 0) {
            throw new IllegalStateException("launcher must be set prior to daemon start");
        }
        this.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (this.state != 0) {
            throw new IllegalStateException("daemon has already been started");
        }
        if (this.getConfigDescriptor().isPrintDescriptor()) {
            System.out.println("   Configuration {");
            System.out.print(this.getConfigDescriptor().toString());
            System.out.println("   }\n");
        }
        Throwable initResult = null;
        this.dispatchEvent(1, null);
        try {
            try {
                int numIOThreads = this.getConfigDescriptor().getIOThreadCount();
                long[] ioThreadCpuAffinityMasks = this.getConfigDescriptor().getIOThreadCPUAffinityMasks();
                int maxOnDemandThreads = this.getConfigDescriptor().getMaxOnDemandThreadCount();
                this.tracer.log("Initializing thread manager (numIOThreads=" + numIOThreads + " maxOnDemandThreads=" + maxOnDemandThreads + ")...", Tracer.Level.INFO);
                this.state = 1;
                this.getThreadManager().init(numIOThreads, ioThreadCpuAffinityMasks, maxOnDemandThreads);
            }
            catch (Throwable t) {
                initResult = t;
                StringBuilder sb = new StringBuilder();
                sb.append("Initialization failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                if (this.getThreadManager().getThreadPool().getMainThread() != null) {
                    this.stop();
                }
                this.dispatchEvent(2, initResult);
                return;
            }
            try {
                this.state = 2;
                this.doInit();
            }
            catch (Throwable t) {
                initResult = t;
                StringBuilder sb = new StringBuilder();
                sb.append("Initialization failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                this.stop();
                this.dispatchEvent(2, initResult);
                return;
            }
        }
        finally {
            this.dispatchEvent(2, initResult);
        }
        Throwable startResult = null;
        this.dispatchEvent(3, null);
        try {
            this.state = 3;
            this.doStart();
        }
        catch (Throwable t) {
            startResult = t;
            StringBuilder sb = new StringBuilder();
            sb.append("Start failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            this.stop();
            return;
        }
        finally {
            this.dispatchEvent(4, startResult);
        }
        try {
            this.state = 4;
            this.getThreadManager().start();
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Thread manager exited with unhandled fault\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(int flags) {
        if (this.state >= 1) {
            boolean nonBlocking = (flags & 1) == 1;
            DmnThreadPool threadPool = this.getThreadManager().getThreadPool();
            if (Thread.currentThread() != threadPool.getMainThread().getDispatcher().getOwner()) {
                switch (this.stopState.get()) {
                    case 0: {
                        this.tracer.log("Scheduling controller stop in main thread...", Tracer.Level.INFO);
                        IEmxUserEvent userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.stopEventHandler);
                        threadPool.getMainThread().getDispatcher().schedUserEv(userEvent);
                        break;
                    }
                    case 1: {
                        this.tracer.log("Stop in currently in progress.", Tracer.Level.INFO);
                        break;
                    }
                    case 2: {
                        this.tracer.log("Server already stopped.", Tracer.Level.INFO);
                        break;
                    }
                    default: {
                        throw new InternalError("unknown stop state '" + this.stopState.get() + "'");
                    }
                }
                if (!nonBlocking && !threadPool.isManagedThread()) {
                    while (true) {
                        try {
                            threadPool.getMainThread().getDispatcher().getOwner().join();
                        }
                        catch (InterruptedException userEvent) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.stopState.compareAndSet(0, 1)) {
                Throwable stopResult = null;
                this.dispatchEvent(5, null);
                try {
                    StringBuilder sb;
                    if (this.state >= 3) {
                        try {
                            this.doStop();
                        }
                        catch (Throwable t) {
                            stopResult = t;
                            sb = new StringBuilder();
                            sb.append("Stop failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                        }
                    }
                    try {
                        this.tracer.log("Stopping the thread manager...", Tracer.Level.INFO);
                        this.getThreadManager().stop();
                    }
                    catch (Throwable t) {
                        stopResult = t;
                        sb = new StringBuilder();
                        sb.append("Stop failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                    this.dispatchEvent(6, stopResult);
                }
                catch (Throwable throwable) {
                    this.dispatchEvent(6, stopResult);
                    throw throwable;
                }
                Throwable closeResult = null;
                this.dispatchEvent(7, null);
                try {
                    if (this.state >= 2) {
                        try {
                            this.doClose();
                        }
                        catch (Throwable t) {
                            closeResult = t;
                            StringBuilder sb = new StringBuilder();
                            sb.append("Close failed\n").append(UtlThrowable.prepareStackTrace((Throwable)t));
                            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                        }
                    }
                }
                finally {
                    this.dispatchEvent(8, closeResult);
                }
                this.stopState.set(2);
            }
        }
    }

    public final void stop() {
        this.stop(0);
    }

    public final void stop(boolean sync) {
        this.stop(sync ? 0 : 1);
    }

    private final class StopEventHandler
    implements IEmxEventHandler {
        private StopEventHandler() {
        }

        public boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            DmnController.this.stop();
            return false;
        }
    }
}

