/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.discovery.impl;

import com.neeve.discovery.DiscoveryObject;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.lang.XString;
import com.neeve.raw.RawDataFactory;
import com.neeve.raw.RawType;
import com.neeve.raw.RawUUID;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

final class DiscoveryEntity
extends DiscoveryObject
implements IDiscoveryEntity {
    private final IDiscoveryCache cache;
    private final XString owner;
    private final XString type;
    private final XString name;
    private final XString host;
    private final RawUUID instance;
    private final List<UtlAddressDescriptor> descriptors;
    private final boolean discovered;
    private final short maxAge;
    private short age;
    private boolean zombie;

    DiscoveryEntity(IDiscoveryCache cache, XString owner, XString type, XString name, XString host, RawUUID instance, List<UtlAddressDescriptor> descriptors, boolean discovered, short age, short maxAge) {
        this.cache = cache;
        this.owner = XString.create((int)0, (boolean)false);
        this.owner.initializeFrom(owner);
        this.type = XString.create((int)0, (boolean)false);
        this.type.initializeFrom(type);
        this.name = XString.create((int)0, (boolean)false);
        this.name.initializeFrom(name);
        if (host == null) {
            this.host = XString.create((String)UtlNet.getLocalHostNameForDisplay((String)"<unknown>"));
        } else {
            this.host = XString.create((int)0, (boolean)false);
            this.host.initializeFrom(host);
        }
        this.instance = RawDataFactory.createRawUUID((boolean)false);
        if (instance == null) {
            this.instance.initializeRandom();
        } else {
            this.instance.initializeFrom((RawType)instance);
        }
        this.descriptors = descriptors;
        this.discovered = discovered;
        this.age = age;
        this.maxAge = maxAge;
        this.zombie = false;
    }

    private final String descriptorsString() {
        StringBuilder builder = new StringBuilder("<");
        Iterator<UtlAddressDescriptor> iterator = this.descriptors.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append(">");
        return builder.toString();
    }

    final void setZombie() {
        this.zombie = true;
    }

    final boolean isZombie() {
        return this.zombie;
    }

    @Override
    public final IDiscoveryCache getCache() {
        return this.cache;
    }

    @Override
    public final String getOwner() {
        return this.owner.getValue();
    }

    @Override
    public final XString getOwnerAsRaw() {
        return this.owner;
    }

    @Override
    public final String getType() {
        return this.type.getValue();
    }

    @Override
    public final XString getTypeAsRaw() {
        return this.type;
    }

    @Override
    public final String getName() {
        return this.name.getValue();
    }

    @Override
    public final XString getNameAsRaw() {
        return this.name;
    }

    @Override
    public final String getHost() {
        return this.host.getValue();
    }

    @Override
    public final XString getHostAsRaw() {
        return this.host;
    }

    @Override
    public final UUID getInstance() {
        return (UUID)this.instance.getValue();
    }

    @Override
    public final RawUUID getInstanceAsRaw() {
        return this.instance;
    }

    @Override
    public final short getMaxAge() {
        return this.maxAge;
    }

    final void setAge(short age) {
        this.age = age;
    }

    @Override
    public final short getAge() {
        return this.age;
    }

    final short incrementAge() {
        this.age = (short)(this.age + 1);
        return this.age;
    }

    final boolean hasExpired() {
        return this.age >= this.maxAge;
    }

    @Override
    public final List<UtlAddressDescriptor> getAddressDescriptors() {
        return this.descriptors;
    }

    @Override
    public final boolean wasDiscovered() {
        return this.discovered;
    }

    public String toString() {
        return "[" + this.getOwner() + "," + this.getInstance() + "," + this.getType() + "," + this.getName() + "," + this.getHost() + "," + this.descriptorsString() + "," + this.getAge() + "/" + this.getMaxAge() + "," + (this.wasDiscovered() ? "D" : "L") + "," + (this.isZombie() ? "Z" : "A") + "]";
    }
}

