/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.TableName;
import java.util.Properties;

public abstract class FromTable
extends ResultSetNode {
    protected Properties tableProperties;
    protected String correlationName;
    private TableName corrTableName;
    protected TableName origTableName;

    @Override
    public void init(Object correlationName, Object tableProperties) {
        this.correlationName = (String)correlationName;
        this.tableProperties = (Properties)tableProperties;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        FromTable other = (FromTable)node;
        this.tableProperties = other.tableProperties;
        this.correlationName = other.correlationName;
        this.corrTableName = (TableName)this.getNodeFactory().copyNode(other.corrTableName, this.getParserContext());
        this.origTableName = (TableName)this.getNodeFactory().copyNode(other.origTableName, this.getParserContext());
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    public void setCorrelationName(String correlationName) {
        this.correlationName = correlationName;
    }

    @Override
    public String toString() {
        return "correlation Name: " + this.correlationName + "\n" + (this.corrTableName != null ? this.corrTableName.toString() : "null") + "\n" + super.toString();
    }

    public TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    public String getExposedName() throws StandardException {
        return null;
    }

    public void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    public TableName getOrigTableName() {
        return this.origTableName;
    }
}

