/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class CreateSequenceNode
extends DDLStatementNode {
    private TableName sequenceName;
    private DataTypeDescriptor dataType;
    private long initialValue;
    private long stepValue;
    private long maxValue;
    private long minValue;
    private boolean cycle;

    @Override
    public void init(Object sequenceName, Object dataType, Object initialValue, Object stepValue, Object maxValue, Object minValue, Object cycle) throws StandardException {
        this.sequenceName = (TableName)sequenceName;
        this.initAndCheck(this.sequenceName);
        this.dataType = dataType != null ? (DataTypeDescriptor)dataType : DataTypeDescriptor.INTEGER;
        long l = this.stepValue = stepValue != null ? (Long)stepValue : 1L;
        if (this.dataType.getTypeId().equals(TypeId.SMALLINT_ID)) {
            this.minValue = minValue != null ? (Long)minValue : -32768L;
            this.maxValue = maxValue != null ? (Long)maxValue : 32767L;
        } else if (this.dataType.getTypeId().equals(TypeId.INTEGER_ID)) {
            this.minValue = minValue != null ? (Long)minValue : Integer.MIN_VALUE;
            this.maxValue = maxValue != null ? (Long)maxValue : Integer.MAX_VALUE;
        } else {
            this.minValue = minValue != null ? (Long)minValue : Long.MIN_VALUE;
            long l2 = this.maxValue = maxValue != null ? (Long)maxValue : Long.MAX_VALUE;
        }
        this.initialValue = initialValue != null ? (Long)initialValue : (this.stepValue > 0L ? this.minValue : this.maxValue);
        this.cycle = cycle != null ? ((Boolean)cycle).booleanValue() : Boolean.FALSE.booleanValue();
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CreateSequenceNode other = (CreateSequenceNode)node;
        this.sequenceName = (TableName)this.getNodeFactory().copyNode(other.sequenceName, this.getParserContext());
        this.dataType = other.dataType;
        this.initialValue = other.initialValue;
        this.stepValue = other.stepValue;
        this.maxValue = other.maxValue;
        this.minValue = other.minValue;
        this.cycle = other.cycle;
    }

    @Override
    public String toString() {
        return super.toString() + "sequenceName: " + this.sequenceName + "\n" + "initial value: " + this.initialValue + "\n" + "step value: " + this.stepValue + "\n" + "maxValue: " + this.maxValue + "\n" + "minValue:" + this.minValue + "\n" + "cycle: " + this.cycle + "\n";
    }

    @Override
    public String statementToString() {
        return "CREATE SEQUENCE";
    }

    public final long getInitialValue() {
        return this.initialValue;
    }

    public final long getStepValue() {
        return this.stepValue;
    }

    public final long getMaxValue() {
        return this.maxValue;
    }

    public final long getMinValue() {
        return this.minValue;
    }

    public final boolean isCycle() {
        return this.cycle;
    }
}

