/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;

final class Start
extends Command {
    private String _appName;
    private XVM _xvm;
    private boolean _async;

    Start(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: start the <appName> app in the <xvmName> xvm [nowait]");
    }

    @Override
    final String name() {
        return "start";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (tokenizer.hasMoreTokens()) {
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("nowait")) {
                this.syntaxError(this.lineNum());
            }
            this._async = true;
        }
        return true;
    }

    @Override
    final void execute() {
        try {
            if (!this.mock()) {
                this.remoteCommand(this._xvm.name(), null, "app_start " + this._appName + " " + this._async, true, 5);
            }
        }
        catch (Exception e) {
            this.error("Line " + this.lineNum() + ": Failed to execute command [" + e.toString() + "].", e);
        }
    }

    @Override
    final void cleanup() {
    }
}

