/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigObject;
import com.neeve.config.ConfigProviderDescriptor;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigProvider;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;

final class ConfigProviderRegistry
extends ConfigObject {
    private static final ConfigProviderRegistry instance = new ConfigProviderRegistry();
    private final HashMap<String, IConfigProvider> providers = new HashMap();

    private ConfigProviderRegistry() {
    }

    static final ConfigProviderRegistry getInstance() {
        return instance;
    }

    private final IConfigProvider createProvider(String className, String name, Properties props) throws EConfigException {
        Class<?> providerClass = null;
        try {
            providerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EConfigException("Configuration provider class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new EConfigException("Configuration provider class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method providerCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Properties")};
            providerCreateMethod = providerClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.util.Properties during instantiation of configuration provider class [" + className + "]");
        }
        catch (SecurityException e) {
            throw new EConfigException("Access to instantiation method in configuration provider class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new EConfigException("Instantiation method in configuration provider class [" + className + "] could not be found");
        }
        IConfigProvider provider = null;
        try {
            try {
                Object[] parameters = new Object[]{name, props};
                provider = (IConfigProvider)providerCreateMethod.invoke(null, parameters);
                if (provider == null) {
                    throw new EConfigException("Instantiation method in configuration provider class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EConfigException("Instantiation method in configuration provider class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EConfigException("Access to instantiation method in configuration provider class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof EConfigException) {
                throw (EConfigException)e.getCause();
            }
            throw new EConfigException(e.getCause());
        }
        return provider;
    }

    private final IConfigProvider createProvider(String name) throws EConfigException {
        if (ConfigProviderDescriptor.exists(name)) {
            try {
                ConfigProviderDescriptor descriptor = ConfigProviderDescriptor.load(name);
                return this.createProvider(descriptor.getClassName(), descriptor.getName(), descriptor.getProperties());
            }
            catch (EConfigException e) {
                throw new EConfigException("Failed to load provider descriptor from configuration repository [" + e.toString() + "]");
            }
        }
        throw new EConfigException("invalid provider '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IConfigProvider getProvider(String name) throws EConfigException {
        HashMap<String, IConfigProvider> hashMap = this.providers;
        synchronized (hashMap) {
            IConfigProvider provider;
            if (this.tracer.debug) {
                this.tracer.log("[ConfigProviderRegistry] Getting provider '" + name + "'...", Tracer.Level.DEBUG);
            }
            if ((provider = this.providers.get(name)) == null) {
                if (this.tracer.debug) {
                    this.tracer.log("[ConfigProviderRegistry] Configuration provider not created. Creating...", Tracer.Level.DEBUG);
                }
                provider = this.createProvider(name);
                this.providers.put(name, provider);
            } else if (this.tracer.debug) {
                this.tracer.log("[ConfigProviderRegistry] Configuration provider already created. Returning...", Tracer.Level.DEBUG);
            }
            return provider;
        }
    }

    static {
        try {
            ConfigProviderRegistry.instance.providers.put("mem", instance.createProvider("com.neeve.config.impl.mem.MemConfigProvider", "mem", new Properties()));
        }
        catch (Exception e) {
            ConfigProviderRegistry.instance.tracer.log("Failed to load 'mem' configuration provider class  [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
            System.exit(0);
        }
        try {
            ConfigProviderRegistry.instance.providers.put("pft", instance.createProvider("com.neeve.config.impl.pft.PftConfigProvider", "pft", new Properties()));
        }
        catch (Exception e) {
            ConfigProviderRegistry.instance.tracer.log("Failed to load 'pft' configuration provider class  [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
            System.exit(0);
        }
    }
}

