/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.StoIntField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;

public final class StoCompoundField
extends StoVariableLengthField<StoFieldContainer> {
    private static final int TFID_POS = 0;
    private static final int TID_POS = 2;
    private static final int LEN_POS = 4;
    public static final int HEADER_LENGTH = 4;

    private StoCompoundField(String name) {
        super(StoField.Type.COMPOUND, name);
    }

    private StoCompoundField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    static final int putHeader(ByteBuffer buffer, int offset, StoFieldContainer val) {
        short tfid = val == null ? (short)0 : val.getTypeFactoryId();
        short tid = val == null ? (short)0 : val.getTypeId();
        StoShortField.put(buffer, offset + 0, tfid);
        StoShortField.put(buffer, offset + 2, tid);
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int putBody(ByteBuffer buffer, int offset, StoFieldContainer val) {
        int len = val == null ? 0 : val.getSerializedLength();
        StoIntField.put(buffer, offset, len);
        if (val != null) {
            int pos = buffer.position();
            try {
                val.sync(buffer, offset + 4);
            }
            finally {
                buffer.position(pos);
            }
        }
        return 4 + len;
    }

    static final short getTypeFactoryId(ByteBuffer buffer, int offset) {
        return StoShortField.get(buffer, offset + 0);
    }

    static final short getTypeId(ByteBuffer buffer, int offset) {
        return StoShortField.get(buffer, offset + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final StoFieldContainer getBody(ByteBuffer buffer, int offset, StoTypeFactory factory, short tid) {
        int len = StoIntField.get(buffer, offset);
        if (len > 0) {
            int pos = buffer.position();
            int limit = buffer.limit();
            try {
                ByteBuffer slicedBuffer = ((ByteBuffer)buffer.limit(offset + 4 + len).position(offset + 4)).slice();
                StoFieldContainer stoFieldContainer = factory == null ? StoFieldContainer.create(slicedBuffer, false) : factory.createCompoundType(tid, slicedBuffer, false);
                return stoFieldContainer;
            }
            finally {
                if (pos > buffer.limit()) {
                    buffer.limit(limit);
                    buffer.position(pos);
                } else {
                    buffer.position(pos);
                    buffer.limit(limit);
                }
            }
        }
        return null;
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoCompoundField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(StoFieldContainer val) {
        return StoCompoundField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, StoFieldContainer val) {
        StoCompoundField.put(buffer, offset, val);
    }

    @Override
    protected final StoFieldContainer deserialize(ByteBuffer buffer, int offset) {
        return StoCompoundField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(StoFieldContainer val1, StoFieldContainer val2) {
        return val1.contentsEquals(val2);
    }

    @Override
    protected final StoFieldContainer clone(StoFieldContainer val) {
        return (StoFieldContainer)val.clone();
    }

    @Override
    protected final String toString(StoFieldContainer val) {
        return val.toString();
    }

    public static StoCompoundField create(String name) {
        return new StoCompoundField(name);
    }

    public static StoCompoundField create(ByteBuffer buffer, int bufferOffset) {
        return new StoCompoundField(buffer, bufferOffset);
    }

    public static final int getBodySerializedLength(ByteBuffer buffer, int offset) {
        return 4 + StoIntField.get(buffer, offset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 4 + StoCompoundField.getBodySerializedLength(buffer, offset + 4);
    }

    public static final int getBodySerializedLength(StoFieldContainer val) {
        return 4 + (val != null ? val.getSerializedLength() : 0);
    }

    public static int getSerializedLength(StoFieldContainer val) {
        return 4 + StoCompoundField.getBodySerializedLength(val);
    }

    public static int put(ByteBuffer buffer, int offset, StoFieldContainer val) {
        return StoCompoundField.putHeader(buffer, offset, val) + StoCompoundField.putBody(buffer, offset + 4, val);
    }

    public static StoFieldContainer get(ByteBuffer buffer, int offset) {
        short tfid = StoCompoundField.getTypeFactoryId(buffer, offset);
        short tid = StoCompoundField.getTypeId(buffer, offset);
        StoTypeFactory factory = null;
        if (tfid != 0 && (factory = StoTypeFactoryRegistry.getInstance().getTypeFactory(tfid)) == null) {
            System.err.println("WARNING: STO type factory '" + tfid + "' could not be found. Unable to instantiate correct user types");
        }
        return StoCompoundField.getBody(buffer, offset + 4, factory, tid);
    }
}

