/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.tools.AbstractCommand;
import com.neeve.tools.HeartbeatsDumpCommand;
import com.neeve.tools.TltCommand;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ToolsCommand
extends AbstractCommand {
    private static final Set<String> topLevelCommands = Stream.of("tlt", "hbdump").collect(Collectors.toCollection(HashSet::new));

    ToolsCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("Usage: rumi tools <command> [options]");
        System.out.println();
        System.out.println("Analysis and troubleshooting tools for Rumi applications");
        System.out.println();
        System.out.println("Available commands:");
        System.out.println("  tlt        Transaction Log Tool - query and analyze transaction logs");
        System.out.println("  hbdump     Heartbeats dump tool - analyze heartbeat data");
        System.out.println();
        System.out.println("Run 'rumi tools <command> --help' for detailed information on a command.");
    }

    private static final AbstractCommand commandHandler(String command) {
        switch (command.toLowerCase()) {
            case "tlt": {
                return new TltCommand();
            }
            case "hbdump": {
                return new HeartbeatsDumpCommand();
            }
        }
        return null;
    }

    @Override
    final void help(String[] args) {
        if (args.length == 0) {
            this.printTopLevelUsage();
        } else {
            AbstractCommand commandHandler = ToolsCommand.commandHandler(args[0]);
            if (commandHandler == null) {
                System.err.println("Unknown tools command '" + args[0] + "'");
                System.err.println();
                this.printTopLevelUsage();
            } else {
                String[] subArgs = new String[args.length - 1];
                System.arraycopy(args, 1, subArgs, 0, subArgs.length);
                commandHandler.help(subArgs);
            }
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length == 0) {
            this.printTopLevelUsage();
            System.exit(1);
        } else if (!topLevelCommands.contains(args[0].toLowerCase())) {
            System.err.println("Unknown tools command '" + args[0] + "'");
            System.err.println();
            this.printTopLevelUsage();
            System.exit(1);
        } else {
            AbstractCommand commandHandler = ToolsCommand.commandHandler(args[0]);
            String[] subArgs = new String[args.length - 1];
            System.arraycopy(args, 1, subArgs, 0, subArgs.length);
            commandHandler.execute(subArgs);
        }
    }
}

