/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.config.Config;
import com.neeve.util.UtlConstants;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlPoolRegistry;
import com.neeve.util.UtlPoolWasher;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlReferenceTracker;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class UtlPool<T extends Item<T>> {
    private final String type;
    private final String name;
    private final String key;
    private final Factory<T> factory;
    private final Params params;
    private final Stats stats;
    private final boolean shouldPool;
    private final UtlPoolWasher washer;
    private final AtomicBoolean guard;
    private final ReentrantLock lock;
    private volatile EvictedItemReceiver evictedItemReceiver;
    private volatile T[] pool;
    private volatile long tail;
    private volatile long head;
    private volatile boolean closed;
    private final boolean leakTrackingEnabled;
    private final StackTraceElement[][] poolMissAllocationTraces;
    private final UtlReferenceTracker.HasReferenceTracker[] poolMissReferenceTrackers;
    private int recordedPoolMissCount = 0;
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private static final int POOL_LEAK_HISTORY_SIZE;
    private static final int POOL_LEAK_TRIGGER_THRESHOLD;
    private static final boolean POOL_LEAK_TRACKING_ENABLED;
    public static final boolean POOL_LEAK_TYPE_TRACKING_ENABLED;
    private static final boolean POOL_DEBUG;
    private static final boolean POOL_CHECKED;
    private static final boolean POOL_LAST_IN_FIRST_OUT;
    private static final LockingStrategy LOCKING_STRATEGY;
    private static final HashSet<String> POOL_LEAK_TRACKING_ENABLED_TYPES;

    private UtlPool(String type, String name, Factory<T> factory, Params creationParams) {
        this.type = type;
        this.name = name != null ? name + "." + instanceCount.incrementAndGet() : null;
        this.key = this.type != null && this.name != null ? this.type + "." + this.name : null;
        this.factory = factory;
        Params params = this.params = creationParams == null ? Params.create() : (Params)creationParams.clone();
        if (Config.getValue((String)"nv.tuning.memory.pool.sourceparamsfromenv", (boolean)Config.getValue((String)"nv.pool.sourceparamsfromenv", (boolean)true))) {
            boolean allowEnvOverride = Config.getValue((String)"nv.tuning.memory.pool.overrideparamsfromenv", (boolean)Config.getValue((String)"nv.pool.overrideparamsfromenv", (boolean)false));
            if (type != null) {
                this.params.loadFromConfig("nv.pool." + type, allowEnvOverride);
                if (POOL_DEBUG) {
                    System.out.println("Sourced parameter for pool: nv.pool." + type + ": " + this.params + "\n  Params Input: " + creationParams);
                }
            }
            if (type != null && name != null) {
                this.params.loadFromConfig("nv.pool." + type + "." + name, allowEnvOverride);
                if (POOL_DEBUG) {
                    System.out.println("Sourced parameter for pool: nv.pool." + type + "." + name + ": " + this.params + "\n  Params Input: " + creationParams);
                }
            }
        }
        this.params.initialCapacity = Math.min(this.params.initialCapacity, this.params.maxCapacity);
        this.params.readOnly = true;
        this.stats = new Stats(type != null && name != null ? type + "." + name : null);
        this.shouldPool = Config.getValue((String)"nv.tuning.memory.pool.shouldpool", (boolean)Config.getValue((String)"nv.pool.shouldpool", (boolean)true));
        this.pool = factory.createItemArray(this.params.initialCapacity);
        this.washer = UtlPoolWasher.getInstance();
        this.guard = LOCKING_STRATEGY == LockingStrategy.Spinning ? new AtomicBoolean(false) : null;
        ReentrantLock reentrantLock = this.lock = LOCKING_STRATEGY == LockingStrategy.Lock ? new ReentrantLock(true) : null;
        if (UtlPool.isLeakTrackingEnabled(this.pool.getClass().getComponentType())) {
            this.poolMissAllocationTraces = new StackTraceElement[POOL_LEAK_HISTORY_SIZE][];
            this.poolMissReferenceTrackers = new UtlReferenceTracker.HasReferenceTracker[POOL_LEAK_HISTORY_SIZE];
            this.leakTrackingEnabled = true;
        } else {
            this.leakTrackingEnabled = false;
            this.poolMissAllocationTraces = null;
            this.poolMissReferenceTrackers = null;
        }
        if (this.params.preallocate && this.shouldPool) {
            for (int i = 0; i < this.pool.length; ++i) {
                this.putUnprotected(factory.createItem(null));
            }
        }
        if (name != null && type != null) {
            UtlPoolRegistry.getInstance().put(this);
        }
    }

    static boolean isLeakTrackingEnabled(Class<?> type) {
        return POOL_LEAK_TRACKING_ENABLED || POOL_LEAK_TRACKING_ENABLED_TYPES.contains(type.getName());
    }

    public static <T extends Item<T>> UtlPool<T> create(String type, String name, Factory<T> factory, Params params) {
        return new UtlPool<T>(type, name, factory, params);
    }

    public static final <T extends Item<T>> UtlPool<T>[] createPoolArray(int size) {
        return new UtlPool[size];
    }

    @Deprecated
    public static final boolean isLockFreeConcurrencyEnabled() {
        return LOCKING_STRATEGY == LockingStrategy.Spinning;
    }

    public static final LockingStrategy getLockingStrategy() {
        return LOCKING_STRATEGY;
    }

    public static final boolean isDetachedWashEnabled() {
        return UtlPoolWasher.isDetached();
    }

    private final void acquireLock() {
        if (LOCKING_STRATEGY == LockingStrategy.Spinning) {
            while (!this.guard.compareAndSet(false, true)) {
            }
        } else if (LOCKING_STRATEGY == LockingStrategy.Lock) {
            this.lock.lock();
        } else {
            throw new IllegalStateException("Attempt to acquire pool lock with locking strategy of " + (Object)((Object)LOCKING_STRATEGY));
        }
    }

    private final void releaseLock() {
        if (LOCKING_STRATEGY == LockingStrategy.Spinning) {
            this.guard.set(false);
        } else if (LOCKING_STRATEGY == LockingStrategy.Lock) {
            this.lock.unlock();
        } else {
            throw new IllegalStateException("Attempt to release pool lock with locking strategy of " + (Object)((Object)LOCKING_STRATEGY));
        }
    }

    private final T getUnprotected(Object object) {
        T item;
        if (this.closed) {
            throw new IllegalStateException("attempt to access a pool (method=get()) after it has been closed");
        }
        ++this.stats.gets;
        if (this.head == this.tail) {
            item = this.factory.createItem(object);
            ++this.stats.misses;
        } else {
            if (POOL_LAST_IN_FIRST_OUT) {
                item = this.pool[(int)(--this.head % (long)this.pool.length)];
            } else {
                item = this.pool[(int)(this.tail % (long)this.pool.length)];
                ++this.tail;
            }
            ++this.stats.hits;
        }
        if (this.leakTrackingEnabled) {
            final Class<?> itemClass = item.getClass();
            long leakCount = this.stats.gets - this.stats.puts;
            if (leakCount > (long)POOL_LEAK_TRIGGER_THRESHOLD) {
                if (this.recordedPoolMissCount < POOL_LEAK_HISTORY_SIZE) {
                    this.poolMissAllocationTraces[this.recordedPoolMissCount] = Thread.currentThread().getStackTrace();
                    if (item instanceof UtlReferenceTracker.HasReferenceTracker) {
                        this.poolMissReferenceTrackers[this.recordedPoolMissCount] = (UtlReferenceTracker.HasReferenceTracker)item;
                    }
                }
                if (++this.recordedPoolMissCount == POOL_LEAK_HISTORY_SIZE) {
                    Thread thread = new Thread("POOL LEAK DUMP"){

                        @Override
                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append("\n");
                            sb.append("PROBABLE POOL LEAK DETECTED FOR").append(": ").append(itemClass.getSimpleName()).append("::").append(UtlPool.this.name).append("\n");
                            sb.append("Allocation History:");
                            for (int miss = 0; miss < UtlPool.this.poolMissAllocationTraces.length; ++miss) {
                                StackTraceElement[] stack = UtlPool.this.poolMissAllocationTraces[miss];
                                UtlReferenceTracker.HasReferenceTracker tracker = UtlPool.this.poolMissReferenceTrackers[miss];
                                sb.append("POOL MISS #").append(miss + 1).append("\n");
                                if (tracker != null && tracker.referenceTracker() != null) {
                                    tracker.referenceTracker().dump(sb);
                                } else if (stack != null) {
                                    for (int i = 3; i < stack.length; ++i) {
                                        sb.append("  ").append(stack[i].toString()).append("\n");
                                    }
                                }
                                ((UtlPool)UtlPool.this).poolMissAllocationTraces[miss] = null;
                                ((UtlPool)UtlPool.this).poolMissReferenceTrackers[miss] = null;
                            }
                            System.err.println(sb);
                        }
                    };
                    thread.start();
                }
            }
        }
        return item.setPool(this);
    }

    private final int sizeUnprotected() {
        if (this.closed) {
            throw new IllegalStateException("attempt to access a pool (method=size()) after it has been closed");
        }
        return (int)(this.head - this.tail);
    }

    private final int capacityUnprotected() {
        if (this.closed) {
            throw new IllegalStateException("attempt to access a pool (method=capacity()) after it has been closed");
        }
        return this.pool.length;
    }

    private final void putUnprotected(T item) {
        if (this.closed) {
            if (POOL_CHECKED || POOL_DEBUG) {
                System.err.println(UtlThrowable.prepareStackTrace((Throwable)new IllegalStateException("attempt to access a pool (method=put()) after it has been closed ")));
            }
            return;
        }
        ++this.stats.puts;
        if (this.head - this.tail == (long)this.pool.length && this.pool.length < this.params.getMaxCapacity()) {
            int newcap = Math.min(this.pool.length * 2, this.params.getMaxCapacity());
            Item[] newpool = this.factory.createItemArray(newcap);
            for (long i = this.tail; i < this.head; ++i) {
                newpool[(int)(i % (long)newpool.length)] = this.pool[(int)(i % (long)this.pool.length)];
            }
            this.pool = newpool;
            ++this.stats.growths;
        }
        if (this.head - this.tail < (long)this.pool.length) {
            this.pool[(int)(this.head % (long)this.pool.length)] = item;
            ++this.head;
        } else {
            ++this.stats.evicts;
            if (this.evictedItemReceiver != null) {
                this.evictedItemReceiver.process(item);
            }
        }
    }

    private final void flushUnprotected(FlushedItemReceiver<T> receiver) {
        while (this.tail != this.head) {
            if (receiver != null) {
                receiver.process(this.pool[(int)(this.tail % (long)this.pool.length)]);
            }
            ++this.tail;
        }
    }

    private final void closeUnprotected(boolean releaseLock) {
        if (!this.closed) {
            try {
                this.stats.stop();
            }
            finally {
                this.closed = true;
                if (releaseLock) {
                    this.releaseLock();
                }
            }
            if (this.name != null && this.type != null) {
                UtlPoolRegistry.getInstance().remove(this);
            }
        } else if (releaseLock) {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void postWash(Item<?> item, boolean detachedWash) {
        if (detachedWash) {
            ++this.stats.dwashes;
        }
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    this.putUnprotected(item);
                }
            } else {
                this.acquireLock();
                try {
                    this.putUnprotected(item);
                }
                finally {
                    this.releaseLock();
                }
            }
        } else {
            this.putUnprotected(item);
        }
    }

    public final String type() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String key() {
        return this.key;
    }

    public final void setSingleThreaded() {
        this.params.threaded = false;
    }

    public final UtlPool<T> setEvictedItemReceiver(EvictedItemReceiver<T> receiver) {
        this.evictedItemReceiver = receiver;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(Object object) {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    return this.getUnprotected(object);
                }
            }
            this.acquireLock();
            try {
                T t = this.getUnprotected(object);
                return t;
            }
            finally {
                this.releaseLock();
            }
        }
        return this.getUnprotected(object);
    }

    public final void put(T item) {
        if (this.shouldPool) {
            this.washer.wash((Item<?>)item, !this.params.threaded || !this.params.detachedWash);
        } else {
            ++this.stats.evicts;
            if (this.evictedItemReceiver != null) {
                this.evictedItemReceiver.process(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    return this.sizeUnprotected();
                }
            }
            this.acquireLock();
            try {
                int n = this.sizeUnprotected();
                return n;
            }
            finally {
                this.releaseLock();
            }
        }
        return this.sizeUnprotected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int capacity() {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    return this.capacityUnprotected();
                }
            }
            this.acquireLock();
            try {
                int n = this.capacityUnprotected();
                return n;
            }
            finally {
                this.releaseLock();
            }
        }
        return this.capacityUnprotected();
    }

    public final Stats stats() {
        return this.stats;
    }

    public final Params params() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush(FlushedItemReceiver<T> receiver) {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    this.flushUnprotected(receiver);
                }
            } else {
                this.acquireLock();
                try {
                    this.flushUnprotected(receiver);
                }
                finally {
                    this.releaseLock();
                }
            }
        } else {
            this.flushUnprotected(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    return this.closed;
                }
            }
            this.acquireLock();
            try {
                boolean bl = this.closed;
                return bl;
            }
            finally {
                this.releaseLock();
            }
        }
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.params.threaded) {
            if (LOCKING_STRATEGY == LockingStrategy.Mutex) {
                UtlPool utlPool = this;
                synchronized (utlPool) {
                    this.closeUnprotected(false);
                }
            } else {
                this.acquireLock();
                this.closeUnprotected(true);
            }
        } else {
            this.closeUnprotected(false);
        }
    }

    static {
        POOL_DEBUG = Config.getValue((String)"nv.tuning.memory.pool.debug", (boolean)Config.getValue((String)"nv.pool.debug", (boolean)false));
        POOL_CHECKED = Config.getValue((String)"nv.tuning.performance.pool.checked", (boolean)Config.getValue((String)"nv.pool.checked", (boolean)Config.getValue((String)"nv.checked", (boolean)false)));
        POOL_LEAK_TRACKING_ENABLED_TYPES = new HashSet();
        String lockingStrategyName = Config.getValue((String)"nv.tuning.performance.pool.lockingstrategy", (String)Config.getValue((String)"nv.pool.lockingstrategy", null));
        if (lockingStrategyName == null) {
            lockingStrategyName = UtlThread.cpuAffinityMasksEnabled() ? LockingStrategy.Spinning.name() : "Mutex";
        }
        LOCKING_STRATEGY = LockingStrategy.valueOf(lockingStrategyName);
        boolean enabled = Config.getValue((String)"nv.tuning.memory.pool.leaktracking.enabled", (boolean)Config.getValue((String)"nv.pool.leaktracking.enabled", (boolean)false));
        String types = Config.getValue((String)"nv.tuning.memory.pool.leaktracking.types", (String)Config.getValue((String)"nv.pool.leaktracking.types", (String)UtlConstants.POOL_LEAKTRACKING_ENABLED_TYPES_DEFAULT));
        boolean allTypes = false;
        if (types != null) {
            for (String type : types.split("\\|")) {
                if (type.trim().equals("*")) {
                    allTypes = true;
                    break;
                }
                POOL_LEAK_TRACKING_ENABLED_TYPES.add(type.trim());
            }
        }
        POOL_LEAK_TRACKING_ENABLED = enabled || allTypes;
        POOL_LEAK_TYPE_TRACKING_ENABLED = enabled || !POOL_LEAK_TRACKING_ENABLED_TYPES.isEmpty();
        POOL_LEAK_HISTORY_SIZE = Config.getValue((String)"nv.tuning.memory.pool.leaktracking.historySize", (int)Config.getValue((String)"nv.pool.leaktracking.historySize", (int)100));
        POOL_LEAK_TRIGGER_THRESHOLD = Config.getValue((String)"nv.tuning.memory.pool.leaktracking.triggerThreshold", (int)Config.getValue((String)"nv.pool.leaktracking.triggerThreshold", (int)100000));
        if (POOL_LEAK_TRACKING_ENABLED) {
            System.err.println("POOL LEAK TRACKING IS ENABLED");
        } else if (!POOL_LEAK_TRACKING_ENABLED_TYPES.isEmpty()) {
            System.err.println("POOL LEAK TRACKING IS ENABLED FOR: " + POOL_LEAK_TRACKING_ENABLED_TYPES);
        }
        POOL_LAST_IN_FIRST_OUT = Config.getValue((String)"nv.tuning.performance.pool.lifo", (boolean)Config.getValue((String)"nv.pool.lifo", (boolean)true));
    }

    public final class Stats {
        private com.neeve.util.UtlPool$Stats.OutputThread thread;
        private NumberFormat format = NumberFormat.getInstance();
        private long startTime;
        private long deltaStartTime;
        private int interval;
        private final int preallocatedCount;
        private long putsLast;
        private long getsLast;
        private long hitsLast;
        private long missesLast;
        private long growthsLast;
        private long evictsLast;
        private long dwashesLast;
        volatile long puts;
        volatile long gets;
        volatile long hits;
        volatile long misses;
        volatile long growths;
        volatile long evicts;
        volatile long dwashes;

        Stats(String key) {
            this.format.setMaximumFractionDigits(2);
            if (key != null) {
                String startProp1 = "nv.tuning.memory.pool." + key + ".stats.interval";
                String startProp2 = "nv.pool." + key + ".stats.interval";
                this.interval = Config.getValue((String)startProp1, (int)Config.getValue((String)startProp2, (int)0));
                if (this.interval > 0) {
                    this.thread = new OutputThread();
                    this.thread.start();
                }
            }
            this.preallocatedCount = UtlPool.this.params.preallocate ? Math.min(UtlPool.this.params.initialCapacity, UtlPool.this.params.maxCapacity) : 0;
        }

        private void stamp(long puts, long gets, long hits, long misses, long growths, long evicts, long dwashes) {
            this.deltaStartTime = System.currentTimeMillis();
            this.putsLast = puts;
            this.getsLast = gets;
            this.hitsLast = hits;
            this.missesLast = misses;
            this.growthsLast = growths;
            this.evictsLast = evicts;
            this.dwashesLast = dwashes;
        }

        final void init() {
            this.startTime = System.currentTimeMillis();
            this.stamp(this.puts, this.gets, this.hits, this.misses, this.growths, this.evicts, this.dwashes);
        }

        final void get(StringBuilder sb) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.deltaStartTime;
            long deltaTotalTime = currentTime - this.startTime;
            long putsCurrent = this.puts;
            long getsCurrent = this.gets;
            long hitsCurrent = this.hits;
            long missesCurrent = this.misses;
            long growthsCurrent = this.growths;
            long evictsCurrent = this.evicts;
            long dwashesCurrent = this.dwashes;
            int sizeCurrent = UtlPool.this.size();
            int capacityCurrent = UtlPool.this.capacity();
            String putsStr = this.format.format(putsCurrent);
            String deltaPutsStr = this.format.format(putsCurrent - this.putsLast);
            String putRateStr = this.format.format(putsCurrent * 1000L / deltaTotalTime);
            String deltaPutRateStr = this.format.format((putsCurrent - this.putsLast) * 1000L / deltaTime);
            String getsStr = this.format.format(getsCurrent);
            String deltaGetsStr = this.format.format(getsCurrent - this.getsLast);
            String getRateStr = this.format.format(getsCurrent * 1000L / deltaTotalTime);
            String deltaGetRateStr = this.format.format((getsCurrent - this.getsLast) * 1000L / deltaTime);
            String hitsStr = this.format.format(hitsCurrent);
            String deltaHitsStr = this.format.format(hitsCurrent - this.hitsLast);
            String hitRateStr = this.format.format(hitsCurrent * 1000L / deltaTotalTime);
            String deltaHitRateStr = this.format.format((hitsCurrent - this.hitsLast) * 1000L / deltaTime);
            String missesStr = this.format.format(missesCurrent);
            String deltaMissesStr = this.format.format(missesCurrent - this.missesLast);
            String missRateStr = this.format.format(missesCurrent * 1000L / deltaTotalTime);
            String deltaMissRateStr = this.format.format((missesCurrent - this.missesLast) * 1000L / deltaTime);
            String growthsStr = this.format.format(growthsCurrent);
            String deltaGrowthsStr = this.format.format(growthsCurrent - this.growthsLast);
            String growthRateStr = this.format.format(growthsCurrent * 1000L / deltaTotalTime);
            String deltaGrowthRateStr = this.format.format((growthsCurrent - this.growthsLast) * 1000L / deltaTime);
            String evictsStr = this.format.format(evictsCurrent);
            String deltaEvictsStr = this.format.format(evictsCurrent - this.evictsLast);
            String evictRateStr = this.format.format(evictsCurrent * 1000L / deltaTotalTime);
            String deltaEvictRateStr = this.format.format((evictsCurrent - this.evictsLast) * 1000L / deltaTime);
            String dwashesStr = this.format.format(dwashesCurrent);
            String deltaDwashesStr = this.format.format(dwashesCurrent - this.dwashesLast);
            String dwashRateStr = this.format.format(dwashesCurrent * 1000L / deltaTotalTime);
            String deltaDwashRateStr = this.format.format((dwashesCurrent - this.dwashesLast) * 1000L / deltaTime);
            sb.append("Size{");
            sb.append(sizeCurrent);
            sb.append("} ");
            sb.append("Capacity{");
            sb.append(capacityCurrent).append(" [max=").append(UtlPool.this.params().getMaxCapacity()).append("]");
            sb.append("} ");
            sb.append("Preallocated{");
            sb.append(this.preallocatedCount);
            sb.append("} ");
            sb.append("Puts{");
            sb.append(putsStr + "(" + putRateStr + ") " + deltaPutsStr + "(" + deltaPutRateStr + ")");
            sb.append("} ");
            sb.append("Gets{");
            sb.append(getsStr + "(" + getRateStr + ") " + deltaGetsStr + "(" + deltaGetRateStr + ")");
            sb.append("} ");
            sb.append("Hits{");
            sb.append(hitsStr + "(" + hitRateStr + ") " + deltaHitsStr + "(" + deltaHitRateStr + ")");
            sb.append("} ");
            sb.append("Misses{");
            sb.append(missesStr + "(" + missRateStr + ") " + deltaMissesStr + "(" + deltaMissRateStr + ")");
            sb.append("} ");
            sb.append("Growths{");
            sb.append(growthsStr + "(" + growthRateStr + ") " + deltaGrowthsStr + "(" + deltaGrowthRateStr + ")");
            sb.append("} ");
            sb.append("Evicts{");
            sb.append(evictsStr + "(" + evictRateStr + ") " + deltaEvictsStr + "(" + deltaEvictRateStr + ")");
            sb.append("} ");
            sb.append("DWashes{");
            sb.append(dwashesStr + "(" + dwashRateStr + ") " + deltaDwashesStr + "(" + deltaDwashRateStr + ")");
            sb.append("}");
            sb.append("\n");
            this.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent);
        }

        final void stop() {
            if (this.thread != null) {
                this.interval = 0;
                this.thread.interrupt();
                while (true) {
                    try {
                        this.thread.join();
                        this.thread = null;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }

        public final long puts() {
            return this.puts;
        }

        public final long gets() {
            return this.gets;
        }

        public final long hits() {
            return this.hits;
        }

        public final long misses() {
            return this.misses;
        }

        public final long evicts() {
            return this.evicts;
        }

        public final long growths() {
            return this.growths;
        }

        public final long detachedWashes() {
            return this.dwashes;
        }

        public final int preallocated() {
            return this.preallocatedCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.putsLast = this.puts;
            this.getsLast = this.gets;
            this.hitsLast = this.hits;
            this.missesLast = this.misses;
            this.growthsLast = this.growths;
            this.evictsLast = this.evicts;
            this.dwashesLast = this.dwashes;
            sb.append("Pool Stats [").append(UtlPool.this.key).append("]{");
            sb.append("puts: ").append(this.puts).append(", ");
            sb.append("gets: ").append(this.gets).append(", ");
            sb.append("misses: ").append(this.misses).append(", ");
            sb.append("growths: ").append(this.growths).append(", ");
            sb.append("evicts: ").append(this.evicts).append(", ");
            sb.append("dwashes: ").append(this.dwashes).append(", ");
            sb.append("puts: ").append(this.puts).append(", ");
            sb.append("size: ").append(UtlPool.this.size()).append(", ");
            sb.append("capacity: ").append(UtlPool.this.capacity()).append(" / ").append(UtlPool.this.params.getMaxCapacity());
            sb.append("}");
            return sb.toString();
        }

        private final class OutputThread
        extends Thread {
            private final String prefix;

            OutputThread() {
                String poolName = UtlPool.this.key();
                this.setName("X-PoolStats-Printer[" + poolName + "]");
                this.setDaemon(true);
                this.prefix = "[Pool<" + poolName + "> STATS]\n";
            }

            @Override
            public final void run() {
                Stats.this.init();
                while (Stats.this.interval > 0) {
                    try {
                        Thread.sleep(Stats.this.interval * 1000);
                        StringBuilder sb = new StringBuilder().append(this.prefix);
                        Stats.this.get(sb);
                        System.out.println(sb.toString());
                    }
                    catch (InterruptedException e) {
                        Stats.this.interval = 0;
                    }
                }
            }
        }
    }

    public static class Params
    implements Cloneable {
        private volatile boolean readOnly = false;
        private volatile int initialCapacity = Config.getValue((String)"nv.tuning.memory.pool.initialCapacity", (int)Config.getValue((String)"nv.pool.initialCapacity", (int)(Config.conserveMemory() ? 128 : 1024)));
        private volatile boolean initialCapacityConfigured;
        private volatile int maxCapacity = Config.getValue((String)"nv.tuning.memory.pool.maxCapacity", (int)Config.getValue((String)"nv.pool.maxCapacity", (int)(Config.conserveMemory() ? 128 : Integer.MAX_VALUE)));
        private volatile boolean maxCapacityConfigured;
        private volatile boolean threaded = false;
        private volatile boolean threadedConfigured;
        private volatile boolean detachedWash = Config.getValue((String)"nv.tuning.performance.pool.detachedWash", (boolean)Config.getValue((String)"nv.pool.detachedWash", (boolean)false));
        private volatile boolean detachedWashConfigured;
        private volatile boolean preallocate = false;
        private volatile boolean preallocateConfigured;

        private Params() {
        }

        public static Params create() {
            return new Params();
        }

        public final boolean isReadOnly() {
            return this.readOnly;
        }

        private final void assertWriteable() throws IllegalStateException {
            if (this.readOnly) {
                throw new IllegalStateException("Params are read only");
            }
        }

        public final Params loadFromConfig(String propertyPrefix, boolean override) {
            this.assertWriteable();
            if (override || !this.detachedWashConfigured) {
                this.detachedWash = Config.getValue((String)(propertyPrefix + ".detachedWash"), (boolean)this.detachedWash);
            }
            if (override || !this.initialCapacityConfigured) {
                this.initialCapacity = Config.getValue((String)(propertyPrefix + ".initialCapacity"), (int)this.initialCapacity);
            }
            if (override || !this.maxCapacityConfigured) {
                this.maxCapacity = Config.getValue((String)(propertyPrefix + ".maxCapacity"), (int)this.maxCapacity);
            }
            if (override || !this.preallocateConfigured) {
                this.preallocate = Config.getValue((String)(propertyPrefix + ".preallocate"), (boolean)this.preallocate);
            }
            if (override || !this.threadedConfigured) {
                this.threaded = Config.getValue((String)(propertyPrefix + ".threaded"), (boolean)this.threaded);
            }
            return this;
        }

        public final Params load(String propertyPrefix, Properties source, boolean override) {
            this.assertWriteable();
            if (override || !this.detachedWashConfigured) {
                this.detachedWash = UtlProps.getValue((Properties)source, (String)(propertyPrefix + ".detachedWash"), (boolean)this.detachedWash);
            }
            if (override || !this.initialCapacityConfigured) {
                this.initialCapacity = UtlProps.getValue((Properties)source, (String)(propertyPrefix + ".initialCapacity"), (int)this.initialCapacity);
            }
            if (override || !this.maxCapacityConfigured) {
                this.maxCapacity = UtlProps.getValue((Properties)source, (String)(propertyPrefix + ".maxCapacity"), (int)this.maxCapacity);
            }
            if (override || !this.preallocateConfigured) {
                this.preallocate = UtlProps.getValue((Properties)source, (String)(propertyPrefix + ".preallocate"), (boolean)this.preallocate);
            }
            if (override || !this.threadedConfigured) {
                this.threaded = UtlProps.getValue((Properties)source, (String)(propertyPrefix + ".threaded"), (boolean)this.threaded);
            }
            return this;
        }

        public final Params load(String propertyPrefix, Map<String, Object> source, boolean override) {
            this.assertWriteable();
            if (override || !this.detachedWashConfigured) {
                this.detachedWash = UtlProps.getValue(source, (String)(propertyPrefix + ".detachedWash"), (boolean)this.detachedWash);
            }
            if (override || !this.initialCapacityConfigured) {
                this.initialCapacity = UtlProps.getValue(source, (String)(propertyPrefix + ".initialCapacity"), (int)this.initialCapacity);
            }
            if (override || !this.maxCapacityConfigured) {
                this.maxCapacity = UtlProps.getValue(source, (String)(propertyPrefix + ".maxCapacity"), (int)this.maxCapacity);
            }
            if (override || !this.preallocateConfigured) {
                this.preallocate = UtlProps.getValue(source, (String)(propertyPrefix + ".preallocate"), (boolean)this.preallocate);
            }
            if (override || !this.threadedConfigured) {
                this.threaded = UtlProps.getValue(source, (String)(propertyPrefix + ".threaded"), (boolean)this.threaded);
            }
            return this;
        }

        public final Params setThreaded(boolean val) {
            this.assertWriteable();
            this.threaded = val;
            this.threadedConfigured = true;
            return this;
        }

        public final boolean isThreaded() {
            return this.threaded;
        }

        public final Params setDetachedWash(boolean val) {
            this.assertWriteable();
            this.detachedWash = val;
            this.detachedWashConfigured = true;
            return this;
        }

        public final boolean isDetachedWash() {
            return this.detachedWash;
        }

        public final Params setInitialCapacity(int val) {
            this.assertWriteable();
            this.initialCapacity = val;
            this.initialCapacityConfigured = true;
            return this;
        }

        public final int getInitialCapacity() {
            return this.initialCapacity;
        }

        public final Params setMaxCapacity(int val) {
            this.assertWriteable();
            this.maxCapacity = val;
            this.maxCapacityConfigured = true;
            return this;
        }

        public final int getMaxCapacity() {
            return this.maxCapacity;
        }

        public Params setPreallocate(boolean preallocate) {
            this.assertWriteable();
            this.preallocate = preallocate;
            this.preallocateConfigured = true;
            return this;
        }

        public boolean isPreallocate() {
            return this.preallocate;
        }

        public Object clone() {
            Params clonee;
            try {
                clonee = (Params)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("Received CloneNotSupportedException even when Cloneable is implemented!");
            }
            clonee.initialCapacity = this.initialCapacity;
            clonee.initialCapacityConfigured = this.initialCapacityConfigured;
            clonee.maxCapacity = this.maxCapacity;
            clonee.maxCapacityConfigured = this.maxCapacityConfigured;
            clonee.threaded = this.threaded;
            clonee.threadedConfigured = this.threadedConfigured;
            clonee.detachedWash = this.detachedWash;
            clonee.detachedWashConfigured = this.detachedWashConfigured;
            clonee.preallocate = this.preallocate;
            clonee.preallocateConfigured = this.preallocateConfigured;
            clonee.readOnly = false;
            return clonee;
        }

        public String toString() {
            return "[threaded=" + this.threaded + ", detachedWash=" + this.detachedWash + ", initialCapacity=" + this.initialCapacity + ", maxCapacity=" + this.maxCapacity + "]";
        }
    }

    public static interface EvictedItemReceiver<T extends Item<T>> {
        public void process(T var1);
    }

    public static interface FlushedItemReceiver<T extends Item<T>> {
        public void process(T var1);
    }

    public static interface Item<T extends Item<T>> {
        public T init();

        public T setPool(UtlPool<T> var1);

        public UtlPool<T> getPool();
    }

    public static interface Factory<T extends Item<T>> {
        public T createItem(Object var1);

        public T[] createItemArray(int var1);
    }

    public static enum LockingStrategy {
        Spinning,
        Mutex,
        Lock;

    }
}

