/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XDoubleCollection;
import com.neeve.lang.XDoubleCollectionBase;
import com.neeve.lang.XDoubleIterator;
import com.neeve.lang.XDoubleList;
import com.neeve.lang.XDoubleListIterator;
import java.util.NoSuchElementException;

public class XDoubleLinkedList
extends XDoubleCollectionBase
implements XDoubleList {
    private transient DoubleNode _head = this.newNode();
    private transient DoubleNode _tail = this.newNode();
    private transient int _size;

    public XDoubleLinkedList() {
        this(4);
    }

    public XDoubleLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        DoubleNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            DoubleNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XDoubleLinkedList(XDoubleCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XDoubleLinkedList newInstance() {
        return new XDoubleLinkedList();
    }

    @Override
    public final boolean add(double value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final double get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final double set(int index, double value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        DoubleNode node = this.nodeAt(index);
        double previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, double value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XDoubleCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        DoubleNode indexNode = this.nodeAt(index);
        XDoubleIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final double remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        DoubleNode node = this.nodeAt(index);
        double previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(double value) {
        int index = 0;
        DoubleNode n = this._head;
        DoubleNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(double value) {
        int index = this.size() - 1;
        DoubleNode n = this._tail;
        DoubleNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XDoubleIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XDoubleListIterator listIterator() {
        return XDoubleLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XDoubleListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XDoubleLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XDoubleList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final double getFirst() {
        DoubleNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final double getLast() {
        DoubleNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(double value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(double value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final double removeFirst() {
        DoubleNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        double previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final double removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        DoubleNode last = this._tail._previous;
        double previousValue = last._value;
        this._tail = last;
        last._value = 0.0;
        return previousValue;
    }

    public final void addBefore(DoubleNode next, double value) {
        DoubleNode newNode;
        DoubleNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        DoubleNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final DoubleNode nodeAt(int index) {
        DoubleNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final DoubleNode head() {
        return this._head;
    }

    @Override
    public final DoubleNode tail() {
        return this._tail;
    }

    @Override
    public final double valueOf(XCollection.Record record) {
        return ((DoubleNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        DoubleNode node = (DoubleNode)record;
        --this._size;
        node._value = 0.0;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        DoubleNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(double value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XDoubleList unmodifiable() {
        return (XDoubleList)super.unmodifiable();
    }

    protected DoubleNode newNode() {
        return new DoubleNode();
    }

    private void increaseCapacity() {
        DoubleNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        DoubleNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        DoubleNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        DoubleNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XDoubleLinkedListIterator
    implements XDoubleListIterator {
        private XDoubleLinkedList _list;
        private DoubleNode _nextNode;
        private DoubleNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XDoubleLinkedListIterator() {
        }

        public static XDoubleLinkedListIterator valueOf(XDoubleLinkedList list, DoubleNode nextNode, int nextIndex, int size) {
            XDoubleLinkedListIterator itr = new XDoubleLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public double next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public double previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(double o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(double o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XDoubleLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XDoubleCollectionBase
    implements XDoubleList {
        private XDoubleLinkedList _list;
        private DoubleNode _head;
        private DoubleNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XDoubleLinkedList list, DoubleNode head, DoubleNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public double valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XDoubleCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XDoubleCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            DoubleNode indexNode = this.nodeAt(index);
            XDoubleIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public double get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public double set(int index, double value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            DoubleNode node = this.nodeAt(index);
            double previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(double element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, double element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public double remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            DoubleNode node = this.nodeAt(index);
            double previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(double value) {
            int index = 0;
            DoubleNode n = this._head;
            DoubleNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(double value) {
            int index = this.size() - 1;
            DoubleNode n = this._tail;
            DoubleNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XDoubleListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XDoubleListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XDoubleLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XDoubleList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final DoubleNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                DoubleNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            DoubleNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class DoubleNode
    implements XCollection.Record {
        private DoubleNode _next;
        private DoubleNode _previous;
        private double _value;

        protected DoubleNode() {
        }

        public final double getValue() {
            return this._value;
        }

        @Override
        public final DoubleNode getNext() {
            return this._next;
        }

        @Override
        public final DoubleNode getPrevious() {
            return this._previous;
        }
    }
}

