/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.io;

import com.neeve.io.IOBuffer;
import com.neeve.memory.MemoryStats;
import com.neeve.util.UtlBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class IOElasticBuffer {
    private static final ThreadLocal<StringBuilder> UTF_BUILDER = new ThreadLocal();
    private static final byte FLG_COPYONWRITE = 1;
    private static final byte FLG_READONLY = 2;
    private static final byte FLG_INCREATEBACKINGBUFFER = 4;
    private static final byte FLG_WRAPPED = 8;
    private static final MemoryStats stats = MemoryStats.getInstance();
    private InputStreamImpl is;
    private OutputStreamImpl os;
    private IOBuffer iobuf;
    private long iobufaddr;
    private int offset;
    private final Sizer sizer;
    private int size;
    private int length;
    private int highwater;
    private Initializer initializer;
    private byte flags;

    private IOElasticBuffer(Sizer sizer, int size, Initializer initializer) {
        this.sizer = sizer;
        this.size = size;
        this.initializer = initializer;
    }

    public static IOElasticBuffer create(Sizer sizer, Initializer initializer) {
        if (sizer == null) {
            throw new IllegalArgumentException("sizer cannot be null");
        }
        return new IOElasticBuffer(sizer, 0, initializer);
    }

    public static IOElasticBuffer create(Sizer sizer) {
        if (sizer == null) {
            throw new IllegalArgumentException("sizer cannot be null");
        }
        return IOElasticBuffer.create(sizer, null);
    }

    public static IOElasticBuffer create(int size, Initializer initializer) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        return new IOElasticBuffer(null, size, initializer);
    }

    public static IOElasticBuffer create(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("IO buffer initial length must be > 0");
        }
        return IOElasticBuffer.create(size, null);
    }

    private final IOElasticBuffer setInCreateBackingBuffer() {
        this.flags = (byte)(this.flags | 4);
        return this;
    }

    private final boolean isInCreateBackingBuffer() {
        return (this.flags & 4) != 0;
    }

    private final IOElasticBuffer clearInCreateBackingBuffer() {
        this.flags = (byte)(this.flags & 0xFFFFFFFB);
        return this;
    }

    private final IOElasticBuffer setWrapped() {
        this.flags = (byte)(this.flags | 8);
        return this;
    }

    public final boolean isWrapped() {
        return (this.flags & 8) != 0;
    }

    private final IOElasticBuffer clearWrapped() {
        this.flags = (byte)(this.flags & 0xFFFFFFF7);
        return this;
    }

    private final boolean setBackingBuffer(IOBuffer val, int off) {
        boolean diffFromCurrent;
        boolean currentExists = this.iobuf != null;
        boolean bl = diffFromCurrent = this.iobuf != val;
        if (currentExists && diffFromCurrent) {
            if (this.isWrapped()) {
                this.iobuf.dispose();
            } else {
                this.iobuf.dispose(this.highwater);
            }
        }
        if (diffFromCurrent) {
            this.iobuf = val;
            this.iobufaddr = val == null ? 0L : this.iobuf.getNativeAddress();
        } else if (val != null) {
            val.dispose();
        }
        this.offset = off;
        return currentExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IOBuffer createBackingBuffer(int requestedLength) {
        if (this.isInCreateBackingBuffer()) {
            throw new IllegalStateException("backing buffer creation invoked recursively!");
        }
        this.setInCreateBackingBuffer();
        try {
            int allocLength = Math.max(requestedLength, this.size > 0 ? this.size : (this.size = this.sizer.getInitialBufferLength()));
            boolean replaceExisting = this.setBackingBuffer(IOBuffer.create(allocLength), 0);
            this.clearWrapped();
            if (!replaceExisting && this.initializer != null) {
                this.initializer.initializeBuffer();
            }
            IOBuffer iOBuffer = this.iobuf;
            return iOBuffer;
        }
        finally {
            this.clearInCreateBackingBuffer();
        }
    }

    private final boolean isResizeNeeded(int newLength) {
        return this.iobuf == null || newLength > this.length && newLength > this.iobuf.getLength();
    }

    private final long getBackingBufferAddrForRead() {
        this.ensureBackingBufferExists();
        return this.iobufaddr;
    }

    private final void copyBackingBuffer(int minLength) {
        IOBuffer iobuf = this.iobuf.acquire();
        int offset = this.offset;
        int length = this.length;
        int allocLength = Math.max(length, minLength);
        IOBuffer newBuffer = this.createBackingBuffer(allocLength);
        IOBuffer.copy(iobuf.getNativeAddress(), offset, newBuffer.getNativeAddress(), this.offset, length);
        iobuf.dispose();
        stats.onIOBufferForked(newBuffer.getCapacity());
    }

    private final long getBackingBufferAddrForWrite(int minLength) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("buffer is read only");
        }
        if (this.iobuf != null && this.isCopyOnWrite()) {
            this.copyBackingBuffer(minLength);
            this.clearCopyOnWrite();
        }
        this.setLength(Math.max(this.length, minLength));
        return this.iobufaddr;
    }

    private final InputStreamImpl is() {
        if (this.is == null) {
            this.is = new InputStreamImpl();
        }
        return this.is;
    }

    private final OutputStreamImpl os() {
        if (this.os == null) {
            this.os = new OutputStreamImpl();
        }
        return this.os;
    }

    public final IOElasticBuffer setInitializer(Initializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public final Initializer getInitializer() {
        return this.initializer;
    }

    public final void reset(boolean setSizeToHighwater) {
        if (this.iobuf != null) {
            if (setSizeToHighwater) {
                this.size = Math.max(this.size, this.highwater);
            }
            this.setBackingBuffer(null, 0);
        }
        this.length = 0;
        this.highwater = 0;
        this.flags = 0;
    }

    public final void reset() {
        this.reset(true);
    }

    public final boolean isResizeNeededFor(int index, int numBytes) {
        if (index < 0) {
            throw new IllegalArgumentException("index cannot be < 0");
        }
        if (numBytes < 0) {
            throw new IllegalArgumentException("numBytes cannot be < 0");
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("buffer is read only");
        }
        return this.isResizeNeeded(index + numBytes);
    }

    public final boolean hasBackingBuffer() {
        return this.iobuf != null;
    }

    public final IOBuffer getBackingBufferUnsafe() {
        return this.iobuf;
    }

    public final void wrapBackingBuffer(IOBuffer iobuf, int offset, int length) {
        if (iobuf == null) {
            throw new IllegalArgumentException("the IO buffer to set cannot be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("the IO buffer offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (offset + length > iobuf.getLength()) {
            throw new IllegalArgumentException("the buffer length + offset goes beyond backing buffer length");
        }
        this.setBackingBuffer(iobuf.acquire(), offset);
        this.highwater = this.length = length;
        this.setWrapped().setReadOnly();
    }

    public final void shareBackingBuffer(IOElasticBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("the buffer to share backing buffer with cannot be null");
        }
        if (buffer.iobuf == null) {
            throw new IllegalArgumentException("the backing buffer of the shared buffer is null");
        }
        this.setBackingBuffer(buffer.iobuf.acquire(), buffer.offset);
        this.highwater = buffer.getHighwater();
        this.length = buffer.getLength();
        if (buffer.isWrapped()) {
            this.setWrapped();
        }
        this.setCopyOnWrite();
        buffer.setCopyOnWrite();
        this.clearReadOnly();
        buffer.clearReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IOBuffer ensureBackingBufferExists() {
        if (this.iobuf == null) {
            IOElasticBuffer iOElasticBuffer = this;
            synchronized (iOElasticBuffer) {
                if (this.iobuf == null) {
                    this.createBackingBuffer(0);
                }
            }
        }
        return this.iobuf;
    }

    public final IOElasticBuffer setReadOnly() {
        this.flags = (byte)(this.flags | 2);
        return this;
    }

    public final IOElasticBuffer clearReadOnly() {
        if (this.isWrapped()) {
            throw new IllegalStateException("cannot set a wrapped buffer as writeable");
        }
        this.flags = (byte)(this.flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isReadOnly() {
        return (this.flags & 2) != 0;
    }

    public final IOElasticBuffer setCopyOnWrite() {
        this.flags = (byte)(this.flags | 1);
        return this;
    }

    public final IOElasticBuffer clearCopyOnWrite() {
        this.flags = (byte)(this.flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isCopyOnWrite() {
        return (this.flags & 1) != 0;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final IOElasticBuffer setLength(int newLength) {
        if (newLength < 0) {
            throw new IllegalArgumentException("length cannot be < 0");
        }
        if (this.iobuf == null) {
            this.createBackingBuffer(newLength);
        } else if (this.isResizeNeeded(newLength)) {
            if (this.isReadOnly()) {
                throw new IllegalStateException("buffer is read only");
            }
            if (this.isCopyOnWrite()) {
                this.copyBackingBuffer(newLength);
                this.clearCopyOnWrite();
            } else {
                this.iobuf = IOBuffer.ensureCapacity(this.iobuf, newLength, true);
                this.iobufaddr = this.iobuf.getNativeAddress();
            }
        }
        this.length = newLength;
        this.highwater = Math.max(this.length, this.highwater);
        return this;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getHighwater() {
        return this.highwater;
    }

    public final IOElasticBuffer put(int index, byte val) {
        return this.putByte(index, val);
    }

    public final IOElasticBuffer putByte(int index, byte val) {
        IOBuffer.putByte(this.getBackingBufferAddrForWrite(index + 1), this.offset + index, val);
        return this;
    }

    public final IOElasticBuffer putChar(int index, char val) {
        IOBuffer.putChar(this.getBackingBufferAddrForWrite(index + 2), this.offset + index, val);
        return this;
    }

    public final int putUTF8Char(int index, char val) {
        return IOBuffer.putUTF8Char(this.getBackingBufferAddrForWrite(index + IOBuffer.calculateUTF8Length(val) * 1), this.offset + index, val);
    }

    public final IOElasticBuffer putShort(int index, short val) {
        IOBuffer.putShort(this.getBackingBufferAddrForWrite(index + 2), this.offset + index, val);
        return this;
    }

    public final IOElasticBuffer putInt(int index, int val) {
        IOBuffer.putInt(this.getBackingBufferAddrForWrite(index + 4), this.offset + index, val);
        return this;
    }

    public final IOElasticBuffer putFloat(int index, float val) {
        IOBuffer.putFloat(this.getBackingBufferAddrForWrite(index + 4), this.offset + index, val);
        return this;
    }

    public final IOElasticBuffer putLong(int index, long val) {
        IOBuffer.putLong(this.getBackingBufferAddrForWrite(index + 8), this.offset + index, val);
        return this;
    }

    public final IOElasticBuffer putDouble(int index, double val) {
        IOBuffer.putDouble(this.getBackingBufferAddrForWrite(index + 8), this.offset + index, val);
        return this;
    }

    public final int putASCIICharSequence(int index, CharSequence val) {
        return IOBuffer.putASCIICharSequence(this.getBackingBufferAddrForWrite(index + val.length() * 1), this.offset + index, val);
    }

    public final int putUTF8CharSequence(int index, CharSequence val) {
        int utflen = IOBuffer.calculateUTF8Length(val);
        return IOBuffer.putUTF8CharSequence(this.getBackingBufferAddrForWrite(index + utflen * 1), this.offset + index, val, utflen, 0, val.length());
    }

    public final int putString(int index, String val) {
        return this.putUTF8CharSequence(index, val);
    }

    public final IOElasticBuffer putFrom(int index, byte[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 1), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, char[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 2), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, short[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 2), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, int[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 4), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, float[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 4), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, long[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 8), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, double[] array, int arrayOffset, int length) {
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length * 8), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, ByteBuffer buffer, int bufferOffset, int length) {
        if (this.iobuf != null && this.iobuf.getBufferUnsafe() == buffer) {
            return this;
        }
        IOBuffer.putFrom(this.getBackingBufferAddrForWrite(index + length), this.offset + index, buffer, bufferOffset, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, ByteBuffer buffer, int length) {
        return this.putFrom(index, buffer, buffer.position(), length);
    }

    public final IOElasticBuffer putFrom(int index, IOBuffer buffer, int bufferOffset, int length) {
        if (this.iobuf == buffer) {
            return this;
        }
        IOBuffer.copy(buffer.getNativeAddress(), bufferOffset, this.getBackingBufferAddrForWrite(index + length), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, IOElasticBuffer buffer, int bufferOffset, int length) {
        if (buffer == this) {
            return this;
        }
        long addr = this.getBackingBufferAddrForWrite(index + length);
        if (buffer.iobuf == null) {
            return this;
        }
        IOBuffer.copy(buffer.iobuf.getNativeAddress(), buffer.offset + bufferOffset, addr, this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFrom(int index, long addr, int addrOffset, int length) {
        if (this.iobufaddr == addr) {
            return this;
        }
        IOBuffer.copy(addr, addrOffset, this.getBackingBufferAddrForWrite(index + length), this.offset + index, length);
        return this;
    }

    public final IOElasticBuffer putFromNative(int index, long addr, int addrOffset, int length) {
        return this.putFrom(index, addr, addrOffset, length);
    }

    public final byte get(int index) {
        return this.getByte(index);
    }

    public final byte getByte(int index) {
        return IOBuffer.getByte(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final int getUnsignedByte(int index) {
        return IOBuffer.getUnsignedByte(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final char getChar(int index) {
        return IOBuffer.getChar(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final short getShort(int index) {
        return IOBuffer.getShort(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final int getUnsignedShort(int index) {
        return IOBuffer.getUnsignedShort(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final int getInt(int index) {
        return IOBuffer.getInt(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final long getUnsignedInt(int index) {
        return IOBuffer.getUnsignedInt(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final float getFloat(int index) {
        return IOBuffer.getFloat(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final long getLong(int index) {
        return IOBuffer.getLong(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final double getDouble(int index) {
        return IOBuffer.getDouble(this.getBackingBufferAddrForRead(), this.offset + index);
    }

    public final String getString(int index, int length) {
        return IOBuffer.getUTF8CharSequence(this.getBackingBufferAddrForRead(), this.offset + index, length);
    }

    public final IOElasticBuffer getTo(int index, byte[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, char[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, short[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, int[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, float[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, long[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, double[] array, int arrayOffset, int length) {
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, array, arrayOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, ByteBuffer buffer, int bufferOffset, int length) {
        if (this.iobuf != null && this.iobuf.getBufferUnsafe() == buffer) {
            return this;
        }
        IOBuffer.getTo(this.getBackingBufferAddrForRead(), this.offset + index, buffer, bufferOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, ByteBuffer buffer, int length) {
        return this.getTo(index, buffer, buffer.position(), length);
    }

    public final IOElasticBuffer getTo(int index, IOBuffer buffer, int bufferOffset, int length) {
        if (this.iobuf == buffer) {
            return this;
        }
        IOBuffer.copy(this.getBackingBufferAddrForRead(), this.offset + index, buffer.getNativeAddress(), bufferOffset, length);
        return this;
    }

    public final IOElasticBuffer getTo(int index, long addr, int addrOffset, int length) {
        if (this.iobufaddr == addr) {
            return this;
        }
        IOBuffer.copy(this.getBackingBufferAddrForRead(), this.offset + index, addr, addrOffset, length);
        return this;
    }

    public final IOElasticBuffer getToNative(int index, long addr, int addrOffset, int length) {
        return this.getTo(index, addr, addrOffset, length);
    }

    public final InputStream inputStream(int index) {
        return this.is().init(index);
    }

    public final OutputStream outputStream(int index) {
        return this.os().init(index);
    }

    public final void wipe(int index, int len) {
        IOBuffer.wipe(this.getBackingBufferAddrForWrite(index + len), this.offset + index, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String dump(String prefix, int index, int len) {
        IOBuffer iobuf = this.ensureBackingBufferExists();
        ByteBuffer bytebuf = iobuf.takeBuffer();
        try {
            String string = UtlBuffer.dump(prefix, bytebuf, this.offset + index, len);
            return string;
        }
        finally {
            iobuf.releaseBuffer();
        }
    }

    public final String toString() {
        return "[buf=" + this.iobuf + ", offset=" + this.offset + ", length=" + this.length + ", ro=" + this.isReadOnly() + ", cow=" + this.isCopyOnWrite() + "]";
    }

    public static interface Sizer {
        public int getInitialBufferLength();
    }

    public static interface Initializer {
        public void initializeBuffer();
    }

    private final class OutputStreamImpl
    extends OutputStream {
        private int pos;

        private OutputStreamImpl() {
        }

        final OutputStreamImpl init(int pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public final void write(int b) throws IOException {
            IOElasticBuffer.this.putByte(this.pos++, (byte)b);
        }

        @Override
        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            IOElasticBuffer.this.putFrom(this.pos, b, off, len);
            this.pos += len;
        }
    }

    private final class InputStreamImpl
    extends InputStream {
        private int pos;

        private InputStreamImpl() {
        }

        final InputStreamImpl init(int pos) {
            this.pos = pos;
            return this;
        }

        @Override
        public final int read() throws IOException {
            return this.pos < IOElasticBuffer.this.length ? 0xFF & IOElasticBuffer.this.getByte(this.pos++) : -1;
        }

        @Override
        public final int read(byte[] bytes, int off, int len) throws IOException {
            int remaining = IOElasticBuffer.this.length - this.pos;
            if (remaining > 0) {
                len = Math.min(len, remaining);
                IOElasticBuffer.this.getTo(this.pos, bytes, off, len);
                this.pos += len;
                return len;
            }
            return -1;
        }
    }
}

