/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageEncodingTypeDescriptor;
import com.neeve.sma.MessageReflector;
import com.neeve.sma.MessageSerializer;
import com.neeve.sma.SmaConfig;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MessageEncodingTypeRegistry
extends SmaObject {
    private static final OpenIntObjectHashMap encodingTypes;
    private static final MessageEncodingTypeRegistry instance;

    private static MessageSerializer loadSerializer(String className) throws Exception {
        if (className != null) {
            Class<?> serializerClass = null;
            try {
                serializerClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Serializer class [" + className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new Exception("Serializer class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method serializerCreateMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                serializerCreateMethod = serializerClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of SMA message encoding type serializer class [" + className + "]");
            }
            catch (SecurityException e) {
                throw new Exception("Access to instantiation method in serializer class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Instantiation method in serializer class [" + className + "] could not be found");
            }
            MessageSerializer serializer = null;
            try {
                try {
                    Object[] parameters = new Object[]{new Properties()};
                    serializer = (MessageSerializer)serializerCreateMethod.invoke(null, parameters);
                    if (serializer == null) {
                        throw new Exception("Instantiation method in serializer class [" + className + "] returned a null object");
                    }
                }
                catch (ClassCastException e) {
                    throw new Exception("Instantiation method in serializer class [" + className + "] returned object of incorrect type");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Access to instantiation method in serializer class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return serializer;
        }
        return null;
    }

    private static MessageReflector loadReflector(String className) throws Exception {
        if (className != null) {
            Class<?> reflectorClass = null;
            try {
                reflectorClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Reflector class [" + className + "] could not be found");
            }
            catch (UnsupportedClassVersionError e) {
                throw new Exception("Reflector class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
            }
            Method reflectorCreateMethod = null;
            try {
                Class[] parameterTypes = new Class[]{Class.forName("java.util.Properties")};
                reflectorCreateMethod = reflectorClass.getMethod("create", parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new InternalError("Failed to load java.util.Properties during instantiation of SMA message encoding type reflector class [" + className + "]");
            }
            catch (SecurityException e) {
                throw new Exception("Access to instantiation method in reflector class [" + className + "] is denied");
            }
            catch (NoSuchMethodException e) {
                throw new Exception("Instantiation method in reflector class [" + className + "] could not be found");
            }
            MessageReflector reflector = null;
            try {
                try {
                    Object[] parameters = new Object[]{new Properties()};
                    reflector = (MessageReflector)reflectorCreateMethod.invoke(null, parameters);
                    if (reflector == null) {
                        throw new Exception("Instantiation method in reflector class [" + className + "] returned a null object");
                    }
                }
                catch (ClassCastException e) {
                    throw new Exception("Instantiation method in reflector class [" + className + "] returned object of incorrect type");
                }
            }
            catch (IllegalAccessException e) {
                throw new Exception("Access to instantiation method in reflector class [" + className + "] is denied");
            }
            catch (InvocationTargetException e) {
                throw new Exception(e.getCause());
            }
            return reflector;
        }
        return null;
    }

    private MessageEncodingTypeRegistry() {
        super(null);
    }

    public static final MessageEncodingTypeRegistry getInstance() {
        return instance;
    }

    public final MessageSerializer getMessageSerializer(int encodingTypeId) {
        EncodingType encodingTypeContext = (EncodingType)encodingTypes.get(encodingTypeId);
        return encodingTypeContext == null ? null : encodingTypeContext.serializer;
    }

    public final MessageReflector getMessageReflector(int encodingTypeId) {
        EncodingType encodingTypeContext = (EncodingType)encodingTypes.get(encodingTypeId);
        return encodingTypeContext == null ? null : encodingTypeContext.reflector;
    }

    static {
        block6: {
            instance = new MessageEncodingTypeRegistry();
            Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)SmaConfig.getConfig());
            tracer.log("Loading SMA message encoding types...", Tracer.Level.VERBOSE);
            encodingTypes = new OpenIntObjectHashMap();
            try {
                Map<Integer, MessageEncodingTypeDescriptor> encodingTypeDescriptors = MessageEncodingTypeDescriptor.loadAll();
                if (encodingTypeDescriptors.size() > 0) {
                    Set<Map.Entry<Integer, MessageEncodingTypeDescriptor>> encodingTypeEntries = encodingTypeDescriptors.entrySet();
                    for (Map.Entry<Integer, MessageEncodingTypeDescriptor> entry : encodingTypeEntries) {
                        MessageEncodingTypeDescriptor descriptor = entry.getValue();
                        String s = "..." + descriptor.getName();
                        try {
                            encodingTypes.put(descriptor.getId(), (Object)new EncodingType(descriptor.getId(), MessageEncodingTypeRegistry.loadSerializer(descriptor.getSerializerClassName()), MessageEncodingTypeRegistry.loadReflector(descriptor.getReflectorClassName())));
                            s = s + " - success";
                        }
                        catch (Exception e) {
                            s = s + " - failed [" + e.toString() + "]";
                        }
                        tracer.log(s, Tracer.Level.VERBOSE);
                    }
                    break block6;
                }
                tracer.log("...<No configured encoding types>", Tracer.Level.VERBOSE);
            }
            catch (SmaException e) {
                tracer.log("Failure encountered while loading SMA message encoding types [" + e.toString() + "]", Tracer.Level.SEVERE);
            }
        }
    }

    private static final class EncodingType {
        final MessageSerializer serializer;
        final MessageReflector reflector;

        EncodingType(int id, MessageSerializer serializer, MessageReflector reflector) {
            this.serializer = serializer;
            this.reflector = reflector;
        }
    }
}

