/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmArray;
import com.neeve.adm.AdmDeprecation;
import com.neeve.adm.AdmDocumentation;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFixedLengthPrimitive;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelElement;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmPooledString;
import com.neeve.adm.AdmPrimitive;
import com.neeve.adm.AdmSemanticType;
import com.neeve.adm.AdmString;
import com.neeve.adm.AdmType;
import java.util.LinkedList;

public final class AdmField
extends AdmModelElement
implements Comparable<AdmField> {
    private final String name;
    private final AdmType type;
    private final AdmModel model;
    private AdmModel originModel;
    private LinkedList<AdmModelImport> importPath;
    private short id;
    private String jsonName;
    private int length;
    private boolean isKey;
    private boolean isUsedAsKey;
    private boolean isReflected;
    private boolean isPinned;
    private boolean required;
    private int index;
    private AdmDocumentation documentation;
    private AdmDeprecation deprecation;
    private AdmSemanticType semanticType;

    public AdmField(AdmModel model, String name, short id, AdmType type) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (id <= 0) {
            throw new IllegalArgumentException("field id must be > 0");
        }
        if (type == null) {
            throw new IllegalArgumentException("field type cannot be null");
        }
        this.model = model;
        this.originModel = model;
        this.name = name;
        this.type = type;
        this.id = id;
        this.jsonName = name;
    }

    public AdmField(AdmModel model, AdmModel originModel, LinkedList<AdmModelImport> importPath, String name, short id, AdmType type) {
        this(model, name, id, type);
        if (originModel == null) {
            throw new IllegalArgumentException("'originModel' cannot be null");
        }
        this.originModel = originModel;
        this.importPath = importPath;
    }

    public final void setIndex(int val) {
        this.index = val;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getName() {
        return this.name;
    }

    public final void setId(short val) {
        this.id = val;
    }

    public final short getId() {
        return this.id;
    }

    public final AdmType getType() {
        return this.type;
    }

    public final String getQualifiedSemanticTypeName(AdmModel model) {
        if (this.semanticType != null) {
            return this.semanticType.getQualifiedName(model);
        }
        return this.type.getQualifiedName(model);
    }

    public final AdmField setJsonName(String val) {
        this.jsonName = val != null ? val : this.name;
        return this;
    }

    public final String getJsonName() {
        return this.jsonName;
    }

    public final AdmField setLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("field length must be > 0");
        }
        if (this.type instanceof AdmString || this.type instanceof AdmPooledString) {
            this.length = length;
            return this;
        }
        throw new IllegalStateException("length can only be set on string fields");
    }

    public final int getLength() {
        if (this.length > 0) {
            return this.length;
        }
        if (this.semanticType != null) {
            return this.semanticType.getLength();
        }
        return this.length;
    }

    public final void setAsKey() {
        if (this.type instanceof AdmEntity && ((AdmEntity)this.type).isEmbedded()) {
            throw new IllegalStateException("an embedded entity type cannot serve as a collection key");
        }
        this.isKey = true;
    }

    public final boolean isKey() {
        return this.isKey;
    }

    public final void setUsedAsKey() {
        this.isUsedAsKey = true;
    }

    public final boolean isUsedAsKey() {
        return this.isUsedAsKey || this.isKey;
    }

    public final void setAsReflected() {
        this.isReflected = true;
    }

    public final boolean isReflected() {
        return this.isReflected;
    }

    public final void setAsPinned() {
        if (!this.isFixedLength()) {
            throw new IllegalStateException("cannot pin variable length field '" + this.getName() + "'");
        }
        this.isPinned = true;
    }

    public final boolean isPinned() {
        return this.isPinned;
    }

    public final boolean isFixedLength() {
        return this.type instanceof AdmFixedLengthPrimitive || this.type instanceof AdmEnumeration || this.type instanceof AdmString && this.length > 0;
    }

    public final int getSerializedLength() {
        if (this.isFixedLength()) {
            if (this.type instanceof AdmFixedLengthPrimitive) {
                return ((AdmPrimitive)this.type).getType().getSerializedLength();
            }
            if (this.type instanceof AdmEnumeration) {
                return AdmPrimitive.Type.Integer.getSerializedLength();
            }
            if (this.type instanceof AdmString) {
                return this.length;
            }
            throw new IllegalStateException("unknown fixed length type '" + ((Object)((Object)this.type)).getClass().getName() + "'");
        }
        return 0;
    }

    public final boolean isReflectable() {
        return this.isEmbedded() && !(this.type instanceof AdmArray);
    }

    public final boolean isIndexable() {
        return this.isEmbedded() && !(this.type instanceof AdmArray);
    }

    public final boolean isEmbeddedEntity() {
        return this.type instanceof AdmEntity && ((AdmEntity)this.type).isEmbedded();
    }

    public final boolean isEmbedded() {
        return this.type instanceof AdmPrimitive || this.type instanceof AdmEnumeration || this.type instanceof AdmArray || this.isEmbeddedEntity();
    }

    public final boolean isRequired() {
        return this.required;
    }

    public final void setRequired(boolean required) {
        this.required = required;
    }

    public final void setDocumentation(AdmDocumentation doc) {
        this.documentation = doc;
    }

    public final AdmDocumentation getDocumentation() {
        return this.documentation;
    }

    public final AdmDeprecation getDeprecation() {
        return this.deprecation == null ? this.type.getDeprecation() : this.deprecation;
    }

    public final void setDeprecation(AdmDeprecation deprecation) {
        this.deprecation = deprecation;
    }

    public final AdmSemanticType getSemanticType() {
        return this.semanticType;
    }

    public final void setSemanticType(AdmSemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public final boolean isDeprecated() {
        return this.deprecation != null || this.type.isDeprecated();
    }

    public final AdmModel getModel() {
        return this.model;
    }

    public final AdmField copy() {
        AdmField fieldCopy = new AdmField(this.getModel(), this.getOriginModel(), this.getImportPath(), this.getName(), 1, this.getType());
        fieldCopy.setId(this.getId());
        fieldCopy.setDocumentation(this.getDocumentation());
        fieldCopy.setSemanticType(this.getSemanticType());
        fieldCopy.setDeprecation(this.getDeprecation());
        if (this.getLength() > 0) {
            fieldCopy.setLength(this.getLength());
        }
        fieldCopy.setJsonName(this.getJsonName());
        fieldCopy.setRequired(this.isRequired());
        if (this.isPinned()) {
            fieldCopy.setAsPinned();
        }
        return fieldCopy;
    }

    public final String getNamespace() {
        return this.model == null ? null : this.model.getNamespace();
    }

    public final String getQualifiedName() {
        if (this.getNamespace() == null) {
            return this.getName();
        }
        return this.getNamespace() + "." + this.getName();
    }

    public final AdmModel getOriginModel() {
        return this.originModel;
    }

    public final boolean isImported() {
        return this.model != this.originModel;
    }

    public final LinkedList<AdmModelImport> getImportPath() {
        return this.importPath;
    }

    public final String toString() {
        return "AdmField [" + this.getNamespace() + "." + this.getName() + ", id: " + this.getId() + ", type: " + this.type.getFullName() + (this.semanticType != null ? "(Semantic Type: " + this.semanticType.getQualifiedName(this.model) + ")" : "") + ", embedded: " + this.isEmbedded() + ", length: " + this.getLength() + ", pinned=" + this.isPinned() + ", key=" + this.isKey() + "]";
    }

    public final int hashCode() {
        int hash = ((Object)((Object)this.type)).hashCode();
        hash = hash * 17 + this.getQualifiedName().hashCode();
        return hash;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof AdmField)) {
            return false;
        }
        return this.equals((AdmField)other);
    }

    public final boolean equals(AdmField other) {
        if (!this.getQualifiedName().equals(other.getQualifiedName())) {
            return false;
        }
        return this.type.getFullName().equals(other.type.getFullName());
    }

    @Override
    public final int compareTo(AdmField o) {
        if (o == this) {
            return 0;
        }
        int c = this.getQualifiedName().compareTo(o.getQualifiedName());
        if (c == 0) {
            c = this.type.getFullName().compareTo(o.type.getFullName());
        }
        return c;
    }
}

