/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.config.Config;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IONativePacket;
import com.neeve.messages.BytesMessage;
import com.neeve.messages.TextMessage;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import java.nio.ByteBuffer;
import java.util.Properties;

@AdmGenerated(encoding="quark", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 590)", date="6/30/25 9:22 PM", buildInfo="${build.version.string}")
public final class MessageFactory
implements IStoreObjectFactory,
MessageViewFactory {
    public static final short OFID = 39;
    public static final short VFID = 39;
    public static final short TFID = 0;
    public static final short ID_BytesMessage = 1;
    public static final short ID_TextMessage = 2;
    static final ObjectMapper mapper = new ObjectMapper();
    private static final ThreadLocal<BytesMessage.BytesMessagePoolFactoryItemCreateArgument> _bytesMessagePoolGetArgument;
    private static final ThreadLocal<TextMessage.TextMessagePoolFactoryItemCreateArgument> _textMessagePoolGetArgument;

    public static final MessageFactory create(Properties props) {
        return new MessageFactory();
    }

    public static final BytesMessage createBytesMessage(UUID id) {
        BytesMessage.BytesMessagePoolFactoryItemCreateArgument arg = _bytesMessagePoolGetArgument.get();
        BytesMessage val = (BytesMessage)BytesMessage._entityPool.get((Object)arg.init(id));
        if (!arg.wasCreated) {
            val.undispose(id);
        }
        return val;
    }

    public static final BytesMessage createBytesMessage() {
        return MessageFactory.createBytesMessage(null);
    }

    public static final BytesMessage createBytesMessageFromJson(String json) {
        return MessageFactory.createBytesMessage().deserializeFromJson(json);
    }

    public static final BytesMessage createBytesMessageFromRawJson(String json) {
        return MessageFactory.createBytesMessage().deserializeFromRawJson(json);
    }

    public static final TextMessage createTextMessage(UUID id) {
        TextMessage.TextMessagePoolFactoryItemCreateArgument arg = _textMessagePoolGetArgument.get();
        TextMessage val = (TextMessage)TextMessage._entityPool.get((Object)arg.init(id));
        if (!arg.wasCreated) {
            val.undispose(id);
        }
        return val;
    }

    public static final TextMessage createTextMessage() {
        return MessageFactory.createTextMessage(null);
    }

    public static final TextMessage createTextMessageFromJson(String json) {
        return MessageFactory.createTextMessage().deserializeFromJson(json);
    }

    public static final TextMessage createTextMessageFromRawJson(String json) {
        return MessageFactory.createTextMessage().deserializeFromRawJson(json);
    }

    public final short getOfid() {
        return 39;
    }

    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        try {
            switch (encodingType) {
                case Quark: {
                    switch (type) {
                        case 1: {
                            return MessageFactory.createBytesMessage(id).deserialize(packet);
                        }
                        case 2: {
                            return MessageFactory.createTextMessage(id).deserialize(packet);
                        }
                    }
                    throw new RuntimeException("unknown object type: " + type);
                }
            }
            throw new RuntimeException("unknown encoding type: " + encodingType);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final short getVfid() {
        return 39;
    }

    public final MessageView create(short type) {
        try {
            switch (type) {
                case 1: {
                    return MessageFactory.createBytesMessage();
                }
                case 2: {
                    return MessageFactory.createTextMessage();
                }
            }
            throw new RuntimeException("unknown messsage type: " + type);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        try {
            switch (encodingType) {
                case 6: {
                    if (message instanceof IONativePacket) {
                        switch (type) {
                            case 1: {
                                return MessageFactory.createBytesMessage(null).deserializeFrom(((IONativePacket)message).addr, ((IONativePacket)message).offset, ((IONativePacket)message).length);
                            }
                            case 2: {
                                return MessageFactory.createTextMessage(null).deserializeFrom(((IONativePacket)message).addr, ((IONativePacket)message).offset, ((IONativePacket)message).length);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof IOBufferPacket) {
                        switch (type) {
                            case 1: {
                                return MessageFactory.createBytesMessage(null).deserializeFrom(((IOBufferPacket)message).buf, ((IOBufferPacket)message).offset, ((IOBufferPacket)message).length);
                            }
                            case 2: {
                                return MessageFactory.createTextMessage(null).deserializeFrom(((IOBufferPacket)message).buf, ((IOBufferPacket)message).offset, ((IOBufferPacket)message).length);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof PktPacket) {
                        switch (type) {
                            case 1: {
                                return MessageFactory.createBytesMessage(null).deserializeFrom((PktPacket)message);
                            }
                            case 2: {
                                return MessageFactory.createTextMessage(null).deserializeFrom((PktPacket)message);
                            }
                        }
                        throw new RuntimeException("unknown message type: " + type);
                    }
                    if (message instanceof byte[]) {
                        switch (type) {
                            case 1: {
                                return MessageFactory.createBytesMessage(null).deserializeFrom((byte[])message, 0, ((byte[])message).length);
                            }
                            case 2: {
                                return MessageFactory.createTextMessage(null).deserializeFrom((byte[])message, 0, ((byte[])message).length);
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    if (message instanceof ByteBuffer) {
                        switch (type) {
                            case 1: {
                                return MessageFactory.createBytesMessage(null).deserializeFrom((ByteBuffer)message);
                            }
                            case 2: {
                                return MessageFactory.createTextMessage(null).deserializeFrom((ByteBuffer)message);
                            }
                        }
                        throw new RuntimeException("unknown object type: " + type);
                    }
                    throw new RuntimeException("unsupported serialized form '" + message.getClass().getName() + "' for XBUF encoded message");
                }
            }
            throw new RuntimeException("unknown encoding type: " + encodingType);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, Config.getValue((String)"nv.indent.json", (boolean)false));
        _bytesMessagePoolGetArgument = new ThreadLocal<BytesMessage.BytesMessagePoolFactoryItemCreateArgument>(){

            @Override
            protected final BytesMessage.BytesMessagePoolFactoryItemCreateArgument initialValue() {
                return new BytesMessage.BytesMessagePoolFactoryItemCreateArgument();
            }
        };
        _textMessagePoolGetArgument = new ThreadLocal<TextMessage.TextMessagePoolFactoryItemCreateArgument>(){

            @Override
            protected final TextMessage.TextMessagePoolFactoryItemCreateArgument initialValue() {
                return new TextMessage.TextMessagePoolFactoryItemCreateArgument();
            }
        };
    }
}

