/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.eaio.uuid.UUID;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventSource;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIterator;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreReader;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsExpectationNotMetException;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.impl.StorePacketPersisterBase;
import com.neeve.ods.impl.StorePersisterCompactionErrorEvent;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.EPktLogExpectationNotMetException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.IRogChangeDataCaptureHandler;
import com.neeve.rog.RogConfig;
import com.neeve.rog.log.RogLogCdcProcessor;
import com.neeve.rog.log.RogLogCompactor;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.rog.log.RogLogQueryRepository;
import com.neeve.rog.log.RogLogQueryRepositoryImpl;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.RogLogStats;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class RogLog
extends StorePacketPersisterBase
implements IStorePersister,
IEventSource {
    public static final String PROP_STORE_ROOT = "storeRoot";
    public static final String PROP_LOG_MODE = "logMode";
    public static final String PROP_SHARED = "shared";
    public static final String PROP_LOG_PRESENCE_EXPECTATION = "presenceExpectation";
    public static final String PROP_LOG_PRESENCE_EXPECTATION_DEFAULT = null;
    public static final String PROP_LOG_EMPTINESS_EXPECTATION = "emptinessExpectation";
    public static final String PROP_LOG_EMPTINESS_EXPECTATION_DEFAULT = null;
    public static final String PROP_INTEGRITY_CHECK = "integrityCheck";
    public static final boolean PROP_INTEGRITY_CHECK_DEFAULT = true;
    public static final String PROP_TRANSACTIONAL_INTEGRITY_CHECK = "txnIntegrityCheck";
    public static final boolean PROP_TRANSACTIONAL_INTEGRITY_CHECK_DEFAULT = true;
    public static final String PROP_AUTO_REPAIR = "autoRepair";
    public static final boolean PROP_AUTO_REPAIR_DEFAULT = false;
    public static final String PROP_INITIAL_LOG_LENGTH = "initialLogLength";
    public static final float PROP_INITIAL_LOG_LENGTH_DEFAULT = 1.0f;
    public static final String PROP_ZERO_OUT_INITIAL = "zeroOutInitial";
    public static final boolean PROP_ZERO_OUT_INITIAL_DEFAULT = false;
    public static final String PROP_LOG_BACKUP_RETENTION_COUNT = "logBackupRetentionCount";
    public static final int PROP_LOG_BACKUP_RETENTION_COUNT_DEFAULT = 1;
    public static final String PROP_LOG_SCAVENGE_POLICY = "logScavengePolicy";
    public static final String PROP_LOG_SCAVENGE_POLICY_DEFAULT = String.valueOf((Object)LogScavengePolicy.Delete);
    public static final String PROP_CDC_ENABLED = "cdcEnabled";
    public static final boolean PROP_CDC_ENABLED_DEFAULT = false;
    public static final String PROP_FLUSH_USING_MAPPED_MEMORY = "flushUsingMappedMemory";
    public static final boolean PROP_FLUSH_USING_MAPPED_MEMORY_DEFAULT = false;
    public static final String PROP_READ_BUFFER_SIZE = "readBufferSize";
    public static final String PROP_READ_BUFFER_SIZE_DEFAULT = "8k";
    public static final String PROP_WRITE_BUFFER_SIZE = "writeBufferSize";
    public static final String PROP_WRITE_BUFFER_SIZE_DEFAULT = "8k";
    @Deprecated
    public static final String PROP_AUTO_FLUSH_SIZE = "autoFlushSize";
    public static final String PROP_PAGE_SIZE = "pageSize";
    public static final String PROP_PAGE_SIZE_DEFAULT = "8k";
    public static final String PROP_FLUSH_ON_COMMIT = "flushOnCommit";
    public static final String PROP_DETACHED = "detachedPersist";
    public static final String PROP_DETACHED_QUEUE_DEPTH = "queueDepth";
    public static final String PROP_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROP_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK = "queueDrainerCpuAffinityMask";
    private static final AtomicInteger counter = new AtomicInteger();
    private final StorePersisterDescriptor descriptor;
    private final Properties props;
    private final StoreReader storeReader;
    private final RogLogCompactor.Params compactorParams;
    private final RogLogCdcProcessor.Params cdcParams;
    private final boolean autoRepair;
    private final File root;
    private final RogLogMetadata metadata;
    private final RogLogStats stats;
    private final RogLogCompactor compactor;
    private final ReentrantLock compactionSynchronizer;
    private final LogScavengePolicy logScavengePolicy;
    private final int logBackupRetentionCount;
    private final boolean flushUsingMappedMemory;
    private String name;
    private boolean messageLog;
    private boolean compactionScheduled;
    private IStorePersister.LogEmptinessExpectation logEmptinessStartupExpectation;
    private IStorePersister.LogPresenceExpectation logPresenceStartupExpectation;
    private PktRecoveryLog log;
    private static boolean failOpen;
    private volatile IStorePersister.ErrorHandler errorHandler;
    private volatile IEventHandler eventHandler;
    private Exception failure;
    private boolean closed;

    private RogLog(String name, StorePersisterDescriptor descriptor, Properties props) {
        super(RogConfig.getConfig(), "Log-" + name + "-" + counter.incrementAndGet(), props);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Creating store persister '" + name + "...", Tracer.Level.DEBUG);
        }
        this.name = name;
        this.descriptor = descriptor;
        this.props = props;
        this.root = new File(UtlProps.getValue((Properties)props, (String)PROP_STORE_ROOT, (String)Config.getDataDirectory((boolean)false)));
        this.autoRepair = UtlProps.getValue((Properties)props, (String)PROP_AUTO_REPAIR, (boolean)false);
        this.storeReader = new StoreReader();
        this.metadata = new RogLogMetadata(this.root, this.name);
        this.logScavengePolicy = LogScavengePolicy.valueOf(UtlProps.getValue((Properties)props, (String)PROP_LOG_SCAVENGE_POLICY, (String)String.valueOf((Object)LogScavengePolicy.Delete)));
        this.logBackupRetentionCount = UtlProps.getValue((Properties)props, (String)PROP_LOG_BACKUP_RETENTION_COUNT, (int)1);
        this.compactorParams = RogLogCompactor.Params.create(props);
        this.compactor = new RogLogCompactor(this, this.compactorParams);
        this.compactionSynchronizer = new ReentrantLock(true);
        this.cdcParams = RogLogCdcProcessor.Params.create(props);
        this.flushUsingMappedMemory = UtlProps.getValue((Properties)props, (String)PROP_FLUSH_USING_MAPPED_MEMORY, (boolean)Config.getValue((String)"nv.rog.log.flushusingmappedmem", (boolean)false));
        this.stats = new RogLogStats(this, name, "nv.rog.log." + name + ".stats.interval");
        super.setStats(this.stats);
    }

    private RogLog(String name, StorePersisterDescriptor descriptor) {
        this(name, descriptor, descriptor.getProperties());
    }

    public static final RogLog create(String name, Properties props) throws OdsException {
        return new RogLog(name, null, props == null ? new Properties() : (Properties)props.clone());
    }

    public static final RogLog create(String name) throws OdsException {
        return RogLog.create(name, (Properties)null);
    }

    public static final RogLog create(String name, StorePersisterDescriptor descriptor) throws OdsException {
        return new RogLog(name, descriptor);
    }

    public static final void failOpen(boolean val) {
        failOpen = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String backupLog(String logName, Properties props, boolean shrinkToSize) throws Exception {
        try (RogLog log = RogLog.create(logName, props);){
            String string = log.backupLog(shrinkToSize);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeFactories() {
        HashSet<String> factories = new HashSet<String>();
        if (this.messageLog) {
            MessageViewFactoryRegistry.getInstance().getMessageViewFactoryNames(factories);
        } else {
            StoreObjectFactoryRegistry.getInstance().getStoreObjectFactoryNames(factories);
        }
        File file = new File(this.root.getAbsolutePath() + File.separator + this.factoriesFilename());
        if (!file.exists()) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "Writing factories...", Tracer.Level.DEBUG);
            }
            try (PrintWriter writer = new PrintWriter(file);){
                for (String factory : factories) {
                    writer.println(factory);
                }
            }
            catch (IOException e) {
                this.tracer.log(this.tracePrefix() + "Failed to create the factories file [" + e.toString() + "]", Tracer.Level.INFO);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Not writing factories (Factories file already exists).", Tracer.Level.DEBUG);
        }
    }

    private final void renameTo(String newName) throws IOException {
        boolean factoriesRenamed;
        boolean metadataRenamed;
        boolean logRenamed;
        block9: {
            File logFile = new File(this.root, this.logFilename());
            File newLogFile = new File(this.root, this.logFilename(newName));
            if (newLogFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", file already exists");
            }
            File newMetadataFile = new File(this.root, this.metadataFilename(newName));
            if (newMetadataFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", metadata file already exists");
            }
            File factoriesFile = new File(this.root, this.factoriesFilename());
            File newFactoriesFile = new File(this.root, this.factoriesFilename(newName));
            if (newFactoriesFile.exists()) {
                throw new IOException("Can't rename " + this.getName() + " to " + newName + ", factories file already exists");
            }
            logRenamed = false;
            metadataRenamed = false;
            factoriesRenamed = false;
            try {
                logRenamed = logFile.renameTo(newLogFile);
                if (!logRenamed) {
                    throw new IOException("Couldn't rename " + logFile + " to " + newLogFile);
                }
                this.metadata.renameTo(newName);
                metadataRenamed = true;
                factoriesRenamed = factoriesFile.exists() ? factoriesFile.renameTo(newFactoriesFile) : true;
            }
            catch (IOException ioe) {
                if (logRenamed) {
                    newLogFile.renameTo(logFile);
                }
                if (metadataRenamed) {
                    this.metadata.renameTo(this.name);
                }
                if (!factoriesRenamed || !newFactoriesFile.exists()) break block9;
                newFactoriesFile.renameTo(factoriesFile);
            }
        }
        if (!(factoriesRenamed && logRenamed && metadataRenamed)) {
            throw new IOException("Failed to rename log " + this.name + " to" + newName);
        }
        this.name = newName;
    }

    private final String indexFilename(String name, int number) {
        return name + (number == 0 ? "" : String.valueOf(number)) + ".index";
    }

    private final String indexFilename(String name) {
        return this.indexFilename(name, this.getLiveLogNumber());
    }

    private final String indexFilename(int number) {
        return this.indexFilename(this.getName(), number);
    }

    private final String indexFilename() {
        return this.indexFilename(this.getLiveLogNumber());
    }

    private final String indexPFilename(String name, int number) {
        return name + (number == 0 ? "" : String.valueOf(number)) + ".index.p";
    }

    private final String indexPFilename(String name) {
        return this.indexPFilename(name, this.getLiveLogNumber());
    }

    private final String indexPFilename(int number) {
        return this.indexPFilename(this.getName(), number);
    }

    private final String indexPFilename() {
        return this.indexPFilename(this.getLiveLogNumber());
    }

    private final String metadataFilename(String name) {
        return name + ".metadata";
    }

    private final String metadataFilename() {
        return this.metadataFilename(this.getName());
    }

    private final String factoriesFilename(String name) {
        return name + ".factories";
    }

    private final String factoriesFilename() {
        return this.factoriesFilename(this.getName());
    }

    private final PktRecoveryLog openPacketRecoveryLogForRead(int logNumber, int flags) {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        PktRecoveryLog packetLog = PktRecoveryLog.create((String)this.log.getDirname(), (String)this.logFilename(logNumber)).setOpenMode(PktRecoveryLog.FileOpenMode.r).setInitialLength(0L).setZeroOutInitial(false).setPageSize(this.log.getPageSize()).setReadBufferSize(this.log.getReadBufferSize()).setWriteBufferSize(this.log.getWriteBufferSize());
        if (this.log.supportsTailing()) {
            flags |= 0x80;
        }
        if (logNumber == this.getLiveLogNumber()) {
            flags |= 0x100;
        }
        packetLog.open(flags, -1L);
        return packetLog;
    }

    private final boolean isCommitEnd(PktPacket packet) {
        return packet.getHeader().getODSSubheader().getFlagCommitEnd();
    }

    final RogLog setAsMessageLog() {
        this.messageLog = true;
        return this;
    }

    final String logFilename(String name, int number) {
        return name + (number == 0 ? "" : "." + String.valueOf(number)) + ".log";
    }

    final String logFilename(String name) {
        return this.logFilename(name, this.getLiveLogNumber());
    }

    final String logFilename(int number) {
        return this.logFilename(this.getName(), number);
    }

    final String logFilename() {
        return this.logFilename(this.getLiveLogNumber());
    }

    static final void checkAndCreateStoreRoot(File root) throws Exception {
        if (root.exists() && !root.isDirectory()) {
            throw new Exception("root directory ('" + root.getAbsolutePath() + "') is a file");
        }
        if (!root.exists()) {
            root.mkdirs();
            if (!root.exists()) {
                throw new Exception("Failed to create store root directory");
            }
        }
    }

    final void setPacketLog(PktRecoveryLog log) {
        if (this.log != null && this.log != log) {
            this.log.close();
        }
        this.log = log;
    }

    final ReentrantLock getCompactionSynchronizer() {
        return this.compactionSynchronizer;
    }

    final IStoreBinding.Role getRole() {
        return this.role;
    }

    final int skipCdcOverMissing() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("log needs to be open to set next CDC log number");
        }
        this.tracer.log(this.tracePrefix() + "Setting next CDC log number....", Tracer.Level.INFO);
        int cdcLogNumber = this.metadata.getCdcLogNumber();
        if (cdcLogNumber >= 0) {
            int liveLogNumber = this.metadata.getLiveLogNumber();
            for (int i = cdcLogNumber; i <= liveLogNumber; ++i) {
                File file = new File(this.root, this.logFilename(i));
                if (file.exists()) {
                    this.tracer.log(this.tracePrefix() + "... #" + i + " exists. setting as next CDC log number", Tracer.Level.INFO);
                    if (i != cdcLogNumber) {
                        this.metadata.setCdcLogNumber(i);
                        this.metadata.setCdcCursor(0L);
                    }
                    break;
                }
                this.tracer.log(this.tracePrefix() + "... #" + i + " does not exist. skipping....", Tracer.Level.INFO);
            }
        } else {
            this.tracer.log(this.tracePrefix() + "... <CDC is not enabled>", Tracer.Level.INFO);
        }
        this.scavenge();
        return this.metadata.getCdcLogNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scavenge() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("log needs to be open for scavenging");
        }
        int cdcLogNumber = this.metadata.getCdcLogNumber();
        int liveLogNumber = this.metadata.getLiveLogNumber();
        this.tracer.log(this.tracePrefix() + "Scavenging old log files....", Tracer.Level.INFO);
        int successCount = 0;
        int failCount = 0;
        block9: for (int i = 0; i < (cdcLogNumber >= 0 ? cdcLogNumber : liveLogNumber); ++i) {
            File file = new File(this.root, this.logFilename(i));
            if (!file.exists()) continue;
            switch (this.logScavengePolicy) {
                case Delete: {
                    this.tracer.log(this.tracePrefix() + "...truncating and deleting '" + file.getName() + "'...", Tracer.Level.INFO);
                    try {
                        try (RandomAccessFile truncate = new RandomAccessFile(file, "rw");){
                            truncate.setLength(0L);
                        }
                        if (file.delete()) {
                            ++successCount;
                            continue block9;
                        }
                        ++failCount;
                        this.tracer.log(this.tracePrefix() + "......unable to delete '" + file.getName() + "'", Tracer.Level.WARNING);
                    }
                    catch (IOException ioe) {
                        String message = this.tracePrefix() + "......unable to delete '" + file.getName() + "' [" + ioe.getMessage() + "]";
                        this.tracer.log(message, Tracer.Level.WARNING);
                        OdsException e = new OdsException(message);
                        e.initCause(ioe);
                        this.dispatchEvent((Event)StorePersisterCompactionErrorEvent.create(null, this, e));
                    }
                    continue block9;
                }
                case Disabled: {
                    this.tracer.log(this.tracePrefix() + "...skipping delete of '" + file.getName() + "' because log scavenge is Disabled...", Tracer.Level.INFO);
                    continue block9;
                }
                default: {
                    throw new InternalError("unknown scavenge policy '" + (Object)((Object)this.logScavengePolicy) + "'");
                }
            }
        }
        this.tracer.log(this.tracePrefix() + "....scavenged " + successCount + " files (" + failCount + " failed).", Tracer.Level.INFO);
    }

    final long getNextWritePointer() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Log is not open");
        }
        return this.log.getNextWritePointer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int getLiveLogNumber() {
        int n;
        if (this.metadata.isOpen()) return this.metadata.getLiveLogNumber();
        if (!new File(this.root, this.metadataFilename(this.name)).exists()) return 0;
        this.metadata.open();
        try {
            n = this.metadata.getLiveLogNumber();
        }
        catch (Throwable throwable) {
            try {
                this.metadata.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.metadata.close();
        return n;
    }

    final void dispatchEvent(Event event) {
        IEventHandler handler = this.eventHandler;
        if (handler != null) {
            try {
                handler.onEvent(event);
            }
            catch (Throwable thrown) {
                this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        } else {
            event.dispose();
        }
    }

    final String backupLog(int logNumber, boolean shrinkToSize) throws Exception {
        this.tracer.log(this.tracePrefix() + "Backing up transaction log (#" + logNumber + " ,shrinkToSize=" + shrinkToSize + ")...", Tracer.Level.INFO);
        String backupFilename = PktRecoveryLog.backup((String)this.root.getAbsolutePath(), (String)this.logFilename(logNumber), (boolean)true, (boolean)shrinkToSize, (boolean)false, (int)this.logBackupRetentionCount);
        if (backupFilename == null) {
            this.tracer.log(this.tracePrefix() + "...no log to back up.", Tracer.Level.INFO);
        } else {
            this.tracer.log(this.tracePrefix() + "...backed up log to '" + backupFilename + "'.", Tracer.Level.INFO);
        }
        return backupFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PktRecoveryLog.Reader createPacketReader(int logNumber, int flags) throws IOException {
        try (PktRecoveryLog packetLog = this.openPacketRecoveryLogForRead(logNumber, flags);){
            PktRecoveryLog.Reader reader = packetLog.createReader().reset();
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PktRecoveryLog.MemoryMappedReader createMemoryMappedPacketReader(int logNumber, PktRecoveryLog.IPacketBufferReceiver receiver, int flags) throws IOException {
        try (PktRecoveryLog packetLog = this.openPacketRecoveryLogForRead(logNumber, flags);){
            PktRecoveryLog.MemoryMappedReader memoryMappedReader = packetLog.createMemoryMappedReader(receiver).reset();
            return memoryMappedReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PktRecoveryLog.MemoryMappedReader createMemoryMappedPacketReader(int logNumber, PktRecoveryLog.IPacketReceiver receiver, int flags) throws IOException {
        try (PktRecoveryLog packetLog = this.openPacketRecoveryLogForRead(logNumber, flags);){
            PktRecoveryLog.MemoryMappedReader memoryMappedReader = packetLog.createMemoryMappedReader(receiver).reset();
            return memoryMappedReader;
        }
    }

    @Override
    protected final void doChangeRole(IStoreBinding.Role role) {
        super.doChangeRole(role);
        if (this.isOpen()) {
            this.metadata.setIsBackup(role == IStoreBinding.Role.Backup);
        }
    }

    @Override
    protected final void doWritePersisterMetadata(IOElasticBuffer buffer, int offset) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "Received metadata to write...", Tracer.Level.DEBUG);
        }
        if (this.metadata.getLiveLogNumber() == RogLogMetadata.getLiveLogNumber(buffer)) {
            int previousCdcLogNumber = this.metadata.getCdcLogNumber();
            this.metadata.deserialize(buffer, offset, this.role);
            if (this.metadata.getCdcLogNumber() != previousCdcLogNumber) {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix() + "...CDC log number has changed (previous=" + previousCdcLogNumber + ", current=" + this.metadata.getCdcLogNumber() + ").", Tracer.Level.DEBUG);
                }
                this.scavenge();
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix() + "...no change to CDC log number (#" + previousCdcLogNumber + ").", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix() + "...live logs are different (this=" + this.metadata.getLiveLogNumber() + ", that=" + RogLogMetadata.getLiveLogNumber(buffer) + ").", Tracer.Level.DEBUG);
        }
    }

    @Override
    protected final void doWrite(PktPacket packet) {
        boolean compactInProgress = false;
        if (this.isCompactionEnabled() && !(compactInProgress = this.compactor.isCompactionInProgress()) && (this.compactionScheduled || this.getSize() >= this.compactorParams.compactionThreshold) && this.isCommitEnd(packet)) {
            this.compactor.compact();
            compactInProgress = true;
        }
        if (compactInProgress) {
            this.compactionScheduled = false;
            this.compactionSynchronizer.lock();
            try {
                this.log.write(packet, 0);
                this.compactor.onPacketWrittenDuringCompaction(packet);
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        } else {
            this.log.write(packet, 0);
        }
    }

    @Override
    protected final boolean hasBufferedDataToFlush() {
        return this.log.hasBufferedDataToFlush();
    }

    @Override
    protected final void doFlush(boolean sync) {
        block6: {
            try {
                if (this.compactor.isCompactionInProgress()) {
                    this.compactionSynchronizer.lock();
                    try {
                        this.log.flush(sync ? 1 : 0);
                        break block6;
                    }
                    finally {
                        this.compactionSynchronizer.unlock();
                    }
                }
                this.log.flush(sync ? 1 : 0);
            }
            catch (Throwable e) {
                this.fail(new OdsException(e));
            }
        }
    }

    @Override
    protected final void doFail(Exception cause) {
        this.failure = cause;
        this.onFailure(this.failure);
        IStorePersister.ErrorHandler errorHandler = this.errorHandler;
        if (errorHandler != null) {
            errorHandler.onError(this.failure);
        }
    }

    @Override
    protected final String tracePrefix() {
        return "[RogLog->'" + this.getName() + "'] ";
    }

    public final PktRecoveryLog getPacketLog() {
        return this.log;
    }

    public final File getLogFile() {
        if (!this.isOpen()) {
            return new File(this.root, this.logFilename(this.getLiveLogNumber()));
        }
        return new File(this.root, this.logFilename());
    }

    public final File getMetadataFile() {
        return new File(this.root, this.metadataFilename());
    }

    public final RogLogMetadata getMetadata() {
        return this.metadata;
    }

    public final long getCompactionThreshold() {
        return this.compactorParams.compactionThreshold;
    }

    public final boolean isCompactionEnabled() {
        return this.compactorParams.compactionThreshold > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCompactionThreshold(int val) {
        RogLog rogLog = this;
        synchronized (rogLog) {
            this.compactorParams.compactionThreshold = (long)val * 1024L * 1024L;
        }
    }

    @Deprecated
    public final void scheduleCompactionOnNextWrite() {
        this.scheduleCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleCompaction() {
        RogLog rogLog = this;
        synchronized (rogLog) {
            if (this.isCompactionEnabled()) {
                this.compactionScheduled = true;
            }
        }
    }

    public final void delete() throws IOException {
        if (this.isOpen()) {
            throw new IOException("Cannot delete open log");
        }
        try {
            this.metadata.open();
        }
        catch (Exception e) {
            throw new IOException("Error opening metadata: " + e.getLocalizedMessage(), e);
        }
        File metadataFile = new File(this.root, this.metadataFilename());
        try {
            new File(this.root, this.logFilename()).delete();
            new File(this.root, this.indexFilename()).delete();
            new File(this.root, this.factoriesFilename()).delete();
            new File(this.root, this.metadataFilename()).delete();
        }
        finally {
            this.metadata.close();
            metadataFile.delete();
        }
    }

    public final String backupLog(boolean shrinkToSize) throws Exception {
        if (this.isOpen()) {
            throw new IllegalStateException("the log file cannot be backed up after the persister has been opened");
        }
        return this.backupLog(this.getLiveLogNumber(), shrinkToSize);
    }

    @Override
    public final void setStartupExpectation(IStorePersister.StartupExpectation expectation, Enum<?> value) {
        if (expectation == null) {
            throw new IllegalArgumentException("expectation cannot be null");
        }
        if (this.isOpen()) {
            throw new IllegalStateException("startup expectation can only be set before open");
        }
        switch (expectation) {
            case LogPresence: {
                if (value != null) {
                    if (value instanceof IStorePersister.LogPresenceExpectation) {
                        this.logPresenceStartupExpectation = (IStorePersister.LogPresenceExpectation)value;
                        break;
                    }
                    throw new IllegalArgumentException("log presence expectation must of type IStorePersister.LogPresenceExpectation");
                }
                this.logPresenceStartupExpectation = null;
                break;
            }
            case LogEmptiness: {
                if (value != null) {
                    if (value instanceof IStorePersister.LogEmptinessExpectation) {
                        this.logEmptinessStartupExpectation = (IStorePersister.LogEmptinessExpectation)value;
                        break;
                    }
                    throw new IllegalArgumentException("log emptiness expectation must of type IStorePersister.LogEmptinessExpectation");
                }
                this.logEmptinessStartupExpectation = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown expectation '" + (Object)((Object)expectation) + "'");
            }
        }
    }

    @Override
    public final void open(IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean truncateLive, boolean concurrentReadWrite) throws Exception {
        block45: {
            int flags;
            int writeBufferSize;
            int readBufferSize;
            int pageSize;
            boolean zeroOutInitial;
            long initialLength;
            PktRecoveryLog.FileOpenMode openMode;
            block49: {
                block48: {
                    block47: {
                        block46: {
                            if (this.isOpen()) {
                                throw new IllegalStateException("log is already open");
                            }
                            if (this.closed) {
                                throw new IllegalStateException("log is closed");
                            }
                            if (failOpen) {
                                throw new OdsException("force failed by user");
                            }
                            String openModeStr = UtlProps.getValue((Properties)this.props, (String)PROP_LOG_MODE, (String)UtlProps.getValue((Properties)this.props, (String)"logOpenMode", (String)PktRecoveryLog.FileOpenMode.rw.toString()));
                            try {
                                openMode = PktRecoveryLog.FileOpenMode.valueOf((String)openModeStr);
                            }
                            catch (Exception e) {
                                throw new OdsException("Invalid log open mode '" + openModeStr + "'.");
                            }
                            boolean doIntegrityCheck = UtlProps.getValue((Properties)this.props, (String)PROP_INTEGRITY_CHECK, (boolean)true);
                            initialLength = (long)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_INITIAL_LOG_LENGTH, (String)String.valueOf(1.0f)), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Gigabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
                            zeroOutInitial = UtlProps.getValue((Properties)this.props, (String)PROP_ZERO_OUT_INITIAL, (boolean)false);
                            pageSize = (int)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_PAGE_SIZE, (String)"8k"), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
                            readBufferSize = (int)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_READ_BUFFER_SIZE, (String)"8k"), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
                            writeBufferSize = (int)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)this.props, (String)PROP_WRITE_BUFFER_SIZE, (String)UtlProps.getValue((Properties)this.props, (String)PROP_AUTO_FLUSH_SIZE, (String)"8k")), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
                            boolean cdcEnabled = UtlProps.getValue((Properties)this.props, (String)PROP_CDC_ENABLED, (boolean)false);
                            if (this.tracer.isEnabled(Tracer.Level.CONFIG)) {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Transaction Log '" + this.getName() + "' Configuration {").append("\n");
                                sb.append("...logOpenMode=" + openMode).append("\n");
                                sb.append("...doLogIntegrityCheck=" + doIntegrityCheck).append("\n");
                                sb.append("...autoRepair=" + this.autoRepair).append("\n");
                                sb.append("...initialLogLength=" + initialLength).append(" (").append(UtlUnit.readableBytesSize((long)initialLength)).append(")").append("\n");
                                sb.append("...zeroOutInitial=" + zeroOutInitial).append("\n");
                                sb.append("...pageSize=" + pageSize).append(" (").append(UtlUnit.readableBytesSize((long)pageSize)).append(")").append("\n");
                                sb.append("...readBufferSize=" + readBufferSize).append(" (").append(UtlUnit.readableBytesSize((long)readBufferSize)).append(")").append("\n");
                                sb.append("...writeBufferSize=" + writeBufferSize).append(" (").append(UtlUnit.readableBytesSize((long)writeBufferSize)).append(")").append("\n");
                                sb.append("...flushUsingMappedMemory=" + this.flushUsingMappedMemory).append("\n");
                                sb.append("...cdcEnabled=" + cdcEnabled).append("\n");
                                sb.append("...storeRoot=" + this.root).append("\n");
                                super.dumpParams("...", sb);
                                this.compactorParams.dump("...", sb);
                                this.cdcParams.dump("...", sb);
                                sb.append("}");
                                this.tracer.log("\n" + sb.toString(), Tracer.Level.CONFIG);
                            }
                            if (this.tracer.debug) {
                                this.tracer.log(this.tracePrefix() + "Opening log (root=" + this.root.getAbsolutePath() + ")...", Tracer.Level.DEBUG);
                            }
                            RogLog.checkAndCreateStoreRoot(this.root);
                            this.metadata.open(serializedMetadata, serializedMetadataOffset, this.role);
                            if (this.messageLog) {
                                this.metadata.setIsPureMessageLogger(true);
                            }
                            if (serializedMetadata == null && this.props.containsKey(PROP_CDC_ENABLED)) {
                                this.metadata.setCdcEnabled(cdcEnabled);
                            }
                            if (truncateLive) {
                                for (int i = 0; i <= this.getLiveLogNumber(); ++i) {
                                    this.backupLog(i, true);
                                }
                            }
                            flags = 0;
                            if (this.autoRepair) {
                                flags |= 2;
                            }
                            if (cdcEnabled || concurrentReadWrite) {
                                flags |= 0x80;
                            }
                            if (!doIntegrityCheck) {
                                flags |= 0x100;
                            }
                            if (this.logPresenceStartupExpectation == null) break block46;
                            switch (this.logPresenceStartupExpectation) {
                                case None: {
                                    break block47;
                                }
                                case Present: {
                                    flags |= 8;
                                    break block47;
                                }
                                case Absent: {
                                    flags |= 0x10;
                                    break block47;
                                }
                                default: {
                                    throw new IllegalArgumentException("unsupported log presence expectation '" + (Object)((Object)this.logPresenceStartupExpectation) + "'");
                                }
                            }
                        }
                        String presenceExpectation = UtlProps.getValue((Properties)this.props, (String)PROP_LOG_PRESENCE_EXPECTATION, (String)PROP_LOG_PRESENCE_EXPECTATION_DEFAULT);
                        if (presenceExpectation != null) {
                            if (presenceExpectation.equalsIgnoreCase("present")) {
                                flags |= 8;
                            } else if (presenceExpectation.equalsIgnoreCase("absent")) {
                                flags |= 0x10;
                            } else {
                                throw new IllegalArgumentException("presence expectation property value must be either 'present', 'absent' or null (equivalent to property not specified)");
                            }
                        }
                    }
                    if (this.logEmptinessStartupExpectation == null) break block48;
                    switch (this.logEmptinessStartupExpectation) {
                        case None: {
                            break block49;
                        }
                        case Empty: {
                            flags |= 4;
                            break block49;
                        }
                        case NotEmpty: {
                            flags |= 0x20;
                            break block49;
                        }
                        default: {
                            throw new IllegalArgumentException("unsupported log emptiness expectation '" + (Object)((Object)this.logEmptinessStartupExpectation) + "'");
                        }
                    }
                }
                String emptinessExpectation = UtlProps.getValue((Properties)this.props, (String)PROP_LOG_EMPTINESS_EXPECTATION, (String)PROP_LOG_EMPTINESS_EXPECTATION_DEFAULT);
                if (emptinessExpectation != null) {
                    if (emptinessExpectation.equalsIgnoreCase("empty")) {
                        flags |= 4;
                    } else if (emptinessExpectation.equalsIgnoreCase("notempty")) {
                        flags |= 0x20;
                    } else {
                        throw new IllegalArgumentException("emptiness expectation property value must be either 'empty', 'notempty' or null (equivalent to property not specified)");
                    }
                }
            }
            try {
                this.tracer.log(this.tracePrefix() + "Live transaction log file is '" + this.logFilename() + "' [" + this.root.getCanonicalPath() + "]...", Tracer.Level.INFO);
                this.log = PktRecoveryLog.create((String)this.root.getAbsolutePath(), (String)this.logFilename()).setOpenMode(openMode).setInitialLength(initialLength).setZeroOutInitial(zeroOutInitial).setPageSize(pageSize).setReadBufferSize(readBufferSize).setWriteBufferSize(writeBufferSize).setFlushUsingMappedMemory(this.flushUsingMappedMemory).setFlushDirectFromPacket(this.flushUsingMappedMemory && Config.tuneForLatency());
                this.log.open(flags, this.metadata.getLastValidatedPosition(), (PktRecoveryLog.ILogIntegrityChecker)(UtlProps.getValue((Properties)this.props, (String)PROP_TRANSACTIONAL_INTEGRITY_CHECK, (boolean)true) ? new LogIntegrityChecker() : null));
                this.metadata.setLastValidatedPosition(this.log.getNextWritePointer());
            }
            catch (EPktLogExpectationNotMetException e) {
                Throwable oe;
                switch (e.getUnmetExpectation()) {
                    case 4: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogEmptiness, this.logEmptinessStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    case 32: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogEmptiness, this.logEmptinessStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    case 8: 
                    case 16: {
                        oe = new OdsExpectationNotMetException(IStorePersister.StartupExpectation.LogPresence, this.logPresenceStartupExpectation, e.getUnmetExpectationData(), e.getMessage());
                        break;
                    }
                    default: {
                        oe = null;
                    }
                }
                if (oe == null) break block45;
                oe.initCause(e);
                throw oe;
            }
        }
        try {
            this.scavenge();
            this.writeFactories();
            if (this.compactorParams.compactionThreshold > 0L) {
                this.compactor.start();
                if (this.compactorParams.compactOnStart) {
                    this.compactor.compact().waitForCompactionToComplete();
                }
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    @Override
    public final void open(IOElasticBuffer serializedMetadata, int serializedMetadataOffset, boolean truncateLive) throws Exception {
        this.open(serializedMetadata, serializedMetadataOffset, truncateLive, false);
    }

    @Override
    public final void open(boolean concurrentReadWrite) throws Exception {
        this.open(null, 0, false, concurrentReadWrite);
    }

    @Override
    public final void open() throws Exception {
        this.open(false);
    }

    public final UUID getLogUUID() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return this.metadata.getLogUUID();
    }

    @Override
    public final boolean isOpen() {
        return this.log != null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final StorePersisterDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void setErrorHandler(IStorePersister.ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public final IStorePersister.ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public final void setEventHandler(IEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public final IStorePersisterStats getStats() {
        return this.stats;
    }

    @Override
    public final boolean wasRepaired() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return this.log.wasRepaired();
    }

    @Override
    public final void readMetadata(IOElasticBuffer buffer) {
        if (this.compactorParams.compactionThreshold > 0L || this.metadata.isCdcEnabled()) {
            this.metadata.serialize(buffer);
        }
    }

    @Override
    public final IStoreReader.IterativeReader iterativeReader(int flags) throws Exception {
        return this.storeReader.open(flags, System.currentTimeMillis());
    }

    @Override
    public final boolean read(IStoreReader.ReadCallback cb) throws Exception {
        return this.read(cb, 0);
    }

    @Override
    public final boolean read(IStoreReader.ReadCallback cb, int flags) throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        long ts = System.currentTimeMillis();
        try {
            StoreCommitEntry commitEntry;
            if (!this.storeReader.open()) {
                this.tracer.log(this.tracePrefix() + "Transaction log read started.", Tracer.Level.INFO);
                this.storeReader.open(flags, ts);
                cb.metadata(this.storeReader.metadata());
            } else {
                this.tracer.log(this.tracePrefix() + "Transaction log read resumed.", Tracer.Level.INFO);
            }
            boolean suspend = false;
            while ((commitEntry = this.storeReader.next()) != null && !(suspend = !cb.entry(commitEntry))) {
            }
            long readTime = System.currentTimeMillis() - ts;
            this.storeReader.stats().recordReadLegTime(readTime);
            long elapsedTime = this.storeReader.stats().elapsedTime();
            if (!suspend) {
                cb.done(-1L);
                this.tracer.log(this.tracePrefix() + "Transaction log read complete (entries=" + this.storeReader.stats().numEntriesRead() + ", transactions=" + this.storeReader.stats().numTransactionsRead() + ", elapsedTime=" + UtlUnit.formatDuration((double)elapsedTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", readTime=" + UtlUnit.formatDuration((double)this.storeReader.stats().readTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ").", Tracer.Level.INFO);
                this.storeReader.close();
            } else {
                this.tracer.log(this.tracePrefix() + "Transaction log read suspended (entries=" + this.storeReader.stats().numEntriesRead() + ", transactions=" + this.storeReader.stats().numTransactionsRead() + ", elapsedTime=" + UtlUnit.formatDuration((double)elapsedTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", sectionReadTime=" + UtlUnit.formatDuration((double)readTime, (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ", totalReadTime=" + UtlUnit.formatDuration((double)this.storeReader.stats().readTime(), (TimeUnit)TimeUnit.MILLISECONDS, (int)0) + ").", Tracer.Level.INFO);
            }
            return !suspend;
        }
        catch (Throwable e) {
            this.storeReader.close();
            throw new OdsException(e);
        }
    }

    public final RogLogReader createReader() throws Exception {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        return new RogLogReader(this, this.tracer, this.tracePrefix());
    }

    public final RogLogReader createReader(int logNumber) throws Exception {
        return new RogLogReader(this, logNumber, this.tracer, this.tracePrefix());
    }

    public final RogLogCdcProcessor createCdcProcessor(IRogChangeDataCaptureHandler handler) throws Exception {
        return new RogLogCdcProcessor(this, handler, this.cdcParams);
    }

    public final long getSize() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.compactor.isCompactionInProgress()) {
            this.compactionSynchronizer.lock();
            try {
                long l = this.log.getSize();
                return l;
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        }
        return this.log.getSize();
    }

    public final long getAllocatedSize() {
        if (!this.isOpen()) {
            throw new IllegalStateException("not open");
        }
        if (this.compactor.isCompactionInProgress()) {
            this.compactionSynchronizer.lock();
            try {
                long l = this.log.getAllocatedSize();
                return l;
            }
            finally {
                this.compactionSynchronizer.unlock();
            }
        }
        return this.log.getAllocatedSize();
    }

    @Override
    public final void fail(Exception cause) {
        this.doFail(cause);
    }

    @Override
    public final void fail() {
        this.fail(new OdsException("force failed by user"));
    }

    public final RogLogQueryRepository asRepository() {
        return new RogLogQueryRepositoryImpl(this);
    }

    public final RogLogCompactor getCompactor() {
        return this.compactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File archive(File archiveFolder, String archiveId) throws IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("Can't archive an open log file");
        }
        if (!this.metadata.exists()) {
            throw new IllegalStateException("Can't archive a transaction log with missing .metadata: " + this.metadataFilename() + " does not exist");
        }
        try {
            this.metadata.open();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error opening transaction log metadata: " + e.getLocalizedMessage(), e);
        }
        try {
            String backupFilename = PktRecoveryLog.backup((String)this.root.getAbsolutePath(), (String)this.logFilename(), (boolean)false, (boolean)true, (boolean)false);
            File backupFile = new File(this.root, backupFilename).getCanonicalFile();
            String backupName = this.getName() + "-" + archiveId;
            if (!archiveFolder.exists() && !archiveFolder.mkdirs()) {
                throw new IOException("Failed to create archive folder " + archiveFolder);
            }
            File archiveLogFile = new File(archiveFolder, this.logFilename(backupName));
            if (!backupFile.renameTo(archiveLogFile)) {
                throw new IOException("Failed to move transaction log backup '" + backupFile + "' to '" + archiveLogFile + "'");
            }
            File metadataFile = new File(this.root, this.metadataFilename());
            File archivedMetadataFile = new File(archiveFolder, this.metadataFilename(backupName));
            UtlFile.copyFile((File)metadataFile, (File)archivedMetadataFile);
            File factoriesFile = new File(this.root, this.factoriesFilename());
            File archivedFactoriesFile = new File(archiveFolder, this.factoriesFilename(backupName));
            UtlFile.copyFile((File)factoriesFile, (File)archivedFactoriesFile);
            File indexFile = new File(this.root, this.indexFilename());
            if (indexFile.exists()) {
                File archivedIndexFile = new File(archiveFolder, this.indexFilename(backupName));
                UtlFile.copyFile((File)indexFile, (File)archivedIndexFile);
                File indexPFile = new File(this.root, this.indexPFilename());
                if (indexPFile.exists()) {
                    File archivedIndexPFile = new File(archiveFolder, this.indexPFilename(backupName));
                    UtlFile.copyFile((File)indexPFile, (File)archivedIndexPFile);
                }
            }
            for (int i = Math.max(0, this.metadata.getCdcLogNumber()); i < Math.max(0, this.metadata.getLiveLogNumber()); ++i) {
                File cdcFile = new File(this.root, this.logFilename(i));
                if (!cdcFile.exists()) continue;
                File archivedCheckpointFile = new File(archiveFolder, backupFilename + "." + i + ".log");
                UtlFile.copyFile((File)cdcFile, (File)archivedCheckpointFile);
            }
            File file = archiveLogFile;
            return file;
        }
        finally {
            this.metadata.close();
        }
    }

    @Override
    public final void close() {
        super.stop();
        try {
            this.compactor.stop();
            if (this.log != null) {
                this.log.close();
            }
            if (this.metadata != null) {
                this.metadata.close();
            }
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix() + "Failed to close the transaction log [" + e.toString() + "]", Tracer.Level.WARNING);
        }
        finally {
            this.log = null;
            this.closed = true;
        }
    }

    public String toString() {
        return "RogLog: " + this.name;
    }

    private final class StoreReader
    implements IStoreReader.IterativeReader {
        private final PacketReceiver packetReceiver = new PacketReceiver();
        private final StoreCommitEntry commitEntry = StoreCommitEntry.create();
        private final Stats stats = new Stats();
        private boolean open;
        private PktRecoveryLog.MemoryMappedReader logReader;

        private StoreReader() {
        }

        final IStoreReader.IterativeReader open(int flags, long ts) throws Exception {
            if (this.open) {
                this.close();
            }
            RogLog.this.compactionSynchronizer.lock();
            this.logReader = RogLog.this.log.createMemoryMappedReader((PktRecoveryLog.IPacketBufferReceiver)this.packetReceiver);
            this.logReader.reset();
            this.stats.init(ts);
            RogLog.this.metadata.serialize(this.commitEntry.serializedPersisterMetadata);
            this.open = true;
            return this;
        }

        @Override
        public final boolean open() {
            return this.open;
        }

        @Override
        public final IOElasticBuffer metadata() {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            return this.commitEntry.serializedPersisterMetadata;
        }

        @Override
        public final void seek(long pos) throws IOException {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            if (pos < 0L) {
                throw new IllegalArgumentException("pos must be >= 0");
            }
            if (pos == 0L) {
                this.logReader.reset();
            } else {
                this.logReader.seek(pos);
            }
        }

        @Override
        public final StoreCommitEntry next() throws Exception {
            PktPacket packet;
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            if (this.logReader.readOne() == null) {
                packet = this.packetReceiver.packet;
                packet.acquire();
            } else {
                packet = null;
            }
            if (packet != null && RogLog.this.depacketize(packet, this.commitEntry)) {
                this.stats.eCount++;
                if (this.commitEntry.commitEnd) {
                    this.stats.tCount++;
                }
                return this.commitEntry;
            }
            return null;
        }

        @Override
        public final Stats stats() {
            if (!this.open) {
                throw new IllegalStateException("reader not open");
            }
            return this.stats;
        }

        @Override
        public final void close() {
            if (this.open) {
                try {
                    this.logReader.close();
                    this.packetReceiver.close();
                    RogLog.this.compactionSynchronizer.unlock();
                }
                catch (Throwable e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\n").append("Failure encountered while closing log read context").append("\n");
                    sb.append("Stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    RogLog.this.tracer.log(RogLog.this.tracePrefix() + sb.toString(), Tracer.Level.WARNING);
                }
                finally {
                    this.open = false;
                }
            }
        }

        private final class Stats
        implements IStoreReader.IterativeReader.Stats {
            private long startTs;
            private int eCount;
            private int tCount;
            private long readTime;

            private Stats() {
            }

            final void init(long ts) {
                this.startTs = ts;
                this.eCount = 0;
                this.tCount = 0;
                this.readTime = 0L;
            }

            @Override
            public final long startTime() {
                return this.startTs;
            }

            @Override
            public final void recordReadLegTime(long timeInMillis) {
                if (!StoreReader.this.open) {
                    throw new IllegalStateException("reader not open");
                }
                this.readTime += timeInMillis;
            }

            @Override
            public final long readTime() {
                return this.readTime;
            }

            @Override
            public final long elapsedTime() {
                return System.currentTimeMillis() - this.startTs;
            }

            @Override
            public final int numEntriesRead() {
                return this.eCount;
            }

            @Override
            public final int numTransactionsRead() {
                return this.tCount;
            }
        }

        private final class PacketReceiver
        implements PktRecoveryLog.IPacketBufferReceiver {
            private PktPacket packet;
            private final XIntLinkedHashMap<PktPacket> cache = new XIntLinkedHashMap();

            PacketReceiver() {
            }

            private final void tagPacketWithFilePositionAndSize(PktPacket packet, long filePosition, int packetLength) {
                PktRecoveryLog.FilePosition position = (PktRecoveryLog.FilePosition)packet.getTag(4);
                if (position == null) {
                    position = new PktRecoveryLog.FilePosition();
                    packet.setTag(4, (Object)position);
                }
                position.setPosition(filePosition);
                position.setSize(packetLength);
            }

            final void close() {
                XIterator iterator = this.cache.reuseableValueIterator();
                while (iterator.hasNext()) {
                    ((PktPacket)iterator.next()).dispose();
                }
                this.cache.clear();
            }

            public final void onPacket(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
                int type = PktHeader.getBodyType((IOBuffer)buffer, (int)bufferPosition);
                this.packet = (PktPacket)this.cache.get(type);
                if (this.packet == null) {
                    this.packet = PktFactory.getInstance().createPacket(type);
                    this.cache.put(type, (Object)this.packet);
                }
                this.packet.deserialize(buffer, bufferPosition, false, true);
                this.tagPacketWithFilePositionAndSize(this.packet, filePosition, packetLength);
            }

            public final void onBufferChange(IOBuffer from, IOBuffer to) {
            }
        }
    }

    private final class LogIntegrityChecker
    implements PktRecoveryLog.ILogIntegrityChecker {
        private boolean inTransaction;
        private int lastTransactionSize;
        private int numValidEntries;
        private long validatedFileLength;

        private LogIntegrityChecker() {
        }

        private final boolean endOfCommit(IOBuffer buffer, int bufferPosition) {
            long addr = buffer.getNativeAddress();
            try {
                int odsSubheaderOffset = PktHeader.getSubheaderOffset((long)addr, (int)bufferPosition, (int)7);
                return odsSubheaderOffset >= 0 ? (PktSubheaderODS.getFlags((long)addr, (int)odsSubheaderOffset) & 1) == 1 : false;
            }
            catch (Throwable e) {
                throw new EPktLogCorruptException(e);
            }
        }

        public final void init(long logPreambleLength) {
            this.inTransaction = false;
            this.lastTransactionSize = 0;
            this.numValidEntries = 0;
            this.validatedFileLength = logPreambleLength;
            if (((RogLog)RogLog.this).tracer.debug) {
                RogLog.this.tracer.log(RogLog.this.tracePrefix() + "[Transaction log integrity checker] Initialized.", Tracer.Level.DEBUG);
            }
        }

        public final void onPacket(IOBuffer buffer, int bufferPosition, int packetLength, long filePosition) {
            if (!this.inTransaction) {
                this.inTransaction = true;
            }
            ++this.lastTransactionSize;
            boolean endOfCommit = this.endOfCommit(buffer, bufferPosition);
            if (endOfCommit) {
                this.inTransaction = false;
                this.numValidEntries += this.lastTransactionSize;
                this.validatedFileLength = filePosition + (long)packetLength;
                this.lastTransactionSize = 0;
            }
            if (((RogLog)RogLog.this).tracer.debug) {
                RogLog.this.tracer.log(RogLog.this.tracePrefix() + "[Transaction log integrity checker] onPacket (fp=" + filePosition + ", pktlen=" + packetLength + ", endOfCommit=" + endOfCommit + ")", Tracer.Level.DEBUG);
            }
        }

        public final void done() {
            if (this.corruptionDetected()) {
                throw new EPktLogCorruptException("incomplete last transaction (" + this.lastTransactionSize + " entries)");
            }
            if (((RogLog)RogLog.this).tracer.debug) {
                RogLog.this.tracer.log(RogLog.this.tracePrefix() + "[Transaction log integrity checker] Done.", Tracer.Level.DEBUG);
            }
        }

        public final boolean corruptionDetected() {
            return this.inTransaction;
        }

        public final int numValidEntries() {
            return this.numValidEntries;
        }

        public final long validatedFileLength() {
            return this.validatedFileLength;
        }
    }

    private static enum LogScavengePolicy {
        Delete,
        Disabled;

    }
}

