/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.util.UtlAddressDescriptor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StoreReplicatorDescriptor
extends OdsObject {
    private final String name;
    private final Properties props;
    public static final String PROP_STORE_NAME = "storeName";
    public static final String PROP_STORE_REPLICATOR_LOCALIFADDR = "localIfAddr";
    public static final String PROP_STORE_REPLICATOR_LOCALPORT = "localPort";
    public static final String PROP_STORE_REPLICATOR_LOCALPORT_DEFAULT = "0";
    public static final String PROP_STORE_REPLICATOR_LINKPARAMS = "linkParams";
    public static final String PROP_STORE_REPLICATOR_LINKREADER_CPUAFFINITYMASK = "linkReaderCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_LINKREADER_CPUAFFINITYMASK_DEFAULT = "0";
    public static final String PROP_STORE_REPLICATOR_DISCOVERY_DESCRIPTOR = "discoveryDescriptor";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_TIME = "initWaitTime";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_TIME_DEFAULT = "5000";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_EXTENSION_UNIT = "initWaitExtensionUnit";
    public static final String PROP_STORE_REPLICATOR_INIT_WAIT_EXTENSION_UNIT_DEFAULT = "100";
    public static final String PROP_STORE_REPLICATOR_FAILONMULTIPLEPRIMARIES = "failOnMultiplePrimaries";
    public static final String PROP_STORE_REPLICATOR_FAILONMULTIPLEPRIMARIES_DEFAULT = "true";
    public static final String PROP_STORE_REPLICATOR_SUPPRESSDISCOVERYSHUTDOWNHOOK = "suppressDiscoveryShutdownHook";
    public static final String PROP_STORE_REPLICATOR_MEMBER_ELECTION_PRIORITY = "memberElectionPriority";
    public static final String PROP_STORE_REPLICATOR_MEMBER_ELECTION_PRIORITY_DEFAULT = "255";
    public static final String PROP_STORE_REPLICATOR_DETACHED_SEND = "detachedSend";
    public static final String PROP_STORE_REPLICATOR_DETACHED_SEND_DEFAULT = "false";
    public static final String PROP_STORE_REPLICATOR_SENDER_CPUAFFINITYMASK = "senderCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_SENDER_QUEUEDEPTH = "senderQueueDepth";
    public static final String PROP_STORE_REPLICATOR_SENDER_QUEUEDEPTH_DEFAULT = "1024";
    public static final String PROP_STORE_REPLICATOR_SENDER_QUEUEWAITSTRATEGY = "senderQueueWaitStrategy";
    public static final String PROP_STORE_REPLICATOR_DETACHED_DISPATCH = "detachedDispatch";
    public static final String PROP_STORE_REPLICATOR_DETACHED_DISPATCH_DEFAULT = "false";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_CPUAFFINITYMASK = "dispatcherCpuAffinityMask";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_QUEUEDEPTH = "dispatcherQueueDepth";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_QUEUEDEPTH_DEFAULT = "1024";
    public static final String PROP_STORE_REPLICATOR_DISPATCHER_QUEUEWAITSTRATEGY = "dispatcherQueueWaitStrategy";

    private StoreReplicatorDescriptor(String name) {
        super(null);
        this.name = name;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final StoreReplicatorDescriptor setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
        return this;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String defVal) {
        return this.props.getProperty(name, defVal);
    }

    public final StoreReplicatorDescriptor setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        return this;
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final Properties save(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        return props;
    }

    public final void save(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            String replicatorContainerAddr = "/ods/replicators";
            IConfigSimpleEntityContainer replicatorContainer = repo.getSimpleEntityContainer("/ods/replicators");
            if (replicatorContainer == null) {
                replicatorContainer = repo.createSimpleEntityContainer("/ods/replicators");
            }
            if ((entity = (IConfigSimpleEntity)replicatorContainer.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)replicatorContainer.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
        }
        catch (EConfigException e) {
            throw new OdsException(e);
        }
    }

    public final void save() throws OdsException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer replicatorContainer = repo.getSimpleEntityContainer("/ods/replicators");
        if (replicatorContainer != null) {
            replicatorContainer.removeEntity(this.name);
        }
    }

    public final void delete() throws OdsException {
        this.delete(Config.getRepository());
    }

    public static StoreReplicatorDescriptor create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("replicator name cannot be null");
        }
        return new StoreReplicatorDescriptor(name);
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("replicator name cannot be null");
        }
        return repo.getSimpleEntity("/ods/replicators/" + name) != null;
    }

    public static boolean exists(String name) {
        return StoreReplicatorDescriptor.exists(Config.getRepository(), name);
    }

    public static StoreReplicatorDescriptor load(IConfigRepository repo, String name) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/ods/replicators/" + name);
        if (entity != null) {
            StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(name);
            replicatorDescriptor.setProperties(entity.getProperties());
            return replicatorDescriptor;
        }
        throw new OdsException("Replicator '" + name + "' not found in repository");
    }

    public static StoreReplicatorDescriptor load(String name) throws OdsException {
        return StoreReplicatorDescriptor.load(Config.getRepository(), name);
    }

    public static Set<StoreReplicatorDescriptor> loadAll(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<StoreReplicatorDescriptor> replicators = new LinkedHashSet<StoreReplicatorDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/replicators");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    replicators.add(StoreReplicatorDescriptor.load(repo, entity.getName()));
                }
                catch (OdsException e) {
                    throw new OdsException("Failure in loading descriptor for replicator '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return replicators;
    }

    public static Set<StoreReplicatorDescriptor> loadAll() throws OdsException {
        return StoreReplicatorDescriptor.loadAll(Config.getRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStore Replicator '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...properties {").append("\n");
        Properties properties = this.getProperties();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                if (name.equals(PROP_STORE_REPLICATOR_DISCOVERY_DESCRIPTOR)) {
                    sb.append("......").append(name).append("=").append(UtlAddressDescriptor.parse((String)properties.getProperty(name), null).toPasswordSanitizedFullString()).append("\n");
                    continue;
                }
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("...}").append("\n");
        return sb.toString();
    }
}

