/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.util.UtlProps;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StorePersisterDescriptor
extends OdsObject {
    public static final String PROP_DETACHED = "detachedPersist";
    public static final String PROP_DETACHED_QUEUE_DEPTH = "queueDepth";
    public static final String PROP_DETACHED_QUEUE_OFFER_STRATEGY = "queueOfferStrategy";
    public static final String PROP_DETACHED_QUEUE_WAIT_STRATEGY = "queueWaitStrategy";
    public static final String PROP_DETACHED_QUEUE_DRAINER_CPU_AFFINITIZATION_MASK = "queueDrainerCpuAffinityMask";
    public static final String PROP_SHARED = "shared";
    public static final String PROP_FLUSH_ON_COMMIT = "flushOnCommit";
    public static final String PROP_RECORD_LEG_LATENCIES = "recordLegLatencies";
    private final String name;
    private final Properties props;
    private String className;

    private StorePersisterDescriptor(String name, String className) {
        super(null);
        this.name = name;
        this.className = className;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final StorePersisterDescriptor setProperty(String name, String value) {
        if (value != null) {
            this.props.setProperty(name, value);
        } else {
            this.props.remove(name);
        }
        return this;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final StorePersisterDescriptor setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        return this;
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final Properties save(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        return props;
    }

    public final void save(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            String persisterContainerAddr = "/ods/persisters";
            IConfigSimpleEntityContainer persisterContainer = repo.getSimpleEntityContainer("/ods/persisters");
            if (persisterContainer == null) {
                persisterContainer = repo.createSimpleEntityContainer("/ods/persisters");
            }
            if ((entity = (IConfigSimpleEntity)persisterContainer.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)persisterContainer.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("MainClass", this.getClassName());
        }
        catch (EConfigException e) {
            throw new OdsException(e);
        }
    }

    public final void save() throws OdsException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer persisterContainer = repo.getSimpleEntityContainer("/ods/persisters");
        if (persisterContainer != null) {
            persisterContainer.removeEntity(this.name);
        }
    }

    public final void delete() throws OdsException {
        this.delete(Config.getRepository());
    }

    public static StorePersisterDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("persister name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("persister class name cannot be null");
        }
        return new StorePersisterDescriptor(name, className);
    }

    public static StorePersisterDescriptor create(String name) {
        return StorePersisterDescriptor.create(name, "com.neeve.rog.log.RogLog");
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("persister name cannot be null");
        }
        return repo.getSimpleEntity("/ods/persisters/" + name) != null;
    }

    public static boolean exists(String name) {
        return StorePersisterDescriptor.exists(Config.getRepository(), name);
    }

    public static StorePersisterDescriptor load(IConfigRepository repo, String name) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/ods/persisters/" + name);
        if (entity != null) {
            StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create(name, entity.getProperty("MainClass", null));
            persisterDescriptor.setProperties(entity.getProperties());
            return persisterDescriptor;
        }
        throw new OdsException("Persister '" + name + "' not found in repository");
    }

    public static StorePersisterDescriptor load(String name) throws OdsException {
        return StorePersisterDescriptor.load(Config.getRepository(), name);
    }

    public static Set<StorePersisterDescriptor> loadAll(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<StorePersisterDescriptor> persisters = new LinkedHashSet<StorePersisterDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ods/persisters");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    persisters.add(StorePersisterDescriptor.load(repo, entity.getName()));
                }
                catch (OdsException e) {
                    throw new OdsException("Failure in loading descriptor for persister '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return persisters;
    }

    public static Set<StorePersisterDescriptor> loadAll() throws OdsException {
        return StorePersisterDescriptor.loadAll(Config.getRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStore Persister '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...class='" + this.getClassName()).append("'\n");
        sb.append("...properties {").append("\n");
        Properties properties = this.getProperties();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                if (name.startsWith("cdc.") || name.startsWith("compaction.")) continue;
                sb.append("......").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
            Properties subProps = new Properties();
            UtlProps.getSubProps((Properties)properties, (String)"cdc.", (boolean)true, (Properties)subProps);
            if (!subProps.isEmpty()) {
                sb.append("......cdc {").append("\n");
                for (String name : subProps.stringPropertyNames()) {
                    sb.append(".........").append(name).append("=").append(subProps.getProperty(name)).append("\n");
                }
                sb.append("......}").append("\n");
            }
            subProps.clear();
            UtlProps.getSubProps((Properties)properties, (String)"compaction.", (boolean)true, (Properties)subProps);
            if (!subProps.isEmpty()) {
                sb.append("......compaction {").append("\n");
                for (String name : subProps.stringPropertyNames()) {
                    sb.append(".........").append(name).append("=").append(subProps.getProperty(name)).append("\n");
                }
                sb.append("......}").append("\n");
            }
        }
        sb.append("...}").append("\n");
        return sb.toString();
    }
}

