/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlLinkedLongMap;
import com.neeve.util.UtlPool;

public class UtlReentrantReadWriteLock {
    private int writeLockCount;
    private int waitingWriters;
    private Thread writeLockOwner;
    private final Object mutex = new Object();
    private final UtlLinkedLongMap<ReadLockEntry> readLockHolders = new UtlLinkedLongMap(4);
    private final UtlPool<ReadLockEntry> readLockPool;

    private UtlReentrantReadWriteLock(String name) {
        this.readLockPool = UtlPool.create("readlockentry", name, new ReadLockEntryFactory(), UtlPool.Params.create().setThreaded(false));
    }

    public static UtlReentrantReadWriteLock create(String name) {
        return new UtlReentrantReadWriteLock(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getReadLock() throws InterruptedException {
        Thread current = Thread.currentThread();
        Object object = this.mutex;
        synchronized (object) {
            ReadLockEntry entry = (ReadLockEntry)this.readLockHolders.get(current.getId());
            if (entry != null) {
                ++entry.count;
                return;
            }
            while (this.writeLockOwner != current && (this.writeLockCount > 0 || this.waitingWriters != 0)) {
                this.mutex.wait();
            }
            entry = this.readLockPool.get(null);
            entry.count = 1;
            this.readLockHolders.put(current.getId(), (Object)entry);
        }
    }

    public final void getReadLockUninterrupted() {
        while (true) {
            try {
                this.getReadLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getWriteLock() throws InterruptedException {
        Thread current = Thread.currentThread();
        Object object = this.mutex;
        synchronized (object) {
            if (this.writeLockOwner != null && this.writeLockOwner == current) {
                ++this.writeLockCount;
                return;
            }
            ++this.waitingWriters;
            while (this.writeLockCount != 0 || this.readLockHolders.size() > 1 || this.readLockHolders.size() == 1 && !this.readLockHolders.containsKey(current.getId())) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException ie) {
                    this.mutex.notifyAll();
                    --this.waitingWriters;
                    throw ie;
                }
            }
            this.writeLockOwner = Thread.currentThread();
            --this.waitingWriters;
            ++this.writeLockCount;
        }
    }

    public final void getWriteLockUninterrupted() {
        while (true) {
            try {
                this.getWriteLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseWriteLock() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.writeLockCount <= 0) {
                throw new IllegalStateException("write lock not owned");
            }
            --this.writeLockCount;
            if (this.writeLockCount != 0) {
                return;
            }
            this.writeLockOwner = null;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseReadLock() {
        Thread current = Thread.currentThread();
        Object object = this.mutex;
        synchronized (object) {
            ReadLockEntry entry = (ReadLockEntry)this.readLockHolders.get(current.getId());
            try {
                if (--entry.count == 0) {
                    this.readLockHolders.remove(current.getId());
                    this.readLockPool.put(entry);
                    this.mutex.notifyAll();
                }
            }
            catch (NullPointerException npe) {
                throw new IllegalStateException("read lock not owned");
            }
        }
    }

    private static final class ReadLockEntryFactory
    implements UtlPool.Factory<ReadLockEntry> {
        private ReadLockEntryFactory() {
        }

        @Override
        public ReadLockEntry createItem(Object object) {
            return new ReadLockEntry();
        }

        public ReadLockEntry[] createItemArray(int size) {
            return new ReadLockEntry[size];
        }
    }

    private static final class ReadLockEntry
    implements UtlPool.Item<ReadLockEntry> {
        private UtlPool<ReadLockEntry> pool;
        int count = 0;

        private ReadLockEntry() {
        }

        @Override
        public ReadLockEntry init() {
            this.count = 0;
            return this;
        }

        @Override
        public ReadLockEntry setPool(UtlPool<ReadLockEntry> pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public UtlPool<ReadLockEntry> getPool() {
            return this.pool;
        }
    }
}

