/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import cern.colt.list.ObjectArrayList;
import com.neeve.stats.EStatsAlreadyPresentException;
import com.neeve.stats.IStats;
import java.util.HashMap;
import java.util.Iterator;

public final class StatsRegistry {
    private final HashMap<String, IStats> table = new HashMap();
    private static final StatsRegistry instance = new StatsRegistry();

    private StatsRegistry() {
    }

    public static StatsRegistry getInstance() {
        return instance;
    }

    public static String getFullyQualifiedName(IStats stats) {
        return stats.getType() + "." + stats.getName() + ".stats";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(IStats stats) throws EStatsAlreadyPresentException {
        HashMap<String, IStats> hashMap = this.table;
        synchronized (hashMap) {
            if (this.table.containsKey(stats.getName())) {
                throw new EStatsAlreadyPresentException();
            }
            this.table.put(StatsRegistry.getFullyQualifiedName(stats), stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStats get(String name) {
        HashMap<String, IStats> hashMap = this.table;
        synchronized (hashMap) {
            return this.table.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectArrayList getValues() {
        HashMap<String, IStats> hashMap = this.table;
        synchronized (hashMap) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<IStats> iterator = this.table.values().iterator();
            while (iterator.hasNext()) {
                list.add((Object)iterator.next());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStats remove(IStats stats) {
        HashMap<String, IStats> hashMap = this.table;
        synchronized (hashMap) {
            return this.table.remove(StatsRegistry.getFullyQualifiedName(stats));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStats remove(String name) {
        HashMap<String, IStats> hashMap = this.table;
        synchronized (hashMap) {
            return this.table.remove(name);
        }
    }
}

