/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XBooleanCollection;
import com.neeve.lang.XBooleanCollectionBase;
import com.neeve.lang.XBooleanIterator;
import com.neeve.lang.XBooleanList;
import com.neeve.lang.XBooleanListIterator;
import com.neeve.lang.XCollection;
import java.util.NoSuchElementException;

public class XBooleanLinkedList
extends XBooleanCollectionBase
implements XBooleanList {
    private transient BooleanNode _head = this.newNode();
    private transient BooleanNode _tail = this.newNode();
    private transient int _size;

    public XBooleanLinkedList() {
        this(4);
    }

    public XBooleanLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        BooleanNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            BooleanNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XBooleanLinkedList(XBooleanCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XBooleanLinkedList newInstance() {
        return new XBooleanLinkedList();
    }

    @Override
    public final boolean add(boolean value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final boolean get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final boolean set(int index, boolean value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        BooleanNode node = this.nodeAt(index);
        boolean previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, boolean value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XBooleanCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        BooleanNode indexNode = this.nodeAt(index);
        XBooleanIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final boolean remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        BooleanNode node = this.nodeAt(index);
        boolean previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(boolean value) {
        int index = 0;
        BooleanNode n = this._head;
        BooleanNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(boolean value) {
        int index = this.size() - 1;
        BooleanNode n = this._tail;
        BooleanNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XBooleanIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XBooleanListIterator listIterator() {
        return XBooleanLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XBooleanListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XBooleanLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XBooleanList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final boolean getFirst() {
        BooleanNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final boolean getLast() {
        BooleanNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(boolean value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(boolean value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final boolean removeFirst() {
        BooleanNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        boolean previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final boolean removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        BooleanNode last = this._tail._previous;
        boolean previousValue = last._value;
        this._tail = last;
        last._value = false;
        return previousValue;
    }

    public final void addBefore(BooleanNode next, boolean value) {
        BooleanNode newNode;
        BooleanNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        BooleanNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final BooleanNode nodeAt(int index) {
        BooleanNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final BooleanNode head() {
        return this._head;
    }

    @Override
    public final BooleanNode tail() {
        return this._tail;
    }

    @Override
    public final boolean valueOf(XCollection.Record record) {
        return ((BooleanNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        BooleanNode node = (BooleanNode)record;
        --this._size;
        node._value = false;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        BooleanNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(boolean value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XBooleanList unmodifiable() {
        return (XBooleanList)super.unmodifiable();
    }

    protected BooleanNode newNode() {
        return new BooleanNode();
    }

    private void increaseCapacity() {
        BooleanNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        BooleanNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        BooleanNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        BooleanNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XBooleanLinkedListIterator
    implements XBooleanListIterator {
        private XBooleanLinkedList _list;
        private BooleanNode _nextNode;
        private BooleanNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XBooleanLinkedListIterator() {
        }

        public static XBooleanLinkedListIterator valueOf(XBooleanLinkedList list, BooleanNode nextNode, int nextIndex, int size) {
            XBooleanLinkedListIterator itr = new XBooleanLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public boolean next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public boolean previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(boolean o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("add not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(boolean o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("set not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("remove not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XBooleanLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XBooleanCollectionBase
    implements XBooleanList {
        private XBooleanLinkedList _list;
        private BooleanNode _head;
        private BooleanNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XBooleanLinkedList list, BooleanNode head, BooleanNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public boolean valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XBooleanCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XBooleanCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            BooleanNode indexNode = this.nodeAt(index);
            XBooleanIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public boolean get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public boolean set(int index, boolean value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            BooleanNode node = this.nodeAt(index);
            boolean previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(boolean element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, boolean element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public boolean remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            BooleanNode node = this.nodeAt(index);
            boolean previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(boolean value) {
            int index = 0;
            BooleanNode n = this._head;
            BooleanNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(boolean value) {
            int index = this.size() - 1;
            BooleanNode n = this._tail;
            BooleanNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XBooleanListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XBooleanListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XBooleanLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XBooleanList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final BooleanNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                BooleanNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            BooleanNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class BooleanNode
    implements XCollection.Record {
        private BooleanNode _next;
        private BooleanNode _previous;
        private boolean _value;

        protected BooleanNode() {
        }

        public final boolean getValue() {
            return this._value;
        }

        @Override
        public final BooleanNode getNext() {
            return this._next;
        }

        @Override
        public final BooleanNode getPrevious() {
            return this._previous;
        }
    }
}

