/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Ssh {
    private static final String[] trimFromToFiles(String[] args) {
        String[] ret = new String[args.length - 2];
        for (int i = 0; i < args.length - 2; ++i) {
            ret[i] = args[i];
        }
        return ret;
    }

    private static final int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    private static final void printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage Ssh -i <keyFile> -p <port> user@host <command>").append("\n");
        System.out.println(sb.toString());
        System.exit(1);
    }

    public static void main(String[] args) {
        block17: {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option keyFilenameOption = parser.addStringOption('i', "keyfile");
            CmdLineParser.Option portOption = parser.addIntegerOption('p', "port");
            if (args.length >= 2) {
                try {
                    parser.parse(Ssh.trimFromToFiles(args));
                    String keyFilename = (String)parser.getOptionValue(keyFilenameOption, null);
                    int port = (Integer)parser.getOptionValue(portOption, (Object)22);
                    if (keyFilename != null) {
                        try {
                            File keyFile = new File(keyFilename);
                            if (keyFile.exists()) {
                                String user = args[args.length - 2].substring(0, args[args.length - 2].indexOf(64));
                                String host = args[args.length - 2].substring(args[args.length - 2].indexOf(64) + 1);
                                String command = args[args.length - 1];
                                System.out.println("host=" + host);
                                System.out.println("port=" + port);
                                System.out.println("user=" + user);
                                System.out.println("keyfile=" + keyFile.getAbsolutePath());
                                System.out.println("command=" + command);
                                JSch jsch = new JSch();
                                jsch.addIdentity(keyFile.getAbsolutePath());
                                Session session = jsch.getSession(user, host, port);
                                Properties config = new Properties();
                                config.put("StrictHostKeyChecking", "no");
                                session.setConfig(config);
                                session.connect();
                                try {
                                    Channel channel = session.openChannel("exec");
                                    ((ChannelExec)channel).setCommand(command);
                                    InputStream in = channel.getInputStream();
                                    channel.connect();
                                    try {
                                        byte[] tmp = new byte[1024];
                                        while (true) {
                                            int i;
                                            if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                                                System.out.print(new String(tmp, 0, i));
                                                continue;
                                            }
                                            if (channel.isClosed()) {
                                                System.out.println("exit-status: " + channel.getExitStatus());
                                                System.exit(channel.getExitStatus());
                                            }
                                            try {
                                                Thread.sleep(1000L);
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        channel.disconnect();
                                        throw throwable;
                                    }
                                }
                                catch (Throwable throwable) {
                                    session.disconnect();
                                    throw throwable;
                                }
                            }
                            System.err.println("ERROR: Key file '" + keyFile.getAbsolutePath() + "' does not exist");
                            System.exit(1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block17;
                    }
                    Ssh.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println("ERROR: " + e.getMessage());
                    Ssh.printUsage();
                }
            } else {
                Ssh.printUsage();
            }
        }
    }
}

