/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.build;

import com.google.common.io.Files;
import com.neeve.build.DDLConfigProcessor;
import com.neeve.ddl.jaxb.Model;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class RumiSystem {
    private final String name;
    private List<File> confDirectories = Collections.emptyList();
    private List<File> resourceDirectories = Collections.emptyList();
    private List<File> scriptDirectories = Collections.emptyList();
    private List<File> jarFiles = Collections.emptyList();
    private Model.SystemDetails systemDetails;

    public RumiSystem(String name) {
        if (name == null) {
            throw new IllegalArgumentException("system name cannot be null");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setConfDirectories(List<File> dirs) {
        this.confDirectories = dirs;
    }

    public final List<File> getConfDirectories() {
        return this.confDirectories;
    }

    public final void setResourceDirectories(List<File> dirs) {
        this.resourceDirectories = dirs;
    }

    public final List<File> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public final void setJarFiles(List<File> jars) {
        this.jarFiles = jars;
    }

    public List<File> getJarFiles() {
        return this.jarFiles;
    }

    public final void setScriptDirectories(List<File> dirs) {
        this.scriptDirectories = dirs;
    }

    public final List<File> getScriptDirectories() {
        return this.scriptDirectories;
    }

    public Model.SystemDetails getSystemDetails() {
        return this.systemDetails;
    }

    public void setSystemDetails(Model.SystemDetails systemDetails) {
        this.systemDetails = systemDetails;
    }

    public final File stage() throws IOException {
        File rootDir = Files.createTempDir();
        rootDir.deleteOnExit();
        File stageDir = rootDir;
        for (File file : this.getConfDirectories()) {
            if (!file.isDirectory()) {
                throw new IOException("specified configuration directory '" + file + "' is not a directory");
            }
            UtlFile.copyDirectory((File)file, (File)stageDir);
        }
        if (this.getSystemDetails() != null) {
            DDLConfigProcessor.processDDL(stageDir, this.getSystemDetails());
        }
        boolean someResourcesExist = false;
        for (File file : this.getResourceDirectories()) {
            if (!file.exists()) continue;
            if (!file.isDirectory()) {
                throw new IOException("specified resource directory '" + file + "' is not a directory");
            }
            if (file.list().length <= 0) continue;
            someResourcesExist = true;
            break;
        }
        if (someResourcesExist) {
            File file = new File(stageDir, "resources");
            file.mkdirs();
            for (File dir : this.getResourceDirectories()) {
                UtlFile.copyDirectory((File)dir, (File)file);
            }
        }
        File file = new File(stageDir, "scripts");
        file.mkdirs();
        for (File dir : this.getScriptDirectories()) {
            UtlFile.copyDirectory((File)dir, (File)file);
        }
        File file2 = new File(stageDir, "jars");
        file2.mkdirs();
        for (File jarFile : this.getJarFiles()) {
            if (jarFile.isDirectory()) {
                throw new IOException("cannot bundle '" + jarFile + "'. only jars are supported");
            }
            UtlFile.copyFile((File)jarFile, (File)new File(file2, jarFile.getName()));
        }
        return rootDir;
    }
}

